/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct.stream.v1;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.internal.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class DirectByteBufferStreamImplV1
implements DirectByteBufferStream {
    private static final byte[] BYTE_ARR_EMPTY = new byte[0];
    private static final short[] SHORT_ARR_EMPTY = new short[0];
    private static final int[] INT_ARR_EMPTY = U.EMPTY_INTS;
    private static final long[] LONG_ARR_EMPTY = U.EMPTY_LONGS;
    private static final float[] FLOAT_ARR_EMPTY = new float[0];
    private static final double[] DOUBLE_ARR_EMPTY = new double[0];
    private static final char[] CHAR_ARR_EMPTY = new char[0];
    private static final boolean[] BOOLEAN_ARR_EMPTY = new boolean[0];
    private static final ArrayCreator<byte[]> BYTE_ARR_CREATOR = new ArrayCreator<byte[]>(){

        @Override
        public byte[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return BYTE_ARR_EMPTY;
                }
            }
            return new byte[len];
        }
    };
    private static final ArrayCreator<short[]> SHORT_ARR_CREATOR = new ArrayCreator<short[]>(){

        @Override
        public short[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return SHORT_ARR_EMPTY;
                }
            }
            return new short[len];
        }
    };
    private static final ArrayCreator<int[]> INT_ARR_CREATOR = new ArrayCreator<int[]>(){

        @Override
        public int[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return INT_ARR_EMPTY;
                }
            }
            return new int[len];
        }
    };
    private static final ArrayCreator<long[]> LONG_ARR_CREATOR = new ArrayCreator<long[]>(){

        @Override
        public long[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return LONG_ARR_EMPTY;
                }
            }
            return new long[len];
        }
    };
    private static final ArrayCreator<float[]> FLOAT_ARR_CREATOR = new ArrayCreator<float[]>(){

        @Override
        public float[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return FLOAT_ARR_EMPTY;
                }
            }
            return new float[len];
        }
    };
    private static final ArrayCreator<double[]> DOUBLE_ARR_CREATOR = new ArrayCreator<double[]>(){

        @Override
        public double[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return DOUBLE_ARR_EMPTY;
                }
            }
            return new double[len];
        }
    };
    private static final ArrayCreator<char[]> CHAR_ARR_CREATOR = new ArrayCreator<char[]>(){

        @Override
        public char[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return CHAR_ARR_EMPTY;
                }
            }
            return new char[len];
        }
    };
    private static final ArrayCreator<boolean[]> BOOLEAN_ARR_CREATOR = new ArrayCreator<boolean[]>(){

        @Override
        public boolean[] create(int len) {
            assert (len >= 0);
            switch (len) {
                case 0: {
                    return BOOLEAN_ARR_EMPTY;
                }
            }
            return new boolean[len];
        }
    };
    private static final Object NULL = new Object();
    @GridToStringExclude
    private final MessageFactory msgFactory;
    private ByteBuffer buf;
    private byte[] heapArr;
    private long baseOff;
    private int arrOff = -1;
    private Object tmpArr;
    private int tmpArrOff;
    private int tmpArrBytes;
    private boolean msgTypeDone;
    private Message msg;
    private Iterator<?> mapIt;
    private Iterator<?> it;
    private Iterator<?> arrIt;
    private Object arrCur = NULL;
    private Object mapCur = NULL;
    private Object cur = NULL;
    private boolean keyDone;
    private int readSize = -1;
    private int readItems;
    private Object[] objArr;
    private Collection<Object> col;
    private Map<Object, Object> map;
    private boolean lastFinished;

    public DirectByteBufferStreamImplV1(MessageFactory msgFactory) {
        this.msgFactory = msgFactory;
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        assert (buf != null);
        if (this.buf != buf) {
            this.buf = buf;
            this.heapArr = buf.isDirect() ? null : buf.array();
            this.baseOff = buf.isDirect() ? GridUnsafe.bufferAddress(buf) : GridUnsafe.BYTE_ARR_OFF;
        }
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public boolean lastFinished() {
        return this.lastFinished;
    }

    @Override
    public void writeByte(byte val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 1);
        }
    }

    @Override
    public void writeShort(short val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putShort(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 2);
        }
    }

    @Override
    public void writeInt(int val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putInt(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 4);
        }
    }

    @Override
    public void writeLong(long val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putLong(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 8);
        }
    }

    @Override
    public void writeFloat(float val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putFloat(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 4);
        }
    }

    @Override
    public void writeDouble(double val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putDouble(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 8);
        }
    }

    @Override
    public void writeChar(char val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putChar(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 2);
        }
    }

    @Override
    public void writeBoolean(boolean val) {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putBoolean(this.heapArr, this.baseOff + (long)pos, val);
            this.buf.position(pos + 1);
        }
    }

    @Override
    public void writeByteArray(byte[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeByteArray(byte[] val, long off, int len) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF + off, len, len);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeShortArray(short[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.SHORT_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeIntArray(int[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.INT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeLongArray(long[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.LONG_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeLongArray(long[] val, int len) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.LONG_ARR_OFF, len, len << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeFloatArray(float[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.FLOAT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeDoubleArray(double[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.DOUBLE_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeCharArray(char[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.CHAR_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BOOLEAN_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeString(String val) {
        this.writeByteArray(val != null ? val.getBytes() : null);
    }

    @Override
    public void writeBitSet(BitSet val) {
        this.writeLongArray(val != null ? val.toLongArray() : null);
    }

    @Override
    public void writeUuid(UUID val) {
        this.writeByteArray(val != null ? U.uuidToBytes(val) : null);
    }

    @Override
    public void writeIgniteUuid(IgniteUuid val) {
        this.writeByteArray(val != null ? U.igniteUuidToBytes(val) : null);
    }

    @Override
    public void writeMessage(Message msg, MessageWriter writer) {
        if (msg != null) {
            if (this.buf.hasRemaining()) {
                try {
                    writer.beforeInnerMessageWrite();
                    writer.setCurrentWriteClass(msg.getClass());
                    this.lastFinished = msg.writeTo(this.buf, writer);
                }
                finally {
                    writer.afterInnerMessageWrite(this.lastFinished);
                }
            } else {
                this.lastFinished = false;
            }
        } else {
            this.writeShort((short)Short.MIN_VALUE);
        }
    }

    @Override
    public <T> void writeObjectArray(T[] arr, MessageCollectionItemType itemType, MessageWriter writer) {
        if (arr != null) {
            if (this.arrIt == null) {
                this.writeInt(arr.length);
                if (!this.lastFinished) {
                    return;
                }
                this.arrIt = this.arrayIterator(arr);
            }
            while (this.arrIt.hasNext() || this.arrCur != NULL) {
                if (this.arrCur == NULL) {
                    this.arrCur = this.arrIt.next();
                }
                this.write(itemType, this.arrCur, writer);
                if (!this.lastFinished) {
                    return;
                }
                this.arrCur = NULL;
            }
            this.arrIt = null;
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public <T> void writeCollection(Collection<T> col, MessageCollectionItemType itemType, MessageWriter writer) {
        if (col != null) {
            if (this.it == null) {
                this.writeInt(col.size());
                if (!this.lastFinished) {
                    return;
                }
                this.it = col.iterator();
            }
            while (this.it.hasNext() || this.cur != NULL) {
                if (this.cur == NULL) {
                    this.cur = this.it.next();
                }
                this.write(itemType, this.cur, writer);
                if (!this.lastFinished) {
                    return;
                }
                this.cur = NULL;
            }
            this.it = null;
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType, MessageWriter writer) {
        if (map != null) {
            if (this.mapIt == null) {
                this.writeInt(map.size());
                if (!this.lastFinished) {
                    return;
                }
                this.mapIt = map.entrySet().iterator();
            }
            while (this.mapIt.hasNext() || this.mapCur != NULL) {
                if (this.mapCur == NULL) {
                    this.mapCur = this.mapIt.next();
                }
                Map.Entry e = (Map.Entry)this.mapCur;
                if (!this.keyDone) {
                    this.write(keyType, e.getKey(), writer);
                    if (!this.lastFinished) {
                        return;
                    }
                    this.keyDone = true;
                }
                this.write(valType, e.getValue(), writer);
                if (!this.lastFinished) {
                    return;
                }
                this.mapCur = NULL;
                this.keyDone = false;
            }
            this.mapIt = null;
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public byte readByte() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 1);
            return GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
        }
        return 0;
    }

    @Override
    public short readShort() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 2);
            return GridUnsafe.getShort(this.heapArr, this.baseOff + (long)pos);
        }
        return 0;
    }

    @Override
    public int readInt() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 4);
            return GridUnsafe.getInt(this.heapArr, this.baseOff + (long)pos);
        }
        return 0;
    }

    @Override
    public long readLong() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 8);
            return GridUnsafe.getLong(this.heapArr, this.baseOff + (long)pos);
        }
        return 0L;
    }

    @Override
    public float readFloat() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 4);
            return GridUnsafe.getFloat(this.heapArr, this.baseOff + (long)pos);
        }
        return 0.0f;
    }

    @Override
    public double readDouble() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 8);
            return GridUnsafe.getDouble(this.heapArr, this.baseOff + (long)pos);
        }
        return 0.0;
    }

    @Override
    public char readChar() {
        boolean bl = this.lastFinished = this.buf.remaining() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 2);
            return GridUnsafe.getChar(this.heapArr, this.baseOff + (long)pos);
        }
        return '\u0000';
    }

    @Override
    public boolean readBoolean() {
        this.lastFinished = this.buf.hasRemaining();
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.buf.position(pos + 1);
            return GridUnsafe.getBoolean(this.heapArr, this.baseOff + (long)pos);
        }
        return false;
    }

    @Override
    public byte[] readByteArray() {
        return this.readArray(BYTE_ARR_CREATOR, 0, GridUnsafe.BYTE_ARR_OFF);
    }

    @Override
    public short[] readShortArray() {
        return this.readArray(SHORT_ARR_CREATOR, 1, GridUnsafe.SHORT_ARR_OFF);
    }

    @Override
    public int[] readIntArray() {
        return this.readArray(INT_ARR_CREATOR, 2, GridUnsafe.INT_ARR_OFF);
    }

    @Override
    public long[] readLongArray() {
        return this.readArray(LONG_ARR_CREATOR, 3, GridUnsafe.LONG_ARR_OFF);
    }

    @Override
    public float[] readFloatArray() {
        return this.readArray(FLOAT_ARR_CREATOR, 2, GridUnsafe.FLOAT_ARR_OFF);
    }

    @Override
    public double[] readDoubleArray() {
        return this.readArray(DOUBLE_ARR_CREATOR, 3, GridUnsafe.DOUBLE_ARR_OFF);
    }

    @Override
    public char[] readCharArray() {
        return this.readArray(CHAR_ARR_CREATOR, 1, GridUnsafe.CHAR_ARR_OFF);
    }

    @Override
    public boolean[] readBooleanArray() {
        return this.readArray(BOOLEAN_ARR_CREATOR, 0, GridUnsafe.BOOLEAN_ARR_OFF);
    }

    @Override
    public String readString() {
        byte[] arr = this.readByteArray();
        return arr != null ? new String(arr) : null;
    }

    @Override
    public BitSet readBitSet() {
        long[] arr = this.readLongArray();
        return arr != null ? BitSet.valueOf(arr) : null;
    }

    @Override
    public UUID readUuid() {
        byte[] arr = this.readByteArray();
        return arr != null ? U.bytesToUuid(arr, 0) : null;
    }

    @Override
    public IgniteUuid readIgniteUuid() {
        byte[] arr = this.readByteArray();
        return arr != null ? U.bytesToIgniteUuid(arr, 0) : null;
    }

    @Override
    public <T extends Message> T readMessage(MessageReader reader) {
        if (!this.msgTypeDone) {
            if (this.buf.remaining() < 2) {
                this.lastFinished = false;
                return null;
            }
            short type = this.readShort();
            this.msg = type == Short.MIN_VALUE ? null : this.msgFactory.create(type);
            this.msgTypeDone = true;
        }
        if (this.msg != null) {
            try {
                reader.beforeInnerMessageRead();
                reader.setCurrentReadClass(this.msg.getClass());
                this.lastFinished = this.msg.readFrom(this.buf, reader);
            }
            finally {
                reader.afterInnerMessageRead(this.lastFinished);
            }
        } else {
            this.lastFinished = true;
        }
        if (this.lastFinished) {
            Message msg0 = this.msg;
            this.msgTypeDone = false;
            this.msg = null;
            return (T)msg0;
        }
        return null;
    }

    @Override
    public <T> T[] readObjectArray(MessageCollectionItemType itemType, Class<T> itemCls, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.objArr == null) {
                this.objArr = itemCls != null ? (Object[])Array.newInstance(itemCls, this.readSize) : new Object[this.readSize];
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.objArr[i] = item;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Object[] objArr0 = this.objArr;
        this.objArr = null;
        return objArr0;
    }

    @Override
    public <C extends Collection<?>> C readCollection(MessageCollectionItemType itemType, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.col == null) {
                this.col = new ArrayList<Object>(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.col.add(item);
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Collection<Object> col0 = this.col;
        this.col = null;
        return (C)col0;
    }

    @Override
    public <M extends Map<?, ?>> M readMap(MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.map == null) {
                this.map = linked ? U.newLinkedHashMap(this.readSize) : U.newHashMap(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                if (!this.keyDone) {
                    Object key = this.read(keyType, reader);
                    if (!this.lastFinished) {
                        return null;
                    }
                    this.mapCur = key;
                    this.keyDone = true;
                }
                Object val = this.read(valType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.map.put(this.mapCur, val);
                this.keyDone = false;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.mapCur = null;
        Map<Object, Object> map0 = this.map;
        this.map = null;
        return (M)map0;
    }

    private boolean writeArray(Object arr, long off, int len, int bytes) {
        assert (arr != null);
        assert (arr.getClass().isArray() && arr.getClass().getComponentType().isPrimitive());
        assert (off > 0L);
        assert (len >= 0);
        assert (bytes >= 0);
        assert (bytes >= this.arrOff);
        if (this.arrOff == -1) {
            if (this.buf.remaining() < 4) {
                return false;
            }
            this.writeInt(len);
            this.arrOff = 0;
        }
        int toWrite = bytes - this.arrOff;
        int pos = this.buf.position();
        int remaining = this.buf.remaining();
        if (toWrite <= remaining) {
            GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, toWrite);
            this.buf.position(pos += toWrite);
            this.arrOff = -1;
            return true;
        }
        GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, remaining);
        this.buf.position(pos += remaining);
        this.arrOff += remaining;
        return false;
    }

    private <T> T readArray(ArrayCreator<T> creator, int lenShift, long off) {
        assert (creator != null);
        if (this.tmpArr == null) {
            if (this.buf.remaining() < 4) {
                this.lastFinished = false;
                return null;
            }
            int len = this.readInt();
            switch (len) {
                case -1: {
                    this.lastFinished = true;
                    return null;
                }
                case 0: {
                    this.lastFinished = true;
                    return creator.create(0);
                }
            }
            this.tmpArr = creator.create(len);
            this.tmpArrBytes = len << lenShift;
        }
        int toRead = this.tmpArrBytes - this.tmpArrOff;
        int remaining = this.buf.remaining();
        int pos = this.buf.position();
        boolean bl = this.lastFinished = toRead <= remaining;
        if (this.lastFinished) {
            GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, toRead);
            this.buf.position(pos + toRead);
            Object arr = this.tmpArr;
            this.tmpArr = null;
            this.tmpArrBytes = 0;
            this.tmpArrOff = 0;
            return (T)arr;
        }
        GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, remaining);
        this.buf.position(pos + remaining);
        this.tmpArrOff += remaining;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(MessageCollectionItemType type, Object val, MessageWriter writer) {
        switch (type) {
            case BYTE: {
                this.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                this.writeShort((Short)val);
                break;
            }
            case INT: {
                this.writeInt((Integer)val);
                break;
            }
            case LONG: {
                this.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)val);
                break;
            }
            case CHAR: {
                this.writeChar(((Character)val).charValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((Boolean)val);
                break;
            }
            case BYTE_ARR: {
                this.writeByteArray((byte[])val);
                break;
            }
            case SHORT_ARR: {
                this.writeShortArray((short[])val);
                break;
            }
            case INT_ARR: {
                this.writeIntArray((int[])val);
                break;
            }
            case LONG_ARR: {
                this.writeLongArray((long[])val);
                break;
            }
            case FLOAT_ARR: {
                this.writeFloatArray((float[])val);
                break;
            }
            case DOUBLE_ARR: {
                this.writeDoubleArray((double[])val);
                break;
            }
            case CHAR_ARR: {
                this.writeCharArray((char[])val);
                break;
            }
            case BOOLEAN_ARR: {
                this.writeBooleanArray((boolean[])val);
                break;
            }
            case STRING: {
                this.writeString((String)val);
                break;
            }
            case BIT_SET: {
                this.writeBitSet((BitSet)val);
                break;
            }
            case UUID: {
                this.writeUuid((UUID)val);
                break;
            }
            case IGNITE_UUID: {
                this.writeIgniteUuid((IgniteUuid)val);
                break;
            }
            case MSG: {
                try {
                    if (val != null) {
                        writer.beforeInnerMessageWrite();
                    }
                    this.writeMessage((Message)val, writer);
                    break;
                }
                finally {
                    if (val != null) {
                        writer.afterInnerMessageWrite(this.lastFinished);
                    }
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
    }

    private Object read(MessageCollectionItemType type, MessageReader reader) {
        switch (type) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case BYTE_ARR: {
                return this.readByteArray();
            }
            case SHORT_ARR: {
                return this.readShortArray();
            }
            case INT_ARR: {
                return this.readIntArray();
            }
            case LONG_ARR: {
                return this.readLongArray();
            }
            case FLOAT_ARR: {
                return this.readFloatArray();
            }
            case DOUBLE_ARR: {
                return this.readDoubleArray();
            }
            case CHAR_ARR: {
                return this.readCharArray();
            }
            case BOOLEAN_ARR: {
                return this.readBooleanArray();
            }
            case STRING: {
                return this.readString();
            }
            case BIT_SET: {
                return this.readBitSet();
            }
            case UUID: {
                return this.readUuid();
            }
            case IGNITE_UUID: {
                return this.readIgniteUuid();
            }
            case MSG: {
                return this.readMessage(reader);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    private Iterator<?> arrayIterator(final Object[] arr) {
        return new Iterator<Object>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < arr.length;
            }

            @Override
            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return arr[this.idx++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return S.toString(DirectByteBufferStreamImplV1.class, this);
    }

    private static interface ArrayCreator<T> {
        public T create(int var1);
    }
}

