/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.compute.ComputeTaskSessionAttributeListener;
import org.apache.ignite.compute.ComputeTaskSessionScope;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionInternal;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridTaskSessionImpl
implements GridTaskSessionInternal {
    private final String taskName;
    private final GridDeployment dep;
    private final String taskClsName;
    private final IgniteUuid sesId;
    private final long startTime;
    private final long endTime;
    private final UUID taskNodeId;
    private final GridKernalContext ctx;
    private Collection<ComputeJobSibling> siblings;
    private Map<Object, Object> attrs;
    private List<ComputeTaskSessionAttributeListener> lsnrs;
    private ClassLoader clsLdr;
    private volatile boolean closed;
    private volatile String cpSpi;
    private volatile String failSpi;
    private volatile String loadSpi;
    private final Object mux = new Object();
    private final AtomicInteger usage = new AtomicInteger(1);
    private final boolean fullSup;
    private final boolean internal;
    private final Collection<UUID> top;
    private final IgnitePredicate<ClusterNode> topPred;
    private final UUID subjId;
    private final IgniteFutureImpl mapFut;
    private final String execName;

    public GridTaskSessionImpl(UUID taskNodeId, String taskName, @Nullable GridDeployment dep, String taskClsName, IgniteUuid sesId, @Nullable Collection<UUID> top, @Nullable IgnitePredicate<ClusterNode> topPred, long startTime, long endTime, Collection<ComputeJobSibling> siblings, @Nullable Map<Object, Object> attrs, GridKernalContext ctx, boolean fullSup, boolean internal, UUID subjId, @Nullable String execName) {
        assert (taskNodeId != null);
        assert (taskName != null);
        assert (sesId != null);
        assert (ctx != null);
        this.taskNodeId = taskNodeId;
        this.taskName = taskName;
        this.dep = dep;
        this.top = top;
        this.topPred = topPred;
        this.taskClsName = taskClsName;
        this.sesId = sesId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.siblings = siblings != null ? Collections.unmodifiableCollection(siblings) : null;
        this.ctx = ctx;
        if (attrs != null && !attrs.isEmpty()) {
            this.attrs = new HashMap<Object, Object>(attrs.size(), 1.0f);
            this.attrs.putAll(attrs);
        }
        this.fullSup = fullSup;
        this.internal = internal;
        this.subjId = subjId;
        this.execName = execName;
        this.mapFut = new IgniteFutureImpl(new GridFutureAdapter());
    }

    @Override
    public boolean isFullSupport() {
        return this.fullSup;
    }

    @Override
    public UUID subjectId() {
        return this.subjId;
    }

    protected void checkFullSupport() {
        if (!this.fullSup) {
            throw new IllegalStateException("Sessions attributes and checkpoints are disabled by default for better performance (to enable, annotate task class with @ComputeTaskSessionFullSupport annotation).");
        }
    }

    public boolean acquire() {
        int cur;
        do {
            if ((cur = this.usage.get()) != 0) continue;
            return false;
        } while (!this.usage.compareAndSet(cur, cur + 1));
        return true;
    }

    public boolean release() {
        int cur;
        do {
            cur = this.usage.get();
            assert (cur > 0);
        } while (!this.usage.compareAndSet(cur, cur - 1));
        return cur == 1;
    }

    @Override
    public GridTaskSessionInternal session() {
        return this;
    }

    @Override
    @Nullable
    public IgniteUuid getJobId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed() {
        if (this.closed) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.fullSup) {
                this.mux.notifyAll();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public UUID getTaskNodeId() {
        return this.taskNodeId;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> V waitForAttribute(K key, long timeout) throws InterruptedException {
        long now;
        long end;
        A.notNull(key, "key");
        this.checkFullSupport();
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long l = end = (now = U.currentTimeMillis()) + timeout < 0L ? Long.MAX_VALUE : now + timeout;
        if (end > this.endTime) {
            end = this.endTime;
        }
        Object object = this.mux;
        synchronized (object) {
            while (!(this.closed || this.attrs != null && this.attrs.containsKey(key) || now >= end)) {
                this.mux.wait(end - now);
                now = U.currentTimeMillis();
            }
            if (this.closed) {
                throw new InterruptedException("Session was closed: " + this);
            }
            return (V)(this.attrs != null ? this.attrs.get(key) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAttribute(Object key, Object val, long timeout) throws InterruptedException {
        long now;
        long end;
        A.notNull(key, "key");
        this.checkFullSupport();
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long l = end = (now = U.currentTimeMillis()) + timeout < 0L ? Long.MAX_VALUE : now + timeout;
        if (end > this.endTime) {
            end = this.endTime;
        }
        Object object = this.mux;
        synchronized (object) {
            boolean isFound = false;
            while (!this.closed && !(isFound = this.isAttributeSet(key, val)) && now < end) {
                this.mux.wait(end - now);
                now = U.currentTimeMillis();
            }
            if (this.closed) {
                throw new InterruptedException("Session was closed: " + this);
            }
            return isFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<?, ?> waitForAttributes(Collection<?> keys, long timeout) throws InterruptedException {
        long now;
        long end;
        A.notNull(keys, "keys");
        this.checkFullSupport();
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long l = end = (now = U.currentTimeMillis()) + timeout < 0L ? Long.MAX_VALUE : now + timeout;
        if (end > this.endTime) {
            end = this.endTime;
        }
        Object object = this.mux;
        synchronized (object) {
            while (!(this.closed || this.attrs != null && this.attrs.keySet().containsAll(keys) || now >= end)) {
                this.mux.wait(end - now);
                now = U.currentTimeMillis();
            }
            if (this.closed) {
                throw new InterruptedException("Session was closed: " + this);
            }
            HashMap retVal = new HashMap(keys.size(), 1.0f);
            if (this.attrs != null) {
                for (Object key : keys) {
                    retVal.put(key, this.attrs.get(key));
                }
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForAttributes(Map<?, ?> attrs, long timeout) throws InterruptedException {
        long now;
        long end;
        A.notNull(attrs, "attrs");
        this.checkFullSupport();
        if (attrs.isEmpty()) {
            return true;
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long l = end = (now = U.currentTimeMillis()) + timeout < 0L ? Long.MAX_VALUE : now + timeout;
        if (end > this.endTime) {
            end = this.endTime;
        }
        Object object = this.mux;
        synchronized (object) {
            boolean isFound = false;
            while (!this.closed && now < end) {
                boolean bl = isFound = this.attrs != null && this.attrs.entrySet().containsAll(attrs.entrySet());
                if (isFound) break;
                this.mux.wait(end - now);
                now = U.currentTimeMillis();
            }
            if (this.closed) {
                throw new InterruptedException("Session was closed: " + this);
            }
            return isFound;
        }
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskClassName() {
        return this.taskClsName;
    }

    @Override
    public IgniteUuid getId() {
        return this.sesId;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    public String getUserVersion() {
        return this.dep == null ? "" : this.dep.userVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getClassLoader() {
        Object object = this.mux;
        synchronized (object) {
            return this.clsLdr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassLoader(ClassLoader clsLdr) {
        assert (clsLdr != null);
        Object object = this.mux;
        synchronized (object) {
            this.clsLdr = clsLdr;
        }
    }

    @Override
    public boolean isTaskNode() {
        return this.taskNodeId.equals(this.ctx.discovery().localNode().id());
    }

    @Override
    public Collection<ComputeJobSibling> refreshJobSiblings() {
        return this.getJobSiblings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComputeJobSibling> getJobSiblings() {
        Object object = this.mux;
        synchronized (object) {
            return this.siblings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobSiblings(Collection<ComputeJobSibling> siblings) {
        Object object = this.mux;
        synchronized (object) {
            this.siblings = Collections.unmodifiableCollection(siblings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobSiblings(Collection<ComputeJobSibling> siblings) {
        assert (this.isTaskNode());
        Object object = this.mux;
        synchronized (object) {
            ArrayList<ComputeJobSibling> tmp = new ArrayList<ComputeJobSibling>(this.siblings.size() + siblings.size());
            tmp.addAll(this.siblings);
            tmp.addAll(siblings);
            this.siblings = Collections.unmodifiableCollection(tmp);
        }
    }

    @Override
    public ComputeJobSibling getJobSibling(IgniteUuid jobId) {
        A.notNull(jobId, "jobId");
        Collection<ComputeJobSibling> tmp = this.getJobSiblings();
        for (ComputeJobSibling sibling : tmp) {
            if (!sibling.getJobId().equals(jobId)) continue;
            return sibling;
        }
        return null;
    }

    @Override
    public void setAttribute(Object key, Object val) {
        A.notNull(key, "key");
        this.checkFullSupport();
        this.setAttributes(Collections.singletonMap(key, val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> V getAttribute(K key) {
        A.notNull(key, "key");
        this.checkFullSupport();
        Object object = this.mux;
        synchronized (object) {
            return (V)(this.attrs != null ? this.attrs.get(key) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(Map<?, ?> attrs) {
        A.notNull(attrs, "attrs");
        this.checkFullSupport();
        if (attrs.isEmpty()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.attrs == null) {
                this.attrs = new HashMap<Object, Object>(attrs.size(), 1.0f);
            }
            this.attrs.putAll(attrs);
        }
        if (this.isTaskNode()) {
            try {
                this.ctx.task().setAttributes(this, attrs);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, Object> getAttributes() {
        this.checkFullSupport();
        Object object = this.mux;
        synchronized (object) {
            return this.attrs == null || this.attrs.isEmpty() ? Collections.emptyMap() : U.sealMap(this.attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInternal(Map<?, ?> attrs) {
        List<ComputeTaskSessionAttributeListener> lsnrs;
        A.notNull(attrs, "attrs");
        this.checkFullSupport();
        if (attrs.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<?, ?>> iterator = this.mux;
        synchronized (iterator) {
            if (this.attrs == null) {
                this.attrs = new HashMap<Object, Object>(attrs.size(), 1.0f);
            }
            this.attrs.putAll(attrs);
            lsnrs = this.lsnrs;
            this.mux.notifyAll();
        }
        if (lsnrs != null) {
            for (Map.Entry<?, ?> entry : attrs.entrySet()) {
                for (ComputeTaskSessionAttributeListener lsnr : lsnrs) {
                    lsnr.onAttributeSet(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributeListener(ComputeTaskSessionAttributeListener lsnr, boolean rewind) {
        ArrayList<ComputeTaskSessionAttributeListener> lsnrs;
        A.notNull(lsnr, "lsnr");
        this.checkFullSupport();
        HashMap<Object, Object> attrs = null;
        Iterator iterator = this.mux;
        synchronized (iterator) {
            ArrayList<ComputeTaskSessionAttributeListener> arrayList = lsnrs = this.lsnrs != null ? new ArrayList<ComputeTaskSessionAttributeListener>(this.lsnrs.size() + 1) : new ArrayList(1);
            if (this.lsnrs != null) {
                lsnrs.addAll(this.lsnrs);
            }
            lsnrs.add(lsnr);
            this.lsnrs = lsnrs;
            if (rewind && this.attrs != null) {
                attrs = new HashMap<Object, Object>(this.attrs);
            }
        }
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                for (ComputeTaskSessionAttributeListener l : lsnrs) {
                    l.onAttributeSet(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttributeListener(ComputeTaskSessionAttributeListener lsnr) {
        A.notNull(lsnr, "lsnr");
        this.checkFullSupport();
        Object object = this.mux;
        synchronized (object) {
            if (this.lsnrs == null) {
                return false;
            }
            ArrayList<ComputeTaskSessionAttributeListener> lsnrs = new ArrayList<ComputeTaskSessionAttributeListener>(this.lsnrs);
            boolean rmv = lsnrs.remove(lsnr);
            this.lsnrs = lsnrs.isEmpty() ? null : lsnrs;
            return rmv;
        }
    }

    @Override
    public void saveCheckpoint(String key, Object state) {
        this.saveCheckpoint(key, state, ComputeTaskSessionScope.SESSION_SCOPE, 0L);
    }

    @Override
    public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout) {
        this.saveCheckpoint(key, state, scope, timeout, true);
    }

    @Override
    public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout, boolean overwrite) {
        this.saveCheckpoint0(this, key, state, scope, timeout, overwrite);
    }

    protected void saveCheckpoint0(GridTaskSessionInternal ses, String key, Object state, ComputeTaskSessionScope scope, long timeout, boolean overwrite) throws IgniteException {
        assert (ses != null);
        A.notNull(key, "key");
        A.ensure(timeout >= 0L, "timeout >= 0");
        if (this.closed) {
            throw new IgniteException("Failed to save checkpoint (session closed): " + ses);
        }
        this.checkFullSupport();
        try {
            this.ctx.checkpoint().storeCheckpoint(ses, key, state, scope, timeout, overwrite);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T> T loadCheckpoint(String key) {
        return this.loadCheckpoint0(this, key);
    }

    protected <T> T loadCheckpoint0(GridTaskSessionInternal ses, String key) {
        assert (ses != null);
        A.notNull(key, "key");
        if (this.closed) {
            throw new IgniteException("Failed to load checkpoint (session closed): " + ses);
        }
        this.checkFullSupport();
        try {
            return (T)this.ctx.checkpoint().loadCheckpoint(ses, key);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean removeCheckpoint(String key) {
        return this.removeCheckpoint0(this, key);
    }

    protected boolean removeCheckpoint0(GridTaskSessionInternal ses, String key) throws IgniteException {
        assert (ses != null);
        A.notNull(key, "key");
        if (this.closed) {
            throw new IgniteException("Failed to remove checkpoint (session closed): " + ses);
        }
        this.checkFullSupport();
        return this.ctx.checkpoint().removeCheckpoint(ses, key);
    }

    @Nullable
    public IgnitePredicate<ClusterNode> getTopologyPredicate() {
        return this.topPred;
    }

    @Override
    public Collection<UUID> getTopology() {
        if (this.topPred != null) {
            return F.viewReadOnly(this.ctx.discovery().allNodes(), F.node2id(), this.topPred);
        }
        return this.top != null ? this.top : F.nodeIds(this.ctx.discovery().allNodes());
    }

    private boolean isAttributeSet(Object key, Object val) {
        assert (Thread.holdsLock(this.mux));
        assert (this.fullSup);
        if (this.attrs != null && this.attrs.containsKey(key)) {
            Object stored = this.attrs.get(key);
            if (val == null && stored == null) {
                return true;
            }
            if (val != null && stored != null) {
                return val.equals(stored);
            }
        }
        return false;
    }

    @Override
    public String getCheckpointSpi() {
        return this.cpSpi;
    }

    public void setCheckpointSpi(String cpSpi) {
        this.cpSpi = cpSpi;
    }

    public String getFailoverSpi() {
        return this.failSpi;
    }

    public void setFailoverSpi(String failSpi) {
        this.failSpi = failSpi;
    }

    public String getLoadBalancingSpi() {
        return this.loadSpi;
    }

    public void setLoadBalancingSpi(String loadSpi) {
        this.loadSpi = loadSpi;
    }

    public long getSequenceNumber() {
        return this.dep == null ? 0L : this.dep.sequenceNumber();
    }

    public GridDeployment deployment() {
        return this.dep;
    }

    public void onMapped() {
        ((GridFutureAdapter)this.mapFut.internalFuture()).onDone();
    }

    public void onDone() {
        ((GridFutureAdapter)this.mapFut.internalFuture()).onDone();
    }

    @Override
    public IgniteFuture<?> mapFuture() {
        return this.mapFut;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Nullable
    public String executorName() {
        return this.execName;
    }

    public String toString() {
        return S.toString(GridTaskSessionImpl.class, this);
    }
}

