/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeExecutionRejectedException;
import org.apache.ignite.compute.ComputeJobFailoverException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTask;

public abstract class ComputeTaskAdapter<T, R>
implements ComputeTask<T, R> {
    private static final long serialVersionUID = 0L;

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        IgniteException e = res.getException();
        if (e != null) {
            if (e instanceof ComputeExecutionRejectedException || e instanceof ClusterTopologyException || e.hasCause(ComputeJobFailoverException.class)) {
                return ComputeJobResultPolicy.FAILOVER;
            }
            throw new IgniteException("Remote job threw user exception (override or implement ComputeTask.result(..) method if you would like to have automatic failover for this exception): " + e.getMessage(), e);
        }
        return ComputeJobResultPolicy.WAIT;
    }
}

