/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.mortbay.util.ajax.JSON;

public class JsonUtil {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];

    public static String toJsonString(Token<? extends TokenIdentifier> token) throws IOException {
        return JsonUtil.toJsonString(Token.class, JsonUtil.toJsonMap(token));
    }

    private static Map<String, Object> toJsonMap(Token<? extends TokenIdentifier> token) throws IOException {
        if (token == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("urlString", token.encodeToUrlString());
        return m;
    }

    public static Token<? extends TokenIdentifier> toToken(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m.get("urlString"));
        return token;
    }

    public static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m = (Map)json.get(Token.class.getSimpleName());
        return JsonUtil.toToken(m);
    }

    private static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m) throws IOException {
        return JsonUtil.toToken(m);
    }

    private static Object[] toJsonArray(Token<? extends TokenIdentifier>[] array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    public static String toJsonString(Token<? extends TokenIdentifier>[] tokens) throws IOException {
        if (tokens == null) {
            return null;
        }
        TreeMap<String, Object[]> m = new TreeMap<String, Object[]>();
        m.put(Token.class.getSimpleName(), JsonUtil.toJsonArray(tokens));
        return JsonUtil.toJsonString(Token.class.getSimpleName() + "s", m);
    }

    private static List<Token<?>> toTokenList(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(JsonUtil.toToken((Map)objects[i]));
        }
        return list;
    }

    public static List<Token<?>> toTokenList(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(Token.class.getSimpleName() + "s");
        return JsonUtil.toTokenList((Object[])m.get(Token.class.getSimpleName()));
    }

    public static String toJsonString(Exception e) {
        TreeMap<String, String> m = new TreeMap<String, String>();
        m.put("exception", e.getClass().getSimpleName());
        m.put("message", e.getMessage());
        m.put("javaClassName", e.getClass().getName());
        return JsonUtil.toJsonString(RemoteException.class, m);
    }

    public static RemoteException toRemoteException(Map<?, ?> json) {
        Map m = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m.get("message");
        String javaClassName = (String)m.get("javaClassName");
        return new RemoteException(javaClassName, message);
    }

    private static String toJsonString(Class<?> clazz, Object value) {
        return JsonUtil.toJsonString(clazz.getSimpleName(), value);
    }

    public static String toJsonString(String key, Object value) {
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put(key, value);
        return JSON.toString(m);
    }

    private static String toString(FsPermission permission) {
        return String.format("%o", permission.toShort());
    }

    private static FsPermission toFsPermission(String s, Boolean aclBit) {
        FsPermission perm = new FsPermission(Short.parseShort(s, 8));
        return aclBit != null && aclBit != false ? new FsAclPermission(perm) : perm;
    }

    public static String toJsonString(HdfsFileStatus status, boolean includeType) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("pathSuffix", status.getLocalName());
        m.put("type", (Object)PathType.valueOf(status));
        if (status.isSymlink()) {
            m.put("symlink", status.getSymlink());
        }
        m.put("length", status.getLen());
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        FsPermission perm = status.getPermission();
        m.put("permission", JsonUtil.toString(perm));
        if (perm.getAclBit()) {
            m.put("aclBit", true);
        }
        m.put("accessTime", status.getAccessTime());
        m.put("modificationTime", status.getModificationTime());
        m.put("blockSize", status.getBlockSize());
        m.put("replication", status.getReplication());
        m.put("fileId", status.getFileId());
        m.put("childrenNum", status.getChildrenNum());
        return includeType ? JsonUtil.toJsonString(FileStatus.class, m) : JSON.toString(m);
    }

    public static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m.get("pathSuffix");
        PathType type = PathType.valueOf((String)m.get("type"));
        byte[] symlink = type != PathType.SYMLINK ? null : DFSUtil.string2Bytes((String)m.get("symlink"));
        long len = (Long)m.get("length");
        String owner = (String)m.get("owner");
        String group = (String)m.get("group");
        FsPermission permission = JsonUtil.toFsPermission((String)m.get("permission"), (Boolean)m.get("aclBit"));
        long aTime = (Long)m.get("accessTime");
        long mTime = (Long)m.get("modificationTime");
        long blockSize = (Long)m.get("blockSize");
        short replication = (short)((Long)m.get("replication")).longValue();
        long fileId = m.containsKey("fileId") ? (Long)m.get("fileId") : 0L;
        Long childrenNumLong = (Long)m.get("childrenNum");
        int childrenNum = childrenNumLong == null ? -1 : childrenNumLong.intValue();
        return new HdfsFileStatus(len, type == PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtil.string2Bytes(localName), fileId, childrenNum);
    }

    private static Map<String, Object> toJsonMap(ExtendedBlock extendedblock) {
        if (extendedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockPoolId", extendedblock.getBlockPoolId());
        m.put("blockId", extendedblock.getBlockId());
        m.put("numBytes", extendedblock.getNumBytes());
        m.put("generationStamp", extendedblock.getGenerationStamp());
        return m;
    }

    private static ExtendedBlock toExtendedBlock(Map<?, ?> m) {
        if (m == null) {
            return null;
        }
        String blockPoolId = (String)m.get("blockPoolId");
        long blockId = (Long)m.get("blockId");
        long numBytes = (Long)m.get("numBytes");
        long generationStamp = (Long)m.get("generationStamp");
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static Map<String, Object> toJsonMap(DatanodeInfo datanodeinfo) {
        if (datanodeinfo == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("ipAddr", datanodeinfo.getIpAddr());
        m.put("name", datanodeinfo.getXferAddr());
        m.put("hostName", datanodeinfo.getHostName());
        m.put("storageID", datanodeinfo.getDatanodeUuid());
        m.put("xferPort", datanodeinfo.getXferPort());
        m.put("infoPort", datanodeinfo.getInfoPort());
        m.put("infoSecurePort", datanodeinfo.getInfoSecurePort());
        m.put("ipcPort", datanodeinfo.getIpcPort());
        m.put("capacity", datanodeinfo.getCapacity());
        m.put("dfsUsed", datanodeinfo.getDfsUsed());
        m.put("remaining", datanodeinfo.getRemaining());
        m.put("blockPoolUsed", datanodeinfo.getBlockPoolUsed());
        m.put("cacheCapacity", datanodeinfo.getCacheCapacity());
        m.put("cacheUsed", datanodeinfo.getCacheUsed());
        m.put("lastUpdate", datanodeinfo.getLastUpdate());
        m.put("xceiverCount", datanodeinfo.getXceiverCount());
        m.put("networkLocation", datanodeinfo.getNetworkLocation());
        m.put("adminState", datanodeinfo.getAdminState().name());
        return m;
    }

    private static int getInt(Map<?, ?> m, String key, int defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (int)((Long)value).longValue();
    }

    private static long getLong(Map<?, ?> m, String key, long defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Long)value;
    }

    private static String getString(Map<?, ?> m, String key, String defaultValue) {
        Object value = m.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m) throws IOException {
        int xferPort;
        if (m == null) {
            return null;
        }
        Object tmpValue = m.get("ipAddr");
        String ipAddr = tmpValue == null ? null : (String)tmpValue;
        tmpValue = m.get("xferPort");
        int n = xferPort = tmpValue == null ? -1 : (int)((Long)tmpValue).longValue();
        if (ipAddr == null) {
            tmpValue = m.get("name");
            if (tmpValue == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            String name = (String)tmpValue;
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo(ipAddr, (String)m.get("hostName"), (String)m.get("storageID"), xferPort, (int)((Long)m.get("infoPort")).longValue(), JsonUtil.getInt(m, "infoSecurePort", 0), (int)((Long)m.get("ipcPort")).longValue(), JsonUtil.getLong(m, "capacity", 0L), JsonUtil.getLong(m, "dfsUsed", 0L), JsonUtil.getLong(m, "remaining", 0L), JsonUtil.getLong(m, "blockPoolUsed", 0L), JsonUtil.getLong(m, "cacheCapacity", 0L), JsonUtil.getLong(m, "cacheUsed", 0L), JsonUtil.getLong(m, "lastUpdate", 0L), JsonUtil.getInt(m, "xceiverCount", 0), JsonUtil.getString(m, "networkLocation", ""), DatanodeInfo.AdminStates.valueOf(JsonUtil.getString(m, "adminState", "NORMAL")));
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    private static Object[] toJsonArray(DatanodeInfo[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = JsonUtil.toJsonMap(array[i]);
        }
        return a;
    }

    private static DatanodeInfo[] toDatanodeInfoArray(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = JsonUtil.toDatanodeInfo((Map)objects[i]);
        }
        return array;
    }

    private static Map<String, Object> toJsonMap(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("blockToken", JsonUtil.toJsonMap(locatedblock.getBlockToken()));
        m.put("isCorrupt", locatedblock.isCorrupt());
        m.put("startOffset", locatedblock.getStartOffset());
        m.put("block", JsonUtil.toJsonMap(locatedblock.getBlock()));
        m.put("locations", JsonUtil.toJsonArray(locatedblock.getLocations()));
        m.put("cachedLocations", JsonUtil.toJsonArray(locatedblock.getCachedLocations()));
        return m;
    }

    private static LocatedBlock toLocatedBlock(Map<?, ?> m) throws IOException {
        if (m == null) {
            return null;
        }
        ExtendedBlock b = JsonUtil.toExtendedBlock((Map)m.get("block"));
        DatanodeInfo[] locations = JsonUtil.toDatanodeInfoArray((Object[])m.get("locations"));
        long startOffset = (Long)m.get("startOffset");
        boolean isCorrupt = (Boolean)m.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtil.toDatanodeInfoArray((Object[])m.get("cachedLocations"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, null, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtil.toBlockToken((Map)m.get("blockToken")));
        return locatedblock;
    }

    private static Object[] toJsonArray(List<LocatedBlock> array) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i));
        }
        return a;
    }

    private static List<LocatedBlock> toLocatedBlockList(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            list.add(JsonUtil.toLocatedBlock((Map)objects[i]));
        }
        return list;
    }

    public static String toJsonString(LocatedBlocks locatedblocks) throws IOException {
        if (locatedblocks == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("fileLength", locatedblocks.getFileLength());
        m.put("isUnderConstruction", locatedblocks.isUnderConstruction());
        m.put("locatedBlocks", JsonUtil.toJsonArray(locatedblocks.getLocatedBlocks()));
        m.put("lastLocatedBlock", JsonUtil.toJsonMap(locatedblocks.getLastLocatedBlock()));
        m.put("isLastBlockComplete", locatedblocks.isLastBlockComplete());
        return JsonUtil.toJsonString(LocatedBlocks.class, m);
    }

    public static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = (Long)m.get("fileLength");
        boolean isUnderConstruction = (Boolean)m.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtil.toLocatedBlockList((Object[])m.get("locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtil.toLocatedBlock((Map)m.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete);
    }

    public static String toJsonString(ContentSummary contentsummary) {
        if (contentsummary == null) {
            return null;
        }
        TreeMap<String, Long> m = new TreeMap<String, Long>();
        m.put("length", contentsummary.getLength());
        m.put("fileCount", contentsummary.getFileCount());
        m.put("directoryCount", contentsummary.getDirectoryCount());
        m.put("quota", contentsummary.getQuota());
        m.put("spaceConsumed", contentsummary.getSpaceConsumed());
        m.put("spaceQuota", contentsummary.getSpaceQuota());
        return JsonUtil.toJsonString(ContentSummary.class, m);
    }

    public static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = (Long)m.get("length");
        long fileCount = (Long)m.get("fileCount");
        long directoryCount = (Long)m.get("directoryCount");
        long quota = (Long)m.get("quota");
        long spaceConsumed = (Long)m.get("spaceConsumed");
        long spaceQuota = (Long)m.get("spaceQuota");
        return new ContentSummary(length, fileCount, directoryCount, quota, spaceConsumed, spaceQuota);
    }

    public static String toJsonString(MD5MD5CRC32FileChecksum checksum) {
        if (checksum == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("algorithm", checksum.getAlgorithmName());
        m.put("length", checksum.getLength());
        m.put("bytes", StringUtils.byteToHexString((byte[])checksum.getBytes()));
        return JsonUtil.toJsonString(FileChecksum.class, m);
    }

    public static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32GzipFileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m.get("algorithm");
        int length = (int)((Long)m.get("length")).longValue();
        byte[] bytes = StringUtils.hexStringToByte((String)((String)m.get("bytes")));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName((String)algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields((DataInput)in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    public static String toJsonString(AclStatus status) {
        if (status == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("owner", status.getOwner());
        m.put("group", status.getGroup());
        m.put("stickyBit", status.isStickyBit());
        m.put("entries", status.getEntries());
        TreeMap<String, TreeMap<String, Object>> finalMap = new TreeMap<String, TreeMap<String, Object>>();
        finalMap.put(AclStatus.class.getSimpleName(), m);
        return JSON.toString(finalMap);
    }

    public static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m.get("owner"));
        aclStatusBuilder.group((String)m.get("group"));
        aclStatusBuilder.stickyBit(((Boolean)m.get("stickyBit")).booleanValue());
        Object[] entries = (Object[])m.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (int i = 0; i < entries.length; ++i) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)((String)entries[i]), (boolean)true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    private static Map<String, Object> toJsonMap(XAttr xAttr, XAttrCodec encoding) throws IOException {
        if (xAttr == null) {
            return null;
        }
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("name", XAttrHelper.getPrefixName(xAttr));
        m.put("value", xAttr.getValue() != null ? XAttrCodec.encodeValue((byte[])xAttr.getValue(), (XAttrCodec)encoding) : null);
        return m;
    }

    private static Object[] toJsonArray(List<XAttr> array, XAttrCodec encoding) throws IOException {
        if (array == null) {
            return null;
        }
        if (array.size() == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] a = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            a[i] = JsonUtil.toJsonMap(array.get(i), encoding);
        }
        return a;
    }

    public static String toJsonString(List<XAttr> xAttrs, XAttrCodec encoding) throws IOException {
        TreeMap<String, Object[]> finalMap = new TreeMap<String, Object[]>();
        finalMap.put("XAttrs", JsonUtil.toJsonArray(xAttrs, encoding));
        return JSON.toString(finalMap);
    }

    public static String toJsonString(List<XAttr> xAttrs) throws IOException {
        ArrayList names = Lists.newArrayListWithCapacity((int)xAttrs.size());
        for (XAttr xAttr : xAttrs) {
            names.add(XAttrHelper.getPrefixName(xAttr));
        }
        String ret = JSON.toString((Object)names);
        TreeMap<String, String> finalMap = new TreeMap<String, String>();
        finalMap.put("XAttrNames", ret);
        return JSON.toString(finalMap);
    }

    public static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtil.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    public static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtil.toXAttrMap((Object[])json.get("XAttrs"));
    }

    public static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        Object[] xattrs = (Object[])JSON.parse((String)namesInJson);
        ArrayList names = Lists.newArrayListWithCapacity((int)json.keySet().size());
        for (int i = 0; i < xattrs.length; ++i) {
            names.add((String)xattrs[i]);
        }
        return names;
    }

    private static Map<String, byte[]> toXAttrMap(Object[] objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.length == 0) {
            return Maps.newHashMap();
        }
        HashMap xAttrs = Maps.newHashMap();
        for (int i = 0; i < objects.length; ++i) {
            Map m = (Map)objects[i];
            String name = (String)m.get("name");
            String value = (String)m.get("value");
            xAttrs.put(name, JsonUtil.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    private static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue((String)value);
        }
        return new byte[0];
    }

    static enum PathType {
        FILE,
        DIRECTORY,
        SYMLINK;


        static PathType valueOf(HdfsFileStatus status) {
            return status.isDir() ? DIRECTORY : (status.isSymlink() ? SYMLINK : FILE);
        }
    }
}

