/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.json;

import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;

public class JSONCompareUtil {
    private static JSONCompareUtil instance = new JSONCompareUtil();

    public static JSONCompareUtil Instance() {
        return instance;
    }

    private JSONCompareUtil() {
    }

    public boolean Contain(JSONObject objectSet, String content, JSONObject object) {
        if (objectSet == null) {
            return false;
        }
        if (!objectSet.containsKey((Object)content)) {
            return false;
        }
        Object contentObject = objectSet.get((Object)content);
        if (!(contentObject instanceof JSONArray)) {
            return false;
        }
        JSONArray contentArray = (JSONArray)contentObject;
        int i = 0;
        while (i < contentArray.size()) {
            JSONObject jsonItem;
            Object itemObject = contentArray.get(i);
            if (itemObject instanceof JSONObject && this.Compare(jsonItem = (JSONObject)itemObject, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean Contain(JSONArray objectSet, Object object) {
        if (object == null) {
            return true;
        }
        if (objectSet == null) {
            return false;
        }
        int i = 0;
        while (i < objectSet.size()) {
            if (this.CompareObject(objectSet.get(i), object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean Contain(JSONObject objectSet, JSONObject object) {
        if (object == null) {
            return true;
        }
        if (objectSet == null) {
            return false;
        }
        for (String key : object.keySet()) {
            Object value = object.get((Object)key);
            if (!objectSet.containsKey((Object)key)) {
                return false;
            }
            Object valueSet = objectSet.get((Object)key);
            if (this.CompareObject(valueSet, value)) continue;
            return false;
        }
        return true;
    }

    public boolean CompareObject(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null && value2 != null) {
            return false;
        }
        if (value1 != null && value2 == null) {
            return false;
        }
        boolean result = false;
        if (value1.getClass() == value2.getClass()) {
            if (value1 instanceof Long && value2 instanceof Long) {
                result = ((Long)value1).longValue() == ((Long)value2).longValue();
            } else if (value1 instanceof Double && value2 instanceof Double) {
                result = Math.abs((Double)value1 - (Double)value2) < 1.0E-8;
            } else if (value1 instanceof Boolean && value2 instanceof Boolean) {
                result = ((Boolean)value1).booleanValue() == ((Boolean)value2).booleanValue();
            } else if (value1 instanceof String && value2 instanceof String) {
                result = ((String)value1).equals((String)value2);
            } else if (value1 instanceof JSONObject && value2 instanceof JSONObject) {
                result = this.Compare((JSONObject)value1, (JSONObject)value2);
            } else if (value1 instanceof JSONArray && value2 instanceof JSONArray) {
                result = this.Compare((JSONArray)value1, (JSONArray)value2);
            }
        }
        return result;
    }

    public boolean Compare(JSONObject arg1, JSONObject arg2) {
        if (arg1 == null && arg2 == null) {
            return true;
        }
        if (arg1 == null && arg2 != null) {
            return false;
        }
        if (arg1 != null && arg2 == null) {
            return false;
        }
        if (arg1.size() != arg2.size()) {
            return false;
        }
        for (String key : arg1.keySet()) {
            if (arg2.containsKey((Object)key)) {
                Object value2;
                Object value1 = arg1.get((Object)key);
                boolean equal = this.CompareObject(value1, value2 = arg2.get((Object)key));
                if (equal) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean Compare(JSONArray arg1, JSONArray arg2) {
        if (arg1 == null && arg2 == null) {
            return true;
        }
        if (arg1 == null && arg2 != null) {
            return false;
        }
        if (arg1 != null && arg2 == null) {
            return false;
        }
        if (arg1.size() != arg2.size()) {
            return false;
        }
        boolean[] useArray = new boolean[arg1.size()];
        int i = 0;
        while (i < arg1.size()) {
            Object value1 = arg1.get(i);
            boolean find = false;
            int ii = 0;
            while (ii < arg1.size()) {
                Object value2;
                boolean equal;
                if (!useArray[ii] && (equal = this.CompareObject(value1, value2 = arg2.get(ii)))) {
                    useArray[ii] = true;
                    find = true;
                    break;
                }
                ++ii;
            }
            if (!find) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

