/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.alibaba.fastjson.JSONObject;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.zillion.util.common.CompressUtil;
import org.zillion.util.common.MyException;

public class HTableUtil {
    public static boolean valid(ZillionTableSchema schema, List<Cell> cellList) {
        if (schema.delete_UsePutV) {
            String q = null;
            for (Cell cell : cellList) {
                byte[] column_name_bytes = CellUtil.cloneQualifier((Cell)cell);
                byte[] cell_bytes = CellUtil.cloneValue((Cell)cell);
                String column_name = ByteToObject.toString(column_name_bytes);
                if (!column_name.equals("v")) continue;
                q = ByteToObject.toString(cell_bytes);
                break;
            }
            return q != null && q.equals("1");
        }
        return true;
    }

    public static JSONObject Convert(ZillionTableSchema schema, byte[] row_bytes, List<Cell> cellList) throws IOException {
        JSONObject resultObject = HTableUtil.ConvertInner(schema.ColumnMap, schema.Key, row_bytes, cellList);
        return resultObject;
    }

    public static JSONObject Convert_index_data(ZillionTableSchema schema, ZillionTableIndex schema_index, byte[] row_bytes, List<Cell> cellList) throws IOException {
        JSONObject resultObject = HTableUtil.ConvertInner(schema.ColumnMap, schema_index.Key, row_bytes, cellList);
        return resultObject;
    }

    private static JSONObject ConvertInner(Map<String, ZillionTableColumn> ColumnMap, String[] Columns, byte[] row_bytes, List<Cell> cellList) throws IOException {
        JSONObject resultObject = new JSONObject();
        int bytes_index = 0;
        int i = 0;
        while (i < Columns.length) {
            String key_name = Columns[i];
            ZillionTableColumn column = ColumnMap.get(key_name);
            byte head = row_bytes[bytes_index];
            ++bytes_index;
            if (head == 0) {
                resultObject.put(key_name, null);
            } else if (column.Type == ZillionTableColumnEnum.STRING) {
                int tmp_index = bytes_index;
                while (row_bytes[tmp_index] != 0) {
                    ++tmp_index;
                }
                String column_value = ByteToObject.toString(row_bytes, bytes_index, tmp_index - bytes_index);
                bytes_index += tmp_index - bytes_index + 1;
                resultObject.put(key_name, (Object)column_value);
            } else if (column.Type == ZillionTableColumnEnum.INT) {
                int column_value = ByteToObject.toInt(row_bytes, bytes_index);
                bytes_index += 4;
                resultObject.put(key_name, (Object)column_value);
            } else if (column.Type == ZillionTableColumnEnum.LONG) {
                long column_value = ByteToObject.toLong(row_bytes, bytes_index);
                bytes_index += 8;
                resultObject.put(key_name, (Object)column_value);
            } else if (column.Type == ZillionTableColumnEnum.FLOAT) {
                float column_value = ByteToObject.toFloat(row_bytes, bytes_index);
                bytes_index += 4;
                resultObject.put(key_name, (Object)column_value);
            } else if (column.Type == ZillionTableColumnEnum.DOUBLE) {
                double column_value = ByteToObject.toDouble(row_bytes, bytes_index);
                bytes_index += 8;
                resultObject.put(key_name, (Object)column_value);
            } else if (column.Type == ZillionTableColumnEnum.BOOLEAN) {
                boolean column_value = row_bytes[bytes_index] != 0;
                ++bytes_index;
                resultObject.put(key_name, (Object)column_value);
            }
            ++i;
        }
        for (Cell cell : cellList) {
            byte[] column_name_bytes = CellUtil.cloneQualifier((Cell)cell);
            String column_name = ByteToObject.toString(column_name_bytes);
            if (resultObject.containsKey((Object)column_name) || column_name.equals("v")) continue;
            byte[] cell_bytes = CellUtil.cloneValue((Cell)cell);
            ZillionTableColumn column = ColumnMap.get(column_name);
            Object column_value = null;
            if (cell_bytes.length > 0) {
                if (column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                    column_value = cell_bytes.length == 1 && cell_bytes[0] == 0 ? "" : (column.Type == ZillionTableColumnEnum.STRING ? ByteToObject.toString(cell_bytes) : ByteToObject.toString(CompressUtil.decompress(cell_bytes)));
                } else if (column.Type == ZillionTableColumnEnum.INT) {
                    column_value = (long)ByteToObject.toInt(cell_bytes);
                } else if (column.Type == ZillionTableColumnEnum.LONG) {
                    column_value = ByteToObject.toLong(cell_bytes);
                } else if (column.Type == ZillionTableColumnEnum.FLOAT) {
                    column_value = (double)ByteToObject.toFloat(cell_bytes);
                } else if (column.Type == ZillionTableColumnEnum.DOUBLE) {
                    column_value = ByteToObject.toDouble(cell_bytes);
                } else if (column.Type == ZillionTableColumnEnum.BOOLEAN) {
                    column_value = ByteToObject.toBoolean(cell_bytes);
                }
            }
            resultObject.put(column_name, column_value);
        }
        return resultObject;
    }

    public static byte[] BuildKey(ZillionTableSchema schema, JSONObject InsertObject) throws IOException {
        byte[][] bytess = new byte[schema.Key.length][];
        int i = 0;
        while (i < schema.Key.length) {
            String column_name = schema.Key[i];
            ZillionTableColumn column = schema.ColumnMap.get(column_name);
            bytess[i] = HTableUtil.GenerateKeyBytes(column, InsertObject.get((Object)column_name));
            ++i;
        }
        int bytes_count = 0;
        int i2 = 0;
        while (i2 < schema.Key.length) {
            bytes_count += bytess[i2].length;
            ++i2;
        }
        byte[] get_key = new byte[bytes_count];
        int bytes_index = 0;
        int i3 = 0;
        while (i3 < schema.Key.length) {
            System.arraycopy(bytess[i3], 0, get_key, bytes_index, bytess[i3].length);
            bytes_index += bytess[i3].length;
            ++i3;
        }
        return get_key;
    }

    public static byte[] BuildKey(Map<String, ZillionTableColumn> ColumnMap, String[] Key, Map<String, byte[]> columnBytesMap) {
        int bytes_count = 0;
        int i = 0;
        while (i < Key.length) {
            String column_name = Key[i];
            ++bytes_count;
            byte[] column_bytes = columnBytesMap.get(column_name);
            if (column_bytes != null) {
                bytes_count += column_bytes.length;
                ZillionTableColumn column = ColumnMap.get(column_name);
                if (column.Type == ZillionTableColumnEnum.STRING) {
                    ++bytes_count;
                }
            }
            ++i;
        }
        byte[] row_key_bytes = new byte[bytes_count];
        int bytes_index = 0;
        int i2 = 0;
        while (i2 < Key.length) {
            String keyItem = Key[i2];
            byte[] column_bytes = columnBytesMap.get(keyItem);
            if (column_bytes != null) {
                row_key_bytes[bytes_index] = 1;
                System.arraycopy(column_bytes, 0, row_key_bytes, ++bytes_index, column_bytes.length);
                bytes_index += column_bytes.length;
                ZillionTableColumn column = ColumnMap.get(keyItem);
                if (column.Type == ZillionTableColumnEnum.STRING) {
                    row_key_bytes[bytes_index] = 0;
                    ++bytes_index;
                }
            } else {
                row_key_bytes[bytes_index] = 0;
                ++bytes_index;
            }
            ++i2;
        }
        return row_key_bytes;
    }

    public static boolean Can_Convert(ZillionTableColumn column, Object columnObject) throws IOException {
        if (columnObject == null) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.STRING && columnObject instanceof String) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.COMPRESSSTRING && columnObject instanceof String) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof Integer) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof Long) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof BigInteger) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Integer) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Long) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof BigInteger) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Integer) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Long) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof BigInteger) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Float) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Double) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof BigDecimal) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Integer) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Long) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigInteger) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Float) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Double) {
            return true;
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigDecimal) {
            return true;
        }
        return column.Type == ZillionTableColumnEnum.BOOLEAN && columnObject instanceof Boolean;
    }

    public static Object ConvertValue(ZillionTableColumn column, Object columnObject) throws Exception {
        if (columnObject == null) {
            return null;
        }
        if (column.Type == ZillionTableColumnEnum.STRING && columnObject instanceof String) {
            return columnObject;
        }
        if (column.Type == ZillionTableColumnEnum.COMPRESSSTRING && columnObject instanceof String) {
            return columnObject;
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Integer) {
            return ((Integer)columnObject).longValue();
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Long) {
            return (long)((Long)columnObject);
        }
        if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof BigInteger) {
            return ((BigInteger)columnObject).longValue();
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Integer) {
            return ((Integer)columnObject).doubleValue();
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Long) {
            return ((Long)columnObject).doubleValue();
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigInteger) {
            return ((BigInteger)columnObject).doubleValue();
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Float) {
            return ((Float)columnObject).doubleValue();
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Double) {
            return (double)((Double)columnObject);
        }
        if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigDecimal) {
            return ((BigDecimal)columnObject).doubleValue();
        }
        if (column.Type == ZillionTableColumnEnum.BOOLEAN && columnObject instanceof Boolean) {
            return columnObject;
        }
        throw new MyException("Column Type error " + column.Name + " " + columnObject.getClass().getName());
    }

    public static byte[] GenerateBytes(ZillionTableColumn column, Object columnObject) throws IOException {
        byte[] data_bytes = null;
        if (columnObject == null) {
            return data_bytes;
        }
        if (column.Type == ZillionTableColumnEnum.STRING && columnObject instanceof String) {
            data_bytes = ByteToObject.toBytes((String)columnObject);
        } else if (column.Type == ZillionTableColumnEnum.COMPRESSSTRING && columnObject instanceof String) {
            data_bytes = CompressUtil.compress(ByteToObject.toBytes((String)columnObject));
        } else if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof Integer) {
            data_bytes = ByteToObject.toBytes((Integer)columnObject);
        } else if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof Long) {
            data_bytes = ByteToObject.toBytes(((Long)columnObject).intValue());
        } else if (column.Type == ZillionTableColumnEnum.INT && columnObject instanceof BigInteger) {
            data_bytes = ByteToObject.toBytes(((BigInteger)columnObject).intValue());
        } else if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Integer) {
            data_bytes = ByteToObject.toBytes(((Integer)columnObject).longValue());
        } else if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof Long) {
            data_bytes = ByteToObject.toBytes((Long)columnObject);
        } else if (column.Type == ZillionTableColumnEnum.LONG && columnObject instanceof BigInteger) {
            data_bytes = ByteToObject.toBytes(((BigInteger)columnObject).longValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Integer) {
            data_bytes = ByteToObject.toBytes(((Integer)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Long) {
            data_bytes = ByteToObject.toBytes(((Long)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof BigInteger) {
            data_bytes = ByteToObject.toBytes(((BigInteger)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Float) {
            data_bytes = ByteToObject.toBytes(((Float)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof Double) {
            data_bytes = ByteToObject.toBytes(((Double)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.FLOAT && columnObject instanceof BigDecimal) {
            data_bytes = ByteToObject.toBytes(((BigDecimal)columnObject).floatValue());
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Integer) {
            data_bytes = ByteToObject.toBytes(((Integer)columnObject).doubleValue());
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Long) {
            data_bytes = ByteToObject.toBytes(((Long)columnObject).doubleValue());
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigInteger) {
            data_bytes = ByteToObject.toBytes(((BigInteger)columnObject).doubleValue());
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Float) {
            data_bytes = ByteToObject.toBytes(((Float)columnObject).doubleValue());
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof Double) {
            data_bytes = ByteToObject.toBytes((Double)columnObject);
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE && columnObject instanceof BigDecimal) {
            data_bytes = ByteToObject.toBytes(((BigDecimal)columnObject).doubleValue());
        } else if (column.Type == ZillionTableColumnEnum.BOOLEAN && columnObject instanceof Boolean) {
            data_bytes = ByteToObject.toBytes((Boolean)columnObject);
        }
        return data_bytes;
    }

    public static byte[] GenerateKeyBytes(ZillionTableColumn column, Object columnObject) throws IOException {
        byte[] result = null;
        if (columnObject == null) {
            result = new byte[]{0};
        } else {
            byte[] data_bytes = HTableUtil.GenerateBytes(column, columnObject);
            if (column.Type == ZillionTableColumnEnum.STRING) {
                result = new byte[data_bytes.length + 2];
                result[0] = 1;
                System.arraycopy(data_bytes, 0, result, 1, data_bytes.length);
                result[result.length - 1] = 0;
            } else {
                result = new byte[data_bytes.length + 1];
                result[0] = 1;
                System.arraycopy(data_bytes, 0, result, 1, data_bytes.length);
            }
        }
        return result;
    }
}

