/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zillion.database.agent.ZillionCriteriaGroup;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.async.AsyncUtil;
import com.zillion.database.util.IDatabase;
import com.zillion.database.util.ITableWrapper;
import com.zillion.database.util.MemoryConfig;
import com.zillion.database.util.TableWrapper_HBase;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.HashUtil;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.HBaseAdminUtil;
import com.zillion.util.table.HBaseConnectionWrapper;
import com.zillion.util.table.HTableUtil;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKHelper;
import com.zillion.util.zk.ZKWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.format.FormatStaticUtil;
import org.zillion.util.log.LogUtil;

public class DatabaseImpl_HBase
implements IDatabase {
    Configuration configuration;
    Configuration configuration_bak;
    MemoryConfig configuration_memory;
    public Connection connection;
    public Admin admin;
    public Connection connection_bak;
    public Admin admin_bak;
    public HBaseConnectionWrapper ConnectionWrapper;
    public Map<String, HTable> table_meta_dataMap;
    public Map<String, HTable> table_meta_splitMap;
    public Map<String, HTable> table_meta_indexMap;

    public DatabaseImpl_HBase(Configuration configuration, Configuration configuration_bak) {
        this.configuration = configuration;
        this.configuration_bak = configuration_bak;
    }

    @Override
    public void Start() throws Exception {
        String principal = this.configuration.get("kerberos.principal");
        String file = this.configuration.get("keytab.file");
        if (principal != null && file != null) {
            String jaas_conf_path = this.configuration.get("zillion.jaas.conf");
            String krb5_conf_path = this.configuration.get("zillion.krb5.conf");
            System.setProperty("java.security.auth.login.config", jaas_conf_path);
            System.setProperty("java.security.krb5.conf", krb5_conf_path);
            int index_ = principal.indexOf("_HOST");
            if (index_ != -1) {
                String prefix = principal.substring(0, index_);
                String suffix = principal.substring(index_ + "_HOST".length());
                if (prefix.charAt(prefix.length() - 1) == '/' && suffix.charAt(0) == '@') {
                    principal = String.valueOf(prefix) + InetAddress.getLocalHost().getHostName() + suffix;
                    this.configuration.set("kerberos.principal", principal);
                }
            }
            UserGroupInformation.setConfiguration((Configuration)this.configuration);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.connection = ConnectionFactory.createConnection((Configuration)this.configuration);
        this.admin = this.connection.getAdmin();
        if (this.configuration_bak != null) {
            this.connection_bak = ConnectionFactory.createConnection((Configuration)this.configuration_bak);
            this.admin_bak = this.connection_bak.getAdmin();
        }
        this.ConnectionWrapper = new HBaseConnectionWrapper(this.configuration);
        this.ConnectionWrapper.InitializeConnection(this.connection);
        this.table_meta_dataMap = new HashMap<String, HTable>();
        this.table_meta_splitMap = new HashMap<String, HTable>();
        this.table_meta_indexMap = new HashMap<String, HTable>();
    }

    @Override
    public void Stop() throws Exception {
        this.connection.close();
    }

    public HTable Get_table_meta_data(String namespace) throws Exception {
        if (!this.table_meta_dataMap.containsKey(namespace)) {
            HTable table_meta_data = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_data"));
            this.table_meta_dataMap.put(namespace, table_meta_data);
        }
        return this.table_meta_dataMap.get(namespace);
    }

    public HTable Get_table_meta_split(String namespace) throws Exception {
        if (!this.table_meta_splitMap.containsKey(namespace) && this.admin.tableExists(TableName.valueOf((String)namespace, (String)"zillion_meta_split"))) {
            HTable table_meta_split = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_split"));
            this.table_meta_splitMap.put(namespace, table_meta_split);
        }
        return this.table_meta_splitMap.get(namespace);
    }

    public HTable Get_table_meta_index(String namespace) throws Exception {
        if (!this.table_meta_indexMap.containsKey(namespace)) {
            HTable table_meta_index = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_index"));
            this.table_meta_indexMap.put(namespace, table_meta_index);
        }
        return this.table_meta_indexMap.get(namespace);
    }

    @Override
    public List<String> ori_namespaceList() throws Exception {
        NamespaceDescriptor[] namespaces;
        ArrayList<String> result = new ArrayList<String>();
        NamespaceDescriptor[] namespaceDescriptorArray = namespaces = this.admin.listNamespaceDescriptors();
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            NamespaceDescriptor namespace = namespaceDescriptorArray[n2];
            String namespace_name = namespace.getName();
            if (!ZillionConstant.ReservedNamespaceMap.containsKey(namespace_name)) {
                result.add(namespace_name);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<String> ori_tableList(String namespace) throws Exception {
        HTableDescriptor[] descs;
        ArrayList<String> result = new ArrayList<String>();
        HTableDescriptor[] hTableDescriptorArray = descs = this.admin.listTableDescriptorsByNamespace(namespace);
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            HTableDescriptor desc = hTableDescriptorArray[n2];
            String table_name = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
            result.add(table_name);
            ++n2;
        }
        return result;
    }

    @Override
    public boolean ori_tableExists(String namespace, String ori_tableName) throws Exception {
        return this.admin.tableExists(TableName.valueOf((String)namespace, (String)ori_tableName));
    }

    @Override
    public void ori_drop_table(String namespace, String ori_tableName) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)ori_tableName));
    }

    @Override
    public void namespace_create(String namespace) throws Exception {
        HBaseAdminUtil.CreateNamespace(this.admin, this.admin_bak, namespace);
    }

    @Override
    public void namespace_drop(String namespace) throws Exception {
        HBaseAdminUtil.DeleteNamespace(this.admin, this.admin_bak, namespace);
    }

    @Override
    public void meta_manage_create_data(String namespace) throws Exception {
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)"zillion_meta_data"), ZillionConstant.familyNames, null, false, Compression.Algorithm.NONE);
    }

    @Override
    public void meta_manage_create_index(String namespace) throws Exception {
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)"zillion_meta_index"), ZillionConstant.familyNames, null, false, Compression.Algorithm.NONE);
    }

    @Override
    public void meta_manage_make_sure_split(String namespace) throws Exception {
        TableName zillion_meta_split = TableName.valueOf((String)namespace, (String)"zillion_meta_split");
        if (!HBaseAdminUtil.tableExists(this.admin, zillion_meta_split)) {
            HBaseAdminUtil.createTable(this.admin, this.admin_bak, zillion_meta_split, ZillionConstant.familyNames, null, false, Compression.Algorithm.NONE);
        }
    }

    @Override
    public void meta_manage_drop_data(String namespace) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)"zillion_meta_data"));
    }

    @Override
    public void meta_manage_drop_index(String namespace) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)"zillion_meta_index"));
    }

    @Override
    public void meta_manage_drop_split(String namespace) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)"zillion_meta_split"));
    }

    @Override
    public void meta_query_insert_data(String namespace, String tableName, JSONObject content, HashObject hashObject) throws Exception {
        HTable table_meta_data = this.Get_table_meta_data(namespace);
        Put put_table = new Put(ByteToObject.toBytes(tableName));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("q"), ByteToObject.toBytes(JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_data.put(put_table);
    }

    @Override
    public void meta_query_insert_index(String namespace, String tableName, String indexName, JSONArray indexColumns, HashObject hashObject) throws Exception {
        HTable table_meta_index = this.Get_table_meta_index(namespace);
        Put put_index = new Put(ByteToObject.toBytes(String.valueOf(tableName) + "." + indexName));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("q"), ByteToObject.toBytes(JSON.toJSONString((Object)indexColumns, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_index.put(put_index);
    }

    @Override
    public void meta_query_insert_split(String namespace, String tableName, HashObject hashObject) throws Exception {
        HTable table_meta_split = this.Get_table_meta_split(namespace);
        Put put_table = new Put(ByteToObject.toBytes(tableName));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_split.put(put_table);
    }

    @Override
    public void meta_query_delete_data(String namespace, String tableName) throws Exception {
        HTable table_meta_data = this.Get_table_meta_data(namespace);
        Delete delete_table = new Delete(ByteToObject.toBytes(tableName));
        delete_table.addFamily(ByteToObject.toBytes("f"));
        table_meta_data.delete(delete_table);
    }

    @Override
    public void meta_query_delete_index(String namespace, String tableName, String indexName) throws Exception {
        HTable table_meta_index = this.Get_table_meta_index(namespace);
        Delete delete_index = new Delete(ByteToObject.toBytes(String.valueOf(tableName) + "." + indexName));
        delete_index.addFamily(ByteToObject.toBytes("f"));
        table_meta_index.delete(delete_index);
    }

    @Override
    public void meta_query_delete_split(String namespace, String tableName) throws Exception {
        Delete delete_table = new Delete(ByteToObject.toBytes(tableName));
        delete_table.addFamily(ByteToObject.toBytes("f"));
        HTable table_meta_split = this.Get_table_meta_split(namespace);
        table_meta_split.delete(delete_table);
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, JSONObject content) throws Exception {
        HTable table_meta_data = this.Get_table_meta_data(namespace);
        Put put_table = new Put(ByteToObject.toBytes(tableName));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("q"), ByteToObject.toBytes(JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        table_meta_data.put(put_table);
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, HashObject hashObject) throws Exception {
        HTable table_meta_data = this.Get_table_meta_data(namespace);
        Put put_table = new Put(ByteToObject.toBytes(tableName));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_data.put(put_table);
    }

    @Override
    public void meta_query_update_index(String namespace, String tableName, String indexName, HashObject hashObject) throws Exception {
        HTable table_meta_index = this.Get_table_meta_index(namespace);
        Put put_index = new Put(ByteToObject.toBytes(String.valueOf(tableName) + "." + indexName));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_index.put(put_index);
    }

    @Override
    public void meta_query_update_split_data(String namespace, String tableName, String child_name, HashObject hashObject) throws Exception {
        HTable table_meta_split = this.Get_table_meta_split(namespace);
        Put put_index = new Put(ByteToObject.toBytes(String.valueOf(tableName) + "_" + child_name));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_split.put(put_index);
    }

    @Override
    public void meta_query_update_split_index(String namespace, String tableName, String indexName, String child_name, HashObject hashObject) throws Exception {
        HTable table_meta_split = this.Get_table_meta_split(namespace);
        Put put_index = new Put(ByteToObject.toBytes(String.valueOf(tableName) + "." + indexName + "_" + child_name));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
        table_meta_split.put(put_index);
    }

    @Override
    public boolean table_split_index_exist(String namespace, String table_name, String index_name, String child_name) throws Exception {
        String tableName = "zillion_index_" + table_name + "." + index_name + "_" + child_name;
        return this.ori_tableExists(namespace, tableName);
    }

    @Override
    public void table_manage_create_data(String namespace, ZillionTableSchema schema) throws Exception {
        String tableName = schema.table_name;
        boolean inMemory = false;
        if (this.configuration_memory == null && schema.resident_memory) {
            inMemory = true;
        }
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_data_" + tableName)), ZillionConstant.familyNames, schema.splitKeys, inMemory, schema.compress ? Compression.Algorithm.LZ4 : Compression.Algorithm.NONE);
    }

    @Override
    public void table_manage_create_index(String namespace, String tableName, ZillionTableIndex schema_index) throws Exception {
        String indexName = schema_index.index_name;
        boolean inMemory = false;
        if (this.configuration_memory == null && schema_index.schema.resident_memory) {
            inMemory = true;
        }
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + tableName + "." + indexName)), ZillionConstant.familyNames, null, inMemory, schema_index.schema.compress ? Compression.Algorithm.LZ4 : Compression.Algorithm.NONE);
    }

    @Override
    public void table_manage_create_split_data(String namespace, String tableName, String child_name, ZillionTableSchema schema) throws Exception {
        String ori_tableName = "zillion_data_" + tableName + "_" + child_name;
        TableName tableNameObject = TableName.valueOf((String)namespace, (String)ori_tableName);
        boolean inMemory = false;
        if (this.configuration_memory == null && schema.resident_memory) {
            inMemory = true;
        }
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, tableNameObject, ZillionConstant.familyNames, schema.splitKeys, inMemory, schema.compress ? Compression.Algorithm.LZ4 : Compression.Algorithm.NONE);
    }

    @Override
    public void table_manage_create_split_index(String namespace, String tableName, String indexName, String child_name, ZillionTableIndex schema_index) throws Exception {
        String ori_tableName = "zillion_index_" + tableName + "." + indexName + "_" + child_name;
        TableName tableNameObject = TableName.valueOf((String)namespace, (String)ori_tableName);
        boolean inMemory = false;
        if (this.configuration_memory == null && schema_index.schema.resident_memory) {
            inMemory = true;
        }
        HBaseAdminUtil.createTable(this.admin, this.admin_bak, tableNameObject, ZillionConstant.familyNames, null, inMemory, schema_index.schema.compress ? Compression.Algorithm.LZ4 : Compression.Algorithm.NONE);
    }

    @Override
    public void table_manage_drop_data(String namespace, String tableName) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_data_" + tableName)));
    }

    @Override
    public void table_manage_drop_index(String namespace, String tableName, String indexName) throws Exception {
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + tableName + "." + indexName)));
    }

    @Override
    public void table_manage_drop_split_data(String namespace, String tableName, String child_name) throws Exception {
        String tableNameString = "zillion_data_" + tableName + "_" + child_name;
        TableName tableNameObject = TableName.valueOf((String)namespace, (String)tableNameString);
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, tableNameObject);
    }

    @Override
    public void table_manage_drop_split_index(String namespace, String tableName, String indexName, String child_name) throws Exception {
        String tableNameString = "zillion_index_" + tableName + "." + indexName + "_" + child_name;
        TableName tableNameObject = TableName.valueOf((String)namespace, (String)tableNameString);
        HBaseAdminUtil.deleteTable(this.admin, this.admin_bak, tableNameObject);
    }

    @Override
    public void table_manage_alter_add_column(String namespace, String ori_tableName, List<ZillionTableColumn> ztcList) throws Exception {
    }

    @Override
    public void table_manage_alter_drop_column(String namespace, String ori_tableName, List<String> columnList) throws Exception {
    }

    @Override
    public void table_manage_alter_compression(String namespace, String ori_tableName, boolean enable) throws Exception {
        HBaseAdminUtil.modifyColumn_compression(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)ori_tableName), ZillionConstant.familyNames, enable ? Compression.Algorithm.LZ4 : Compression.Algorithm.NONE);
    }

    @Override
    public void table_manage_alter_in_memory(String namespace, String ori_tableName, boolean enable) throws Exception {
        HBaseAdminUtil.modifyColumn_in_memory(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)ori_tableName), ZillionConstant.familyNames, enable);
    }

    @Override
    public void meta_read(String namespace, List<String> tableNameList, List<String> tableContentList, List<HashObject> tableHashList, List<String> indexNameList, List<String> indexContentList, List<HashObject> indexHashList, List<String> splitNameList, List<HashObject> splitHashList) throws Exception {
        HashObject hashObject;
        String q;
        String row;
        Result res;
        HTable table_meta_data = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_data"));
        HTable table_meta_index = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_index"));
        this.table_meta_dataMap.put(namespace, table_meta_data);
        this.table_meta_indexMap.put(namespace, table_meta_index);
        Scan scan = new Scan();
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("q"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
        ResultScanner scanner = table_meta_data.getScanner(scan);
        while ((res = scanner.next()) != null) {
            row = ByteToObject.toString(res.getRow());
            q = ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("q")));
            hashObject = new HashObject();
            hashObject.insert_count = Long.parseLong(ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"))));
            hashObject.delete_count = Long.parseLong(ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"))));
            hashObject.hash_code = res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
            tableNameList.add(row);
            tableContentList.add(q);
            tableHashList.add(hashObject);
        }
        scanner.close();
        scan = new Scan();
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("q"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"));
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
        scanner = table_meta_index.getScanner(scan);
        while ((res = scanner.next()) != null) {
            row = ByteToObject.toString(res.getRow());
            q = ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("q")));
            hashObject = new HashObject();
            hashObject.insert_count = Long.parseLong(ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"))));
            hashObject.delete_count = Long.parseLong(ByteToObject.toString(res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"))));
            hashObject.hash_code = res.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
            indexNameList.add(row);
            indexContentList.add(q);
            indexHashList.add(hashObject);
        }
        scanner.close();
        if (this.admin.tableExists(TableName.valueOf((String)namespace, (String)"zillion_meta_split"))) {
            Result res2;
            HTable table_meta_split = (HTable)this.connection.getTable(TableName.valueOf((String)namespace, (String)"zillion_meta_split"));
            this.table_meta_splitMap.put(namespace, table_meta_split);
            Scan scan2 = new Scan();
            scan2.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"));
            scan2.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"));
            scan2.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
            ResultScanner scanner2 = table_meta_split.getScanner(scan2);
            while ((res2 = scanner2.next()) != null) {
                String row2 = ByteToObject.toString(res2.getRow());
                hashObject = new HashObject();
                hashObject.insert_count = Long.parseLong(ByteToObject.toString(res2.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"))));
                hashObject.delete_count = Long.parseLong(ByteToObject.toString(res2.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"))));
                hashObject.hash_code = res2.getValue(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"));
                splitNameList.add(row2);
                splitHashList.add(hashObject);
            }
            scanner2.close();
        }
    }

    @Override
    public int clear_table_split(String namespace, ZillionTableSchema schema, List<String> query_monthList, ZKWrapper ZK) throws Exception {
        Object query_month;
        String query_month2;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        Stat stat = new Stat();
        int count = 0;
        int index_split = 0;
        while (index_split < query_monthList.size()) {
            query_month2 = query_monthList.get(index_split);
            byte[] hash = ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "/" + query_month2, false, stat);
            HashObject hashObject = HashUtil.Parse(hash);
            hashObject.delete_count = hashObject.insert_count - hashObject.delete_count;
            hashObject.insert_count = 0L;
            count = (int)((long)count + hashObject.delete_count);
            ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + query_month2 + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
            for (ZillionTableIndex schema_index : schema.Indexes) {
                String indexName = schema_index.index_name;
                ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + (String)indexName + "/" + query_month2 + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
            }
            ++index_split;
        }
        int index_wait = 0;
        while (index_wait < 15) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean hash_tmp_finish = true;
            int index_split2 = 0;
            while (index_split2 < query_monthList.size()) {
                query_month = query_monthList.get(index_split2);
                List<String> children = ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + (String)query_month, false);
                if (children.size() > 0) {
                    hash_tmp_finish = false;
                }
                for (ZillionTableIndex schema_index : schema.Indexes) {
                    String indexName = schema_index.index_name;
                    children = ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName + "/" + (String)query_month, false);
                    if (children.size() <= 0) continue;
                    hash_tmp_finish = false;
                    break;
                }
                if (!hash_tmp_finish) break;
                ++index_split2;
            }
            if (hash_tmp_finish) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            ++index_wait;
        }
        index_split = 0;
        while (index_split < query_monthList.size()) {
            query_month2 = query_monthList.get(index_split);
            ZKHelper.recursiveChildren(ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + query_month2);
            for (ZillionTableIndex schema_index : schema.Indexes) {
                String indexName = schema_index.index_name;
                ZKHelper.recursiveChildren(ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName + "/" + query_month2);
            }
            ++index_split;
        }
        HashObject hashObject = new HashObject();
        byte[] hash = hashObject.toBytes();
        int index_split3 = 0;
        while (index_split3 < query_monthList.size()) {
            query_month = query_monthList.get(index_split3);
            ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "/" + (String)query_month, hash, -1);
            HTable table_meta_split = this.Get_table_meta_split(namespace);
            Put put_table = new Put(ByteToObject.toBytes(String.valueOf(schema.table_name) + "_" + (String)query_month));
            put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
            put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
            put_table.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
            table_meta_split.put(put_table);
            HBaseAdminUtil.clearTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_data_" + schema.table_name + "_" + (String)query_month)));
            for (ZillionTableIndex schema_index : schema.Indexes) {
                String indexName = schema_index.index_name;
                ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "." + indexName + "/" + (String)query_month, hash, -1);
                Put put_index = new Put(ByteToObject.toBytes(String.valueOf(schema.table_name) + "." + indexName + "_" + (String)query_month));
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hi"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.insert_count)));
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hd"), ByteToObject.toBytes(FormatStaticUtil.toString(hashObject.delete_count)));
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("hc"), hashObject.hash_code);
                table_meta_split.put(put_index);
                HBaseAdminUtil.clearTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + schema.table_name + "." + indexName + "_" + (String)query_month)));
            }
            ++index_split3;
        }
        return count;
    }

    @Override
    public int clear_table_not_split(String namespace, ZillionTableSchema schema, ZKWrapper ZK) throws Exception {
        Object indexName;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        Stat stat = new Stat();
        int count = 0;
        byte[] hash = ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false, stat);
        HashObject hashObject = HashUtil.Parse(hash);
        hashObject.delete_count = hashObject.insert_count - hashObject.delete_count;
        hashObject.insert_count = 0L;
        count = (int)((long)count + hashObject.delete_count);
        ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
        for (ZillionTableIndex schema_index : schema.Indexes) {
            indexName = schema_index.index_name;
            ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + (String)indexName + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
        }
        int index_wait = 0;
        while (index_wait < 15) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean hash_tmp_finish = true;
            List<String> children = ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name, false);
            if (children.size() > 0) {
                hash_tmp_finish = false;
            }
            for (ZillionTableIndex schema_index : schema.Indexes) {
                String indexName2 = schema_index.index_name;
                children = ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName2, false);
                if (children.size() <= 0) continue;
                hash_tmp_finish = false;
                break;
            }
            if (hash_tmp_finish) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            ++index_wait;
        }
        ZKHelper.recursiveChildren(ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name);
        for (ZillionTableIndex schema_index : schema.Indexes) {
            String indexName3 = schema_index.index_name;
            ZKHelper.recursiveChildren(ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName3);
        }
        HashObject hashObject2 = new HashObject();
        byte[] hash2 = hashObject2.toBytes();
        ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, hash2, -1);
        HBaseAdminUtil.clearTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_data_" + schema.table_name)));
        for (ZillionTableIndex schema_index : schema.Indexes) {
            indexName = schema_index.index_name;
            ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "." + (String)indexName, hash2, -1);
            HBaseAdminUtil.clearTable(this.admin, this.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + schema.table_name + "." + (String)indexName)));
        }
        return count;
    }

    private static void generate_ScanColumns(ZillionTableSchema schema, JSONObject Criteria, Map<String, Boolean> ScanColumnsMap) {
        for (String key : Criteria.keySet()) {
            ScanColumnsMap.put(key, true);
        }
    }

    @Override
    public void scan(SchemaRepositoryContainer container, ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray ReturnColumns, ZillionCriteriaGroup group, String QueryType, JSONArray content, ZillionQueryTmp zqt, ZipArchiveOutputStream out, AsyncJob job, boolean SortInDB, JSONArray OrderBy, long Limit_Skip, long Limit_Count, ZillionQueryResult result, JSONObject Set2) throws Exception {
        JSONArray contentInner;
        block62: {
            Object column_name;
            HashMap<String, Boolean> ScanColumnsMap = new HashMap<String, Boolean>();
            DatabaseImpl_HBase.generate_ScanColumns(schema, group.otherCriteria, ScanColumnsMap);
            boolean SortAsc = true;
            if (QueryType.equals("delete")) {
                for (ZillionTableIndex index_schama : schema.Indexes) {
                    String[] stringArray = index_schama.Key;
                    int n = index_schama.Key.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyItem = stringArray[n2];
                        ScanColumnsMap.put(keyItem, true);
                        ++n2;
                    }
                }
            } else if (QueryType.equals("update")) {
                String keyItem;
                int n;
                int n3;
                String[] stringArray;
                boolean update_index = false;
                for (ZillionTableIndex index_schama : schema.Indexes) {
                    stringArray = index_schama.Key;
                    n3 = index_schama.Key.length;
                    n = 0;
                    while (n < n3) {
                        keyItem = stringArray[n];
                        if (Set2.containsKey((Object)keyItem)) {
                            update_index = true;
                            break;
                        }
                        ++n;
                    }
                    if (update_index) break;
                }
                if (update_index) {
                    int i = 0;
                    while (i < schema.OtherColumn.length) {
                        column_name = schema.OtherColumn[i];
                        ScanColumnsMap.put((String)column_name, true);
                        ++i;
                    }
                } else {
                    for (ZillionTableIndex index_schama : schema.Indexes) {
                        stringArray = index_schama.Key;
                        n3 = index_schama.Key.length;
                        n = 0;
                        while (n < n3) {
                            keyItem = stringArray[n];
                            ScanColumnsMap.put(keyItem, true);
                            ++n;
                        }
                    }
                }
            } else if (QueryType.equals("select") || QueryType.equals("export")) {
                int n;
                if (ReturnColumns == null) {
                    ReturnColumns = new JSONArray();
                    for (String key : schema.ColumnMap.keySet()) {
                        ReturnColumns.add((Object)key);
                    }
                }
                String[] keysInner = group.index_index == -1 ? schema.Key : schema.Indexes.get((int)group.index_index).Key;
                int index_rcs = 0;
                while (index_rcs < ReturnColumns.size()) {
                    String key = (String)ReturnColumns.get(index_rcs);
                    boolean key_exist = false;
                    String[] stringArray = keysInner;
                    n = keysInner.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String keyInner = stringArray[n4];
                        if (keyInner.equals(key)) {
                            key_exist = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!key_exist) {
                        ScanColumnsMap.put(key, true);
                    }
                    ++index_rcs;
                }
                if (!SortInDB && OrderBy != null && OrderBy.size() > 0) {
                    int i = 0;
                    while (i < OrderBy.size()) {
                        JSONObject item = (JSONObject)OrderBy.get(i);
                        String key = (String)item.get((Object)"Column");
                        boolean key_exist = false;
                        String[] stringArray = keysInner;
                        int n5 = keysInner.length;
                        n = 0;
                        while (n < n5) {
                            String keyInner = stringArray[n];
                            if (keyInner.equals(key)) {
                                key_exist = true;
                                break;
                            }
                            ++n;
                        }
                        if (!key_exist) {
                            ScanColumnsMap.put(key, true);
                        }
                        ++i;
                    }
                }
                if (SortInDB && OrderBy != null && OrderBy.size() > 0) {
                    JSONObject item0 = (JSONObject)OrderBy.get(0);
                    SortAsc = (Boolean)item0.get((Object)"Asc");
                }
            }
            Scan scan = new Scan();
            scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"));
            if (schema.table_type == null || schema.table_type.equals("index_data") || schema.table_type.startsWith("split_")) {
                int i = 0;
                while (i < schema.OtherColumn.length) {
                    column_name = schema.OtherColumn[i];
                    if (ScanColumnsMap.containsKey(column_name)) {
                        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes((String)column_name));
                    }
                    ++i;
                }
            } else if (schema.table_type.equals("all_column")) {
                String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
                int ii = 0;
                while (ii < Columns.length) {
                    String column_name2 = Columns[ii];
                    scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name2));
                    ++ii;
                }
            }
            if (!SortAsc) {
                scan.setReversed(true);
                scan.setStartRow(group.itemListOfGroup.get((int)0).bytes_lt);
                scan.setStopRow(group.itemListOfGroup.get((int)0).bytes_gt);
                if (group.valueFilterList.size() > 0) {
                    FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                    for (Filter filter : group.valueFilterList) {
                        filterList.addFilter(filter);
                    }
                    scan.setFilter((Filter)filterList);
                }
            } else {
                MultiRowRangeFilter rowFilter = new MultiRowRangeFilter(group.rangeList_new);
                if (group.valueFilterList.size() > 0) {
                    FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                    filterList.addFilter((Filter)rowFilter);
                    for (Filter filter : group.valueFilterList) {
                        filterList.addFilter(filter);
                    }
                    scan.setFilter((Filter)filterList);
                } else {
                    scan.setFilter((Filter)rowFilter);
                }
            }
            ITableWrapper tableWrapper = group.index_index == -1 ? schemaWrapper.dataWrapper : schemaWrapper.indexWrapperList.get(group.index_index);
            ResultScanner scanner = ((TableWrapper_HBase)tableWrapper).htable.getScanner(scan);
            contentInner = new JSONArray();
            try {
                Result res;
                while ((res = scanner.next()) != null) {
                    if (!HTableUtil.valid(schema, res.listCells())) continue;
                    JSONObject resultObject = null;
                    if (group.scObject != null) {
                        if (group.index_index == -1) {
                            resultObject = HTableUtil.Convert(schema, res.getRow(), res.listCells());
                        } else {
                            ZillionTableIndex schema_index = schema.Indexes.get(group.index_index);
                            resultObject = HTableUtil.Convert_index_data(schema, schema_index, res.getRow(), res.listCells());
                        }
                        if (!group.scObject.match(resultObject)) continue;
                    }
                    ++zqt.scanned_count;
                    ++zqt.count_wait_tmp;
                    if (zqt.count_wait_tmp >= AsyncUtil.count_wait) {
                        job.Add(zqt.count_wait_tmp);
                        zqt.count_wait_tmp = 0L;
                    }
                    if ((long)zqt.scanned_count > Limit_Skip && (long)zqt.scanned_count <= Limit_Skip + Limit_Count) {
                        ++result.count;
                        if (!QueryType.equals("select_count")) {
                            if (resultObject == null) {
                                if (group.index_index == -1) {
                                    resultObject = HTableUtil.Convert(schema, res.getRow(), res.listCells());
                                } else {
                                    ZillionTableIndex schema_index = schema.Indexes.get(group.index_index);
                                    resultObject = HTableUtil.Convert_index_data(schema, schema_index, res.getRow(), res.listCells());
                                }
                            }
                            if (QueryType.equals("select")) {
                                if (job.brs != null) {
                                    job.brs.TryPush(resultObject);
                                } else {
                                    content.add((Object)resultObject);
                                }
                            } else {
                                contentInner.add((Object)resultObject);
                            }
                        }
                        if (QueryType.equals("delete") && (long)contentInner.size() >= ZillionConstant.query_group_size) {
                            this.batch_process(schema, schemaWrapper, QueryType, contentInner, Set2, false);
                            contentInner.clear();
                        }
                        if (!QueryType.equals("export") || (long)contentInner.size() < ZillionConstant.export_batch_size) continue;
                        out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(String.valueOf(zqt.df.format(zqt.zip_index++)) + ".json"));
                        byte[] bytes = JSON.toJSONString((Object)contentInner, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8");
                        out.write(bytes);
                        out.closeArchiveEntry();
                        contentInner.clear();
                        continue;
                    }
                    if ((long)zqt.scanned_count <= Limit_Skip + Limit_Count) continue;
                    zqt.scanned_finish = true;
                    break;
                }
                scanner.close();
            }
            catch (Exception e) {
                LogUtil.warn(e);
                try {
                    scanner.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e instanceof NullPointerException) break block62;
                throw e;
            }
        }
        if (zqt.count_wait_tmp > 0L) {
            job.Add(zqt.count_wait_tmp);
            zqt.count_wait_tmp = 0L;
        }
        if ((QueryType.equals("delete") || QueryType.equals("update")) && contentInner.size() > 0) {
            this.batch_process(schema, schemaWrapper, QueryType, contentInner, Set2, false);
            contentInner.clear();
        }
        if (QueryType.equals("export") && contentInner.size() > 0) {
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(String.valueOf(zqt.df.format(zqt.zip_index++)) + ".json"));
            byte[] bytes = JSON.toJSONString((Object)contentInner, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8");
            out.write(bytes);
            out.closeArchiveEntry();
            contentInner.clear();
        }
    }

    @Override
    public void batch_process(ZillionTableSchema schema, SchemaWrapper wrapper, String QueryType, JSONArray InsertObjects, JSONObject Set2, boolean is_put) throws Exception {
        ITableWrapper indexTable;
        int i;
        if (!(QueryType.equals("insert") || QueryType.equals("delete") || QueryType.equals("update"))) {
            return;
        }
        if (InsertObjects.size() == 0) {
            return;
        }
        HashMap<String, byte[]> columnBytesMap_new = new HashMap<String, byte[]>();
        if (QueryType.equals("update")) {
            int i2 = 0;
            while (i2 < schema.OtherColumn.length) {
                String column_name = schema.OtherColumn[i2];
                ZillionTableColumn column = schema.ColumnMap.get(column_name);
                if (Set2.containsKey((Object)column_name)) {
                    Object columnObject = Set2.get((Object)column_name);
                    byte[] column_bytes = HTableUtil.GenerateBytes(column, columnObject);
                    columnBytesMap_new.put(column_name, column_bytes);
                }
                ++i2;
            }
        }
        ArrayList<Delete> batch_delete = new ArrayList<Delete>();
        ArrayList<Put> batch_delete_UsePutV = new ArrayList<Put>();
        ArrayList<Put> batch_insert = new ArrayList<Put>();
        ArrayList index_deleteListList = new ArrayList();
        ArrayList index_deleteListList_UsePutV = new ArrayList();
        ArrayList index_insertListList = new ArrayList();
        int index_object = 0;
        while (index_object < InsertObjects.size()) {
            HashMap<String, byte[]> columnBytesMap_tmp;
            JSONObject InsertObject = (JSONObject)InsertObjects.get(index_object);
            HashMap<String, byte[]> columnBytesMap = new HashMap<String, byte[]>();
            for (String column_name : schema.ColumnMap.keySet()) {
                ZillionTableColumn column = schema.ColumnMap.get(column_name);
                if (!InsertObject.containsKey((Object)column_name)) continue;
                Object columnObject = InsertObject.get((Object)column_name);
                byte[] column_bytes = HTableUtil.GenerateBytes(column, columnObject);
                columnBytesMap.put(column_name, column_bytes);
            }
            if (QueryType.equals("update")) {
                columnBytesMap_tmp = new HashMap();
                columnBytesMap_tmp.putAll(columnBytesMap);
                for (String key : columnBytesMap_new.keySet()) {
                    columnBytesMap_tmp.remove(key);
                    columnBytesMap_tmp.put(key, (byte[])columnBytesMap_new.get(key));
                }
            } else {
                columnBytesMap_tmp = columnBytesMap;
            }
            int i3 = 0;
            while (i3 < schema.Indexes.size()) {
                index_deleteListList.add(new ArrayList());
                index_deleteListList_UsePutV.add(new ArrayList());
                index_insertListList.add(new ArrayList());
                ++i3;
            }
            byte[] row_key_bytes = HTableUtil.BuildKey(schema.ColumnMap, schema.Key, columnBytesMap);
            byte[] row_key_bytes_new = HTableUtil.BuildKey(schema.ColumnMap, schema.Key, columnBytesMap_tmp);
            if (QueryType.equals("delete")) {
                if (schema.delete_UsePutV) {
                    Put delete_UsePutV = DatabaseImpl_HBase.build_data_delete_UsePutV(schema, row_key_bytes);
                    batch_delete_UsePutV.add(delete_UsePutV);
                } else {
                    Delete delete = new Delete(row_key_bytes);
                    delete.addFamily(ByteToObject.toBytes("f"));
                    batch_delete.add(delete);
                }
            } else if (QueryType.equals("insert")) {
                Put put = DatabaseImpl_HBase.build_data_insert(schema, row_key_bytes, columnBytesMap_tmp, false);
                batch_insert.add(put);
            } else if (QueryType.equals("update")) {
                Put put;
                int compare = Bytes.compareTo((byte[])row_key_bytes, (byte[])row_key_bytes_new);
                if (compare == 0) {
                    put = DatabaseImpl_HBase.build_data_insert(schema, row_key_bytes_new, columnBytesMap_tmp, true);
                    batch_insert.add(put);
                } else {
                    if (schema.delete_UsePutV) {
                        Put delete_UsePutV = DatabaseImpl_HBase.build_data_delete_UsePutV(schema, row_key_bytes);
                        batch_delete_UsePutV.add(delete_UsePutV);
                    } else {
                        Delete delete = new Delete(row_key_bytes);
                        delete.addFamily(ByteToObject.toBytes("f"));
                        batch_delete.add(delete);
                    }
                    put = DatabaseImpl_HBase.build_data_insert(schema, row_key_bytes_new, columnBytesMap_tmp, false);
                    batch_insert.add(put);
                }
            }
            int i4 = 0;
            while (i4 < schema.Indexes.size()) {
                byte[] index_row_bytes;
                ZillionTableIndex index = schema.Indexes.get(i4);
                List index_deleteList = (List)index_deleteListList.get(i4);
                List index_deleteList_UsePutV = (List)index_deleteListList_UsePutV.get(i4);
                List index_insertList = (List)index_insertListList.get(i4);
                if (schema.table_type == null) {
                    byte[] row_key_bytes_index = HTableUtil.BuildKey(schema.ColumnMap, index.Key, columnBytesMap);
                    index_row_bytes = new byte[row_key_bytes_index.length + row_key_bytes.length];
                    System.arraycopy(row_key_bytes_index, 0, index_row_bytes, 0, row_key_bytes_index.length);
                    System.arraycopy(row_key_bytes, 0, index_row_bytes, row_key_bytes_index.length, row_key_bytes.length);
                } else {
                    index_row_bytes = HTableUtil.BuildKey(schema.ColumnMap, index.Key, columnBytesMap);
                }
                if (QueryType.equals("delete")) {
                    if (schema.delete_UsePutV) {
                        Put delete_UsePutV = DatabaseImpl_HBase.build_index_delete_UsePutV(schema, index, index_row_bytes);
                        index_deleteList_UsePutV.add(delete_UsePutV);
                    } else {
                        Delete delete_index = new Delete(index_row_bytes);
                        delete_index.addFamily(ByteToObject.toBytes("f"));
                        index_deleteList.add(delete_index);
                    }
                } else if (QueryType.equals("insert")) {
                    Put put_index = DatabaseImpl_HBase.build_index_insert(schema, index, index_row_bytes, columnBytesMap_tmp, false);
                    index_insertList.add(put_index);
                } else if (QueryType.equals("update")) {
                    Put put_index;
                    byte[] index_row_bytes_new;
                    if (schema.table_type == null) {
                        byte[] row_key_bytes_index = HTableUtil.BuildKey(schema.ColumnMap, index.Key, columnBytesMap_tmp);
                        index_row_bytes_new = new byte[row_key_bytes_index.length + row_key_bytes_new.length];
                        System.arraycopy(row_key_bytes_index, 0, index_row_bytes_new, 0, row_key_bytes_index.length);
                        System.arraycopy(row_key_bytes_new, 0, index_row_bytes_new, row_key_bytes_index.length, row_key_bytes_new.length);
                    } else {
                        index_row_bytes_new = HTableUtil.BuildKey(schema.ColumnMap, index.Key, columnBytesMap_tmp);
                    }
                    int compare = Bytes.compareTo((byte[])index_row_bytes, (byte[])index_row_bytes_new);
                    if (compare == 0) {
                        put_index = DatabaseImpl_HBase.build_index_insert(schema, index, index_row_bytes_new, columnBytesMap_tmp, true);
                        index_insertList.add(put_index);
                    } else {
                        if (schema.delete_UsePutV) {
                            Put delete_UsePutV = DatabaseImpl_HBase.build_index_delete_UsePutV(schema, index, index_row_bytes);
                            index_deleteList_UsePutV.add(delete_UsePutV);
                        } else {
                            Delete delete_index = new Delete(index_row_bytes);
                            delete_index.addFamily(ByteToObject.toBytes("f"));
                            index_deleteList.add(delete_index);
                        }
                        put_index = DatabaseImpl_HBase.build_index_insert(schema, index, index_row_bytes_new, columnBytesMap_tmp, false);
                        index_insertList.add(put_index);
                    }
                }
                ++i4;
            }
            ++index_object;
        }
        if (schema.delete_UsePutV) {
            if (batch_delete_UsePutV.size() > 0) {
                ((TableWrapper_HBase)wrapper.dataWrapper).htable.put(batch_delete_UsePutV);
                if (ZillionConstant.disable_AutoFlush) {
                    ((TableWrapper_HBase)wrapper.dataWrapper).htable.flushCommits();
                }
            }
        } else if (batch_delete.size() > 0) {
            ((TableWrapper_HBase)wrapper.dataWrapper).htable.delete(batch_delete);
            if (ZillionConstant.disable_AutoFlush) {
                ((TableWrapper_HBase)wrapper.dataWrapper).htable.flushCommits();
            }
        }
        if (batch_insert.size() > 0) {
            ((TableWrapper_HBase)wrapper.dataWrapper).htable.put(batch_insert);
            if (ZillionConstant.disable_AutoFlush) {
                ((TableWrapper_HBase)wrapper.dataWrapper).htable.flushCommits();
            }
        }
        if (schema.delete_UsePutV) {
            i = 0;
            while (i < schema.Indexes.size()) {
                indexTable = wrapper.indexWrapperList.get(i);
                List index_deleteList_UsePutV = (List)index_deleteListList_UsePutV.get(i);
                if (index_deleteList_UsePutV.size() > 0) {
                    ((TableWrapper_HBase)indexTable).htable.put(index_deleteList_UsePutV);
                    if (ZillionConstant.disable_AutoFlush) {
                        ((TableWrapper_HBase)indexTable).htable.flushCommits();
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < schema.Indexes.size()) {
                indexTable = wrapper.indexWrapperList.get(i);
                List index_deleteList = (List)index_deleteListList.get(i);
                if (index_deleteList.size() > 0) {
                    ((TableWrapper_HBase)indexTable).htable.delete(index_deleteList);
                    if (ZillionConstant.disable_AutoFlush) {
                        ((TableWrapper_HBase)indexTable).htable.flushCommits();
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < schema.Indexes.size()) {
            indexTable = wrapper.indexWrapperList.get(i);
            List index_insertList = (List)index_insertListList.get(i);
            if (index_insertList.size() > 0) {
                ((TableWrapper_HBase)indexTable).htable.put(index_insertList);
                if (ZillionConstant.disable_AutoFlush) {
                    ((TableWrapper_HBase)indexTable).htable.flushCommits();
                }
            }
            ++i;
        }
    }

    private static Put build_data_delete_UsePutV(ZillionTableSchema schema, byte[] row_key_bytes) {
        Put delete_UsePutV;
        block3: {
            block2: {
                delete_UsePutV = new Put(row_key_bytes);
                delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"), ByteToObject.toBytes("0"));
                if (schema.table_type != null && !schema.table_type.equals("index_data") && !schema.table_type.startsWith("split_")) break block2;
                int i = 0;
                while (i < schema.OtherColumn.length) {
                    String column_name = schema.OtherColumn[i];
                    delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), null);
                    ++i;
                }
                break block3;
            }
            if (!schema.table_type.equals("all_column")) break block3;
            String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
            int ii = 0;
            while (ii < Columns.length) {
                String column_name = Columns[ii];
                delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), null);
                ++ii;
            }
        }
        return delete_UsePutV;
    }

    private static Put build_data_insert(ZillionTableSchema schema, byte[] row_key_bytes_new, Map<String, byte[]> columnBytesMap_tmp, boolean is_update) {
        Put put;
        block8: {
            block7: {
                put = new Put(row_key_bytes_new);
                if (is_update) {
                    put.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("u"), ByteToObject.toBytes("1"));
                }
                put.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"), ByteToObject.toBytes("1"));
                if (schema.table_type != null && !schema.table_type.equals("index_data") && !schema.table_type.startsWith("split_")) break block7;
                int ii = 0;
                while (ii < schema.OtherColumn.length) {
                    String column_name = schema.OtherColumn[ii];
                    ZillionTableColumn column_def = schema.ColumnMap.get(column_name);
                    if (columnBytesMap_tmp.containsKey(column_name)) {
                        byte[] column_bytes = columnBytesMap_tmp.get(column_name);
                        if ((column_def.Type == ZillionTableColumnEnum.STRING || column_def.Type == ZillionTableColumnEnum.COMPRESSSTRING) && column_bytes != null && column_bytes.length == 0) {
                            byte[] column_bytesInner = new byte[]{0};
                            column_bytes = column_bytesInner;
                        }
                        put.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                    }
                    ++ii;
                }
                break block8;
            }
            if (!schema.table_type.equals("all_column")) break block8;
            String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
            int ii = 0;
            while (ii < Columns.length) {
                String column_name = Columns[ii];
                ZillionTableColumn column_def = schema.ColumnMap.get(column_name);
                if (columnBytesMap_tmp.containsKey(column_name)) {
                    byte[] column_bytes = columnBytesMap_tmp.get(column_name);
                    if ((column_def.Type == ZillionTableColumnEnum.STRING || column_def.Type == ZillionTableColumnEnum.COMPRESSSTRING) && column_bytes != null && column_bytes.length == 0) {
                        byte[] column_bytesInner = new byte[]{0};
                        column_bytes = column_bytesInner;
                    }
                    put.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                }
                ++ii;
            }
        }
        return put;
    }

    private static Put build_index_delete_UsePutV(ZillionTableSchema schema, ZillionTableIndex index, byte[] index_row_bytes) {
        Put delete_UsePutV;
        block3: {
            block4: {
                delete_UsePutV = new Put(index_row_bytes);
                delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"), ByteToObject.toBytes("0"));
                if (schema.table_type == null) break block3;
                if (!schema.table_type.equals("index_data") && !schema.table_type.startsWith("split_")) break block4;
                int ii = 0;
                while (ii < schema.OtherColumn.length) {
                    String column_name = schema.OtherColumn[ii];
                    if (!index.KeyMap.containsKey(column_name)) {
                        delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), null);
                    }
                    ++ii;
                }
                break block3;
            }
            if (!schema.table_type.equals("all_column")) break block3;
            String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
            int ii = 0;
            while (ii < Columns.length) {
                String column_name = Columns[ii];
                delete_UsePutV.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), null);
                ++ii;
            }
        }
        return delete_UsePutV;
    }

    private static Put build_index_insert(ZillionTableSchema schema, ZillionTableIndex index, byte[] index_row_bytes_new, Map<String, byte[]> columnBytesMap_tmp, boolean is_update) {
        Put put_index;
        block7: {
            block8: {
                put_index = new Put(index_row_bytes_new);
                if (is_update) {
                    put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("u"), ByteToObject.toBytes("1"));
                }
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"), ByteToObject.toBytes("1"));
                if (schema.table_type == null) break block7;
                if (!schema.table_type.equals("index_data") && !schema.table_type.startsWith("split_")) break block8;
                int ii = 0;
                while (ii < schema.OtherColumn.length) {
                    String column_name = schema.OtherColumn[ii];
                    ZillionTableColumn column_def = schema.ColumnMap.get(column_name);
                    if (!index.KeyMap.containsKey(column_name) && columnBytesMap_tmp.containsKey(column_name)) {
                        byte[] column_bytes = columnBytesMap_tmp.get(column_name);
                        if ((column_def.Type == ZillionTableColumnEnum.STRING || column_def.Type == ZillionTableColumnEnum.COMPRESSSTRING) && column_bytes != null && column_bytes.length == 0) {
                            byte[] column_bytesInner = new byte[]{0};
                            column_bytes = column_bytesInner;
                        }
                        put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                    }
                    ++ii;
                }
                break block7;
            }
            if (!schema.table_type.equals("all_column")) break block7;
            String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
            int ii = 0;
            while (ii < Columns.length) {
                String column_name = Columns[ii];
                ZillionTableColumn column_def = schema.ColumnMap.get(column_name);
                if (columnBytesMap_tmp.containsKey(column_name)) {
                    byte[] column_bytes = columnBytesMap_tmp.get(column_name);
                    if ((column_def.Type == ZillionTableColumnEnum.STRING || column_def.Type == ZillionTableColumnEnum.COMPRESSSTRING) && column_bytes != null && column_bytes.length == 0) {
                        byte[] column_bytesInner = new byte[]{0};
                        column_bytes = column_bytesInner;
                    }
                    put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                }
                ++ii;
            }
        }
        return put_index;
    }

    @Override
    public JSONArray batch_get(ZillionTableSchema schema, ITableWrapper table_wrapper, JSONArray InsertObjects, JSONArray content, Map<String, Boolean> ReturnColumnsMap) throws Exception {
        Result[] results;
        byte[][] row_bytes_array = new byte[InsertObjects.size()][];
        ArrayList<Get> batch = new ArrayList<Get>();
        int i = 0;
        while (i < InsertObjects.size()) {
            JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
            byte[] row_bytes = HTableUtil.BuildKey(schema, InsertObject);
            row_bytes_array[i] = row_bytes;
            Get get = new Get(row_bytes);
            get.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"));
            String[] stringArray = schema.OtherColumn;
            int n = schema.OtherColumn.length;
            int n2 = 0;
            while (n2 < n) {
                String column_name = stringArray[n2];
                if (ReturnColumnsMap.containsKey(column_name)) {
                    get.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name));
                }
                ++n2;
            }
            batch.add(get);
            ++i;
        }
        ArrayList<byte[]> exist_row_bytesList = new ArrayList<byte[]>();
        Result[] resultArray = results = ((TableWrapper_HBase)table_wrapper).htable.get(batch);
        int column_name = results.length;
        int get = 0;
        while (get < column_name) {
            Result res = resultArray[get];
            if (res != null && res.getRow() != null && HTableUtil.valid(schema, res.listCells())) {
                exist_row_bytesList.add(res.getRow());
                JSONObject resultObject = HTableUtil.Convert(schema, res.getRow(), res.listCells());
                content.add((Object)resultObject);
            }
            ++get;
        }
        JSONArray InsertObjects_real = new JSONArray();
        int i2 = 0;
        while (i2 < InsertObjects.size()) {
            JSONObject InsertObject = (JSONObject)InsertObjects.get(i2);
            byte[] row_bytes = row_bytes_array[i2];
            boolean exist = false;
            for (byte[] exist_row_bytes : exist_row_bytesList) {
                if (Bytes.compareTo((byte[])exist_row_bytes, (byte[])row_bytes) != 0) continue;
                exist = true;
                break;
            }
            if (!exist) {
                InsertObjects_real.add((Object)InsertObject);
            }
            ++i2;
        }
        return InsertObjects_real;
    }

    @Override
    public ITableWrapper generateTableWrapper(String namespace, String ori_tableName, int exist_count) throws Exception {
        TableName tableNameObject = TableName.valueOf((String)namespace, (String)ori_tableName);
        return this.ConnectionWrapper.getTable(exist_count, tableNameObject);
    }
}

