/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.util.table.HTableUtil;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hbase.Cell;
import org.zillion.util.common.HexToByte;
import org.zillion.util.common.MyException;
import org.zillion.util.json.FastJsonUtil;

public class ZillionQueryCheckUtil {
    public static void Check_batch(ZillionTableSchema schema, JSONArray InsertObjects) throws Exception {
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < InsertObjects.size()) {
            JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
            byte[] row_key_bytes = HTableUtil.BuildKey(schema, InsertObject);
            String hexString = HexToByte.byteToHex(row_key_bytes);
            int exist_count = 0;
            if (keyMap.containsKey(hexString)) {
                exist_count = (Integer)keyMap.get(hexString);
                keyMap.remove(hexString);
            }
            keyMap.put(hexString, exist_count + 1);
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : keyMap.keySet()) {
            int count = (Integer)keyMap.get(key);
            if (count <= 1) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            JSONObject json = HTableUtil.Convert(schema, HexToByte.hexToByte(key), new ArrayList<Cell>());
            sb.append("this object appear " + count + " times:" + "\n");
            sb.append(FastJsonUtil.toFormatString(json));
        }
        if (sb.length() > 0) {
            throw new MyException("ZillionQueryCheck: Key exist many times\n" + sb.toString());
        }
    }

    public static void CheckInsert(ZillionTableSchema schema, JSONObject InsertObject) throws Exception {
        for (String Name : schema.ColumnMap.keySet()) {
            ZillionTableColumn ztc = schema.ColumnMap.get(Name);
            Object columnValue = InsertObject.get((Object)Name);
            ZillionQueryCheckUtil.CheckColumn(ztc, columnValue);
        }
    }

    public static void CheckKey(ZillionTableSchema schema, JSONObject Key) throws Exception {
        int i = 0;
        while (i < schema.Key.length) {
            String Name = schema.Key[i];
            ZillionTableColumn ztc = schema.ColumnMap.get(Name);
            Object columnValue = Key.get((Object)Name);
            ZillionQueryCheckUtil.CheckColumn(ztc, columnValue);
            ++i;
        }
    }

    public static void CheckCriteria(ZillionTableSchema schema, JSONObject Criteria) throws Exception {
        for (String Name : Criteria.keySet()) {
            if (!schema.ColumnMap.containsKey(Name)) {
                throw new MyException("ZillionQueryCheck: Column not exist: " + Name);
            }
            ZillionTableColumn ztc = schema.ColumnMap.get(Name);
            if (ztc.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                throw new MyException("ZillionQueryCheck: Criteria can't use CompressString: " + Name);
            }
            Object columnValue = Criteria.get((Object)Name);
            if (columnValue instanceof JSONObject) {
                JSONObject columnValueJSON = (JSONObject)columnValue;
                if (columnValueJSON.containsKey((Object)"in")) {
                    Object inObject = columnValueJSON.get((Object)"in");
                    if (inObject instanceof JSONObject) continue;
                    if (inObject instanceof JSONArray) {
                        JSONArray inValueArray = (JSONArray)inObject;
                        int i = 0;
                        while (i < inValueArray.size()) {
                            Object columnValueInner = inValueArray.get(i);
                            if (!(columnValueInner instanceof JSONArray) && !(columnValueInner instanceof JSONObject)) {
                                ZillionQueryCheckUtil.CheckColumn(ztc, columnValueInner);
                            }
                            ++i;
                        }
                        continue;
                    }
                    throw new MyException("ZillionQueryCheck: in " + inObject.getClass().getName());
                }
                if (columnValueJSON.containsKey((Object)"$regex")) {
                    String regex = (String)columnValueJSON.get((Object)"$regex");
                    ZillionQueryCheckUtil.CheckColumn(ztc, regex);
                    continue;
                }
                for (String key : columnValueJSON.keySet()) {
                    Object columnValueInner = columnValueJSON.get((Object)key);
                    ZillionQueryCheckUtil.CheckColumn(ztc, columnValueInner);
                }
                continue;
            }
            ZillionQueryCheckUtil.CheckColumn(ztc, columnValue);
        }
    }

    public static void CheckSet(ZillionTableSchema schema, JSONObject Set2) throws Exception {
        for (String Name : Set2.keySet()) {
            if (!schema.ColumnMap.containsKey(Name)) {
                throw new MyException("ZillionQueryCheck: Column not exist: " + Name);
            }
            ZillionTableColumn ztc = schema.ColumnMap.get(Name);
            Object columnValue = Set2.get((Object)Name);
            ZillionQueryCheckUtil.CheckColumn(ztc, columnValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void CheckColumn(ZillionTableColumn ztc, Object columnValue) throws Exception {
        if (ztc.NotNull && columnValue == null) {
            throw new MyException("ZillionQueryCheck: " + ztc.Name + "'s value cant be null ");
        }
        if (columnValue == null) {
            return;
        }
        if (ztc.Type == ZillionTableColumnEnum.STRING || ztc.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
            if (!(columnValue instanceof String)) throw new MyException("ZillionQueryCheck: " + ztc.Name + " value type error, value must be String");
            String stringValue = (String)columnValue;
            if (stringValue.length() <= ztc.max_length) return;
            throw new MyException("ZillionQueryCheck: " + ztc.Name + " length " + stringValue.length() + " > " + ztc.max_length);
        }
        if (HTableUtil.Can_Convert(ztc, columnValue)) return;
        throw new MyException("ZillionQueryCheck: " + ztc.Name + " value type error");
    }
}

