/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.property;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryField;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class QueryBinaryProperty
implements GridQueryProperty {
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private String propName;
    private String alias;
    private QueryBinaryProperty parent;
    private Class<?> type;
    private volatile int isKeyProp;
    private volatile BinaryField field;
    private volatile boolean fieldTaken;
    private volatile boolean warned;
    private final boolean notNull;
    private final Object defaultValue;

    public QueryBinaryProperty(GridKernalContext ctx, String propName, QueryBinaryProperty parent, Class<?> type, @Nullable Boolean key, String alias, boolean notNull, Object defaultValue) {
        this.ctx = ctx;
        this.log = ctx.log(QueryBinaryProperty.class);
        this.propName = propName;
        this.alias = F.isEmpty(alias) ? propName : alias;
        this.parent = parent;
        this.type = type;
        this.notNull = notNull;
        if (key != null) {
            this.isKeyProp = key != false ? 1 : -1;
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public Object value(Object key, Object val) throws IgniteCheckedException {
        Object obj;
        if (this.parent != null) {
            obj = this.parent.value(key, val);
            if (obj == null) {
                return null;
            }
            if (!this.ctx.cacheObjects().isBinaryObject(obj)) {
                throw new IgniteCheckedException("Non-binary object received as a result of property extraction [parent=" + this.parent + ", propName=" + this.propName + ", obj=" + obj + ']');
            }
        } else {
            int isKeyProp0 = this.isKeyProp;
            if (isKeyProp0 == 0) {
                if (key instanceof BinaryObject && ((BinaryObject)key).hasField(this.propName)) {
                    isKeyProp0 = 1;
                    this.isKeyProp = 1;
                } else if (val instanceof BinaryObject && ((BinaryObject)val).hasField(this.propName)) {
                    isKeyProp0 = -1;
                    this.isKeyProp = -1;
                } else {
                    if (!this.warned) {
                        U.warn(this.log, "Neither key nor value have property \"" + this.propName + "\" " + "(is cache indexing configured correctly?)");
                        this.warned = true;
                    }
                    return null;
                }
            }
            Object object = obj = isKeyProp0 == 1 ? key : val;
        }
        if (obj instanceof BinaryObject) {
            BinaryObject obj0 = (BinaryObject)obj;
            return this.fieldValue(obj0);
        }
        if (obj instanceof BinaryObjectBuilder) {
            BinaryObjectBuilder obj0 = (BinaryObjectBuilder)obj;
            return obj0.getField(this.propName);
        }
        throw new IgniteCheckedException("Unexpected binary object class [type=" + obj.getClass() + ']');
    }

    @Override
    public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
        Object obj;
        Object object = obj = this.key() ? key : val;
        if (obj == null) {
            return;
        }
        Object srcObj = obj;
        if (!(srcObj instanceof BinaryObjectBuilder)) {
            throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
        }
        if (this.parent != null) {
            obj = this.parent.value(key, val);
        }
        boolean needsBuild = false;
        if (obj instanceof BinaryObjectExImpl) {
            if (this.parent == null) {
                throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
            }
            needsBuild = true;
            obj = ((BinaryObjectExImpl)obj).toBuilder();
        }
        if (!(obj instanceof BinaryObjectBuilder)) {
            throw new UnsupportedOperationException("Individual properties can be set for binary builders only");
        }
        this.setValue0((BinaryObjectBuilder)obj, this.propName, propVal, this.type());
        if (needsBuild) {
            obj = ((BinaryObjectBuilder)obj).build();
            assert (this.parent != null);
            this.setValue0((BinaryObjectBuilder)srcObj, this.parent.propName, obj, obj.getClass());
        }
    }

    private <T> void setValue0(BinaryObjectBuilder builder, String field, Object val, Class<T> valType) {
        builder.setField(field, val, valType);
    }

    private BinaryField binaryField(BinaryObject obj) {
        if (this.ctx.query().skipFieldLookup()) {
            return null;
        }
        BinaryField field0 = this.field;
        if (field0 == null && !this.fieldTaken) {
            BinaryType type;
            BinaryType binaryType = type = obj instanceof BinaryObjectEx ? ((BinaryObjectEx)obj).rawType() : obj.type();
            if (type != null) {
                field0 = type.field(this.propName);
                assert (field0 != null);
                this.field = field0;
            }
            this.fieldTaken = true;
        }
        return field0;
    }

    private Object fieldValue(BinaryObject obj) {
        BinaryField field = this.binaryField(obj);
        if (field != null) {
            return field.value(obj);
        }
        return obj.field(this.propName);
    }

    @Override
    public String name() {
        return this.alias;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public boolean key() {
        int isKeyProp0 = this.isKeyProp;
        if (isKeyProp0 == 0) {
            throw new IllegalStateException("Ownership flag not set for binary property. Have you set 'keyFields' property of QueryEntity in programmatic or XML configuration?");
        }
        return isKeyProp0 == 1;
    }

    @Override
    public GridQueryProperty parent() {
        return this.parent;
    }

    @Override
    public boolean notNull() {
        return this.notNull;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }
}

