/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public abstract class IgfsEntryInfo
implements Externalizable {
    private static final long serialVersionUID = 0L;
    protected IgniteUuid id;
    protected Map<String, String> props;
    protected long accessTime;
    protected long modificationTime;

    protected IgfsEntryInfo() {
    }

    protected IgfsEntryInfo(IgniteUuid id, @Nullable Map<String, String> props, long accessTime, long modificationTime) {
        assert (id != null);
        this.id = id;
        this.props = props == null || props.isEmpty() ? null : props;
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public Map<String, String> properties() {
        return this.props == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.props);
    }

    public long accessTime() {
        return this.accessTime;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    public abstract boolean isFile();

    public abstract IgfsEntryInfo length(long var1);

    public abstract IgfsEntryInfo listing(@Nullable Map<String, IgfsListingEntry> var1);

    public IgfsEntryInfo properties(@Nullable Map<String, String> props) {
        IgfsEntryInfo res = this.copy();
        res.props = props;
        return res;
    }

    public IgfsEntryInfo accessModificationTime(long accessTime, long modificationTime) {
        IgfsEntryInfo res = this.copy();
        res.accessTime = accessTime;
        res.modificationTime = modificationTime;
        return res;
    }

    public abstract IgfsEntryInfo lock(IgniteUuid var1);

    public abstract IgfsEntryInfo unlock(long var1);

    public abstract IgfsEntryInfo fileMap(IgfsFileMap var1);

    protected abstract IgfsEntryInfo copy();

    public boolean isDirectory() {
        return !this.isFile();
    }

    public abstract long length();

    public abstract int blockSize();

    public abstract long blocksCount();

    public abstract Map<String, IgfsListingEntry> listing();

    public abstract boolean hasChildren();

    public abstract boolean hasChild(String var1);

    public abstract boolean hasChild(String var1, IgniteUuid var2);

    @Nullable
    public abstract IgniteUuid affinityKey();

    public abstract IgfsFileMap fileMap();

    @Nullable
    public abstract IgniteUuid lockId();

    public abstract boolean evictExclude();

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.id);
        IgfsUtils.writeProperties(out, this.props);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readGridUuid(in);
        this.props = IgfsUtils.readProperties(in);
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    protected void writeBinary(BinaryRawWriter out) {
        BinaryUtils.writeIgniteUuid(out, this.id);
        IgfsUtils.writeProperties(out, this.props);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    protected void readBinary(BinaryRawReader in) {
        this.id = BinaryUtils.readIgniteUuid(in);
        this.props = IgfsUtils.readProperties(in);
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    public String toString() {
        return S.toString(IgfsEntryInfo.class, this);
    }
}

