/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridDistributedUnlockRequest
extends GridDistributedBaseMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;

    public GridDistributedUnlockRequest() {
    }

    public GridDistributedUnlockRequest(int cacheId, int keyCnt, boolean addDepInfo) {
        super(keyCnt, addDepInfo);
        this.cacheId = cacheId;
    }

    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    public void addKey(KeyCacheObject key, GridCacheContext ctx) throws IgniteCheckedException {
        if (this.keys == null) {
            this.keys = new ArrayList<KeyCacheObject>(this.keysCount());
        }
        this.keys.add(key);
    }

    @Override
    public int partition() {
        return this.keys != null && !this.keys.isEmpty() ? this.keys.get(0).partition() : -1;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        this.prepareMarshalCacheObjects(this.keys, ctx.cacheContext(this.cacheId));
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        this.finishUnmarshalCacheObjects(this.keys, ctx.cacheContext(this.cacheId), ldr);
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txLockMessageLogger();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 7: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 7: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedUnlockRequest.class);
    }

    @Override
    public short directType() {
        return 27;
    }

    @Override
    public byte fieldsCount() {
        return 8;
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedUnlockRequest.class, this, "super", super.toString());
    }
}

