/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteRebalanceIterator;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteRebalanceIteratorImpl;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheOffheapManagerImpl
implements IgniteCacheOffheapManager {
    protected GridCacheSharedContext ctx;
    protected CacheGroupContext grp;
    protected IgniteLogger log;
    private IgniteCacheOffheapManager.CacheDataStore locCacheDataStore;
    protected final ConcurrentMap<Integer, IgniteCacheOffheapManager.CacheDataStore> partDataStores = new ConcurrentHashMap<Integer, IgniteCacheOffheapManager.CacheDataStore>();
    protected PendingEntriesTree pendingEntries;
    private volatile boolean hasPendingEntries;
    private final GridAtomicLong globalRmvId = new GridAtomicLong(U.currentTimeMillis() * 1000000L);
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private int updateValSizeThreshold;
    protected GridStripedLock partStoreLock = new GridStripedLock(Runtime.getRuntime().availableProcessors());

    @Override
    public GridAtomicLong globalRemoveId() {
        return this.globalRmvId;
    }

    @Override
    public void start(GridCacheSharedContext ctx, CacheGroupContext grp) throws IgniteCheckedException {
        this.ctx = ctx;
        this.grp = grp;
        this.log = ctx.logger(this.getClass());
        this.updateValSizeThreshold = ctx.database().pageSize() / 2;
        if (grp.affinityNode()) {
            ctx.database().checkpointReadLock();
            try {
                this.initDataStructures();
                if (grp.isLocal()) {
                    this.locCacheDataStore = this.createCacheDataStore(0);
                }
            }
            finally {
                ctx.database().checkpointReadUnlock();
            }
        }
    }

    @Override
    public void onCacheStarted(GridCacheContext cctx) throws IgniteCheckedException {
        if (cctx.affinityNode() && cctx.ttl().eagerTtlEnabled() && this.pendingEntries == null) {
            String name = "PendingEntries";
            long rootPage = this.allocateForTree();
            this.pendingEntries = new PendingEntriesTree(this.grp, name, this.grp.dataRegion().pageMemory(), rootPage, this.grp.reuseList(), true);
        }
    }

    protected void initDataStructures() throws IgniteCheckedException {
    }

    @Override
    public void stopCache(int cacheId, boolean destroy) {
        if (destroy && this.grp.affinityNode()) {
            this.removeCacheData(cacheId);
        }
    }

    @Override
    public void stop() {
        try {
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                this.destroyCacheDataStore(store);
            }
            if (this.pendingEntries != null) {
                this.pendingEntries.destroy();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public void onKernalStop() {
        this.busyLock.block();
    }

    private void removeCacheData(int cacheId) {
        assert (this.grp.affinityNode());
        try {
            if (this.grp.sharedGroup()) {
                assert (cacheId != 0);
                assert (this.ctx.database().checkpointLockIsHeldByThread());
                for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                    store.clear(cacheId);
                }
                if (this.pendingEntries != null) {
                    PendingRow row = new PendingRow(cacheId);
                    GridCursor cursor = this.pendingEntries.find(row, row, PendingEntriesTree.WITHOUT_KEY);
                    while (cursor.next()) {
                        boolean res = this.pendingEntries.removex(cursor.get());
                        assert (res);
                    }
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public IgniteCacheOffheapManager.CacheDataStore dataStore(GridDhtLocalPartition part) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore;
        }
        assert (part != null);
        return part.dataStore();
    }

    @Override
    public long cacheEntriesCount(int cacheId) {
        long size = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            size += store.cacheSize(cacheId);
        }
        return size;
    }

    @Override
    public long totalPartitionEntriesCount(int p) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore.fullSize();
        }
        GridDhtLocalPartition part = this.grp.topology().localPartition(p, AffinityTopologyVersion.NONE, false, true);
        return part != null ? part.dataStore().fullSize() : 0L;
    }

    @Nullable
    private IgniteCacheOffheapManager.CacheDataStore partitionData(int p) {
        if (this.grp.isLocal()) {
            return this.locCacheDataStore;
        }
        GridDhtLocalPartition part = this.grp.topology().localPartition(p, AffinityTopologyVersion.NONE, false, true);
        return part != null ? part.dataStore() : null;
    }

    @Override
    public long cacheEntriesCount(int cacheId, boolean primary, boolean backup, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (this.grp.isLocal()) {
            return this.cacheEntriesCount(cacheId, 0);
        }
        long cnt = 0L;
        Iterator<IgniteCacheOffheapManager.CacheDataStore> it = this.cacheData(primary, backup, topVer);
        while (it.hasNext()) {
            cnt += it.next().cacheSize(cacheId);
        }
        return cnt;
    }

    @Override
    public long cacheEntriesCount(int cacheId, int part) {
        IgniteCacheOffheapManager.CacheDataStore store = this.partitionData(part);
        return store == null ? 0L : store.cacheSize(cacheId);
    }

    private Iterator<IgniteCacheOffheapManager.CacheDataStore> cacheData(boolean primary, boolean backup, AffinityTopologyVersion topVer) {
        assert (primary || backup);
        if (this.grp.isLocal()) {
            return this.singletonIterator(this.locCacheDataStore);
        }
        Iterator<GridDhtLocalPartition> it = this.grp.topology().currentLocalPartitions().iterator();
        if (primary && backup) {
            return F.iterator(it, new IgniteClosure<GridDhtLocalPartition, IgniteCacheOffheapManager.CacheDataStore>(){

                @Override
                public IgniteCacheOffheapManager.CacheDataStore apply(GridDhtLocalPartition part) {
                    return part.dataStore();
                }
            }, true, new IgnitePredicate[0]);
        }
        final Set<Integer> parts = primary ? this.grp.affinity().primaryPartitions(this.ctx.localNodeId(), topVer) : this.grp.affinity().backupPartitions(this.ctx.localNodeId(), topVer);
        return F.iterator(it, new IgniteClosure<GridDhtLocalPartition, IgniteCacheOffheapManager.CacheDataStore>(){

            @Override
            public IgniteCacheOffheapManager.CacheDataStore apply(GridDhtLocalPartition part) {
                return part.dataStore();
            }
        }, true, new IgnitePredicate<GridDhtLocalPartition>(){

            @Override
            public boolean apply(GridDhtLocalPartition part) {
                return parts.contains(part.id());
            }
        });
    }

    @Override
    public void invoke(GridCacheContext cctx, KeyCacheObject key, GridDhtLocalPartition part, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
        this.dataStore(part).invoke(cctx, key, c);
    }

    @Override
    public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, GridDhtLocalPartition part, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
        assert (expireTime >= 0L);
        this.dataStore(part).update(cctx, key, val, ver, expireTime, oldRow);
    }

    @Override
    public void remove(GridCacheContext cctx, KeyCacheObject key, int partId, GridDhtLocalPartition part) throws IgniteCheckedException {
        this.dataStore(part).remove(cctx, key, partId);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheMapEntry entry) throws IgniteCheckedException {
        KeyCacheObject key = entry.key();
        assert (this.grp.isLocal() || entry.localPartition() != null) : entry;
        return this.dataStore(entry.localPartition()).find(entry.context(), key);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
        CacheDataRow row;
        if (cctx.isLocal()) {
            row = this.locCacheDataStore.find(cctx, key);
        } else {
            GridDhtLocalPartition part = cctx.topology().localPartition(cctx.affinity().partition(key), null, false);
            CacheDataRow cacheDataRow = row = part != null ? this.dataStore(part).find(cctx, key) : null;
        }
        assert (row == null || row.value() != null) : row;
        return row;
    }

    @Override
    public boolean containsKey(GridCacheMapEntry entry) {
        try {
            return this.read(entry) != null;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to read value", e);
            return false;
        }
    }

    @Override
    public void onPartitionCounterUpdated(int part, long cntr) {
    }

    @Override
    public void onPartitionInitialCounterUpdated(int part, long cntr) {
    }

    @Override
    public long lastUpdatedPartitionCounter(int part) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(GridCacheContext cctx, boolean readers) {
        GridCacheVersion obsoleteVer = null;
        try (GridCloseableIterator<CacheDataRow> it = this.grp.isLocal() ? this.iterator(cctx.cacheId(), this.cacheDataStores().iterator()) : this.evictionSafeIterator(cctx.cacheId(), this.cacheDataStores().iterator());){
            while (it.hasNext()) {
                cctx.shared().database().checkpointReadLock();
                try {
                    KeyCacheObject key = ((CacheDataRow)it.next()).key();
                    try {
                        if (obsoleteVer == null) {
                            obsoleteVer = this.ctx.versions().next();
                        }
                        GridCacheEntryEx entry = cctx.cache().entryEx(key);
                        entry.clear(obsoleteVer, readers);
                    }
                    catch (GridDhtInvalidPartitionException entry) {
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to clear cache entry: " + key, e);
                    }
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to close iterator", e);
        }
    }

    @Override
    public int onUndeploy(ClassLoader ldr) {
        return 0;
    }

    @Override
    public long offHeapAllocatedSize() {
        return 0L;
    }

    @Override
    public <K, V> GridCloseableIterator<Cache.Entry<K, V>> cacheEntriesIterator(final GridCacheContext cctx, boolean primary, boolean backup, AffinityTopologyVersion topVer, final boolean keepBinary) throws IgniteCheckedException {
        final GridIterator<CacheDataRow> it = this.cacheIterator(cctx.cacheId(), primary, backup, topVer);
        return new GridCloseableIteratorAdapter<Cache.Entry<K, V>>(){
            private CacheEntryImplEx next;

            @Override
            protected Cache.Entry<K, V> onNext() {
                CacheEntryImplEx ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            protected boolean onHasNext() {
                if (this.next != null) {
                    return true;
                }
                CacheSearchRow nextRow = null;
                if (it.hasNext()) {
                    nextRow = (CacheDataRow)it.next();
                }
                if (nextRow != null) {
                    KeyCacheObject key = nextRow.key();
                    CacheObject val = nextRow.value();
                    Object key0 = cctx.unwrapBinaryIfNeeded(key, keepBinary, false);
                    Object val0 = cctx.unwrapBinaryIfNeeded(val, keepBinary, false);
                    this.next = new CacheEntryImplEx<Object, Object>(key0, val0, nextRow.version());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public GridCloseableIterator<KeyCacheObject> cacheKeysIterator(int cacheId, int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<KeyCacheObject>();
        }
        final GridCursor<? extends CacheDataRow> cur = data.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
        return new GridCloseableIteratorAdapter<KeyCacheObject>(){
            private KeyCacheObject next;

            @Override
            protected KeyCacheObject onNext() {
                KeyCacheObject res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                if (cur.next()) {
                    CacheDataRow row = (CacheDataRow)cur.get();
                    this.next = row.key();
                }
                return this.next != null;
            }
        };
    }

    @Override
    public GridIterator<CacheDataRow> cacheIterator(int cacheId, boolean primary, boolean backups, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        return this.iterator(cacheId, this.cacheData(primary, backups, topVer));
    }

    @Override
    public GridIterator<CacheDataRow> cachePartitionIterator(int cacheId, int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(cacheId, this.singletonIterator(data));
    }

    @Override
    public GridIterator<CacheDataRow> partitionIterator(int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(0, this.singletonIterator(data));
    }

    private GridCloseableIterator<CacheDataRow> iterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private int curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    if (this.cur == null) {
                        if (!dataIt.hasNext()) break;
                        IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                        this.curPart = ds.partId();
                        GridCursor<? extends CacheDataRow> gridCursor = this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                    }
                    if (this.cur.next()) {
                        this.next = this.cur.get();
                        this.next.key().partition(this.curPart);
                        break;
                    }
                    this.cur = null;
                }
                return this.next != null;
            }
        };
    }

    private GridCloseableIterator<CacheDataRow> evictionSafeIterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private GridDhtLocalPartition curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    if (this.cur == null) {
                        if (!dataIt.hasNext()) break;
                        IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                        if (!this.reservePartition(ds.partId())) continue;
                        GridCursor<? extends CacheDataRow> gridCursor = this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                    }
                    if (this.cur.next()) {
                        this.next = this.cur.get();
                        this.next.key().partition(this.curPart.id());
                        break;
                    }
                    this.cur = null;
                    this.releaseCurrentPartition();
                }
                return this.next != null;
            }

            private void releaseCurrentPartition() {
                GridDhtLocalPartition p = this.curPart;
                assert (p != null);
                this.curPart = null;
                p.release();
            }

            private boolean reservePartition(int partId) {
                GridDhtLocalPartition p = IgniteCacheOffheapManagerImpl.this.grp.topology().localPartition(partId);
                if (p != null && p.reserve()) {
                    this.curPart = p;
                    return true;
                }
                return false;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.curPart != null) {
                    this.releaseCurrentPartition();
                }
            }
        };
    }

    private <T> Iterator<T> singletonIterator(final T item) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return item;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private long allocateForTree() throws IgniteCheckedException {
        long pageId;
        ReuseList reuseList = this.grp.reuseList();
        if (reuseList == null || (pageId = reuseList.takeRecycledPage()) == 0L) {
            pageId = this.grp.dataRegion().pageMemory().allocatePage(this.grp.groupId(), 65535, (byte)2);
        }
        return pageId;
    }

    @Override
    public RootPage rootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
        long pageId = this.allocateForTree();
        return new RootPage(new FullPageId(pageId, this.grp.groupId()), true);
    }

    @Override
    public void dropRootPageForIndex(int cacheId, String idxName) throws IgniteCheckedException {
    }

    @Override
    public ReuseList reuseListForIndex(String idxName) {
        return this.grp.reuseList();
    }

    @Override
    public GridCloseableIterator<CacheDataRow> reservedIterator(int part, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        final GridDhtLocalPartition loc = this.grp.topology().localPartition(part, topVer, false);
        if (loc == null || !loc.reserve()) {
            return null;
        }
        if (loc.state() != GridDhtPartitionState.OWNING) {
            loc.release();
            return null;
        }
        IgniteCacheOffheapManager.CacheDataStore data = this.partitionData(part);
        final GridCursor<? extends CacheDataRow> cur = data.cursor();
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                if (cur.next()) {
                    this.next = (CacheDataRow)cur.get();
                }
                return this.next != null;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                assert (loc != null && loc.state() == GridDhtPartitionState.OWNING && loc.reservations() > 0) : "Partition should be in OWNING state and has at least 1 reservation: " + loc;
                loc.release();
            }
        };
    }

    @Override
    public IgniteRebalanceIterator rebalanceIterator(IgniteDhtDemandedPartitionsMap parts, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        TreeMap<Integer, GridCloseableIterator<CacheDataRow>> iterators = new TreeMap<Integer, GridCloseableIterator<CacheDataRow>>();
        HashSet<Integer> missing = new HashSet<Integer>();
        for (Integer p : parts.fullSet()) {
            GridCloseableIterator<CacheDataRow> partIter = this.reservedIterator(p, topVer);
            if (partIter == null) {
                missing.add(p);
                continue;
            }
            iterators.put(p, partIter);
        }
        IgniteHistoricalIterator historicalIterator = this.historicalIterator(parts.historicalMap(), missing);
        IgniteRebalanceIteratorImpl iter = new IgniteRebalanceIteratorImpl(iterators, historicalIterator);
        for (Integer p : missing) {
            iter.setPartitionMissing(p);
        }
        return iter;
    }

    @Nullable
    protected IgniteHistoricalIterator historicalIterator(CachePartitionPartialCountersMap partCntrs, Set<Integer> missing) throws IgniteCheckedException {
        return null;
    }

    @Override
    public final IgniteCacheOffheapManager.CacheDataStore createCacheDataStore(int p) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore dataStore;
        this.partStoreLock.lock(p);
        try {
            assert (!this.partDataStores.containsKey(p));
            dataStore = this.createCacheDataStore0(p);
            this.partDataStores.put(p, dataStore);
        }
        finally {
            this.partStoreLock.unlock(p);
        }
        return dataStore;
    }

    protected IgniteCacheOffheapManager.CacheDataStore createCacheDataStore0(int p) throws IgniteCheckedException {
        long rootPage = this.allocateForTree();
        CacheDataRowStore rowStore = new CacheDataRowStore(this.grp, this.grp.freeList(), p);
        String idxName = this.treeName(p);
        CacheDataTree dataTree = new CacheDataTree(this.grp, idxName, this.grp.reuseList(), rowStore, rootPage, true);
        return new CacheDataStoreImpl(p, idxName, rowStore, dataTree);
    }

    @Override
    public Iterable<IgniteCacheOffheapManager.CacheDataStore> cacheDataStores() {
        if (this.grp.isLocal()) {
            return Collections.singleton(this.locCacheDataStore);
        }
        return new Iterable<IgniteCacheOffheapManager.CacheDataStore>(){

            @Override
            public Iterator<IgniteCacheOffheapManager.CacheDataStore> iterator() {
                return IgniteCacheOffheapManagerImpl.this.partDataStores.values().iterator();
            }
        };
    }

    @Override
    public final void destroyCacheDataStore(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        int p = store.partId();
        this.partStoreLock.lock(p);
        try {
            boolean removed = this.partDataStores.remove(p, store);
            assert (removed);
            this.destroyCacheDataStore0(store);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.partStoreLock.unlock(p);
        }
    }

    protected void destroyCacheDataStore0(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        store.destroy();
    }

    protected final String treeName(int p) {
        return BPlusTree.treeName("p-" + p, "CacheData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        assert (!cctx.isNear()) : cctx.name();
        if (this.hasPendingEntries && this.pendingEntries != null) {
            GridCacheVersion obsoleteVer = null;
            long now = U.currentTimeMillis();
            GridCursor cur = this.grp.sharedGroup() ? this.pendingEntries.find(new PendingRow(cctx.cacheId()), new PendingRow(cctx.cacheId(), now, 0L)) : this.pendingEntries.find(null, new PendingRow(0, now, 0L));
            if (!cur.next()) {
                return false;
            }
            int cleared = 0;
            cctx.shared().database().checkpointReadLock();
            try {
                do {
                    PendingRow row = (PendingRow)cur.get();
                    if (amount != -1 && cleared > amount) {
                        boolean bl = true;
                        return bl;
                    }
                    if (row.key.partition() == -1) {
                        row.key.partition(cctx.affinity().partition(row.key));
                    }
                    assert (row.key != null && row.link != 0L && row.expireTime != 0L) : row;
                    if (this.pendingEntries.removex(row)) {
                        if (obsoleteVer == null) {
                            obsoleteVer = this.ctx.versions().next();
                        }
                        c.apply(cctx.cache().entryEx(row.key), obsoleteVer);
                    }
                    ++cleared;
                } while (cur.next());
            }
            finally {
                cctx.shared().database().checkpointReadUnlock();
            }
        }
        return false;
    }

    @Override
    public long expiredSize() throws IgniteCheckedException {
        return this.pendingEntries != null ? this.pendingEntries.size() : 0L;
    }

    protected class CacheDataStoreImpl
    implements IgniteCacheOffheapManager.CacheDataStore {
        private final int partId;
        private String name;
        private final CacheDataRowStore rowStore;
        private final CacheDataTree dataTree;
        protected final AtomicLong cntr = new AtomicLong();
        private final AtomicLong storageSize = new AtomicLong();
        private final ConcurrentMap<Integer, AtomicLong> cacheSizes = new ConcurrentHashMap<Integer, AtomicLong>();
        protected long initCntr;

        public CacheDataStoreImpl(int partId, String name, CacheDataRowStore rowStore, CacheDataTree dataTree) {
            this.partId = partId;
            this.name = name;
            this.rowStore = rowStore;
            this.dataTree = dataTree;
        }

        void incrementSize(int cacheId) {
            this.storageSize.incrementAndGet();
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                AtomicLong size = (AtomicLong)this.cacheSizes.get(cacheId);
                if (size == null) {
                    size = new AtomicLong();
                    AtomicLong old = this.cacheSizes.putIfAbsent(cacheId, size);
                    if (old != null) {
                        size = old;
                    }
                }
                size.incrementAndGet();
            }
        }

        void decrementSize(int cacheId) {
            this.storageSize.decrementAndGet();
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                AtomicLong size = (AtomicLong)this.cacheSizes.get(cacheId);
                if (size == null) {
                    return;
                }
                size.decrementAndGet();
            }
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public long cacheSize(int cacheId) {
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                AtomicLong size = (AtomicLong)this.cacheSizes.get(cacheId);
                return size != null ? (long)((int)size.get()) : 0L;
            }
            return this.storageSize.get();
        }

        @Override
        public Map<Integer, Long> cacheSizes() {
            if (!IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                return null;
            }
            HashMap<Integer, Long> res = new HashMap<Integer, Long>();
            for (Map.Entry e : this.cacheSizes.entrySet()) {
                res.put((Integer)e.getKey(), ((AtomicLong)e.getValue()).longValue());
            }
            return res;
        }

        @Override
        public long fullSize() {
            return this.storageSize.get();
        }

        @Override
        public long updateCounter() {
            return this.cntr.get();
        }

        @Override
        public void updateCounter(long val) {
            long val0;
            while ((val0 = this.cntr.get()) < val && !this.cntr.compareAndSet(val0, val)) {
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        private boolean canUpdateOldRow(GridCacheContext cctx, @Nullable CacheDataRow oldRow, DataRow dataRow) throws IgniteCheckedException {
            if (oldRow == null || cctx.queries().enabled()) {
                return false;
            }
            if (oldRow.expireTime() != dataRow.expireTime()) {
                return false;
            }
            boolean sizeWithCacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup();
            int oldLen = DataPageIO.getRowSize(oldRow, sizeWithCacheId);
            if (oldLen > IgniteCacheOffheapManagerImpl.this.updateValSizeThreshold) {
                return false;
            }
            int newLen = DataPageIO.getRowSize(dataRow, sizeWithCacheId);
            return oldLen == newLen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void invoke(GridCacheContext cctx, KeyCacheObject key, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                this.dataTree.invoke(new SearchRow(cacheId, key), (Object)CacheDataRowAdapter.RowData.NO_KEY, c);
                switch (c.operationType()) {
                    case PUT: {
                        assert (c.newRow() != null) : c;
                        CacheDataRow oldRow = c.oldRow();
                        this.finishUpdate(cctx, (CacheDataRow)c.newRow(), oldRow);
                        return;
                    }
                    case REMOVE: {
                        CacheDataRow oldRow = c.oldRow();
                        this.finishRemove(cctx, key, oldRow);
                        return;
                    }
                    case NOOP: {
                        return;
                    }
                    default: {
                        assert (false) : c.operationType();
                        return;
                    }
                }
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        @Override
        public CacheDataRow createRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
            DataRow dataRow = new DataRow(key, val, ver, this.partId, expireTime, cacheId);
            if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow)) {
                dataRow.link(oldRow.link());
            } else {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                this.rowStore.addRow(dataRow);
            }
            assert (dataRow.link() != 0L) : dataRow;
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                dataRow.cacheId(cctx.cacheId());
            }
            return dataRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (oldRow == null || oldRow.link() != 0L) : oldRow;
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                CacheDataRow old;
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
                assert (oldRow == null || oldRow.cacheId() == cacheId) : oldRow;
                DataRow dataRow = new DataRow(key, val, ver, this.partId, expireTime, cacheId);
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow)) {
                    old = oldRow;
                    dataRow.link(oldRow.link());
                } else {
                    this.rowStore.addRow(dataRow);
                    assert (dataRow.link() != 0L) : dataRow;
                    if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                        dataRow.cacheId(cctx.cacheId());
                    }
                    if (oldRow != null) {
                        old = oldRow;
                        this.dataTree.putx(dataRow);
                    } else {
                        old = this.dataTree.put(dataRow);
                    }
                }
                this.finishUpdate(cctx, dataRow, old);
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        private void finishUpdate(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId;
            if (oldRow == null) {
                this.incrementSize(cctx.cacheId());
            }
            KeyCacheObject key = newRow.key();
            long expireTime = newRow.expireTime();
            GridCacheQueryManager qryMgr = cctx.queries();
            int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            if (qryMgr.enabled()) {
                qryMgr.store(newRow, oldRow, true);
            }
            if (oldRow != null) {
                assert (oldRow.link() != 0L) : oldRow;
                if (IgniteCacheOffheapManagerImpl.this.pendingEntries != null && oldRow.expireTime() != 0L) {
                    IgniteCacheOffheapManagerImpl.this.pendingEntries.removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
                }
                if (newRow.link() != oldRow.link()) {
                    this.rowStore.removeRow(oldRow.link());
                }
            }
            if (IgniteCacheOffheapManagerImpl.this.pendingEntries != null && expireTime != 0L) {
                IgniteCacheOffheapManagerImpl.this.pendingEntries.putx(new PendingRow(cacheId, expireTime, newRow.link()));
                IgniteCacheOffheapManagerImpl.this.hasPendingEntries = true;
            }
            this.updateIgfsMetrics(cctx, key, oldRow != null ? oldRow.value() : null, newRow.value());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
            if (!IgniteCacheOffheapManagerImpl.this.busyLock.enterBusy()) {
                throw new NodeStoppingException("Operation has been cancelled (node is stopping).");
            }
            try {
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                CacheDataRow oldRow = (CacheDataRow)this.dataTree.remove(new SearchRow(cacheId, key));
                this.finishRemove(cctx, key, oldRow);
            }
            finally {
                IgniteCacheOffheapManagerImpl.this.busyLock.leaveBusy();
            }
        }

        private void finishRemove(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            GridCacheQueryManager qryMgr;
            if (oldRow != null) {
                int cacheId;
                int n = cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
                assert (oldRow.link() != 0L) : oldRow;
                assert (cacheId == 0 || oldRow.cacheId() == cacheId) : "Incorrect cache ID [expected=" + cacheId + ", actual=" + oldRow.cacheId() + "].";
                if (IgniteCacheOffheapManagerImpl.this.pendingEntries != null && oldRow.expireTime() != 0L) {
                    IgniteCacheOffheapManagerImpl.this.pendingEntries.removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
                }
                this.decrementSize(cctx.cacheId());
            }
            if ((qryMgr = cctx.queries()).enabled()) {
                qryMgr.remove(key, oldRow);
            }
            if (oldRow != null) {
                this.rowStore.removeRow(oldRow.link());
            }
            this.updateIgfsMetrics(cctx, key, oldRow != null ? oldRow.value() : null, null);
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            key.valueBytes(cctx.cacheObjectContext());
            int cacheId = IgniteCacheOffheapManagerImpl.this.grp.sharedGroup() ? cctx.cacheId() : 0;
            CacheDataRow row = (CacheDataRow)this.dataTree.findOne(new SearchRow(cacheId, key), (Object)CacheDataRowAdapter.RowData.NO_KEY);
            if (row != null) {
                row.key(key);
                IgniteCacheOffheapManagerImpl.this.grp.dataRegion().evictionTracker().touchPage(row.link());
            }
            return row;
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor() throws IgniteCheckedException {
            return this.dataTree.find(null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId) throws IgniteCheckedException {
            return this.cursor(cacheId, null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper) throws IgniteCheckedException {
            return this.cursor(cacheId, lower, upper, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x) throws IgniteCheckedException {
            SearchRow upperRow;
            SearchRow lowerRow;
            if (IgniteCacheOffheapManagerImpl.this.grp.sharedGroup()) {
                assert (cacheId != 0);
                lowerRow = lower != null ? new SearchRow(cacheId, lower) : new SearchRow(cacheId);
                upperRow = upper != null ? new SearchRow(cacheId, upper) : new SearchRow(cacheId);
            } else {
                lowerRow = lower != null ? new SearchRow(0, lower) : null;
                upperRow = upper != null ? new SearchRow(0, upper) : null;
            }
            return this.dataTree.find(lowerRow, upperRow, x);
        }

        @Override
        public void destroy() throws IgniteCheckedException {
            final AtomicReference exception = new AtomicReference();
            this.dataTree.destroy(new IgniteInClosure<CacheSearchRow>(){

                @Override
                public void apply(CacheSearchRow row) {
                    try {
                        CacheDataStoreImpl.this.rowStore.removeRow(row.link());
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteCacheOffheapManagerImpl.this.log, "Fail remove row [link=" + row.link() + "]");
                        IgniteCheckedException ex = (IgniteCheckedException)exception.get();
                        if (ex == null) {
                            exception.set(e);
                        }
                        ex.addSuppressed(e);
                    }
                }
            });
            if (exception.get() != null) {
                throw new IgniteCheckedException("Fail destroy store", (Throwable)exception.get());
            }
        }

        @Override
        public void clear(int cacheId) throws IgniteCheckedException {
            assert (cacheId != 0);
            assert (IgniteCacheOffheapManagerImpl.this.ctx.database().checkpointLockIsHeldByThread());
            if (this.cacheSize(cacheId) == 0L) {
                return;
            }
            IgniteCheckedException ex = null;
            GridCursor<? extends CacheDataRow> cur = this.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
            while (cur.next()) {
                CacheDataRow row = cur.get();
                assert (row.link() != 0L) : row;
                try {
                    boolean res = this.dataTree.removex(row);
                    assert (res) : row;
                    this.rowStore.removeRow(row.link());
                    this.decrementSize(cacheId);
                }
                catch (IgniteCheckedException e) {
                    U.error(IgniteCacheOffheapManagerImpl.this.log, "Fail remove row [link=" + row.link() + "]");
                    if (ex == null) {
                        ex = e;
                        continue;
                    }
                    ex.addSuppressed(e);
                }
            }
            if (ex != null) {
                throw new IgniteCheckedException("Fail destroy store", ex);
            }
        }

        @Override
        public RowStore rowStore() {
            return this.rowStore;
        }

        @Override
        public long nextUpdateCounter() {
            return this.cntr.incrementAndGet();
        }

        @Override
        public long initialUpdateCounter() {
            return this.initCntr;
        }

        @Override
        public void updateInitialCounter(long cntr) {
            if (this.updateCounter() < cntr) {
                this.updateCounter(cntr);
            }
            this.initCntr = cntr;
        }

        @Override
        public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
            this.rowStore().setRowCacheCleaner(rowCacheCleaner);
        }

        @Override
        public void init(long size, long updCntr, @Nullable Map<Integer, Long> cacheSizes) {
            this.initCntr = updCntr;
            this.storageSize.set(size);
            this.cntr.set(updCntr);
            if (cacheSizes != null) {
                for (Map.Entry<Integer, Long> e : cacheSizes.entrySet()) {
                    this.cacheSizes.put(e.getKey(), new AtomicLong(e.getValue()));
                }
            }
        }

        private void updateIgfsMetrics(GridCacheContext cctx, KeyCacheObject key, CacheObject oldVal, CacheObject newVal) {
            GridCacheAdapter cache = cctx.cache();
            if (cache == null) {
                return;
            }
            if (cache.isIgfsDataCache() && !cctx.isNear() && IgniteCacheOffheapManagerImpl.this.ctx.kernalContext().igfsHelper().isIgfsBlockKey(key.value(cctx.cacheObjectContext(), false))) {
                int oldSize = this.valueLength(cctx, oldVal);
                int newSize = this.valueLength(cctx, newVal);
                int delta = newSize - oldSize;
                if (delta != 0) {
                    cache.onIgfsDataSizeChanged(delta);
                }
            }
        }

        private int valueLength(GridCacheContext cctx, @Nullable CacheObject val) {
            if (val == null) {
                return 0;
            }
            byte[] bytes = (byte[])val.value(cctx.cacheObjectContext(), false);
            if (bytes != null) {
                return bytes.length;
            }
            return 0;
        }
    }
}

