/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.util.Collection;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.discovery.GridLocalMetrics;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetrics;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClusterMetricsImpl
implements ClusterMetrics {
    private volatile GridJobMetrics jobMetrics;
    private volatile long jobMetricsUpdateTime;
    private final Object jobMetricsMux = new Object();
    private final GridKernalContext ctx;
    private final GridLocalMetrics vmMetrics;
    private final long nodeStartTime;

    public ClusterMetricsImpl(GridKernalContext ctx, GridLocalMetrics vmMetrics, long nodeStartTime) {
        this.ctx = ctx;
        this.vmMetrics = vmMetrics;
        this.nodeStartTime = nodeStartTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.jobMetricsUpdateTime == 0L ? U.currentTimeMillis() : this.jobMetricsUpdateTime;
    }

    @Override
    public int getMaximumActiveJobs() {
        return this.jobMetrics().getMaximumActiveJobs();
    }

    @Override
    public int getCurrentActiveJobs() {
        return this.jobMetrics().getCurrentActiveJobs();
    }

    @Override
    public float getAverageActiveJobs() {
        return this.jobMetrics().getAverageActiveJobs();
    }

    @Override
    public int getMaximumWaitingJobs() {
        return this.jobMetrics().getMaximumWaitingJobs();
    }

    @Override
    public int getCurrentWaitingJobs() {
        return this.jobMetrics().getCurrentWaitingJobs();
    }

    @Override
    public float getAverageWaitingJobs() {
        return this.jobMetrics().getAverageWaitingJobs();
    }

    @Override
    public int getMaximumRejectedJobs() {
        return this.jobMetrics().getMaximumRejectedJobs();
    }

    @Override
    public int getCurrentRejectedJobs() {
        return this.jobMetrics().getCurrentRejectedJobs();
    }

    @Override
    public float getAverageRejectedJobs() {
        return this.jobMetrics().getAverageRejectedJobs();
    }

    @Override
    public int getTotalRejectedJobs() {
        return this.jobMetrics().getTotalRejectedJobs();
    }

    @Override
    public int getMaximumCancelledJobs() {
        return this.jobMetrics().getMaximumCancelledJobs();
    }

    @Override
    public int getCurrentCancelledJobs() {
        return this.jobMetrics().getCurrentCancelledJobs();
    }

    @Override
    public float getAverageCancelledJobs() {
        return this.jobMetrics().getAverageCancelledJobs();
    }

    @Override
    public int getTotalCancelledJobs() {
        return this.jobMetrics().getTotalCancelledJobs();
    }

    @Override
    public int getTotalExecutedJobs() {
        return this.jobMetrics().getTotalExecutedJobs();
    }

    @Override
    public long getTotalJobsExecutionTime() {
        return this.jobMetrics().getTotalJobsExecutionTime();
    }

    @Override
    public long getMaximumJobWaitTime() {
        return this.jobMetrics().getMaximumJobWaitTime();
    }

    @Override
    public long getCurrentJobWaitTime() {
        return this.jobMetrics().getCurrentJobWaitTime();
    }

    @Override
    public double getAverageJobWaitTime() {
        return this.jobMetrics().getAverageJobWaitTime();
    }

    @Override
    public long getMaximumJobExecuteTime() {
        return this.jobMetrics().getMaximumJobExecuteTime();
    }

    @Override
    public long getCurrentJobExecuteTime() {
        return this.jobMetrics().getCurrentJobExecuteTime();
    }

    @Override
    public double getAverageJobExecuteTime() {
        return this.jobMetrics().getAverageJobExecuteTime();
    }

    @Override
    public int getTotalExecutedTasks() {
        return this.ctx.task().getTotalExecutedTasks();
    }

    @Override
    public long getTotalBusyTime() {
        return this.getUpTime() - this.getTotalIdleTime();
    }

    @Override
    public long getTotalIdleTime() {
        return this.jobMetrics().getTotalIdleTime();
    }

    @Override
    public long getCurrentIdleTime() {
        return this.jobMetrics().getCurrentIdleTime();
    }

    @Override
    public float getBusyTimePercentage() {
        return 1.0f - this.getIdleTimePercentage();
    }

    @Override
    public float getIdleTimePercentage() {
        return (float)this.getTotalIdleTime() / (float)this.getUpTime();
    }

    @Override
    public int getTotalCpus() {
        return this.vmMetrics.getAvailableProcessors();
    }

    @Override
    public double getCurrentCpuLoad() {
        return this.vmMetrics.getCurrentCpuLoad();
    }

    @Override
    public double getAverageCpuLoad() {
        return this.jobMetrics().getAverageCpuLoad();
    }

    @Override
    public double getCurrentGcCpuLoad() {
        return this.vmMetrics.getCurrentGcCpuLoad();
    }

    @Override
    public long getHeapMemoryInitialized() {
        return this.vmMetrics.getHeapMemoryInitialized();
    }

    @Override
    public long getHeapMemoryUsed() {
        return this.vmMetrics.getHeapMemoryUsed();
    }

    @Override
    public long getHeapMemoryCommitted() {
        return this.vmMetrics.getHeapMemoryCommitted();
    }

    @Override
    public long getHeapMemoryMaximum() {
        return this.vmMetrics.getHeapMemoryMaximum();
    }

    @Override
    public long getHeapMemoryTotal() {
        return this.vmMetrics.getHeapMemoryMaximum();
    }

    @Override
    public long getNonHeapMemoryInitialized() {
        return this.vmMetrics.getNonHeapMemoryInitialized();
    }

    @Override
    public long getNonHeapMemoryUsed() {
        Collection<GridCacheAdapter<?, ?>> caches = this.ctx.cache().internalCaches();
        long nonHeapUsed = this.vmMetrics.getNonHeapMemoryUsed();
        for (GridCacheAdapter<?, ?> cache : caches) {
            if (!cache.context().statisticsEnabled() || !cache.context().started() || cache.context().affinity().affinityTopologyVersion().topologyVersion() <= 0L) continue;
            nonHeapUsed += cache.metrics0().getOffHeapAllocatedSize();
        }
        return nonHeapUsed;
    }

    @Override
    public long getNonHeapMemoryCommitted() {
        return this.vmMetrics.getNonHeapMemoryCommitted();
    }

    @Override
    public long getNonHeapMemoryMaximum() {
        return this.vmMetrics.getNonHeapMemoryMaximum();
    }

    @Override
    public long getNonHeapMemoryTotal() {
        return this.vmMetrics.getNonHeapMemoryMaximum();
    }

    @Override
    public long getUpTime() {
        return this.vmMetrics.getUptime();
    }

    @Override
    public long getStartTime() {
        return this.vmMetrics.getStartTime();
    }

    @Override
    public long getNodeStartTime() {
        return this.nodeStartTime;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.vmMetrics.getThreadCount();
    }

    @Override
    public int getMaximumThreadCount() {
        return this.vmMetrics.getPeakThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.vmMetrics.getTotalStartedThreadCount();
    }

    @Override
    public int getCurrentDaemonThreadCount() {
        return this.vmMetrics.getDaemonThreadCount();
    }

    @Override
    public long getLastDataVersion() {
        return this.ctx.cache().lastDataVersion();
    }

    @Override
    public int getSentMessagesCount() {
        return this.ctx.io().getSentMessagesCount();
    }

    @Override
    public long getSentBytesCount() {
        return this.ctx.io().getSentBytesCount();
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.ctx.io().getReceivedMessagesCount();
    }

    @Override
    public long getReceivedBytesCount() {
        return this.ctx.io().getReceivedBytesCount();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.ctx.io().getOutboundMessagesQueueSize();
    }

    @Override
    public int getTotalNodes() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridJobMetrics jobMetrics() {
        if (this.jobMetrics == null) {
            Object object = this.jobMetricsMux;
            synchronized (object) {
                if (this.jobMetrics == null) {
                    this.jobMetricsUpdateTime = U.currentTimeMillis();
                    this.jobMetrics = this.ctx.jobMetric().getJobMetrics();
                }
            }
        }
        return this.jobMetrics;
    }
}

