/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.zillion.util.json.FastJsonReaderUtil;

public class TableUtil {
    static String[] table_names_ci = new String[]{"ci_instance", "ci_instanceinput", "ci_instanceoutput", "ci_status"};
    static String[] table_names_ce = new String[]{"ce_preroundindex", "ce_curround", "ce_computelog", "ce_computeinputlog", "ce_computeinputdetail", "ce_computeoutputdetail"};
    static String[] table_names_fjd = new String[]{"fjd_0_computedetail", "fjd_0_computelog", "fjd_0_metercomputetime", "fjd_1_computedetail", "fjd_1_computelog", "fjd_2_computedetail", "fjd_2_computelog", "fjd_3_computedetail", "fjd_3_computelog"};
    static String[] table_names_data = new String[]{"data_servicedata", "data_servicedata_max", "data_objectdata", "data_objectdata_max", "data_energydata", "data_energydata_max", "fjd_0_near", "fjd_0_rate", "fjd_1_near", "fjd_2_near", "fjd_3_near", "fjd_statinst", "original_flag"};
    static String[] table_names_data_seperate = new String[]{"data_servicedata_1min", "data_servicedata_5min", "data_servicedata_15min", "data_servicedata_1h", "data_servicedata_1d", "data_servicedata_1m", "data_servicedata_1y", "data_servicedata_max_1h", "data_servicedata_max_1d", "data_servicedata_max_1m", "data_servicedata_max_1y", "data_objectdata_1min", "data_objectdata_5min", "data_objectdata_15min", "data_objectdata_1h", "data_objectdata_1d", "data_objectdata_1m", "data_objectdata_1y", "data_objectdata_max_1h", "data_objectdata_max_1d", "data_objectdata_max_1m", "data_objectdata_max_1y", "data_energydata_1min", "data_energydata_5min", "data_energydata_15min", "data_energydata_1h", "data_energydata_1d", "data_energydata_1m", "data_energydata_1y", "data_energydata_max_1h", "data_energydata_max_1d", "data_energydata_max_1m", "data_energydata_max_1y", "data_tenantdata_15min", "data_tenantdata_1h", "data_tenantdata_1d", "data_tenantdata_1m", "data_tenantdata_1y", "data_tenantdata_max_1h", "data_tenantdata_max_1d", "data_tenantdata_max_1m", "data_tenantdata_max_1y", "data_tenantfee_15min", "data_tenantfee_1h", "data_tenantfee_1d", "data_tenantfee_1m", "data_tenantfee_1y", "data_tenantbalance", "data_tenantbalance_present", "fjd_0_near_1min", "fjd_0_near_5min", "fjd_0_near_15min", "fjd_0_near_1h", "fjd_0_near_1d", "fjd_0_rate_1min", "fjd_0_rate_5min", "fjd_0_rate_15min", "fjd_0_rate_1h", "fjd_0_rate_1d", "fjd_1_near_1min", "fjd_1_near_5min", "fjd_1_near_15min", "fjd_1_near_1h", "fjd_1_near_1d", "fjd_2_near_1min", "fjd_2_near_5min", "fjd_2_near_15min", "fjd_2_near_1h", "fjd_2_near_1d", "fjd_3_near_1min", "fjd_3_near_5min", "fjd_3_near_15min", "fjd_3_near_1h", "fjd_3_near_1d", "fjd_statinst_5min", "fjd_statinst_15min", "fjd_statinst_1h", "fjd_statinst_1d", "fjd_statinst_1m", "fjd_statinst_1y", "original_flag"};
    static String[] table_names_loss_rate = new String[]{"fjd_0_loss_rate_1d", "fjd_0_loss_rate_1m"};

    public static void DropTables(ZillionAgent agent, String database_name) throws Exception {
        ArrayList<String[]> table_namesList = new ArrayList<String[]>();
        table_namesList.add(table_names_ci);
        table_namesList.add(table_names_ce);
        table_namesList.add(table_names_fjd);
        if (ConstantCE.time_period_seperate) {
            table_namesList.add(table_names_data_seperate);
        } else {
            table_namesList.add(table_names_data);
        }
        Iterator iterator = table_namesList.iterator();
        while (iterator.hasNext()) {
            String[] table_names;
            for (String table_name : table_names = (String[])iterator.next()) {
                try {
                    agent.DDL_DropTable(database_name, table_name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void AddTables(ZillionAgent agent, String database_name) throws Exception {
        ArrayList<String[]> table_namesList = new ArrayList<String[]>();
        table_namesList.add(table_names_ci);
        table_namesList.add(table_names_ce);
        table_namesList.add(table_names_fjd);
        if (ConstantCE.time_period_seperate) {
            table_namesList.add(table_names_data_seperate);
        } else {
            table_namesList.add(table_names_data);
        }
        if (ConstantCE.fjd_0_loss_rate_enable) {
            table_namesList.add(table_names_loss_rate);
        }
        Iterator iterator = table_namesList.iterator();
        while (iterator.hasNext()) {
            String[] table_names;
            for (String table_name : table_names = (String[])iterator.next()) {
                TableUtil.AddTable(agent, database_name, table_name);
            }
        }
    }

    public static void ClearTables(ZillionAgent agent, String database_name, boolean ci_include, boolean is_clear) throws Exception {
        ArrayList<String[]> table_namesList = new ArrayList<String[]>();
        if (ci_include) {
            table_namesList.add(table_names_ci);
        }
        table_namesList.add(table_names_ce);
        table_namesList.add(table_names_fjd);
        if (ConstantCE.time_period_seperate) {
            table_namesList.add(table_names_data_seperate);
        } else {
            table_namesList.add(table_names_data);
        }
        Iterator iterator = table_namesList.iterator();
        while (iterator.hasNext()) {
            String[] table_names;
            for (String table_name : table_names = (String[])iterator.next()) {
                QueryUtil.ClearTable((IZillionAgent)agent, database_name, table_name, is_clear);
            }
        }
    }

    public static void AlterTables(ZillionAgent agent, String database_name) throws Exception {
        String[] logs = new String[]{"ce_computelog", "fjd_0_computelog", "fjd_1_computelog", "fjd_2_computelog"};
        JSONArray Columns_add = new JSONArray();
        JSONObject Column = new JSONObject();
        Column.put("Name", (Object)"operate_time_from");
        Column.put("Type", (Object)"String(20)");
        Columns_add.add((Object)Column);
        Column = new JSONObject();
        Column.put("Name", (Object)"operate_time_to");
        Column.put("Type", (Object)"String(20)");
        Columns_add.add((Object)Column);
        JSONObject alter_content = new JSONObject();
        alter_content.put("Columns_add", (Object)Columns_add);
        for (String table_name : logs) {
            try {
                agent.DDL_AlterTable(database_name, table_name, "Columns_add", alter_content);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Columns exist:")) continue;
                throw e;
            }
        }
        String[] details = new String[]{"ce_computeoutputdetail", "fjd_0_computedetail", "fjd_1_computedetail", "fjd_2_computedetail"};
        Columns_add = new JSONArray();
        Column = new JSONObject();
        Column.put("Name", (Object)"operate_time_to");
        Column.put("Type", (Object)"String(20)");
        Columns_add.add((Object)Column);
        alter_content = new JSONObject();
        alter_content.put("Columns_add", (Object)Columns_add);
        for (String table_name : details) {
            try {
                agent.DDL_AlterTable(database_name, table_name, "Columns_add", alter_content);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Columns exist:")) continue;
                throw e;
            }
        }
        details = new String[]{"fjd_0_computelog"};
        Columns_add = new JSONArray();
        Column = new JSONObject();
        Column.put("Name", (Object)"is_recompute");
        Column.put("Type", (Object)"Long");
        Columns_add.add((Object)Column);
        alter_content = new JSONObject();
        alter_content.put("Columns_add", (Object)Columns_add);
        for (String table_name : details) {
            try {
                agent.DDL_AlterTable(database_name, table_name, "Columns_add", alter_content);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Columns exist:")) continue;
                throw e;
            }
        }
        details = new String[]{"fjd_0_computelog"};
        Columns_add = new JSONArray();
        Column = new JSONObject();
        Column.put("Name", (Object)"detail_content");
        Column.put("Type", (Object)"String(16777215)");
        Columns_add.add((Object)Column);
        alter_content = new JSONObject();
        alter_content.put("Columns_add", (Object)Columns_add);
        for (String table_name : details) {
            try {
                agent.DDL_AlterTable(database_name, table_name, "Columns_add", alter_content);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Columns exist:")) continue;
                throw e;
            }
        }
        details = new String[]{"tenant_recharge"};
        Columns_add = new JSONArray();
        Column = new JSONObject();
        Column.put("Name", (Object)"is_used");
        Column.put("Type", (Object)"Long");
        Columns_add.add((Object)Column);
        alter_content = new JSONObject();
        alter_content.put("Columns_add", (Object)Columns_add);
        for (String table_name : details) {
            try {
                agent.DDL_AlterTable(database_name, table_name, "Columns_add", alter_content);
            }
            catch (Exception e) {
                if (e.getMessage().contains("Columns exist:")) continue;
                throw e;
            }
        }
    }

    public static void AddTable(ZillionAgent agent, String database_name, String table_name) throws Exception {
        String file_name = table_name;
        if (table_name.startsWith("fjd_3")) {
            file_name = "fjd_2" + table_name.substring("fjd_2".length());
        }
        JSONObject table_schema = FastJsonReaderUtil.Instance().ReadJSONObject(new File(Constant.GetPath() + "/def_" + file_name + ".json"));
        JSONArray Indexes = (JSONArray)table_schema.get((Object)"Indexes");
        table_schema.remove((Object)"Indexes");
        try {
            agent.DDL_AddTable(database_name, table_name, table_schema, Indexes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

