/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.sagacloud.util.compute_engine.core.AnnotationDescription;
import com.sagacloud.util.compute_engine.core.IDao_data_max;
import com.sagacloud.util.compute_engine.util.Constant;
import com.zillion.database.agent.IZillionAgent;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Dao_data_maxManager {
    private IZillionAgent agent;
    private String database_name;
    private static Dao_data_maxManager instance = new Dao_data_maxManager();
    Map<String, IDao_data_max> daoMap = new HashMap<String, IDao_data_max>();

    public static Dao_data_maxManager Instance() {
        return instance;
    }

    private Dao_data_maxManager() {
    }

    public void Initialize(IZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
        this.LoadClassByReflections();
        this.LoadClassByJar();
    }

    private void LoadClassByReflections() {
        try {
            Reflections reflections = new Reflections("com.sagacloud.extend.dao_data_max", new Scanner[0]);
            Set annotated = reflections.getTypesAnnotatedWith(AnnotationDescription.class);
            for (Class clazz : annotated) {
                Class<?>[] interfaces = clazz.getInterfaces();
                boolean flag = false;
                for (int ii = 0; ii < interfaces.length; ++ii) {
                    Class<?> inter = interfaces[ii];
                    if (!inter.getName().equals("com.sagacloud.util.compute_engine.core.IDao_data_max")) continue;
                    flag = true;
                }
                if (!flag) continue;
                this.add((IDao_data_max)clazz.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void LoadClassByJar() {
        try {
            String dirPath = Constant.GetPath() + "/dao_data_max/";
            File dir = new File(dirPath);
            String[] files = new String[]{};
            if (!dir.exists()) {
                dirPath = Constant.GetPath() + "/../lib/dao_data_max/";
                dir = new File(dirPath);
                if (dir.exists()) {
                    files = dir.list();
                }
            } else {
                files = dir.list();
            }
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = new URL("file:" + dirPath + files[i]);
            }
            URLClassLoader loader = new URLClassLoader(urls);
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dirPath + files[i]);
                if (!file.isFile()) continue;
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 6);
                    name = name.replaceAll("/", ".");
                    Class<?> clazz = loader.loadClass(name);
                    Class<?>[] interfaces = clazz.getInterfaces();
                    boolean flag = false;
                    for (int ii = 0; ii < interfaces.length; ++ii) {
                        Class<?> inter = interfaces[ii];
                        if (!inter.getName().equals("com.sagacloud.util.compute_engine.core.IDao_data_max")) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    this.add((IDao_data_max)clazz.newInstance());
                }
                jar.close();
            }
            loader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void add(IDao_data_max function) {
        function.Initialize(this.agent, this.database_name);
        this.daoMap.put(function.GetName(), function);
    }

    public IDao_data_max Get(String dao_type) {
        return this.daoMap.get(dao_type);
    }
}

