/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instance;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instanceinput;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instanceoutput;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class CoreInstance {
    public String object_sign;
    public String instance_name;
    public List<CoreInput> inputList = new ArrayList<CoreInput>();
    public List<CoreOutput> outputList = new ArrayList<CoreOutput>();

    public static CoreInstance Convert(Entity_ci_instance instance) {
        CoreInstance result = new CoreInstance();
        try {
            result.object_sign = instance.getObject_sign();
            result.instance_name = instance.getInstance_name();
            for (Entity_ci_instanceinput instanceinput : instance.getInputs()) {
                CoreInput input = CoreInstance.Convert_input(instanceinput);
                result.inputList.add(input);
            }
            for (Entity_ci_instanceoutput instanceoutput : instance.getOutputs()) {
                CoreOutput output = CoreInstance.Convert_output(instanceoutput);
                result.outputList.add(output);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static CoreInput Convert_input(Entity_ci_instanceinput instanceinput) {
        CoreInput input = new CoreInput();
        input.input_sign = instanceinput.getInput_sign();
        input.time_period = instanceinput.getTime_period();
        input.data_class = instanceinput.getData_class();
        input.dao_type = instanceinput.getDao_type();
        input.dao_key = (JSONObject)JSON.parse((String)instanceinput.getDao_key());
        input.source_object_sign = instanceinput.getSource_object_sign();
        input.source_instance_name = instanceinput.getSource_instance_name();
        input.source_output_sign = instanceinput.getSource_output_sign();
        return input;
    }

    public static CoreOutput Convert_output(Entity_ci_instanceoutput instanceoutput) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        CoreOutput output = new CoreOutput();
        output.output_sign = instanceoutput.getOutput_sign();
        output.time_begin = sdf.parse(instanceoutput.getTime_begin());
        output.time_end = sdf.parse(instanceoutput.getTime_end());
        output.data_class = instanceoutput.getData_class();
        output.dao_type = instanceoutput.getDao_type();
        output.dao_key = (JSONObject)JSON.parse((String)instanceoutput.getDao_key());
        output.need_all_var_data = instanceoutput.getNeed_all_var_data();
        output.time_period_intialized = instanceoutput.getTime_period_intialized();
        output.time_period = instanceoutput.getTime_period();
        output.mode = instanceoutput.getMode();
        output.expression = instanceoutput.getExpression();
        output.custom_function_name = instanceoutput.getCustom_function_name();
        if (instanceoutput.getCustom_paramsMap() != null) {
            JSONObject itemJSON = (JSONObject)JSON.parse((String)instanceoutput.getCustom_paramsMap());
            for (String key : itemJSON.keySet()) {
                output.custom_paramsMap.put(key, (String)itemJSON.get((Object)key));
            }
        }
        output.otherMap = instanceoutput.getOtherMap();
        return output;
    }
}

