/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.file.MappedFile;
import org.apache.ignite.internal.util.typedef.internal.U;

public class MappedFileMemoryProvider
implements DirectMemoryProvider {
    private static final String ALLOCATOR_FILE_PREFIX = "allocator-";
    private static final FilenameFilter ALLOCATOR_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(MappedFileMemoryProvider.ALLOCATOR_FILE_PREFIX);
        }
    };
    private IgniteLogger log;
    private final File allocationPath;
    private long[] sizes;
    private List<MappedFile> mappedFiles;

    public MappedFileMemoryProvider(IgniteLogger log, File allocationPath) {
        this.log = log;
        this.allocationPath = allocationPath;
    }

    @Override
    public void initialize(long[] sizes) {
        this.sizes = sizes;
        this.mappedFiles = new ArrayList<MappedFile>(sizes.length);
        if (!this.allocationPath.exists() && !this.allocationPath.mkdirs()) {
            throw new IgniteException("Failed to initialize allocation path (make sure directory is writable for the current user): " + this.allocationPath);
        }
        if (!this.allocationPath.isDirectory()) {
            throw new IgniteException("Failed to initialize allocation path (path is a file): " + this.allocationPath);
        }
        File[] files = this.allocationPath.listFiles(ALLOCATOR_FILTER);
        if (files.length != 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Will clean up the following files upon start: " + Arrays.asList(files));
            }
            for (File file : files) {
                if (file.delete()) continue;
                throw new IgniteException("Failed to delete allocated file on start (make sure file is not opened by another process and current user has enough rights): " + file);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.mappedFiles != null) {
            for (MappedFile file : this.mappedFiles) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    this.log.error("Failed to close memory-mapped file upon stop (will ignore) [file=" + file.file() + ", err=" + e.getMessage() + ']');
                }
            }
            this.mappedFiles = null;
        }
    }

    @Override
    public DirectMemoryRegion nextRegion() {
        try {
            if (this.mappedFiles.size() == this.sizes.length) {
                return null;
            }
            int idx = this.mappedFiles.size();
            long chunkSize = this.sizes[idx];
            File file = new File(this.allocationPath, ALLOCATOR_FILE_PREFIX + MappedFileMemoryProvider.alignInt(idx));
            MappedFile mappedFile = new MappedFile(file, chunkSize);
            this.mappedFiles.add(mappedFile);
            return mappedFile;
        }
        catch (IOException e) {
            U.error(this.log, "Failed to allocate next memory-mapped region", e);
            return null;
        }
    }

    private static String alignInt(int idx) {
        String idxStr = String.valueOf(idx);
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 8 - idxStr.length(); ++i) {
            res.append('0');
        }
        res.append(idxStr);
        return res.toString();
    }
}

