/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.mapreduce.records;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.mapreduce.IgfsFileRange;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class IgfsByteDelimiterRecordResolver
implements IgfsRecordResolver,
Externalizable {
    private static final long serialVersionUID = 0L;
    private byte[][] delims;
    @GridToStringExclude
    private int maxDelimLen;

    public IgfsByteDelimiterRecordResolver() {
    }

    public IgfsByteDelimiterRecordResolver(byte[] ... delims) {
        if (delims == null || delims.length == 0) {
            throw new IllegalArgumentException("Delimiters cannot be null or empty.");
        }
        this.delims = delims;
        int maxDelimLen = 0;
        for (byte[] delim : delims) {
            if (delim == null) {
                throw new IllegalArgumentException("Delimiter cannot be null.");
            }
            if (maxDelimLen >= delim.length) continue;
            maxDelimLen = delim.length;
        }
        this.maxDelimLen = maxDelimLen;
    }

    @Override
    public IgfsFileRange resolveRecords(IgniteFileSystem fs, IgfsInputStream stream, IgfsFileRange suggestedRecord) throws IgniteException, IOException {
        long suggestedStart = suggestedRecord.start();
        long suggestedEnd = suggestedStart + suggestedRecord.length();
        IgniteBiTuple<State, Delimiter> firstDelim = this.findFirstDelimiter(stream, suggestedStart);
        State state = firstDelim != null ? firstDelim.getKey() : new State();
        Delimiter curDelim = firstDelim.getValue();
        while (curDelim != null && curDelim.end < suggestedStart) {
            curDelim = this.nextDelimiter(stream, state);
        }
        if (curDelim != null && curDelim.end >= suggestedStart && curDelim.end < suggestedEnd || suggestedStart == 0L) {
            long start;
            long l = start = suggestedStart == 0L ? 0L : curDelim.end;
            if (curDelim == null || curDelim.end < suggestedEnd) {
                IgniteBiTuple<State, Delimiter> lastDelim = this.findFirstDelimiter(stream, suggestedEnd);
                state = lastDelim != null ? firstDelim.getKey() : new State();
                curDelim = lastDelim.getValue();
                while (curDelim != null && curDelim.end < suggestedEnd) {
                    curDelim = this.nextDelimiter(stream, state);
                }
            }
            long end = curDelim != null ? curDelim.end : stream.position();
            return new IgfsFileRange(suggestedRecord.path(), start, end - start);
        }
        return null;
    }

    private int maxDelimiterLength(byte[][] delims) {
        int maxDelimLen = 0;
        for (byte[] delim : delims) {
            if (delim == null) {
                throw new IllegalArgumentException("Delimiter cannot be null.");
            }
            if (maxDelimLen >= delim.length) continue;
            maxDelimLen = delim.length;
        }
        return maxDelimLen;
    }

    @Nullable
    private IgniteBiTuple<State, Delimiter> findFirstDelimiter(IgfsInputStream stream, long startPos) throws IOException {
        Delimiter delim;
        State state;
        long curPos = Math.max(0L, startPos - (long)this.maxDelimLen);
        while (true) {
            stream.seek(curPos);
            state = new State();
            delim = this.nextDelimiter(stream, state);
            if (curPos == 0L || delim == null || delim.start - curPos > (long)(this.maxDelimLen - 1)) break;
            curPos = Math.max(0L, curPos - (long)this.maxDelimLen);
        }
        return F.t(state, delim);
    }

    private Delimiter nextDelimiter(IgfsInputStream is, State state) throws IOException {
        assert (is != null);
        assert (state != null);
        Map parts = state.parts;
        LinkedList delimQueue = state.delims;
        int nextByte = is.read();
        while (nextByte != -1) {
            for (int idx = 0; idx < this.delims.length; ++idx) {
                int val;
                byte[] delim = this.delims[idx];
                int n = val = parts.containsKey(idx) ? (Integer)parts.get(idx) : 0;
                if (delim[val] == nextByte) {
                    if (val == delim.length - 1) {
                        parts.remove(idx);
                        Delimiter newDelim = new Delimiter(is.position() - (long)delim.length, is.position());
                        boolean ignore = false;
                        int replaceIdx = -1;
                        for (int i = delimQueue.size() - 1; i >= 0; --i) {
                            Delimiter prevDelim = (Delimiter)delimQueue.get(i);
                            if (prevDelim.start < newDelim.start) {
                                if (prevDelim.end <= newDelim.start) continue;
                                ignore = true;
                                break;
                            }
                            if (prevDelim.start != newDelim.start) continue;
                            replaceIdx = i;
                            break;
                        }
                        if (ignore) continue;
                        if (replaceIdx >= 0) {
                            delimQueue.removeAll(delimQueue.subList(replaceIdx, delimQueue.size()));
                        }
                        delimQueue.add(newDelim);
                        continue;
                    }
                    parts.put(idx, ++val);
                    continue;
                }
                if (val == 0) continue;
                if (delim[0] == nextByte) {
                    boolean shift = true;
                    for (int k = 1; k < val; ++k) {
                        if (delim[k] == nextByte) continue;
                        shift = false;
                        break;
                    }
                    if (shift) continue;
                    parts.put(idx, 1);
                    continue;
                }
                parts.remove(idx);
            }
            if (!delimQueue.isEmpty()) {
                Delimiter delim = (Delimiter)delimQueue.get(0);
                if (is.position() - delim.end >= (long)this.maxDelimLen) {
                    return (Delimiter)delimQueue.poll();
                }
            }
            nextByte = is.read();
        }
        return (Delimiter)delimQueue.poll();
    }

    public String toString() {
        return S.toString(IgfsByteDelimiterRecordResolver.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.delims != null) {
            out.writeBoolean(true);
            out.writeInt(this.delims.length);
            for (byte[] delim : this.delims) {
                U.writeByteArray(out, delim);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            int len = in.readInt();
            this.delims = new byte[len][];
            for (int i = 0; i < len; ++i) {
                this.delims[i] = U.readByteArray(in);
            }
            this.maxDelimLen = this.maxDelimiterLength(this.delims);
        }
    }

    private static class State {
        private final Map<Integer, Integer> parts = new HashMap<Integer, Integer>();
        private final LinkedList<Delimiter> delims = new LinkedList();

        private State() {
        }
    }

    private static class Delimiter {
        private final long start;
        private final long end;

        private Delimiter(long start, long end) {
            assert (start >= 0L && end >= 0L && start <= end);
            this.start = start;
            this.end = end;
        }
    }
}

