/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import javax.cache.configuration.Factory;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class TransactionConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final boolean DFLT_TX_SERIALIZABLE_ENABLED = false;
    public static final TransactionConcurrency DFLT_TX_CONCURRENCY = TransactionConcurrency.PESSIMISTIC;
    public static final TransactionIsolation DFLT_TX_ISOLATION = TransactionIsolation.REPEATABLE_READ;
    public static final long DFLT_TRANSACTION_TIMEOUT = 0L;
    public static final long TX_TIMEOUT_ON_PARTITION_MAP_EXCHANGE = 0L;
    public static final int DFLT_PESSIMISTIC_TX_LOG_LINGER = 10000;
    private boolean txSerEnabled = false;
    private TransactionIsolation dfltIsolation = DFLT_TX_ISOLATION;
    private TransactionConcurrency dfltConcurrency = DFLT_TX_CONCURRENCY;
    private long dfltTxTimeout = 0L;
    private volatile long txTimeoutOnPartitionMapExchange = 0L;
    private int pessimisticTxLogSize;
    private int pessimisticTxLogLinger = 10000;
    private String tmLookupClsName;
    private Factory txManagerFactory;
    private boolean useJtaSync;

    public TransactionConfiguration() {
    }

    public TransactionConfiguration(TransactionConfiguration cfg) {
        this.dfltConcurrency = cfg.getDefaultTxConcurrency();
        this.dfltIsolation = cfg.getDefaultTxIsolation();
        this.dfltTxTimeout = cfg.getDefaultTxTimeout();
        this.txTimeoutOnPartitionMapExchange = cfg.getTxTimeoutOnPartitionMapExchange();
        this.pessimisticTxLogLinger = cfg.getPessimisticTxLogLinger();
        this.pessimisticTxLogSize = cfg.getPessimisticTxLogSize();
        this.txSerEnabled = cfg.isTxSerializableEnabled();
        this.tmLookupClsName = cfg.getTxManagerLookupClassName();
        this.txManagerFactory = cfg.getTxManagerFactory();
        this.useJtaSync = cfg.isUseJtaSynchronization();
    }

    @Deprecated
    public boolean isTxSerializableEnabled() {
        return this.txSerEnabled;
    }

    @Deprecated
    public TransactionConfiguration setTxSerializableEnabled(boolean txSerEnabled) {
        this.txSerEnabled = txSerEnabled;
        return this;
    }

    public TransactionConcurrency getDefaultTxConcurrency() {
        return this.dfltConcurrency;
    }

    public TransactionConfiguration setDefaultTxConcurrency(TransactionConcurrency dfltConcurrency) {
        this.dfltConcurrency = dfltConcurrency;
        return this;
    }

    public TransactionIsolation getDefaultTxIsolation() {
        return this.dfltIsolation;
    }

    public TransactionConfiguration setDefaultTxIsolation(TransactionIsolation dfltIsolation) {
        this.dfltIsolation = dfltIsolation;
        return this;
    }

    public long getDefaultTxTimeout() {
        return this.dfltTxTimeout;
    }

    public TransactionConfiguration setDefaultTxTimeout(long dfltTxTimeout) {
        this.dfltTxTimeout = dfltTxTimeout;
        return this;
    }

    public long getTxTimeoutOnPartitionMapExchange() {
        return this.txTimeoutOnPartitionMapExchange;
    }

    public TransactionConfiguration setTxTimeoutOnPartitionMapExchange(long txTimeoutOnPartitionMapExchange) {
        this.txTimeoutOnPartitionMapExchange = txTimeoutOnPartitionMapExchange;
        return this;
    }

    public int getPessimisticTxLogSize() {
        return this.pessimisticTxLogSize;
    }

    public TransactionConfiguration setPessimisticTxLogSize(int pessimisticTxLogSize) {
        this.pessimisticTxLogSize = pessimisticTxLogSize;
        return this;
    }

    public int getPessimisticTxLogLinger() {
        return this.pessimisticTxLogLinger;
    }

    public TransactionConfiguration setPessimisticTxLogLinger(int pessimisticTxLogLinger) {
        this.pessimisticTxLogLinger = pessimisticTxLogLinger;
        return this;
    }

    @Deprecated
    public String getTxManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    @Deprecated
    public TransactionConfiguration setTxManagerLookupClassName(String tmLookupClsName) {
        this.tmLookupClsName = tmLookupClsName;
        return this;
    }

    public <T> Factory<T> getTxManagerFactory() {
        return this.txManagerFactory;
    }

    public <T> TransactionConfiguration setTxManagerFactory(Factory<T> factory) {
        this.txManagerFactory = factory;
        return this;
    }

    public boolean isUseJtaSynchronization() {
        return this.useJtaSync;
    }

    public TransactionConfiguration setUseJtaSynchronization(boolean useJtaSync) {
        this.useJtaSync = useJtaSync;
        return this;
    }
}

