/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public abstract class AbstractHFileWriter
implements HFile.Writer {
    protected Cell lastCell = null;
    protected FSDataOutputStream outputStream;
    protected final boolean closeOutputStream;
    protected HFile.FileInfo fileInfo = new HFile.FileInfo();
    protected long entryCount = 0L;
    protected long totalKeyLength = 0L;
    protected long totalValueLength = 0L;
    protected long totalUncompressedBytes = 0L;
    protected final KeyValue.KVComparator comparator;
    protected List<byte[]> metaNames = new ArrayList<byte[]>();
    protected List<Writable> metaData = new ArrayList<Writable>();
    protected Cell firstCellInBlock = null;
    protected final Path path;
    protected final CacheConfig cacheConf;
    protected final String name;
    protected final HFileDataBlockEncoder blockEncoder;
    protected final HFileContext hFileContext;

    public AbstractHFileWriter(CacheConfig cacheConf, FSDataOutputStream outputStream, Path path, KeyValue.KVComparator comparator, HFileContext fileContext) {
        this.outputStream = outputStream;
        this.path = path;
        this.name = path != null ? path.getName() : outputStream.toString();
        this.hFileContext = fileContext;
        DataBlockEncoding encoding = this.hFileContext.getDataBlockEncoding();
        this.blockEncoder = encoding != DataBlockEncoding.NONE ? new HFileDataBlockEncoderImpl(encoding) : NoOpDataBlockEncoder.INSTANCE;
        this.comparator = comparator != null ? comparator : KeyValue.COMPARATOR;
        this.closeOutputStream = path != null;
        this.cacheConf = cacheConf;
    }

    protected void finishFileInfo() throws IOException {
        if (this.lastCell != null) {
            byte[] lastKey = CellUtil.getCellKeySerializedAsKeyValueKey((Cell)this.lastCell);
            this.fileInfo.append(HFile.FileInfo.LASTKEY, lastKey, false);
        }
        int avgKeyLen = this.entryCount == 0L ? 0 : (int)(this.totalKeyLength / this.entryCount);
        this.fileInfo.append(HFile.FileInfo.AVG_KEY_LEN, Bytes.toBytes((int)avgKeyLen), false);
        int avgValueLen = this.entryCount == 0L ? 0 : (int)(this.totalValueLength / this.entryCount);
        this.fileInfo.append(HFile.FileInfo.AVG_VALUE_LEN, Bytes.toBytes((int)avgValueLen), false);
        this.fileInfo.append(HFile.FileInfo.CREATE_TIME_TS, Bytes.toBytes((long)this.hFileContext.getFileCreateTime()), false);
    }

    @Override
    public void appendFileInfo(byte[] k, byte[] v) throws IOException {
        this.fileInfo.append(k, v, true);
    }

    protected final void writeFileInfo(FixedFileTrailer trailer, DataOutputStream out) throws IOException {
        trailer.setFileInfoOffset(this.outputStream.getPos());
        this.finishFileInfo();
        this.fileInfo.write(out);
    }

    protected boolean checkKey(Cell cell) throws IOException {
        boolean isDuplicateKey = false;
        if (cell == null) {
            throw new IOException("Key cannot be null or empty");
        }
        if (this.lastCell != null) {
            int keyComp = this.comparator.compareOnlyKeyPortion(this.lastCell, cell);
            if (keyComp > 0) {
                throw new IOException("Added a key not lexically larger than previous. Current cell = " + cell + ", lastCell = " + this.lastCell);
            }
            if (keyComp == 0) {
                isDuplicateKey = true;
            }
        }
        return isDuplicateKey;
    }

    protected void checkValue(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            throw new IOException("Value cannot be null");
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return "writer=" + (this.path != null ? this.path.toString() : null) + ", name=" + this.name + ", compression=" + this.hFileContext.getCompression().getName();
    }

    protected void finishClose(FixedFileTrailer trailer) throws IOException {
        trailer.setMetaIndexCount(this.metaNames.size());
        trailer.setTotalUncompressedBytes(this.totalUncompressedBytes + (long)trailer.getTrailerSize());
        trailer.setEntryCount(this.entryCount);
        trailer.setCompressionCodec(this.hFileContext.getCompression());
        trailer.serialize((DataOutputStream)this.outputStream);
        if (this.closeOutputStream) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    public static Compression.Algorithm compressionByName(String algoName) {
        if (algoName == null) {
            return HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        return Compression.getCompressionAlgorithmByName((String)algoName);
    }

    protected static FSDataOutputStream createOutputStream(Configuration conf, FileSystem fs, Path path, InetSocketAddress[] favoredNodes) throws IOException {
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        return FSUtils.create(conf, fs, path, perms, favoredNodes);
    }
}

