/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.util.Constant;
import com.zillion.database.agent.ZillionAgent;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.zillion.util.json.FastJsonUtil;
import org.zillion.util.log.LogUtil;

public class delete_original_month_null {
    static String database_name = "ems_data";
    static String[] buildings = new String[]{"4419000001", "4419000012"};
    static String time_from = "20180401000000";
    static String time_to = "20180601000000";

    public static void main(String[] args) throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource((InputStream)new FileInputStream(Constant.GetPath() + "/hbase-site.xml"));
        ZillionAgent agent = new ZillionAgent(configuration);
        agent.Start();
        for (String building : buildings) {
            delete_original_month_null.ProcessBuilding(agent, database_name, building);
        }
        agent.Stop();
        System.out.println();
    }

    static void ProcessBuilding(ZillionAgent agent, String database_name, String building) throws Exception {
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"select");
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)"original_present");
        wrapperObject.put("Criteria", (Object)Criteria);
        JSONObject queryResult = agent.Query(wrapperObject);
        JSONArray resultContent = (JSONArray)queryResult.get((Object)"Content");
        for (int i = 0; i < resultContent.size(); ++i) {
            JSONObject item = (JSONObject)resultContent.get(i);
            String meter = (String)item.get((Object)"meter");
            long funcid = (Long)item.get((Object)"funcid");
            delete_original_month_null.ProcessPoint(agent, database_name, building, meter, funcid, time_from, time_to);
            if (i == 0 || i % 100 != 0) continue;
            LogUtil.warn((String)(i + "/" + resultContent.size()));
        }
    }

    static void ProcessPoint(ZillionAgent agent, String database_name, String building, String meter, long funcid, String time_from, String time_to) throws Exception {
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        JSONObject Range = new JSONObject();
        Range.put("$gte", (Object)time_from);
        Range.put("$lt", (Object)time_to);
        Criteria.put("receivetime", (Object)Range);
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"select");
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)"original_month");
        wrapperObject.put("Criteria", (Object)Criteria);
        JSONObject queryResult = agent.Query(wrapperObject);
        JSONArray resultContent = (JSONArray)queryResult.get((Object)"Content");
        boolean has_null = false;
        String null_time_from = null;
        String null_time_to = null;
        for (int i = 0; i < resultContent.size(); ++i) {
            JSONObject item = (JSONObject)resultContent.get(i);
            String receivetime = (String)item.get((Object)"receivetime");
            Double data = (Double)item.get((Object)"data");
            if (data == null) {
                if (has_null) {
                    null_time_to = receivetime;
                } else {
                    has_null = true;
                    null_time_from = receivetime;
                    null_time_to = receivetime;
                }
            }
            if (data == null && i != resultContent.size() - 1 || !has_null) continue;
            item.remove((Object)"data");
            item.remove((Object)"receivetime");
            JSONObject RangeInner = new JSONObject();
            RangeInner.put("$gte", (Object)null_time_from);
            RangeInner.put("$lte", (Object)null_time_to);
            item.put("receivetime", (Object)RangeInner);
            LogUtil.warn((String)FastJsonUtil.toFormatString((Object)item));
            JSONObject wrapperObjectInner = new JSONObject();
            wrapperObjectInner.put("QueryType", (Object)"delete");
            wrapperObjectInner.put("Database", (Object)database_name);
            wrapperObjectInner.put("Datatable", (Object)"original_month");
            wrapperObjectInner.put("Criteria", (Object)item);
            agent.Query(wrapperObjectInner);
            has_null = false;
            null_time_from = null;
            null_time_to = null;
        }
    }
}

