/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONReader;
import com.alibaba.fastjson.JSONWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.zillion.util.json.FastJsonUtil;

public class FastJsonReaderUtil {
    private static FastJsonReaderUtil instance = new FastJsonReaderUtil();

    public static FastJsonReaderUtil Instance() {
        return instance;
    }

    private FastJsonReaderUtil() {
    }

    public Object parse(byte[] JSON_bytes) throws Exception {
        return this.parse(new String(JSON_bytes, "UTF-8"));
    }

    public Object parse(String JSONString) throws Exception {
        Object result = JSON.parse((String)JSONString);
        FastJsonUtil.Normalize(result);
        return result;
    }

    public JSONObject ReadJSONObject(File file) throws Exception {
        Object result = this.ReadInner(file);
        if (result == null) {
            return null;
        }
        FastJsonUtil.Normalize(result);
        return (JSONObject)result;
    }

    public JSONArray ReadJSONArray(File file) throws Exception {
        Object result = this.ReadInner(file);
        if (result == null) {
            return null;
        }
        FastJsonUtil.Normalize(result);
        return (JSONArray)result;
    }

    private Object ReadInner(File file) throws Exception {
        Object result = null;
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(is);
        JSONReader json_reader = new JSONReader((Reader)reader);
        result = json_reader.readObject();
        json_reader.close();
        ((Reader)reader).close();
        ((InputStream)is).close();
        return result;
    }

    public void Write(JSONObject result, String filepath) throws Exception {
        this.WriteInner(result, filepath);
    }

    public void Write(JSONArray result, String filepath) throws Exception {
        this.WriteInner(result, filepath);
    }

    private void WriteInner(Object result, String filepath) throws Exception {
        FileOutputStream os = new FileOutputStream(filepath);
        OutputStreamWriter writer = new OutputStreamWriter(os);
        JSONWriter json_writer = new JSONWriter((Writer)writer);
        json_writer.config(SerializerFeature.WriteMapNullValue, false);
        json_writer.writeObject(result);
        json_writer.close();
        ((Writer)writer).close();
        ((OutputStream)os).close();
    }
}

