/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionCriteriaGroup;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.util.DataSourceConfig_DBCP;
import com.zillion.database.util.IMemory;
import com.zillion.database.util.MemoryConfig_Ignite;
import com.zillion.database.util.MySQLUtil;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.dbcp2.BasicDataSource;

public class MemoryImpl_Ignite
implements IMemory {
    public static int DEFAULT_VARCHAR_LENGTH = 125;
    MemoryConfig_Ignite configuration;
    DataSource ds;

    static {
        try {
            Class.forName("org.apache.ignite.IgniteJdbcDriver").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public MemoryImpl_Ignite(MemoryConfig_Ignite configuration) {
        this.configuration = configuration;
    }

    @Override
    public void Start() throws Exception {
        if (!(this.configuration.config instanceof DataSourceConfig_DBCP)) {
            throw new Exception("Unknowd DataSourceConfig:" + this.configuration.config.name);
        }
        DataSourceConfig_DBCP config_DBCP = this.configuration.config;
        BasicDataSource bds = new BasicDataSource();
        bds.setDriverClassName("org.apache.ignite.IgniteJdbcDriver");
        bds.setUrl(config_DBCP.url);
        bds.setUsername(config_DBCP.username);
        bds.setPassword(config_DBCP.password);
        bds.setInitialSize(config_DBCP.initialSize);
        bds.setMaxTotal(config_DBCP.maxTotal);
        bds.setMaxIdle(config_DBCP.maxIdle);
        bds.setMinIdle(config_DBCP.minIdle);
        bds.setMaxWaitMillis((long)config_DBCP.maxWaitMillis);
        this.ds = bds;
    }

    @Override
    public void Stop() throws Exception {
        if (this.configuration.config instanceof DataSourceConfig_DBCP) {
            BasicDataSource bds = (BasicDataSource)this.ds;
            bds.close();
        }
    }

    private Connection getConnection() throws Exception {
        Connection conn = this.ds.getConnection();
        return conn;
    }

    @Override
    public void table_manage_create_data(String namespace, ZillionTableSchema schema) throws Exception {
        String tableName = schema.table_name;
        String ori_tableName = "zillion_data_" + tableName;
        this.ori_create_table(namespace, schema, ori_tableName);
    }

    @Override
    public void table_manage_create_index(String namespace, String tableName, ZillionTableIndex schema_index) throws Exception {
        ZillionTableSchema schema = schema_index.schema;
        String ori_tableName = "zillion_data_" + tableName;
        this.ori_create_index(namespace, schema, schema_index, ori_tableName);
    }

    @Override
    public void table_manage_drop_data(String namespace, String tableName) throws Exception {
        this.ori_drop_table(namespace, "zillion_data_" + tableName);
    }

    @Override
    public void table_manage_drop_index(String namespace, String tableName, String indexName) throws Exception {
        this.ori_drop_index(namespace, "zillion_data_" + tableName, indexName);
    }

    @Override
    public JSONArray batch_get(ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray InsertObjects, JSONArray content, JSONArray ReturnColumns) throws Exception {
        Connection conn = this.getConnection();
        HashMap<String, Boolean> ReturnColumnsMap = new HashMap<String, Boolean>();
        if (ReturnColumns == null) {
            for (String key : schema.ColumnMap.keySet()) {
                ReturnColumnsMap.put(key, true);
            }
        } else {
            int index_rcs = 0;
            while (index_rcs < ReturnColumns.size()) {
                String key;
                key = (String)ReturnColumns.get(index_rcs);
                ReturnColumnsMap.put(key, true);
                ++index_rcs;
            }
        }
        String ori_tableName_full = "PUBLIC." + schema.Namespace + "_" + schema.table_name + (schemaWrapper.child_name == null ? "" : "_" + schemaWrapper.child_name);
        JSONArray result = MySQLUtil.batch_get(conn, ori_tableName_full, schema, InsertObjects, content, ReturnColumnsMap);
        conn.close();
        return result;
    }

    @Override
    public void batch_process(ZillionTableSchema schema, SchemaWrapper schemaWrapper, String QueryType, JSONArray InsertObjects, boolean is_put) throws Exception {
        Connection conn = this.getConnection();
        String ori_tableName = "zillion_data_" + schema.table_name;
        String ori_tableName_full = "PUBLIC." + schema.Namespace + "_" + ori_tableName + (schemaWrapper.child_name == null ? "" : "_" + schemaWrapper.child_name);
        MySQLUtil.batch_process(conn, ori_tableName_full, schema, QueryType, InsertObjects, is_put);
        conn.close();
    }

    @Override
    public void scan(SchemaRepositoryContainer container, ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray ReturnColumns, ZillionCriteriaGroup group, String QueryType, JSONArray content, ZillionQueryTmp zqt, ZipArchiveOutputStream out, AsyncJob job, boolean SortInDB, JSONArray OrderBy, long Limit_Skip, long Limit_Count, ZillionQueryResult result, JSONObject Set2) throws Exception {
        Connection conn = this.getConnection();
        String ori_tableName = "zillion_data_" + schema.table_name;
        String ori_tableName_full = "PUBLIC." + schema.Namespace + "_" + ori_tableName + (schemaWrapper.child_name == null ? "" : "_" + schemaWrapper.child_name);
        String[] keysInner = group.index_index == -1 ? schema.Key : schema.Indexes.get((int)group.index_index).Key;
        MySQLUtil.scan(conn, ori_tableName_full, container, schema, schemaWrapper, ReturnColumns, group.CriteriaList, QueryType, content, zqt, out, job, keysInner, SortInDB, OrderBy, Limit_Skip, Limit_Count, result, Set2);
        conn.close();
    }

    private void generateColumn_Ignite(StringBuffer sb_table, ZillionTableColumn column) {
        if (sb_table.length() != 0) {
            sb_table.append(",");
        }
        sb_table.append("`");
        sb_table.append(column.Name);
        sb_table.append("`");
        sb_table.append(" ");
        if (column.Type == ZillionTableColumnEnum.LONG) {
            sb_table.append("bigint");
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE) {
            sb_table.append("double");
        } else if (column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
            int max_length_real = column.max_length == Integer.MAX_VALUE ? DEFAULT_VARCHAR_LENGTH : column.max_length;
            sb_table.append("varchar(" + max_length_real + ")");
        } else if (column.Type == ZillionTableColumnEnum.BOOLEAN) {
            sb_table.append("int");
        }
        if (column.NotNull || !column.NotNull && column.NullValueConvert) {
            sb_table.append(" NOT NULL");
        }
    }

    private void ori_create_index(String namespace, ZillionTableSchema schema, ZillionTableIndex schema_index, String ori_tableName) throws Exception {
        Connection conn = this.getConnection();
        StringBuffer sb_key = new StringBuffer();
        String[] stringArray = schema_index.Key;
        int n = schema_index.Key.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ZillionTableColumn column = schema.ColumnMap.get(key);
            if (sb_key.length() != 0) {
                sb_key.append(",");
            }
            sb_key.append("`");
            sb_key.append(column.Name);
            sb_key.append("`");
            ++n2;
        }
        String stringSQL = "CREATE INDEX IF NOT EXISTS PUBLIC." + namespace + "_" + ori_tableName + "_" + schema_index.index_name + " ON " + "PUBLIC." + namespace + "_" + ori_tableName + "(" + sb_key.toString() + ")";
        MySQLUtil.ori_execute(conn, stringSQL);
        conn.close();
    }

    private void ori_create_table(String namespace, ZillionTableSchema schema, String ori_tableName) throws Exception {
        ZillionTableColumn column;
        String key;
        Connection conn = this.getConnection();
        StringBuffer sb_table = new StringBuffer();
        StringBuffer sb_key = new StringBuffer();
        String[] stringArray = schema.Key;
        int n = schema.Key.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            column = schema.ColumnMap.get(key);
            this.generateColumn_Ignite(sb_table, column);
            if (sb_key.length() != 0) {
                sb_key.append(",");
            }
            sb_key.append("`");
            sb_key.append(column.Name);
            sb_key.append("`");
            ++n2;
        }
        stringArray = schema.OtherColumn;
        n = schema.OtherColumn.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            column = schema.ColumnMap.get(key);
            this.generateColumn_Ignite(sb_table, column);
            ++n2;
        }
        String stringSQL = "CREATE TABLE IF NOT EXISTS PUBLIC." + namespace + "_" + ori_tableName + "(" + sb_table.toString() + ",PRIMARY KEY (" + sb_key.toString() + "))";
        MySQLUtil.ori_execute(conn, stringSQL);
        conn.close();
    }

    private void ori_drop_index(String namespace, String name, String index_name) throws Exception {
        Connection conn = this.getConnection();
        String stringSQL = "DROP INDEX IF EXISTS PUBLIC." + namespace + "_" + name + "_" + index_name;
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        stmt.execute();
        stmt.close();
        conn.close();
    }

    private void ori_drop_table(String namespace, String name) throws Exception {
        Connection conn = this.getConnection();
        String stringSQL = "DROP TABLE IF EXISTS PUBLIC." + namespace + "_" + name;
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        stmt.execute();
        stmt.close();
        conn.close();
    }
}

