/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionCriteriaGroup;
import com.zillion.database.agent.ZillionCriteriaMatchItem;
import com.zillion.database.agent.ZillionCriteriaMatchUtil;
import com.zillion.database.agent.ZillionOrderByUtil;
import com.zillion.database.agent.ZillionQueryCheckUtil;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.second.SecondCriteria;
import com.zillion.database.util.ITableWrapper;
import com.zillion.util.common.JSONObjectComparator;
import com.zillion.util.common.SplitUtil;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.zillion.util.common.ListUtil;
import org.zillion.util.common.MyException;
import org.zillion.util.json.FastJsonCompareUtil;
import org.zillion.util.json.FastJsonUtil;
import org.zillion.util.log.LogUtil;

public class ZillionQueryUtil {
    public static JSONObject getData(SchemaRepositoryContainer container, ZillionTableSchema schema, JSONObject InsertObject, JSONArray content, JSONArray ReturnColumns) throws Exception {
        JSONArray InsertObjects_realInner;
        JSONObject result = null;
        JSONArray InsertObjectsInner = new JSONArray();
        InsertObjectsInner.add((Object)InsertObject);
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            String split_value = (String)InsertObject.get((Object)schema.split_column);
            String child_name = split_value.substring(0, SplitUtil.split_type2child_length.get(schema.table_type));
            InsertObjects_realInner = ZillionQueryUtil.getDatasInner(container, schema, child_name, InsertObjectsInner, content, ReturnColumns);
        } else {
            InsertObjects_realInner = ZillionQueryUtil.getDatasInner(container, schema, null, InsertObjectsInner, content, ReturnColumns);
        }
        if (InsertObjects_realInner.size() > 0) {
            result = (JSONObject)InsertObjects_realInner.get(0);
        }
        return result;
    }

    public static JSONArray getDatas(SchemaRepositoryContainer container, ZillionTableSchema schema, JSONArray InsertObjects, JSONArray content, JSONArray ReturnColumns) throws Exception {
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            HashMap<String, JSONArray> InsertObjectsMap = new HashMap<String, JSONArray>();
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                String split_value = (String)InsertObject.get((Object)schema.split_column);
                String child_name = split_value.substring(0, SplitUtil.split_type2child_length.get(schema.table_type));
                if (!InsertObjectsMap.containsKey(child_name)) {
                    InsertObjectsMap.put(child_name, new JSONArray());
                }
                ((JSONArray)InsertObjectsMap.get(child_name)).add((Object)InsertObject);
                ++i;
            }
            JSONArray InsertObjects_real = new JSONArray();
            Object[] child_nameArray = InsertObjectsMap.keySet().toArray(new String[0]);
            Arrays.sort(child_nameArray);
            Object[] objectArray = child_nameArray;
            int n = child_nameArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child_name = objectArray[n2];
                JSONArray InsertObjectsInner = (JSONArray)InsertObjectsMap.get(child_name);
                JSONArray InsertObjects_realInner = ZillionQueryUtil.getDatasInner(container, schema, (String)child_name, InsertObjectsInner, content, ReturnColumns);
                InsertObjects_real.addAll((Collection)InsertObjects_realInner);
                ++n2;
            }
            return InsertObjects_real;
        }
        JSONArray InsertObjects_real = ZillionQueryUtil.getDatasInner(container, schema, null, InsertObjects, content, ReturnColumns);
        return InsertObjects_real;
    }

    private static JSONArray getDatasInner(SchemaRepositoryContainer container, ZillionTableSchema schema, String child_name, JSONArray InsertObjects, JSONArray content, JSONArray ReturnColumns) throws Exception {
        JSONArray InsertObjects_real;
        ITableWrapper table_wrapper;
        HashMap<String, Boolean> ReturnColumnsMap = new HashMap<String, Boolean>();
        if (ReturnColumns == null) {
            for (String key : schema.ColumnMap.keySet()) {
                ReturnColumnsMap.put(key, true);
            }
        } else {
            int index_rcs = 0;
            while (index_rcs < ReturnColumns.size()) {
                String key;
                key = (String)ReturnColumns.get(index_rcs);
                ReturnColumnsMap.put(key, true);
                ++index_rcs;
            }
        }
        if (ZillionConstant.check_query) {
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                ZillionQueryCheckUtil.CheckKey(schema, InsertObject);
                ++i;
            }
        }
        if ((table_wrapper = schema.connect(container, child_name, false)) != null) {
            InsertObjects_real = container.DatabaseImpl.batch_get(schema, table_wrapper, InsertObjects, content, ReturnColumnsMap);
            table_wrapper.unuse();
        } else {
            InsertObjects_real = InsertObjects;
        }
        return InsertObjects_real;
    }

    public static List<String> get_all_splits(ZillionTableSchema schema) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date_from = sdf.parse("20000101");
        Date date_to = sdf.parse("20310101");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date_from);
        while (calendar.getTime().getTime() < date_to.getTime()) {
            String str = sdf.format(calendar.getTime());
            if (schema.table_type.equals("split_hour")) {
                result.add(str.substring(0, SplitUtil.split_type2child_length.get(schema.table_type)));
                calendar.add(11, 1);
                continue;
            }
            if (schema.table_type.equals("split_day")) {
                result.add(str.substring(0, SplitUtil.split_type2child_length.get(schema.table_type)));
                calendar.add(5, 1);
                continue;
            }
            if (schema.table_type.equals("split_month")) {
                result.add(str.substring(0, SplitUtil.split_type2child_length.get(schema.table_type)));
                calendar.add(2, 1);
                continue;
            }
            result.add(str.substring(0, SplitUtil.split_type2child_length.get(schema.table_type)));
            calendar.add(1, 1);
        }
        return result;
    }

    private static List<String> get_splits(ZillionTableSchema schema, List<String> child_nameList, List<JSONObject> CriteriaList) throws MyException {
        String suffix;
        ArrayList<String> child_nameNeed = new ArrayList<String>();
        if (schema.table_type.equals("split_hour")) {
            suffix = "0000";
        } else if (schema.table_type.equals("split_day")) {
            suffix = "000000";
        } else if (schema.table_type.equals("split_month")) {
            suffix = "01000000";
        } else if (schema.table_type.equals("split_year")) {
            suffix = "0101000000";
        } else {
            throw new MyException("get_splits error table_type:" + schema.table_type);
        }
        for (JSONObject CriteriaInner : CriteriaList) {
            if (CriteriaInner.containsKey((Object)schema.split_column)) {
                String split_value;
                Object split_valueObject = CriteriaInner.get((Object)schema.split_column);
                if (split_valueObject == null) {
                    throw new MyException("ZillionAgent: split_column:" + schema.split_column + " can't be null");
                }
                if (split_valueObject instanceof String) {
                    split_value = (String)split_valueObject;
                    String child_name = split_value.substring(0, SplitUtil.split_type2child_length.get(schema.table_type));
                    ListUtil.Merge(child_nameNeed, child_name);
                    continue;
                }
                if (split_valueObject instanceof JSONObject) {
                    String month;
                    int i;
                    int child_length;
                    String child_name;
                    String value;
                    split_value = (JSONObject)split_valueObject;
                    ArrayList<String> child_nameListInner = new ArrayList<String>();
                    child_nameListInner.addAll(child_nameList);
                    if (split_value.containsKey((Object)"$gt")) {
                        child_name = value = (String)split_value.get((Object)"$gt");
                        child_length = SplitUtil.split_type2child_length.get(schema.table_type);
                        if (value.length() > child_length) {
                            child_name = value.substring(0, child_length);
                        }
                        i = child_nameListInner.size() - 1;
                        while (i >= 0) {
                            month = (String)child_nameListInner.get(i);
                            if (month.compareTo(child_name) < 0) {
                                child_nameListInner.remove(i);
                            }
                            --i;
                        }
                    }
                    if (split_value.containsKey((Object)"$gte")) {
                        child_name = value = (String)split_value.get((Object)"$gte");
                        child_length = SplitUtil.split_type2child_length.get(schema.table_type);
                        if (value.length() > child_length) {
                            child_name = value.substring(0, child_length);
                        }
                        i = child_nameListInner.size() - 1;
                        while (i >= 0) {
                            month = (String)child_nameListInner.get(i);
                            if (month.compareTo(child_name) < 0) {
                                child_nameListInner.remove(i);
                            }
                            --i;
                        }
                    }
                    if (split_value.containsKey((Object)"$lt")) {
                        value = (String)split_value.get((Object)"$lt");
                        int i2 = child_nameListInner.size() - 1;
                        while (i2 >= 0) {
                            String child_name2 = (String)child_nameListInner.get(i2);
                            if ((String.valueOf(child_name2) + suffix).compareTo(value) >= 0) {
                                child_nameListInner.remove(i2);
                            }
                            --i2;
                        }
                    }
                    if (split_value.containsKey((Object)"$lte")) {
                        value = (String)split_value.get((Object)"$lte");
                        int i3 = child_nameListInner.size() - 1;
                        while (i3 >= 0) {
                            String child_name3 = (String)child_nameListInner.get(i3);
                            if ((String.valueOf(child_name3) + suffix).compareTo(value) > 0) {
                                child_nameListInner.remove(i3);
                            }
                            --i3;
                        }
                    }
                    ListUtil.MergeList(child_nameNeed, child_nameListInner);
                    continue;
                }
                throw new MyException("ZillionAgent: split_column:" + schema.split_column + " can't be " + split_valueObject.getClass().getName());
            }
            ListUtil.MergeList(child_nameNeed, child_nameList);
            break;
        }
        Collections.sort(child_nameNeed);
        return child_nameNeed;
    }

    public static List<SchemaWrapper> getSchemaWrapperList(SchemaRepositoryContainer container, ZillionTableSchema schema, String query_month, boolean create_split_table, List<JSONObject> CriteriaList, boolean has_data, boolean has_index, String index_name) throws Exception {
        ArrayList<SchemaWrapper> schemaWrapperList = new ArrayList<SchemaWrapper>();
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            if (query_month != null) {
                SchemaWrapper schemaWrapper;
                ITableWrapper dataWrapper = null;
                if (has_data) {
                    dataWrapper = schema.connect(container, query_month, create_split_table);
                }
                ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
                if (has_index) {
                    int i = 0;
                    while (i < schema.Indexes.size()) {
                        ZillionTableIndex index = schema.Indexes.get(i);
                        ITableWrapper indexWrapper = index_name == null || index.index_name.equals(index_name) ? index.connect(container, query_month, create_split_table) : null;
                        wrapperIndexs.add(indexWrapper);
                        ++i;
                    }
                }
                if ((schemaWrapper = new SchemaWrapper(query_month, dataWrapper, wrapperIndexs)).valid()) {
                    schemaWrapperList.add(schemaWrapper);
                }
            } else {
                String zkpath_namespace = "/zillion/ns/" + schema.Namespace;
                List<String> child_nameList = container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false);
                List<String> child_nameNeed = ZillionQueryUtil.get_splits(schema, child_nameList, CriteriaList);
                for (String child_name : child_nameNeed) {
                    SchemaWrapper schemaWrapper;
                    ITableWrapper dataWrapper = null;
                    if (has_data) {
                        dataWrapper = schema.connect(container, child_name, create_split_table);
                    }
                    ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
                    if (has_index) {
                        int i = 0;
                        while (i < schema.Indexes.size()) {
                            ZillionTableIndex index = schema.Indexes.get(i);
                            ITableWrapper indexWrapper = index_name == null || index.index_name.equals(index_name) ? index.connect(container, child_name, create_split_table) : null;
                            wrapperIndexs.add(indexWrapper);
                            ++i;
                        }
                    }
                    if (!(schemaWrapper = new SchemaWrapper(child_name, dataWrapper, wrapperIndexs)).valid()) continue;
                    schemaWrapperList.add(schemaWrapper);
                }
            }
        } else {
            SchemaWrapper schemaWrapper;
            ITableWrapper dataWrapper = null;
            if (has_data) {
                dataWrapper = schema.connect(container, null, false);
            }
            ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
            if (has_index) {
                int i = 0;
                while (i < schema.Indexes.size()) {
                    ZillionTableIndex index = schema.Indexes.get(i);
                    ITableWrapper indexWrapper = index_name == null || index.index_name.equals(index_name) ? index.connect(container, null, false) : null;
                    wrapperIndexs.add(indexWrapper);
                    ++i;
                }
            }
            if ((schemaWrapper = new SchemaWrapper(null, dataWrapper, wrapperIndexs)).valid()) {
                schemaWrapperList.add(schemaWrapper);
            }
        }
        return schemaWrapperList;
    }

    public static Set<Object> parse_set(SchemaRepositoryContainer container, Object inObject) throws Exception {
        if (inObject instanceof JSONObject) {
            JSONObject inObjectJSON = (JSONObject)inObject;
            if (inObjectJSON.containsKey((Object)"QueryType")) {
                JSONObject queryResultInner = container.agent.Query(inObjectJSON);
                JSONArray valueArray = (JSONArray)queryResultInner.get((Object)"Content");
                Set<Object> result = FastJsonUtil.ValueArray2ValueSet(valueArray);
                return result;
            }
            if (inObjectJSON.containsKey((Object)"SetOperator")) {
                String SetOperator = (String)inObjectJSON.get((Object)"SetOperator");
                if (SetOperator.equals("or") || SetOperator.equals("and")) {
                    ArrayList<Set<Object>> valueSetList = new ArrayList<Set<Object>>();
                    JSONArray SetArray = (JSONArray)inObjectJSON.get((Object)"SetArray");
                    int i = 0;
                    while (i < SetArray.size()) {
                        Object SetArrayItem = SetArray.get(i);
                        Set<Object> innerSet = ZillionQueryUtil.parse_set(container, SetArrayItem);
                        valueSetList.add(innerSet);
                        ++i;
                    }
                    if (SetOperator.equals("or")) {
                        Set<Object> result = FastJsonUtil.ValueSet_or(valueSetList);
                        return result;
                    }
                    Set<Object> result = FastJsonUtil.ValueSet_and(valueSetList);
                    return result;
                }
                if (SetOperator.equals("sub")) {
                    Set<Object> innerSet1 = ZillionQueryUtil.parse_set(container, inObjectJSON.get((Object)"Set1"));
                    Set<Object> innerSet2 = ZillionQueryUtil.parse_set(container, inObjectJSON.get((Object)"Set2"));
                    Set<Object> result = FastJsonUtil.ValueSet_sub(innerSet1, innerSet2);
                    return result;
                }
                throw new MyException("SetOperator cant be " + SetOperator);
            }
            throw new MyException("QueryType or SetOperator not exist");
        }
        if (inObject instanceof JSONArray) {
            JSONArray inObjectArray = (JSONArray)inObject;
            Set<Object> valueSet = FastJsonUtil.ValueArray2ValueSet(inObjectArray);
            return valueSet;
        }
        throw new MyException("seperate_in: " + inObject);
    }

    private static List<JSONObject> seperate_in(SchemaRepositoryContainer container, JSONObject Criteria) throws Exception {
        JSONArray valueArray;
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        ArrayList<String> inColumnList = new ArrayList<String>();
        ArrayList<JSONArray> inValueArrayList = new ArrayList<JSONArray>();
        int zuhe = 1;
        for (String key : Criteria.keySet()) {
            JSONObject valueJSON;
            Object value = Criteria.get((Object)key);
            if (value == null || !(value instanceof JSONObject) || !(valueJSON = (JSONObject)value).containsKey((Object)"in")) continue;
            Object inObject = valueJSON.get((Object)"in");
            Set<Object> valueSet = ZillionQueryUtil.parse_set(container, inObject);
            valueArray = FastJsonUtil.ValueSet2ValueArray(valueSet);
            inColumnList.add(key);
            inValueArrayList.add(valueArray);
            zuhe *= valueArray.size();
        }
        if (inColumnList.size() == 0) {
            result.add(Criteria);
        } else {
            int index_zuhe = 0;
            while (index_zuhe < zuhe) {
                int tmp = index_zuhe;
                int[] indexArray = new int[inColumnList.size()];
                int ii = 0;
                while (ii < inColumnList.size()) {
                    JSONArray valueArray2 = (JSONArray)inValueArrayList.get(ii);
                    indexArray[ii] = tmp % valueArray2.size();
                    tmp /= valueArray2.size();
                    ++ii;
                }
                JSONObject CriteriaInner = new JSONObject();
                int ii2 = 0;
                while (ii2 < inColumnList.size()) {
                    String column = (String)inColumnList.get(ii2);
                    valueArray = (JSONArray)inValueArrayList.get(ii2);
                    CriteriaInner.put(column, valueArray.get(indexArray[ii2]));
                    ++ii2;
                }
                for (String key : Criteria.keySet()) {
                    Object value = Criteria.get((Object)key);
                    boolean exist = false;
                    for (String inColumn : inColumnList) {
                        if (!inColumn.equals(key)) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    CriteriaInner.put(key, value);
                }
                result.add(CriteriaInner);
                ++index_zuhe;
            }
        }
        return result;
    }

    public static ZillionQueryResult query(SchemaRepositoryContainer container, ZillionTableSchema schema, String query_month, String QueryType, JSONArray ReturnColumns, JSONObject Criteria, JSONArray Criterias, JSONArray SecondCriteria2, JSONArray OrderBy, JSONObject Limit, JSONObject Set2, String ExportZip, AsyncJob job) throws Exception {
        boolean update_check = true;
        if (update_check && QueryType.equals("update") && (schema.table_name.equals("work_order") || schema.table_name.equals("table_index_data"))) {
            String uuid = UUID.randomUUID().toString();
            AsyncJob jobInner = new AsyncJob(uuid, null);
            LogUtil.warn("update_check_sql:" + schema.table_name + (query_month == null ? "" : "_" + query_month) + "\n" + "Criteria:" + (Criteria != null ? FastJsonUtil.toFormatString(Criteria) : FastJsonUtil.toFormatString(Criterias)) + "\n" + "Set:" + FastJsonUtil.toFormatString(Set2));
            ZillionQueryResult resultInner = ZillionQueryUtil.query(container, schema, query_month, "select", null, null, Criteria, Criterias, SecondCriteria2, null, null, null, null, jobInner);
            LogUtil.warn("update_check_old:" + resultInner.content.size() + "\t" + FastJsonUtil.toFormatString(resultInner.content));
        }
        ZillionQueryResult result = ZillionQueryUtil.query(container, schema, query_month, QueryType, null, ReturnColumns, Criteria, Criterias, SecondCriteria2, OrderBy, Limit, Set2, ExportZip, job);
        if (update_check && QueryType.equals("update") && (schema.table_name.equals("work_order") || schema.table_name.equals("table_index_data"))) {
            String uuid = UUID.randomUUID().toString();
            AsyncJob jobInner = new AsyncJob(uuid, null);
            ZillionQueryResult resultInner = ZillionQueryUtil.query(container, schema, query_month, "select", null, null, Criteria, Criterias, SecondCriteria2, null, null, null, null, jobInner);
            LogUtil.warn("update_check_new:" + resultInner.content.size() + "\t" + FastJsonUtil.toFormatString(resultInner.content));
            boolean match = true;
            int i = 0;
            while (i < resultInner.content.size()) {
                JSONObject item = (JSONObject)resultInner.content.get(i);
                if (!FastJsonCompareUtil.Instance().Contain(item, Set2)) {
                    match = false;
                    break;
                }
                ++i;
            }
            LogUtil.warn("update_check_result:" + match);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static ZillionQueryResult query(SchemaRepositoryContainer container, ZillionTableSchema schema, String query_month, String QueryType, String UniqueReturnColumn, JSONArray ReturnColumns, JSONObject Criteria, JSONArray Criterias, JSONArray SecondCriteria, JSONArray OrderBy, JSONObject Limit, JSONObject Set, String ExportZip, AsyncJob job) throws Exception {
        if (ZillionConstant.check_query) {
            if (Criteria != null) {
                ZillionQueryCheckUtil.CheckCriteria(schema, Criteria);
            } else {
                i = 0;
                while (i < Criterias.size()) {
                    CriteriaInner = (JSONObject)Criterias.get(i);
                    ZillionQueryCheckUtil.CheckCriteria(schema, CriteriaInner);
                    ++i;
                }
            }
        }
        if (QueryType.equals("update")) {
            contain_key = false;
            key_sb = new StringBuffer();
            for (String column : Set.keySet()) {
                if (!schema.KeyMap.containsKey(column)) continue;
                contain_key = true;
                if (key_sb.length() > 0) {
                    key_sb.append(" ");
                }
                key_sb.append(column);
            }
            if (contain_key) {
                throw new MyException("ZillionQueryCheck: you can't update key:" + key_sb.toString());
            }
            if (ZillionConstant.check_query) {
                ZillionQueryCheckUtil.CheckSet(schema, Set);
            }
        }
        CriteriaList = new ArrayList<JSONObject>();
        if (Criteria != null) {
            CriteriaList.addAll(ZillionQueryUtil.seperate_in(container, Criteria));
        } else {
            i = 0;
            while (i < Criterias.size()) {
                CriteriaInner = (JSONObject)Criterias.get(i);
                CriteriaList.addAll(ZillionQueryUtil.seperate_in(container, CriteriaInner));
                ++i;
            }
        }
        scObject = null;
        if (SecondCriteria != null) {
            scObject = new SecondCriteria(container, schema, SecondCriteria);
        }
        matchItemListList = new ArrayList<ArrayList<E>>();
        i = 0;
        while (i < CriteriaList.size()) {
            CriteriaInner = (JSONObject)CriteriaList.get(i);
            matchItemList = new ArrayList<ZillionCriteriaMatchItem>();
            matchItem = ZillionCriteriaMatchUtil.CriteriaMatch(schema, schema.Key, CriteriaInner);
            if (matchItem != null) {
                matchItem.index_index = -1;
                matchItemList.add(matchItem);
            }
            ii = 0;
            while (ii < schema.Indexes.size()) {
                index_schema = schema.Indexes.get(ii);
                matchItem = ZillionCriteriaMatchUtil.CriteriaMatch(schema, index_schema.Key, CriteriaInner);
                if (matchItem != null) {
                    matchItem.index_index = ii;
                    matchItemList.add(matchItem);
                }
                ++ii;
            }
            if (matchItemList.size() == 0) {
                throw new MyException("ZillionAgent: Criteria error \n" + FastJsonUtil.toFormatString(CriteriaInner));
            }
            matchItemListList.add(matchItemList);
            ++i;
        }
        groupList = new ArrayList<ZillionCriteriaGroup>();
        matchItemUsed = new boolean[matchItemListList.size()];
        i = 0;
        while (i < CriteriaList.size()) {
            matchItemUsed[i] = false;
            ++i;
        }
        while (true) {
            best_matchItem = null;
            best_i = -1;
            i = 0;
            while (i < CriteriaList.size()) {
                if (!matchItemUsed[i]) {
                    matchItemList = (List)matchItemListList.get(i);
                    ii = 0;
                    while (ii < matchItemList.size()) {
                        matchItem = (ZillionCriteriaMatchItem)matchItemList.get(ii);
                        if (best_matchItem == null || best_matchItem.matched < matchItem.matched) {
                            best_matchItem = matchItem;
                            best_i = i;
                        }
                        ++ii;
                    }
                }
                ++i;
            }
            if (best_matchItem == null) break;
            group = new ZillionCriteriaGroup();
            group.index_index = best_matchItem.index_index;
            group.CriteriaList.add((JSONObject)CriteriaList.get(best_i));
            group.itemListOfGroup.add(best_matchItem);
            group.rangeList_old.add(new MultiRowRangeFilter.RowRange(best_matchItem.bytes_gt, best_matchItem.bytes_gt_include, best_matchItem.bytes_lt, best_matchItem.bytes_lt_include));
            group.otherCriteria = best_matchItem.otherCriteria;
            group.valueFilterList = best_matchItem.valueFilterList;
            group.scObject = scObject;
            matchItemUsed[best_i] = true;
            i = 0;
            while (i < CriteriaList.size()) {
                if (!matchItemUsed[i]) {
                    matchItemList = (List)matchItemListList.get(i);
                    ii = 0;
                    while (ii < matchItemList.size()) {
                        matchItem = (ZillionCriteriaMatchItem)matchItemList.get(ii);
                        if (matchItem.index_index == best_matchItem.index_index && FastJsonCompareUtil.Instance().Compare(matchItem.otherCriteria, best_matchItem.otherCriteria)) {
                            group.itemListOfGroup.add(matchItem);
                            matchItemUsed[i] = true;
                            group.CriteriaList.add((JSONObject)CriteriaList.get(i));
                            group.rangeList_old.add(new MultiRowRangeFilter.RowRange(matchItem.bytes_gt, matchItem.bytes_gt_include, matchItem.bytes_lt, matchItem.bytes_lt_include));
                            break;
                        }
                        ++ii;
                    }
                }
                ++i;
            }
            for (MultiRowRangeFilter.RowRange rr_old : group.rangeList_old) {
                index_exist = -1;
                rr_exist = null;
                index_tmp = 0;
                while (index_tmp < group.rangeList_new.size()) {
                    rr_new = group.rangeList_new.get(index_tmp);
                    if (Arrays.equals(rr_new.getStartRow(), rr_old.getStartRow()) && Arrays.equals(rr_new.getStopRow(), rr_old.getStopRow())) {
                        index_exist = index_tmp;
                        rr_exist = rr_new;
                        break;
                    }
                    ++index_tmp;
                }
                if (rr_exist != null) {
                    startRowInclusive = rr_exist.isStartRowInclusive() != false || rr_old.isStartRowInclusive() != false;
                    v0 = stopRowInclusive = rr_exist.isStopRowInclusive() != false || rr_old.isStopRowInclusive() != false;
                    if (startRowInclusive == rr_exist.isStartRowInclusive() && stopRowInclusive == rr_exist.isStopRowInclusive()) continue;
                    group.rangeList_new.remove(index_exist);
                    group.rangeList_new.add(new MultiRowRangeFilter.RowRange(rr_exist.getStartRow(), startRowInclusive, rr_exist.getStopRow(), stopRowInclusive));
                    continue;
                }
                group.rangeList_new.add(rr_old);
            }
            groupList.add(group);
            if (!ZillionConstant.printCriteriaGroup) continue;
            ZillionQueryUtil.print(schema, group);
        }
        Final_Limit_Skip = 0L;
        Final_Limit_Count = 0x7FFFFFFFL;
        Limit_Skip = 0L;
        Limit_Count = 0x7FFFFFFFL;
        if (QueryType.equals("select") && Limit != null) {
            Skip_tmp = FastJsonUtil.getLong(Limit, "Skip");
            Count_tmp = FastJsonUtil.getLong(Limit, "Count");
            if (Skip_tmp != null) {
                Final_Limit_Skip = Skip_tmp;
            }
            if (Count_tmp != null) {
                Final_Limit_Count = Count_tmp;
            }
        }
        OrderByReal = null;
        SortAsc = true;
        if (!QueryType.equals("select")) {
            SortInDB = false;
        } else if (groupList.size() > 1) {
            SortInDB = false;
        } else if (OrderBy == null || OrderBy.size() == 0) {
            SortInDB = true;
        } else {
            group = (ZillionCriteriaGroup)groupList.get(0);
            keys = group.index_index == -1 ? schema.Key : schema.Indexes.get((int)group.index_index).Key;
            splits = new ArrayList<String>();
            if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                if (query_month == null) {
                    all_splits = ZillionQueryUtil.get_all_splits(schema);
                    splits = ZillionQueryUtil.get_splits(schema, all_splits, group.CriteriaList);
                } else {
                    splits.add(query_month);
                }
            }
            max_equal_small = 0;
            criteriaInner = group.CriteriaList.get(0);
            index_key = 0;
            while (index_key < keys.length) {
                keyItem = keys[index_key];
                if (!criteriaInner.containsKey((Object)keyItem) || (value = criteriaInner.get((Object)keyItem)) != null && (value instanceof JSONObject || value instanceof JSONArray)) break;
                max_equal_small = index_key + 1;
                ++index_key;
            }
            if (schema.table_type != null && schema.table_type.startsWith("split_") && splits.size() > 1) {
                if (group.CriteriaList.size() > 1) {
                    SortInDB = false;
                } else {
                    index_split = -1;
                    index_key = 0;
                    while (index_key < keys.length) {
                        keyItem = keys[index_key];
                        if (keyItem.equals(schema.split_column)) {
                            index_split = index_key;
                            break;
                        }
                        ++index_key;
                    }
                    if (max_equal_small < index_split) {
                        SortInDB = false;
                    } else {
                        OrderBy_tmp = new JSONArray();
                        if (!ZillionOrderByUtil.Match(keys, max_equal_small, OrderBy, OrderBy_tmp)) {
                            SortInDB = false;
                        } else {
                            SortInDB = true;
                            OrderByReal = OrderBy_tmp;
                        }
                    }
                }
            } else if (group.CriteriaList.size() > 1) {
                SortInDB = !ZillionOrderByUtil.Match(keys, OrderBy) ? Boolean.valueOf(false) : (!(AscTmp = ((Boolean)(item0 = (JSONObject)OrderBy.get(0)).get((Object)"Asc")).booleanValue()) ? Boolean.valueOf(false) : Boolean.valueOf(true));
            } else {
                OrderBy_tmp = new JSONArray();
                if (!ZillionOrderByUtil.Match(keys, max_equal_small, OrderBy, OrderBy_tmp)) {
                    SortInDB = false;
                } else {
                    SortInDB = true;
                    OrderByReal = OrderBy_tmp;
                }
            }
        }
        if (SortInDB.booleanValue()) {
            if (OrderByReal != null && OrderByReal.size() > 0) {
                item0 = (JSONObject)OrderByReal.get(0);
                SortAsc = (Boolean)item0.get((Object)"Asc");
            }
            Limit_Skip = Final_Limit_Skip;
            Limit_Count = Final_Limit_Count;
        }
        if (ZillionConstant.printCriteriaGroup) {
            LogUtil.warn("SortInDB:" + schema.Namespace + " " + schema.table_name + (query_month != null ? "_" + query_month : "") + "\n" + (Criteria != null ? FastJsonUtil.toString(Criteria) : FastJsonUtil.toString(Criterias)) + "\n" + (OrderBy != null ? FastJsonUtil.toString(OrderBy) : "") + "\n" + "SortInDB:" + SortInDB + "\n" + "SortAsc:" + SortAsc);
        }
        if (QueryType.equals("select_count") || QueryType.equals("update") || QueryType.equals("delete") || QueryType.equals("export")) {
            if (groupList.size() > 1) {
                throw new MyException("ZillionAgent: " + QueryType + " group can't be " + groupList.size());
            }
        } else if (QueryType.equals("select") && job.brs != null) {
            if (groupList.size() > 1) {
                throw new MyException("ZillionAgent: " + QueryType + " buffered group can't be " + groupList.size());
            }
            if (!SortInDB.booleanValue()) {
                throw new MyException("ZillionAgent: " + QueryType + " buffered group can't order by in memory");
            }
        }
        result = new ZillionQueryResult();
        content = new JSONArray();
        out = null;
        if (QueryType.equals("export")) {
            out = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(ExportZip));
        }
        index_group = 0;
        while (index_group < groupList.size()) {
            group = (ZillionCriteriaGroup)groupList.get(index_group);
            contentOfGroup = new JSONArray();
            if (group.index_index == -1) {
                schemaWrapperList = QueryType.equals("delete") || QueryType.equals("update") ? ZillionQueryUtil.getSchemaWrapperList(container, schema, query_month, false, CriteriaList, true, true, null) : ZillionQueryUtil.getSchemaWrapperList(container, schema, query_month, false, CriteriaList, true, false, null);
            } else {
                schema_index = schema.Indexes.get(group.index_index);
                schemaWrapperList = QueryType.equals("delete") != false || QueryType.equals("update") != false ? ZillionQueryUtil.getSchemaWrapperList(container, schema, query_month, false, CriteriaList, true, true, null) : ZillionQueryUtil.getSchemaWrapperList(container, schema, query_month, false, CriteriaList, false, true, schema_index.index_name);
            }
            if (SortInDB.booleanValue() && !SortAsc) {
                Collections.reverse(schemaWrapperList);
            }
            zqt = new ZillionQueryTmp();
            try {
                try {
                    for (SchemaWrapper schemaWrapper : schemaWrapperList) {
                        container.DatabaseImpl.scan(container, schema, schemaWrapper, ReturnColumns, group, QueryType, contentOfGroup, zqt, out, job, SortInDB, OrderByReal, Limit_Skip, Limit_Count, result, Set);
                        if (!zqt.scanned_finish) continue;
                    }
                }
                catch (Exception exp) {
                    ZillionQueryUtil.print(schema, group);
                    throw exp;
                }
            }
            finally {
                ** for (schemaWrapper : schemaWrapperList)
            }
lbl-1000:
            // 1 sources

            {
                schemaWrapper.unuse();
                continue;
            }
lbl275:
            // 1 sources

            if (QueryType.equals("export")) {
                out.finish();
                out.close();
            }
            if (QueryType.equals("select")) {
                if (groupList.size() == 1) {
                    content = contentOfGroup;
                } else {
                    ii = 0;
                    while (ii < contentOfGroup.size()) {
                        item = (JSONObject)contentOfGroup.get(ii);
                        if (!FastJsonCompareUtil.Instance().Contain(content, item, schema.Key)) {
                            content.add((Object)item);
                        }
                        ++ii;
                    }
                }
            }
            ++index_group;
        }
        if (QueryType.equals("select")) {
            if (!SortInDB.booleanValue() && OrderBy != null && OrderBy.size() > 0) {
                contentList = new ArrayList<JSONObject>();
                index_ = 0;
                while (index_ < content.size()) {
                    contentList.add((JSONObject)content.get(index_));
                    ++index_;
                }
                Collections.sort(contentList, new JSONObjectComparator(OrderBy));
                content_all = new JSONArray();
                index_ = (int)Limit_Skip;
                while (index_ < contentList.size() && (long)index_ < Limit_Skip + Limit_Count) {
                    content_all.add(contentList.get(index_));
                    ++index_;
                }
                content = new JSONArray();
                index_ = (int)Final_Limit_Skip;
                while (index_ < content_all.size() && index_ < (int)(Final_Limit_Skip + Final_Limit_Count)) {
                    content.add(content_all.get(index_));
                    ++index_;
                }
            }
            content = ZillionQueryUtil.cut(content, UniqueReturnColumn, ReturnColumns);
            if (job.brs != null) {
                job.brs.Finish(true, null);
            }
        }
        result.content = content;
        if (QueryType.equals("select")) {
            result.count = result.content.size();
        }
        return result;
    }

    public static JSONArray cut(JSONArray content, String UniqueReturnColumn, JSONArray ReturnColumns) {
        JSONArray result = content;
        if (UniqueReturnColumn != null) {
            JSONArray content_cut = new JSONArray();
            int index_ = 0;
            while (index_ < content.size()) {
                JSONObject contentItem = (JSONObject)content.get(index_);
                content_cut.add(contentItem.get((Object)UniqueReturnColumn));
                ++index_;
            }
            result = content_cut;
        } else if (ReturnColumns != null) {
            JSONArray content_cut = new JSONArray();
            int index_ = 0;
            while (index_ < content.size()) {
                JSONObject contentItem = (JSONObject)content.get(index_);
                JSONObject tmpObject = new JSONObject();
                int index_rc = 0;
                while (index_rc < ReturnColumns.size()) {
                    String rc_name = (String)ReturnColumns.get(index_rc);
                    if (contentItem.containsKey((Object)rc_name)) {
                        tmpObject.put(rc_name, contentItem.get((Object)rc_name));
                    }
                    ++index_rc;
                }
                content_cut.add((Object)tmpObject);
                ++index_;
            }
            result = content_cut;
        }
        return result;
    }

    public static void batch_put_insert(SchemaRepositoryContainer container, ZillionTableSchema schema, JSONArray InsertObjects, boolean is_put) throws Exception {
        if (ZillionConstant.check_query) {
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                ZillionQueryCheckUtil.CheckInsert(schema, InsertObject);
                ++i;
            }
        }
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            HashMap<String, JSONArray> InsertObjectsMap = new HashMap<String, JSONArray>();
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                String split_value = (String)InsertObject.get((Object)schema.split_column);
                String child_name = split_value.substring(0, SplitUtil.split_type2child_length.get(schema.table_type));
                if (!InsertObjectsMap.containsKey(child_name)) {
                    InsertObjectsMap.put(child_name, new JSONArray());
                }
                ((JSONArray)InsertObjectsMap.get(child_name)).add((Object)InsertObject);
                ++i;
            }
            Object[] child_nameArray = InsertObjectsMap.keySet().toArray(new String[0]);
            Arrays.sort(child_nameArray);
            Object[] objectArray = child_nameArray;
            int child_name = child_nameArray.length;
            int split_value = 0;
            while (split_value < child_name) {
                Object child_name2 = objectArray[split_value];
                JSONArray InsertObjectsInner = (JSONArray)InsertObjectsMap.get(child_name2);
                ITableWrapper dataWrapper = schema.connect(container, (String)child_name2, true);
                ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
                int i2 = 0;
                while (i2 < schema.Indexes.size()) {
                    ZillionTableIndex index = schema.Indexes.get(i2);
                    ITableWrapper indexWrapper = index.connect(container, (String)child_name2, true);
                    wrapperIndexs.add(indexWrapper);
                    ++i2;
                }
                SchemaWrapper schemaWrapper = new SchemaWrapper((String)child_name2, dataWrapper, wrapperIndexs);
                try {
                    container.DatabaseImpl.batch_process(schema, schemaWrapper, "insert", InsertObjectsInner, null, is_put);
                }
                finally {
                    schemaWrapper.unuse();
                }
                ++split_value;
            }
        } else {
            ITableWrapper dataWrapper = schema.connect(container, null, false);
            ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
            int i = 0;
            while (i < schema.Indexes.size()) {
                ZillionTableIndex index = schema.Indexes.get(i);
                ITableWrapper indexWrapper = index.connect(container, null, false);
                wrapperIndexs.add(indexWrapper);
                ++i;
            }
            SchemaWrapper schemaWrapper = new SchemaWrapper(null, dataWrapper, wrapperIndexs);
            try {
                container.DatabaseImpl.batch_process(schema, schemaWrapper, "insert", InsertObjects, null, is_put);
            }
            finally {
                schemaWrapper.unuse();
            }
        }
    }

    private static String toSQLString(String columnName, Object columnCondition) {
        StringBuffer sbInner = new StringBuffer();
        if (columnCondition instanceof JSONObject) {
            JSONObject columnRangeJSON = (JSONObject)columnCondition;
            if (columnRangeJSON.containsKey((Object)"$regex")) {
                String regex = (String)columnRangeJSON.get((Object)"$regex");
                sbInner.append(String.valueOf(columnName) + " like " + "\"" + regex + "\"");
            } else {
                for (String fuhao : columnRangeJSON.keySet()) {
                    Object columnObject = columnRangeJSON.get((Object)fuhao);
                    if (sbInner.length() > 0) {
                        sbInner.append(" and ");
                    }
                    if (fuhao.equals("$lt")) {
                        sbInner.append(String.valueOf(columnName) + "<" + columnObject);
                        continue;
                    }
                    if (fuhao.equals("$lte")) {
                        sbInner.append(String.valueOf(columnName) + "<=" + columnObject);
                        continue;
                    }
                    if (fuhao.equals("$gt")) {
                        sbInner.append(String.valueOf(columnName) + ">" + columnObject);
                        continue;
                    }
                    if (!fuhao.equals("$gte")) continue;
                    sbInner.append(String.valueOf(columnName) + ">=" + columnObject);
                }
            }
        } else {
            if (sbInner.length() > 0) {
                sbInner.append(" and ");
            }
            sbInner.append(String.valueOf(columnName) + "=" + columnCondition);
        }
        return sbInner.toString();
    }

    public static void batch_remove(SchemaRepositoryContainer container, ZillionTableSchema schema, JSONArray InsertObjects) throws Exception {
        if (ZillionConstant.check_query) {
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                ZillionQueryCheckUtil.CheckKey(schema, InsertObject);
                ++i;
            }
        }
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            HashMap<String, JSONArray> InsertObjectsMap = new HashMap<String, JSONArray>();
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                String split_value = (String)InsertObject.get((Object)schema.split_column);
                String child_name = split_value.substring(0, SplitUtil.split_type2child_length.get(schema.table_type));
                if (!InsertObjectsMap.containsKey(child_name)) {
                    InsertObjectsMap.put(child_name, new JSONArray());
                }
                ((JSONArray)InsertObjectsMap.get(child_name)).add((Object)InsertObject);
                ++i;
            }
            Object[] child_nameArray = InsertObjectsMap.keySet().toArray(new String[0]);
            Arrays.sort(child_nameArray);
            Object[] objectArray = child_nameArray;
            int child_name = child_nameArray.length;
            int split_value = 0;
            while (split_value < child_name) {
                Object child_name2 = objectArray[split_value];
                JSONArray InsertObjectsInner = (JSONArray)InsertObjectsMap.get(child_name2);
                ITableWrapper dataWrapper = schema.connect(container, (String)child_name2, false);
                if (dataWrapper != null) {
                    ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
                    int i2 = 0;
                    while (i2 < schema.Indexes.size()) {
                        ZillionTableIndex index = schema.Indexes.get(i2);
                        ITableWrapper indexWrapper = index.connect(container, (String)child_name2, false);
                        wrapperIndexs.add(indexWrapper);
                        ++i2;
                    }
                    SchemaWrapper schemaWrapper = new SchemaWrapper((String)child_name2, dataWrapper, wrapperIndexs);
                    try {
                        container.DatabaseImpl.batch_process(schema, schemaWrapper, "delete", InsertObjectsInner, null, false);
                    }
                    finally {
                        schemaWrapper.unuse();
                    }
                }
                ++split_value;
            }
        } else {
            ITableWrapper dataWrapper = schema.connect(container, null, false);
            ArrayList<ITableWrapper> wrapperIndexs = new ArrayList<ITableWrapper>();
            int i = 0;
            while (i < schema.Indexes.size()) {
                ZillionTableIndex index = schema.Indexes.get(i);
                ITableWrapper indexWrapper = index.connect(container, null, false);
                wrapperIndexs.add(indexWrapper);
                ++i;
            }
            SchemaWrapper schemaWrapper = new SchemaWrapper(null, dataWrapper, wrapperIndexs);
            try {
                container.DatabaseImpl.batch_process(schema, schemaWrapper, "delete", InsertObjects, null, false);
            }
            finally {
                schemaWrapper.unuse();
            }
        }
    }

    private static void print(ZillionTableSchema schema, ZillionCriteriaGroup group) {
        String[] keysOfGroup;
        StringBuffer sbKeyAll = new StringBuffer();
        if (group.index_index == -1) {
            keysOfGroup = schema.Key;
            sbKeyAll.append("Key");
        } else {
            ZillionTableIndex schema_index = schema.Indexes.get(group.index_index);
            keysOfGroup = schema_index.Key;
            sbKeyAll.append(schema_index.index_name);
        }
        StringBuffer sbKey = new StringBuffer();
        String[] stringArray = keysOfGroup;
        int n = keysOfGroup.length;
        int n2 = 0;
        while (n2 < n) {
            String keyOfGroup = stringArray[n2];
            if (sbKey.length() > 0) {
                sbKey.append(",");
            }
            sbKey.append(keyOfGroup);
            ++n2;
        }
        sbKeyAll.append("[" + sbKey.toString() + "]");
        StringBuffer sbKeyCondition = new StringBuffer();
        int i = 0;
        while (i < group.itemListOfGroup.size()) {
            ZillionCriteriaMatchItem itemInner = group.itemListOfGroup.get(i);
            StringBuffer sbInner = new StringBuffer();
            int ii = 0;
            while (ii < itemInner.matched) {
                String columnName = keysOfGroup[ii];
                Object columnCondition = group.CriteriaList.get(i).get((Object)columnName);
                String SQLString = ZillionQueryUtil.toSQLString(columnName, columnCondition);
                if (sbInner.length() > 0) {
                    sbInner.append(" and ");
                }
                sbInner.append(SQLString);
                ++ii;
            }
            if (sbKeyCondition.length() > 0) {
                sbKeyCondition.append(" or ");
            }
            sbKeyCondition.append("(" + sbInner.toString() + ")");
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select from `" + schema.Namespace + "." + schema.table_name + "`");
        sb.append(" use " + sbKeyAll.toString());
        sb.append(" where ");
        if (group.otherCriteria.size() > 0) {
            sb.append("(" + sbKeyCondition.toString() + ")");
            for (String otherKey : group.otherCriteria.keySet()) {
                Object otherValue = group.otherCriteria.get((Object)otherKey);
                String SQLString = ZillionQueryUtil.toSQLString(otherKey, otherValue);
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append(SQLString);
            }
        } else {
            sb.append(sbKeyCondition.toString());
        }
        LogUtil.warn(sb.toString());
        StringBuffer sbKeyCondition_json = new StringBuffer();
        for (JSONObject condition : group.CriteriaList) {
            if (sbKeyCondition_json.length() > 0) {
                sbKeyCondition_json.append(",");
            }
            sbKeyCondition_json.append(FastJsonUtil.toFormatString(condition));
        }
        LogUtil.warn("Key Condition:" + sbKeyCondition_json.toString());
        if (group.otherCriteria != null) {
            StringBuffer sbOtherCondition_json = new StringBuffer();
            sbOtherCondition_json.append(FastJsonUtil.toFormatString(group.otherCriteria));
            LogUtil.warn("Other Condition:" + sbOtherCondition_json.toString());
        }
    }
}

