/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorPersistentStoreConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String persistenceStorePath;
    private long checkpointingFreq;
    private long lockWaitTime;
    private long checkpointingPageBufSize;
    private int checkpointingThreads;
    private int walHistSize;
    private int walSegments;
    private int walSegmentSize;
    private String walStorePath;
    private String walArchivePath;
    private boolean metricsEnabled;
    private WALMode walMode;
    private int tlbSize;
    private long walFlushFreq;
    private long walFsyncDelay;
    private int walRecordIterBuffSize;
    private boolean alwaysWriteFullPages;
    private int subIntervals;
    private long rateTimeInterval;

    public VisorPersistentStoreConfiguration() {
    }

    public VisorPersistentStoreConfiguration(DataStorageConfiguration cfg) {
        this.persistenceStorePath = cfg.getStoragePath();
        this.checkpointingFreq = cfg.getCheckpointFrequency();
        this.lockWaitTime = cfg.getLockWaitTime();
        this.checkpointingThreads = cfg.getCheckpointThreads();
        this.walHistSize = cfg.getWalHistorySize();
        this.walSegments = cfg.getWalSegments();
        this.walSegmentSize = cfg.getWalSegmentSize();
        this.walStorePath = cfg.getWalPath();
        this.walArchivePath = cfg.getWalArchivePath();
        this.metricsEnabled = cfg.isMetricsEnabled();
        this.walMode = cfg.getWalMode();
        this.tlbSize = cfg.getWalBufferSize();
        this.walFlushFreq = cfg.getWalFlushFrequency();
        this.walFsyncDelay = cfg.getWalFsyncDelayNanos();
        this.walRecordIterBuffSize = cfg.getWalRecordIteratorBufferSize();
        this.alwaysWriteFullPages = cfg.isAlwaysWriteFullPages();
        this.subIntervals = cfg.getMetricsSubIntervalCount();
        this.rateTimeInterval = cfg.getMetricsRateTimeInterval();
    }

    public String getPersistentStorePath() {
        return this.persistenceStorePath;
    }

    public long getCheckpointingFrequency() {
        return this.checkpointingFreq;
    }

    public long getCheckpointingPageBufferSize() {
        return this.checkpointingPageBufSize;
    }

    public int getCheckpointingThreads() {
        return this.checkpointingThreads;
    }

    public long getLockWaitTime() {
        return this.lockWaitTime;
    }

    public int getWalHistorySize() {
        return this.walHistSize;
    }

    public int getWalSegments() {
        return this.walSegments;
    }

    public int getWalSegmentSize() {
        return this.walSegmentSize;
    }

    public String getWalStorePath() {
        return this.walStorePath;
    }

    public String getWalArchivePath() {
        return this.walArchivePath;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public long getRateTimeInterval() {
        return this.rateTimeInterval;
    }

    public int getSubIntervals() {
        return this.subIntervals;
    }

    public WALMode getWalMode() {
        return this.walMode;
    }

    public int getTlbSize() {
        return this.tlbSize;
    }

    public long getWalFlushFrequency() {
        return this.walFlushFreq;
    }

    public long getWalFsyncDelayNanos() {
        return this.walFsyncDelay;
    }

    public int getWalRecordIteratorBufferSize() {
        return this.walRecordIterBuffSize;
    }

    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.persistenceStorePath);
        out.writeLong(this.checkpointingFreq);
        out.writeLong(this.lockWaitTime);
        out.writeLong(this.checkpointingPageBufSize);
        out.writeInt(this.checkpointingThreads);
        out.writeInt(this.walHistSize);
        out.writeInt(this.walSegments);
        out.writeInt(this.walSegmentSize);
        U.writeString(out, this.walStorePath);
        U.writeString(out, this.walArchivePath);
        out.writeBoolean(this.metricsEnabled);
        U.writeEnum(out, this.walMode);
        out.writeInt(this.tlbSize);
        out.writeLong(this.walFlushFreq);
        out.writeLong(this.walFsyncDelay);
        out.writeInt(this.walRecordIterBuffSize);
        out.writeBoolean(this.alwaysWriteFullPages);
        out.writeInt(this.subIntervals);
        out.writeLong(this.rateTimeInterval);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.persistenceStorePath = U.readString(in);
        this.checkpointingFreq = in.readLong();
        this.lockWaitTime = in.readLong();
        this.checkpointingPageBufSize = in.readLong();
        this.checkpointingThreads = in.readInt();
        this.walHistSize = in.readInt();
        this.walSegments = in.readInt();
        this.walSegmentSize = in.readInt();
        this.walStorePath = U.readString(in);
        this.walArchivePath = U.readString(in);
        this.metricsEnabled = in.readBoolean();
        this.walMode = WALMode.fromOrdinal(in.readByte());
        this.tlbSize = in.readInt();
        this.walFlushFreq = in.readLong();
        this.walFsyncDelay = in.readLong();
        this.walRecordIterBuffSize = in.readInt();
        this.alwaysWriteFullPages = in.readBoolean();
        this.subIntervals = in.readInt();
        this.rateTimeInterval = in.readLong();
    }

    public String toString() {
        return S.toString(VisorPersistentStoreConfiguration.class, this);
    }
}

