/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;

public class StripedCompositeReadWriteLock
implements ReadWriteLock {
    private static final AtomicInteger IDX_GEN = new AtomicInteger();
    private static final ThreadLocal<Integer> IDX = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return IDX_GEN.incrementAndGet();
        }
    };
    private final ReentrantReadWriteLock[] locks;
    private final WriteLock writeLock;

    public StripedCompositeReadWriteLock(int concurrencyLvl) {
        this.locks = new ReadLock[concurrencyLvl];
        for (int i = 0; i < concurrencyLvl; ++i) {
            this.locks[i] = new ReadLock();
        }
        this.writeLock = new WriteLock();
    }

    @Override
    @NotNull
    public Lock readLock() {
        int idx;
        Thread curThread = Thread.currentThread();
        if (curThread instanceof IgniteThread) {
            IgniteThread igniteThread = (IgniteThread)curThread;
            idx = igniteThread.compositeRwLockIndex();
            if (idx == -1) {
                idx = IDX_GEN.incrementAndGet();
                igniteThread.compositeRwLockIndex(idx);
            }
        } else {
            idx = IDX.get();
        }
        return this.locks[idx % this.locks.length].readLock();
    }

    @Override
    @NotNull
    public Lock writeLock() {
        return this.writeLock;
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.locks[this.locks.length - 1].isWriteLockedByCurrentThread();
    }

    private class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            block2: {
                try {
                    this.lock0(false);
                }
                catch (InterruptedException ignore) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)"Should never happen");
                }
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.lock0(true);
        }

        @Override
        public void unlock() {
            this.unlock0(StripedCompositeReadWriteLock.this.locks.length - 1);
        }

        private void lock0(boolean canInterrupt) throws InterruptedException {
            int i;
            try {
                for (i = 0; i < StripedCompositeReadWriteLock.this.locks.length; ++i) {
                    if (canInterrupt) {
                        StripedCompositeReadWriteLock.this.locks[i].writeLock().lockInterruptibly();
                        continue;
                    }
                    StripedCompositeReadWriteLock.this.locks[i].writeLock().lock();
                }
            }
            catch (InterruptedException e) {
                this.unlock0(i - 1);
                throw e;
            }
        }

        private void unlock0(int fromIdx) {
            for (int i = fromIdx; i >= 0; --i) {
                StripedCompositeReadWriteLock.this.locks[i].writeLock().unlock();
            }
        }

        @Override
        public boolean tryLock() {
            int i;
            try {
                for (i = 0; i < StripedCompositeReadWriteLock.this.locks.length; ++i) {
                    if (StripedCompositeReadWriteLock.this.locks[i].writeLock().tryLock()) continue;
                    break;
                }
            }
            finally {
                if (0 < i && i < StripedCompositeReadWriteLock.this.locks.length) {
                    this.unlock0(i - 1);
                }
            }
            return i == StripedCompositeReadWriteLock.this.locks.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            int i;
            long end = unit.toNanos(time) + System.nanoTime();
            try {
                for (i = 0; i < StripedCompositeReadWriteLock.this.locks.length && System.nanoTime() < end; ++i) {
                    if (StripedCompositeReadWriteLock.this.locks[i].writeLock().tryLock(time, unit)) continue;
                    break;
                }
            }
            finally {
                if (0 < i && i < StripedCompositeReadWriteLock.this.locks.length) {
                    this.unlock0(i - 1);
                }
            }
            return i == StripedCompositeReadWriteLock.this.locks.length;
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadLock
    extends ReentrantReadWriteLock {
        private static final long serialVersionUID = 0L;
        private long p0;
        private long p1;
        private long p2;
        private long p3;
        private long p4;
        private long p5;
        private long p6;
        private long p7;

        private ReadLock() {
        }
    }
}

