/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaUpdateTimesProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long accessTime;
    private long modificationTime;

    public IgfsMetaUpdateTimesProcessor() {
    }

    public IgfsMetaUpdateTimesProcessor(long accessTime, long modificationTime) {
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
    }

    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo oldInfo = (IgfsEntryInfo)entry.getValue();
        entry.setValue((Object)oldInfo.accessModificationTime(this.accessTime, this.modificationTime));
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    public String toString() {
        return S.toString(IgfsMetaUpdateTimesProcessor.class, this);
    }
}

