/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.igfs.IgfsCommunicationMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class IgfsSyncMessage
extends IgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private long order;
    private boolean res;

    public IgfsSyncMessage() {
    }

    public IgfsSyncMessage(long order, boolean res) {
        this.order = order;
        this.res = res;
    }

    public long order() {
        return this.order;
    }

    public boolean response() {
        return this.res;
    }

    public String toString() {
        return S.toString(IgfsSyncMessage.class, this);
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("order", this.order)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("res", this.res)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.order = reader.readLong("order");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.res = reader.readBoolean("res");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgfsSyncMessage.class);
    }

    @Override
    public short directType() {
        return 71;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }
}

