/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cacheobject;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectByteArrayImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.apache.ignite.internal.processors.cache.IncompleteCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cacheobject.NoOpBinary;
import org.apache.ignite.internal.processors.cacheobject.UserCacheObjectByteArrayImpl;
import org.apache.ignite.internal.processors.cacheobject.UserCacheObjectImpl;
import org.apache.ignite.internal.processors.cacheobject.UserKeyCacheObjectImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheObjectProcessorImpl
extends GridProcessorAdapter
implements IgniteCacheObjectProcessor {
    private static final Collection<Class<?>> IMMUTABLE_CLS = new HashSet();
    private IgniteBinary noOpBinary = new NoOpBinary();

    public IgniteCacheObjectProcessorImpl(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public IgniteBinary binary() {
        return this.noOpBinary;
    }

    @Override
    @Nullable
    public CacheObject prepareForCache(@Nullable CacheObject obj, GridCacheContext cctx) {
        if (obj == null) {
            return null;
        }
        return obj.prepareForCache(cctx.cacheObjectContext());
    }

    @Override
    public byte[] marshal(CacheObjectValueContext ctx, Object val) throws IgniteCheckedException {
        return CU.marshal(ctx.kernalContext().cache().context(), ctx.addDeploymentInfo(), val);
    }

    @Override
    public Object unmarshal(CacheObjectValueContext ctx, byte[] bytes, ClassLoader clsLdr) throws IgniteCheckedException {
        return U.unmarshal(ctx.kernalContext(), bytes, U.resolveClassLoader(clsLdr, ctx.kernalContext().config()));
    }

    @Override
    public KeyCacheObject toCacheKeyObject(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        if (obj instanceof KeyCacheObject) {
            KeyCacheObject key = (KeyCacheObject)obj;
            if (key.partition() == -1) {
                key.partition(this.partition(ctx, cctx, key));
            }
            return (KeyCacheObject)obj;
        }
        return this.toCacheKeyObject0(ctx, cctx, obj, userObj);
    }

    protected KeyCacheObject toCacheKeyObject0(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj, boolean userObj) {
        int part = this.partition(ctx, cctx, obj);
        if (!userObj) {
            return new KeyCacheObjectImpl(obj, null, part);
        }
        return new UserKeyCacheObjectImpl(obj, part);
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) {
        switch (type) {
            case 2: {
                return new CacheObjectByteArrayImpl(bytes);
            }
            case 1: {
                return new CacheObjectImpl(null, bytes);
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + type);
    }

    @Override
    public KeyCacheObject toKeyCacheObject(CacheObjectContext ctx, byte type, byte[] bytes) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                throw new IllegalArgumentException("Byte arrays cannot be used as cache keys.");
            }
            case 1: {
                return new KeyCacheObjectImpl(ctx.kernalContext().cacheObjects().unmarshal(ctx, bytes, null), bytes, -1);
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + type);
    }

    @Override
    public CacheObject toCacheObject(CacheObjectContext ctx, ByteBuffer buf) {
        int len = buf.getInt();
        assert (len >= 0) : len;
        byte type = buf.get();
        byte[] data = new byte[len];
        buf.get(data);
        return this.toCacheObject(ctx, type, data);
    }

    @Override
    public IncompleteCacheObject toCacheObject(CacheObjectContext ctx, ByteBuffer buf, @Nullable IncompleteCacheObject incompleteObj) throws IgniteCheckedException {
        if (incompleteObj == null) {
            incompleteObj = new IncompleteCacheObject(buf);
        }
        if (incompleteObj.isReady()) {
            return incompleteObj;
        }
        incompleteObj.readData(buf);
        if (incompleteObj.isReady()) {
            incompleteObj.object(this.toCacheObject(ctx, incompleteObj.type(), incompleteObj.data()));
        }
        return incompleteObj;
    }

    @Override
    public IncompleteCacheObject toKeyCacheObject(CacheObjectContext ctx, ByteBuffer buf, @Nullable IncompleteCacheObject incompleteObj) throws IgniteCheckedException {
        if (incompleteObj == null) {
            incompleteObj = new IncompleteCacheObject(buf);
        }
        if (incompleteObj.isReady()) {
            return incompleteObj;
        }
        incompleteObj.readData(buf);
        if (incompleteObj.isReady()) {
            incompleteObj.object(this.toKeyCacheObject(ctx, incompleteObj.type(), incompleteObj.data()));
        }
        return incompleteObj;
    }

    @Override
    @Nullable
    public CacheObject toCacheObject(CacheObjectContext ctx, @Nullable Object obj, boolean userObj) {
        if (obj == null || obj instanceof CacheObject) {
            return (CacheObject)obj;
        }
        return this.toCacheObject0(obj, userObj);
    }

    protected CacheObject toCacheObject0(@Nullable Object obj, boolean userObj) {
        assert (obj != null);
        if (obj instanceof byte[]) {
            if (!userObj) {
                return new CacheObjectByteArrayImpl((byte[])obj);
            }
            return new UserCacheObjectByteArrayImpl((byte[])obj);
        }
        if (!userObj) {
            return new CacheObjectImpl(obj, null);
        }
        return new UserCacheObjectImpl(obj, null);
    }

    protected final int partition(CacheObjectContext ctx, @Nullable GridCacheContext cctx, Object obj) {
        try {
            return cctx != null ? cctx.affinity().partition(obj, false) : ctx.kernalContext().affinity().partition0(ctx.cacheName(), obj, null);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to get partition", e);
            return -1;
        }
    }

    @Override
    public CacheObjectContext contextForCache(CacheConfiguration ccfg) throws IgniteCheckedException {
        assert (ccfg != null);
        boolean storeVal = !ccfg.isCopyOnRead() || !this.isBinaryEnabled(ccfg) && (QueryUtils.isEnabled(ccfg) || this.ctx.config().isPeerClassLoadingEnabled());
        CacheObjectContext res = new CacheObjectContext(this.ctx, ccfg.getName(), ccfg.getAffinityMapper() != null ? ccfg.getAffinityMapper() : new GridCacheDefaultAffinityKeyMapper(), ccfg.isCopyOnRead(), storeVal, this.ctx.config().isPeerClassLoadingEnabled() && !this.isBinaryEnabled(ccfg));
        this.ctx.resource().injectGeneric(res.defaultAffMapper());
        return res;
    }

    @Override
    public boolean immutable(Object obj) {
        assert (obj != null);
        return IMMUTABLE_CLS.contains(obj.getClass());
    }

    @Override
    public void onContinuousProcessorStarted(GridKernalContext ctx) throws IgniteCheckedException {
    }

    @Override
    public int typeId(String typeName) {
        return 0;
    }

    @Override
    public Object unwrapTemporary(GridCacheContext ctx, Object obj) throws IgniteException {
        return obj;
    }

    @Override
    public boolean isBinaryObject(Object obj) {
        return false;
    }

    @Override
    public boolean isBinaryEnabled(CacheConfiguration<?, ?> ccfg) {
        return false;
    }

    @Override
    public int typeId(Object obj) {
        return 0;
    }

    @Override
    public Object field(Object obj, String fieldName) {
        return null;
    }

    @Override
    public boolean hasField(Object obj, String fieldName) {
        return false;
    }

    static {
        IMMUTABLE_CLS.add(String.class);
        IMMUTABLE_CLS.add(Boolean.class);
        IMMUTABLE_CLS.add(Byte.class);
        IMMUTABLE_CLS.add(Short.class);
        IMMUTABLE_CLS.add(Character.class);
        IMMUTABLE_CLS.add(Integer.class);
        IMMUTABLE_CLS.add(Long.class);
        IMMUTABLE_CLS.add(Float.class);
        IMMUTABLE_CLS.add(Double.class);
        IMMUTABLE_CLS.add(UUID.class);
        IMMUTABLE_CLS.add(IgniteUuid.class);
        IMMUTABLE_CLS.add(BigDecimal.class);
    }
}

