/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecord
extends PageDeltaRecord {
    private long updateCntr;
    private long globalRmvId;
    private int partSize;
    private byte state;
    private int allocatedIdxCandidate;
    private long cntrsPageId;

    public MetaPageUpdatePartitionDataRecord(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate) {
        super(grpId, pageId);
        this.updateCntr = updateCntr;
        this.globalRmvId = globalRmvId;
        this.partSize = partSize;
        this.state = state;
        this.allocatedIdxCandidate = allocatedIdxCandidate;
        this.cntrsPageId = cntrsPageId;
    }

    public long updateCounter() {
        return this.updateCntr;
    }

    public long globalRemoveId() {
        return this.globalRmvId;
    }

    public int partitionSize() {
        return this.partSize;
    }

    public long countersPageId() {
        return this.cntrsPageId;
    }

    public byte state() {
        return this.state;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setUpdateCounter(pageAddr, this.updateCntr);
        io.setGlobalRemoveId(pageAddr, this.globalRmvId);
        io.setSize(pageAddr, this.partSize);
        io.setCountersPageId(pageAddr, this.cntrsPageId);
        io.setPartitionState(pageAddr, this.state);
        io.setCandidatePageCount(pageAddr, this.allocatedIdxCandidate);
    }

    public int allocatedIndexCandidate() {
        return this.allocatedIdxCandidate;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_UPDATE_COUNTERS;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecord.class, this, "super", super.toString());
    }
}

