/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageRemoveRecord
extends PageDeltaRecord {
    private int itemId;

    public DataPageRemoveRecord(int grpId, long pageId, int itemId) {
        super(grpId, pageId);
        this.itemId = itemId;
    }

    public int itemId() {
        return this.itemId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
        io.removeRow(pageAddr, this.itemId, pageMem.pageSize());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_REMOVE_RECORD;
    }

    @Override
    public String toString() {
        return S.toString(DataPageRemoveRecord.class, this, "super", super.toString());
    }
}

