/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.JdbcThinSSLUtil;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryMetadataRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.ipc.loopback.IpcClientTcpEndpoint;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteProductVersion;

public class JdbcThinTcpIo {
    private static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    private static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    private static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    private static final ClientListenerProtocolVersion VER_2_4_0 = ClientListenerProtocolVersion.create(2, 4, 0);
    private static final ClientListenerProtocolVersion VER_2_5_0;
    private static final ClientListenerProtocolVersion CURRENT_VER;
    private static final int HANDSHAKE_MSG_SIZE = 13;
    private static final int DYNAMIC_SIZE_MSG_CAP = 256;
    private static final int MAX_BATCH_QRY_CNT = 32;
    private static final int QUERY_FETCH_MSG_SIZE = 13;
    private static final int QUERY_META_MSG_SIZE = 9;
    private static final int QUERY_CLOSE_MSG_SIZE = 9;
    private static final Random RND;
    private final ConnectionProperties connProps;
    private IpcClientTcpEndpoint endpoint;
    private BufferedOutputStream out;
    private BufferedInputStream in;
    private boolean closed;
    private IgniteProductVersion igniteVer;
    private int srvIdx;
    private Thread ownThread;
    private final Object mux = new Object();
    private ClientListenerProtocolVersion srvProtocolVer;

    public JdbcThinTcpIo(ConnectionProperties connProps) {
        this.connProps = connProps;
        this.srvIdx = RND.nextInt(connProps.getAddresses().length);
    }

    public void start() throws SQLException, IOException {
        this.start(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int timeout) throws SQLException, IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.ownThread != null) {
                throw new SQLException("Concurrent access to JDBC connection is not allowed [ownThread=" + this.ownThread.getName() + ", curThread=" + Thread.currentThread().getName(), "08001");
            }
            this.ownThread = Thread.currentThread();
        }
        try {
            ArrayList<String> inaccessibleAddrs = null;
            ArrayList<Exception> exceptions = null;
            HostAndPortRange[] srvs = this.connProps.getAddresses();
            boolean connected = false;
            for (int i = 0; i < srvs.length; ++i) {
                InetAddress[] addrs;
                HostAndPortRange srv = srvs[this.srvIdx];
                block15: for (InetAddress addr : addrs = this.getAllAddressesByHost(srv.host())) {
                    for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                        try {
                            this.connect(new InetSocketAddress(addr, port), timeout);
                            connected = true;
                            continue block15;
                        }
                        catch (IOException | SQLException exception) {
                            if (inaccessibleAddrs == null) {
                                inaccessibleAddrs = new ArrayList<String>();
                            }
                            inaccessibleAddrs.add(addr.getHostName());
                            if (exceptions == null) {
                                exceptions = new ArrayList<Exception>();
                            }
                            exceptions.add(exception);
                            continue;
                        }
                    }
                }
                if (connected) break;
                this.srvIdx = (this.srvIdx + 1) % srvs.length;
            }
            if (!connected && inaccessibleAddrs != null && exceptions != null) {
                if (exceptions.size() == 1) {
                    Exception ex = (Exception)exceptions.get(0);
                    if (ex instanceof SQLException) {
                        throw (SQLException)ex;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                }
                SQLException e = new SQLException("Failed to connect to server [url=" + this.connProps.getUrl() + ']', "08001");
                for (Exception ex : exceptions) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
            this.handshake(CURRENT_VER);
        }
        finally {
            object = this.mux;
            synchronized (object) {
                this.ownThread = null;
            }
        }
    }

    private void connect(InetSocketAddress addr, int timeout) throws IOException, SQLException {
        Socket sock;
        if ("require".equalsIgnoreCase(this.connProps.getSslMode())) {
            sock = JdbcThinSSLUtil.createSSLSocket(addr, this.connProps);
        } else if ("disable".equalsIgnoreCase(this.connProps.getSslMode())) {
            sock = new Socket();
            try {
                sock.connect(addr, timeout);
            }
            catch (IOException e) {
                throw new SQLException("Failed to connect to server [host=" + addr.getHostName() + ", port=" + addr.getPort() + ']', "08001", e);
            }
        } else {
            throw new SQLException("Unknown sslMode. [sslMode=" + this.connProps.getSslMode() + ']', "08001");
        }
        if (this.connProps.getSocketSendBuffer() != 0) {
            sock.setSendBufferSize(this.connProps.getSocketSendBuffer());
        }
        if (this.connProps.getSocketReceiveBuffer() != 0) {
            sock.setReceiveBufferSize(this.connProps.getSocketReceiveBuffer());
        }
        sock.setTcpNoDelay(this.connProps.isTcpNoDelay());
        try {
            this.endpoint = new IpcClientTcpEndpoint(sock);
            this.out = new BufferedOutputStream(this.endpoint.outputStream());
            this.in = new BufferedInputStream(this.endpoint.inputStream());
        }
        catch (IgniteCheckedException e) {
            throw new SQLException("Failed to connect to server [url=" + this.connProps.getUrl() + ']', "08001", e);
        }
    }

    protected InetAddress[] getAllAddressesByHost(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host);
    }

    public void handshake(ClientListenerProtocolVersion ver) throws IOException, SQLException {
        BinaryWriterExImpl writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(13), null, null);
        writer.writeByte((byte)1);
        writer.writeShort(ver.major());
        writer.writeShort(ver.minor());
        writer.writeShort(ver.maintenance());
        writer.writeByte((byte)1);
        writer.writeBoolean(this.connProps.isDistributedJoins());
        writer.writeBoolean(this.connProps.isEnforceJoinOrder());
        writer.writeBoolean(this.connProps.isCollocated());
        writer.writeBoolean(this.connProps.isReplicatedOnly());
        writer.writeBoolean(this.connProps.isAutoCloseServerCursor());
        writer.writeBoolean(this.connProps.isLazy());
        writer.writeBoolean(this.connProps.isSkipReducerOnUpdate());
        if (!F.isEmpty(this.connProps.getUsername())) {
            assert (ver.compareTo(VER_2_5_0) >= 0) : "Authentication is supported since 2.5";
            writer.writeString(this.connProps.getUsername());
            writer.writeString(this.connProps.getPassword());
        }
        this.send(writer.array());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(null, new BinaryHeapInputStream(this.read()), null, null, false);
        boolean accepted = reader.readBoolean();
        if (accepted) {
            if (reader.available() > 0) {
                byte maj = reader.readByte();
                byte min = reader.readByte();
                byte maintenance = reader.readByte();
                String stage = reader.readString();
                long ts = reader.readLong();
                byte[] hash = reader.readByteArray();
                this.igniteVer = new IgniteProductVersion(maj, min, maintenance, stage, ts, hash);
            } else {
                this.igniteVer = new IgniteProductVersion(2, 0, 0, "Unknown", 0L, null);
            }
            this.srvProtocolVer = ver;
        } else {
            short maj = reader.readShort();
            short min = reader.readShort();
            short maintenance = reader.readShort();
            String err = reader.readString();
            ClientListenerProtocolVersion srvProtoVer0 = ClientListenerProtocolVersion.create(maj, min, maintenance);
            if (srvProtoVer0.compareTo(VER_2_5_0) < 0 && !F.isEmpty(this.connProps.getUsername())) {
                throw new SQLException("Authentication doesn't support by remote server[driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + srvProtoVer0 + ", err=" + err + ", url=" + this.connProps.getUrl() + ']', "08004");
            }
            if (VER_2_4_0.equals(this.srvProtocolVer) || VER_2_3_0.equals(this.srvProtocolVer) || VER_2_1_5.equals(this.srvProtocolVer)) {
                this.handshake(this.srvProtocolVer);
            } else if (VER_2_1_0.equals(this.srvProtocolVer)) {
                this.handshake_2_1_0();
            } else {
                throw new SQLException("Handshake failed [driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + this.srvProtocolVer + ", err=" + err + ']', "08004");
            }
        }
    }

    private void handshake_2_1_0() throws IOException, SQLException {
        BinaryWriterExImpl writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(13), null, null);
        writer.writeByte((byte)1);
        writer.writeShort(VER_2_1_0.major());
        writer.writeShort(VER_2_1_0.minor());
        writer.writeShort(VER_2_1_0.maintenance());
        writer.writeByte((byte)1);
        writer.writeBoolean(this.connProps.isDistributedJoins());
        writer.writeBoolean(this.connProps.isEnforceJoinOrder());
        writer.writeBoolean(this.connProps.isCollocated());
        writer.writeBoolean(this.connProps.isReplicatedOnly());
        writer.writeBoolean(this.connProps.isAutoCloseServerCursor());
        this.send(writer.array());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(null, new BinaryHeapInputStream(this.read()), null, null, false);
        boolean accepted = reader.readBoolean();
        if (!accepted) {
            short maj = reader.readShort();
            short min = reader.readShort();
            short maintenance = reader.readShort();
            String err = reader.readString();
            ClientListenerProtocolVersion ver = ClientListenerProtocolVersion.create(maj, min, maintenance);
            throw new SQLException("Handshake failed [driverProtocolVer=" + CURRENT_VER + ", remoteNodeProtocolVer=" + ver + ", err=" + err + ']', "08004");
        }
        this.igniteVer = new IgniteProductVersion(2, 1, 0, "Unknown", 0L, null);
        this.srvProtocolVer = VER_2_1_0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBatchRequestNoWaitResponse(JdbcOrderedBatchExecuteRequest req) throws IOException, SQLException {
        Object object = this.mux;
        synchronized (object) {
            if (this.ownThread != null) {
                throw new SQLException("Concurrent access to JDBC connection is not allowed [ownThread=" + this.ownThread.getName() + ", curThread=" + Thread.currentThread().getName(), "08006");
            }
            this.ownThread = Thread.currentThread();
        }
        try {
            if (!this.isUnorderedStreamSupported()) {
                throw new SQLException("Streaming without response doesn't supported by server [driverProtocolVer=" + CURRENT_VER + ", remoteNodeVer=" + this.igniteVer + ']', "50000");
            }
            int cap = JdbcThinTcpIo.guessCapacity(req);
            BinaryWriterExImpl writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(cap), null, null);
            req.writeBinary(writer);
            this.send(writer.array());
        }
        finally {
            Object object2 = this.mux;
            synchronized (object2) {
                this.ownThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdbcResponse sendRequest(JdbcRequest req) throws SQLException, IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.ownThread != null) {
                throw new SQLException("Concurrent access to JDBC connection is not allowed [ownThread=" + this.ownThread.getName() + ", curThread=" + Thread.currentThread().getName(), "08006");
            }
            this.ownThread = Thread.currentThread();
        }
        try {
            int cap = JdbcThinTcpIo.guessCapacity(req);
            BinaryWriterExImpl writer = new BinaryWriterExImpl(null, new BinaryHeapOutputStream(cap), null, null);
            req.writeBinary(writer);
            this.send(writer.array());
            JdbcResponse jdbcResponse = this.readResponse();
            return jdbcResponse;
        }
        finally {
            Object object2 = this.mux;
            synchronized (object2) {
                this.ownThread = null;
            }
        }
    }

    JdbcResponse readResponse() throws IOException {
        BinaryReaderExImpl reader = new BinaryReaderExImpl(null, new BinaryHeapInputStream(this.read()), null, null, false);
        JdbcResponse res = new JdbcResponse();
        res.readBinary(reader);
        return res;
    }

    private static int guessCapacity(JdbcRequest req) {
        int cap;
        if (req instanceof JdbcBatchExecuteRequest) {
            List<JdbcQuery> qrys = ((JdbcBatchExecuteRequest)req).queries();
            int cnt = !F.isEmpty(qrys) ? Math.min(32, qrys.size()) : 0;
            cap = cnt * 256 + 1;
        } else {
            cap = req instanceof JdbcQueryCloseRequest ? 9 : (req instanceof JdbcQueryMetadataRequest ? 9 : (req instanceof JdbcQueryFetchRequest ? 13 : 256));
        }
        return cap;
    }

    private void send(byte[] req) throws IOException {
        int size = req.length;
        this.out.write(size & 0xFF);
        this.out.write(size >> 8 & 0xFF);
        this.out.write(size >> 16 & 0xFF);
        this.out.write(size >> 24 & 0xFF);
        this.out.write(req);
        this.out.flush();
    }

    private byte[] read() throws IOException {
        byte[] sizeBytes = this.read(4);
        int msgSize = (0xFF & sizeBytes[3]) << 24 | (0xFF & sizeBytes[2]) << 16 | ((0xFF & sizeBytes[1]) << 8) + (0xFF & sizeBytes[0]);
        return this.read(msgSize);
    }

    private byte[] read(int size) throws IOException {
        int res;
        byte[] data = new byte[size];
        for (int off = 0; off != size; off += res) {
            res = this.in.read(data, off, size - off);
            if (res != -1) continue;
            throw new IOException("Failed to read incoming message (not enough data).");
        }
        return data;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        U.closeQuiet(this.out);
        U.closeQuiet(this.in);
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        this.closed = true;
    }

    public ConnectionProperties connectionProperties() {
        return this.connProps;
    }

    IgniteProductVersion igniteVersion() {
        return this.igniteVer;
    }

    boolean isUnorderedStreamSupported() {
        assert (this.srvProtocolVer != null);
        return this.srvProtocolVer.compareTo(VER_2_5_0) >= 0;
    }

    static {
        CURRENT_VER = VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
        RND = new Random(U.currentTimeMillis());
    }
}

