/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timeline;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineEvent
implements Comparable<TimelineEvent> {
    private long timestamp;
    private String eventType;
    private Map<String, Object> eventInfo = new HashMap<String, Object>();

    @XmlElement(name="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @XmlElement(name="eventtype")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @XmlElement(name="eventinfo")
    public Map<String, Object> getEventInfo() {
        return this.eventInfo;
    }

    public void addEventInfo(String key, Object value) {
        this.eventInfo.put(key, value);
    }

    public void addEventInfo(Map<String, Object> eventInfo) {
        this.eventInfo.putAll(eventInfo);
    }

    public void setEventInfo(Map<String, Object> eventInfo) {
        this.eventInfo = eventInfo;
    }

    @Override
    public int compareTo(TimelineEvent other) {
        if (this.timestamp > other.timestamp) {
            return -1;
        }
        if (this.timestamp < other.timestamp) {
            return 1;
        }
        return this.eventType.compareTo(other.eventType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineEvent event = (TimelineEvent)o;
        if (this.timestamp != event.timestamp) {
            return false;
        }
        if (!this.eventType.equals(event.eventType)) {
            return false;
        }
        return !(this.eventInfo != null ? !this.eventInfo.equals(event.eventInfo) : event.eventInfo != null);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.eventType.hashCode();
        result = 31 * result + (this.eventInfo != null ? this.eventInfo.hashCode() : 0);
        return result;
    }
}

