/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.cache.CacheException;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.value.Value;

public class GridThreadLocalTable
extends Table {
    private final ThreadLocal<Table> tbl = new ThreadLocal();

    public GridThreadLocalTable(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, persistIndexes, persistData);
    }

    public void innerTable(Table t) {
        if (t == null) {
            this.tbl.remove();
        } else {
            this.tbl.set(t);
        }
    }

    private Table innerTable() {
        Table t = this.tbl.get();
        if (t == null) {
            throw new CacheException("Table `" + this.getName() + "` can be accessed only within Ignite query context.");
        }
        return t;
    }

    public Index getPrimaryKey() {
        return this.innerTable().getPrimaryKey();
    }

    public Column getRowIdColumn() {
        return this.innerTable().getRowIdColumn();
    }

    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> cols) {
        return this.innerTable().getBestPlanItem(session, masks, filters, filter, sortOrder, cols);
    }

    public Value getDefaultValue(Session session, Column column) {
        return this.innerTable().getDefaultValue(session, column);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        return this.innerTable().getTemplateSimpleRow(singleColumn);
    }

    public Row getTemplateRow() {
        return this.innerTable().getTemplateRow();
    }

    public Column getColumn(String columnName) {
        return this.innerTable().getColumn(columnName);
    }

    public Column getColumn(int index) {
        return this.innerTable().getColumn(index);
    }

    public Index getIndexForColumn(Column column, boolean needGetFirstOrLast, boolean needFindNext) {
        return this.innerTable().getIndexForColumn(column, needGetFirstOrLast, needFindNext);
    }

    public Column[] getColumns() {
        return this.innerTable().getColumns();
    }

    protected void setColumns(Column[] columns) {
        throw new IllegalStateException("Cols: " + Arrays.asList(columns));
    }

    public boolean lock(Session session, boolean exclusive, boolean force) {
        return this.innerTable().lock(session, exclusive, force);
    }

    public void close(Session session) {
    }

    public void unlock(Session s) {
        this.innerTable().unlock(s);
    }

    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        return this.innerTable().addIndex(session, indexName, indexId, cols, indexType, create, indexComment);
    }

    public void removeRow(Session session, Row row) {
        this.innerTable().removeRow(session, row);
    }

    public void truncate(Session session) {
        this.innerTable().truncate(session);
    }

    public void addRow(Session session, Row row) {
        this.innerTable().addRow(session, row);
    }

    public void checkSupportAlter() {
        this.innerTable().checkSupportAlter();
    }

    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    public Index getUniqueIndex() {
        return this.innerTable().getUniqueIndex();
    }

    public Index getScanIndex(Session session) {
        return this.innerTable().getScanIndex(session);
    }

    public ArrayList<Index> getIndexes() {
        return this.innerTable().getIndexes();
    }

    public boolean isLockedExclusively() {
        return this.innerTable().isLockedExclusively();
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return this.innerTable().isDeterministic();
    }

    public boolean canGetRowCount() {
        return this.innerTable().canGetRowCount();
    }

    public boolean canDrop() {
        return false;
    }

    public long getRowCount(Session session) {
        return this.innerTable().getRowCount(session);
    }

    public long getRowCountApproximation() {
        Table t = this.tbl.get();
        return t == null ? 0L : t.getRowCountApproximation();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public String getCreateSQL() {
        return "";
    }

    public String getDropSQL() {
        return "";
    }

    public void addDependencies(HashSet<DbObject> dependencies) {
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public static class Engine
    implements TableEngine {
        private static ThreadLocal<GridThreadLocalTable> createdTbl = new ThreadLocal();

        public static GridThreadLocalTable getCreated() {
            GridThreadLocalTable tbl = createdTbl.get();
            assert (tbl != null);
            createdTbl.remove();
            return tbl;
        }

        public Table createTable(CreateTableData d) {
            assert (createdTbl.get() == null);
            GridThreadLocalTable tbl = new GridThreadLocalTable(d.schema, d.id, d.tableName, d.persistIndexes, d.persistData);
            createdTbl.set(tbl);
            return tbl;
        }
    }
}

