/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.Collection;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridChangeStateCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> commands = U.sealList(GridRestCommand.CLUSTER_ACTIVE, GridRestCommand.CLUSTER_INACTIVE, GridRestCommand.CLUSTER_CURRENT_STATE);

    public GridChangeStateCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return commands;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest restRest) {
        GridRestChangeStateRequest req = (GridRestChangeStateRequest)restRest;
        GridFutureAdapter<GridRestResponse> fut = new GridFutureAdapter<GridRestResponse>();
        GridRestResponse res = new GridRestResponse();
        try {
            if (req.command().equals((Object)GridRestCommand.CLUSTER_CURRENT_STATE)) {
                Boolean currentState = this.ctx.state().publicApiActiveState(false);
                res.setResponse(currentState);
            } else {
                this.ctx.grid().active(req.active());
            }
            fut.onDone(res);
        }
        catch (Exception e) {
            SB sb = new SB();
            sb.a(e.getMessage()).a("\n").a("suppressed: \n");
            for (Throwable t : X.getSuppressedList(e)) {
                sb.a(t.getMessage()).a("\n");
            }
            res.setError(sb.toString());
            fut.onDone(res);
        }
        return fut;
    }
}

