/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public final class IgfsMetaDirectoryListingReplaceProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String name;
    private IgniteUuid id;

    public IgfsMetaDirectoryListingReplaceProcessor() {
    }

    public IgfsMetaDirectoryListingReplaceProcessor(String name, IgniteUuid id) {
        this.name = name;
        this.id = id;
    }

    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> e, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo fileInfo = (IgfsEntryInfo)e.getValue();
        assert (fileInfo.isDirectory());
        HashMap<String, IgfsListingEntry> listing = new HashMap<String, IgfsListingEntry>(fileInfo.listing());
        IgfsListingEntry oldEntry = (IgfsListingEntry)listing.get(this.name);
        if (oldEntry == null) {
            throw new IgniteException("Directory listing doesn't contain expected entry: " + this.name);
        }
        listing.put(this.name, new IgfsListingEntry(this.id, oldEntry.isDirectory()));
        e.setValue((Object)fileInfo.listing(listing));
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeGridUuid(out, this.id);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.id = U.readGridUuid(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeString(this.name);
        BinaryUtils.writeIgniteUuid(out, this.id);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.name = in.readString();
        this.id = BinaryUtils.readIgniteUuid(in);
    }

    public String toString() {
        return S.toString(IgfsMetaDirectoryListingReplaceProcessor.class, this);
    }
}

