/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsHandshakeResponse
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String igfsName;
    private long blockSize;
    private Boolean sampling;

    public IgfsHandshakeResponse() {
    }

    public IgfsHandshakeResponse(String igfsName, long blockSize, Boolean sampling) {
        this.igfsName = igfsName;
        this.blockSize = blockSize;
        this.sampling = sampling;
    }

    public String igfsName() {
        return this.igfsName;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public Boolean sampling() {
        return this.sampling;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igfsName);
        out.writeLong(this.blockSize);
        if (this.sampling != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.sampling);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igfsName = U.readString(in);
        this.blockSize = in.readLong();
        if (in.readBoolean()) {
            this.sampling = in.readBoolean();
        }
    }
}

