/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsDirectoryInfo
extends IgfsEntryInfo
implements Binarylizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Map<String, IgfsListingEntry> listing;

    public IgfsDirectoryInfo() {
    }

    @Override
    public IgfsEntryInfo length(long len) {
        throw new UnsupportedOperationException("length");
    }

    @Override
    public IgfsDirectoryInfo listing(@Nullable Map<String, IgfsListingEntry> listing) {
        IgfsDirectoryInfo res = this.copy();
        res.listing = listing;
        return res;
    }

    @Override
    public IgfsEntryInfo lock(IgniteUuid lockId) {
        throw new UnsupportedOperationException("lock");
    }

    @Override
    public IgfsEntryInfo unlock(long modificationTime) {
        throw new UnsupportedOperationException("unlock");
    }

    @Override
    public IgfsEntryInfo fileMap(IgfsFileMap fileMap) {
        throw new UnsupportedOperationException("fileMap");
    }

    IgfsDirectoryInfo(IgniteUuid id, @Nullable Map<String, IgfsListingEntry> listing, @Nullable Map<String, String> props, long accessTime, long modificationTime) {
        super(id, props, accessTime, modificationTime);
        this.listing = listing;
    }

    @Override
    protected IgfsDirectoryInfo copy() {
        return new IgfsDirectoryInfo(this.id, this.listing, this.props, this.accessTime, this.modificationTime);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public int blockSize() {
        return 0;
    }

    @Override
    public long blocksCount() {
        return 0L;
    }

    @Override
    public Map<String, IgfsListingEntry> listing() {
        return this.listing != null ? this.listing : Collections.emptyMap();
    }

    @Override
    public boolean hasChildren() {
        return !F.isEmpty(this.listing);
    }

    @Override
    public boolean hasChild(String name) {
        return this.listing != null && this.listing.containsKey(name);
    }

    @Override
    public boolean hasChild(String name, IgniteUuid expId) {
        IgfsListingEntry entry;
        if (this.listing != null && (entry = this.listing.get(name)) != null) {
            return F.eq(expId, entry.fileId());
        }
        return false;
    }

    @Override
    @Nullable
    public IgniteUuid affinityKey() {
        return null;
    }

    @Override
    public IgfsFileMap fileMap() {
        return null;
    }

    @Override
    @Nullable
    public IgniteUuid lockId() {
        return null;
    }

    @Override
    public boolean evictExclude() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.listing != null) {
            out.writeBoolean(true);
            out.writeInt(this.listing.size());
            for (Map.Entry<String, IgfsListingEntry> entry : this.listing.entrySet()) {
                U.writeString(out, entry.getKey());
                IgfsUtils.writeListingEntry(out, entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.readBoolean()) {
            int listingSize = in.readInt();
            this.listing = new HashMap<String, IgfsListingEntry>(listingSize);
            for (int i = 0; i < listingSize; ++i) {
                String key = U.readString(in);
                IgfsListingEntry val = IgfsUtils.readListingEntry(in);
                this.listing.put(key, val);
            }
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        this.writeBinary(out);
        if (this.listing != null) {
            out.writeBoolean(true);
            out.writeInt(this.listing.size());
            for (Map.Entry<String, IgfsListingEntry> entry : this.listing.entrySet()) {
                out.writeString(entry.getKey());
                IgfsUtils.writeListingEntry(out, entry.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.readBinary(in);
        if (in.readBoolean()) {
            int listingSize = in.readInt();
            this.listing = new HashMap<String, IgfsListingEntry>(listingSize);
            for (int i = 0; i < listingSize; ++i) {
                String key = in.readString();
                IgfsListingEntry val = IgfsUtils.readListingEntry(in);
                this.listing.put(key, val);
            }
        }
    }

    public int hashCode() {
        return this.id.hashCode() ^ (this.props == null ? 0 : this.props.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IgfsDirectoryInfo that = (IgfsDirectoryInfo)obj;
        return this.id.equals(that.id) && F.eq(this.props, that.props);
    }

    @Override
    public String toString() {
        return S.toString(IgfsDirectoryInfo.class, this);
    }
}

