/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.StorageException;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.SwitchSegmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentArchiveResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.SingleSegmentLogicalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FsyncModeFileWriteAheadLogManager
extends GridCacheSharedManagerAdapter
implements IgniteWriteAheadLogManager {
    public static final FileDescriptor[] EMPTY_DESCRIPTORS = new FileDescriptor[0];
    public static final String WAL_SEGMENT_FILE_EXT = ".wal";
    private static final byte[] FILL_BUF = new byte[0x100000];
    private static final Pattern WAL_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal");
    private static final Pattern WAL_TEMP_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal\\.tmp");
    public static final FileFilter WAL_SEGMENT_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_TEMP_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final Pattern WAL_SEGMENT_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip");
    public static final FileFilter WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && (WAL_NAME_PATTERN.matcher(file.getName()).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches());
        }
    };
    private static final Pattern WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip\\.tmp");
    private static final FileFilter WAL_SEGMENT_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final int LATEST_SERIALIZER_VERSION = 2;
    private final boolean alwaysWriteFullPages;
    private final long maxWalSegmentSize;
    private final WALMode mode;
    private final int tlbSize;
    private final long flushFreq;
    private final long fsyncDelay;
    private final DataStorageConfiguration dsCfg;
    private final GridEventStorageManager evt;
    private IgniteConfiguration igCfg;
    private DataStorageMetricsImpl metrics;
    private File walWorkDir;
    private File walArchiveDir;
    private RecordSerializer serializer;
    private final int serializerVersion = IgniteSystemProperties.getInteger("IGNITE_WAL_SERIALIZER_VERSION", 2);
    private volatile long lastTruncatedArchiveIdx = -1L;
    private final FileIOFactory ioFactory;
    private static final AtomicReferenceFieldUpdater<FsyncModeFileWriteAheadLogManager, FileWriteHandle> currentHndUpd = AtomicReferenceFieldUpdater.newUpdater(FsyncModeFileWriteAheadLogManager.class, FileWriteHandle.class, "currentHnd");
    private final ThreadLocal<ByteBuffer> tlb = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocateDirect(FsyncModeFileWriteAheadLogManager.this.tlbSize);
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
    };
    private volatile FileArchiver archiver;
    private volatile FileCompressor compressor;
    private volatile FileDecompressor decompressor;
    private final ThreadLocal<WALPointer> lastWALPtr = new ThreadLocal();
    private volatile FileWriteHandle currentHnd;
    private volatile Throwable envFailed;
    private final long walAutoArchiveAfterInactivity;
    private AtomicLong lastRecordLoggedMs = new AtomicLong();
    @Nullable
    private volatile GridTimeoutProcessor.CancelableTask backgroundFlushSchedule;
    @Nullable
    private volatile GridTimeoutObject nextAutoArchiveTimeoutObj;

    public FsyncModeFileWriteAheadLogManager(@NotNull GridKernalContext ctx) {
        this.igCfg = ctx.config();
        DataStorageConfiguration dsCfg = this.igCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.maxWalSegmentSize = dsCfg.getWalSegmentSize();
        this.mode = dsCfg.getWalMode();
        this.tlbSize = dsCfg.getWalThreadLocalBufferSize();
        this.flushFreq = dsCfg.getWalFlushFrequency();
        this.fsyncDelay = dsCfg.getWalFsyncDelayNanos();
        this.alwaysWriteFullPages = dsCfg.isAlwaysWriteFullPages();
        this.ioFactory = dsCfg.getFileIOFactory();
        this.walAutoArchiveAfterInactivity = dsCfg.getWalAutoArchiveAfterInactivity();
        this.evt = ctx.event();
        assert (this.mode == WALMode.FSYNC) : dsCfg;
    }

    @Override
    public void start0() throws IgniteCheckedException {
        if (!this.cctx.kernalContext().clientNode()) {
            PdsFolderSettings resolveFolders = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
            this.checkWalConfiguration();
            final File walWorkDir0 = this.walWorkDir = this.initDirectory(this.dsCfg.getWalPath(), "db/wal", resolveFolders.folderName(), "write ahead log work directory");
            final File walArchiveDir0 = this.walArchiveDir = this.initDirectory(this.dsCfg.getWalArchivePath(), "db/wal/archive", resolveFolders.folderName(), "write ahead log archive directory");
            this.serializer = new RecordSerializerFactoryImpl(this.cctx).createSerializer(this.serializerVersion);
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
            this.metrics = dbMgr.persistentStoreMetricsImpl();
            this.checkOrPrepareFiles();
            this.metrics.setWalSizeProvider((IgniteOutClosure<Long>)new CO<Long>(){

                @Override
                public Long apply() {
                    long size = 0L;
                    for (File f : walWorkDir0.listFiles()) {
                        size += f.length();
                    }
                    for (File f : walArchiveDir0.listFiles()) {
                        size += f.length();
                    }
                    return size;
                }
            });
            IgniteBiTuple<Long, Long> tup = this.scanMinMaxArchiveIndices();
            this.lastTruncatedArchiveIdx = tup == null ? -1L : tup.get1() - 1L;
            this.archiver = new FileArchiver(tup == null ? -1L : tup.get2());
            if (this.dsCfg.isWalCompactionEnabled()) {
                this.compressor = new FileCompressor();
                this.decompressor = new FileDecompressor();
            }
            if (this.mode != WALMode.NONE) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started write-ahead log manager [mode=" + (Object)((Object)this.mode) + ']');
                }
            } else {
                U.quietAndWarn(this.log, "Started write-ahead log manager in NONE mode, persisted data may be lost in a case of unexpected node failure. Make sure to deactivate the cluster before shutdown.");
            }
        }
    }

    private void checkWalConfiguration() throws IgniteCheckedException {
        if (this.dsCfg.getWalPath() == null ^ this.dsCfg.getWalArchivePath() == null) {
            throw new IgniteCheckedException("Properties should be either both specified or both null [walStorePath = " + this.dsCfg.getWalPath() + ", walArchivePath = " + this.dsCfg.getWalArchivePath() + "]");
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        GridTimeoutObject timeoutObj;
        GridTimeoutProcessor.CancelableTask schedule = this.backgroundFlushSchedule;
        if (schedule != null) {
            schedule.close();
        }
        if ((timeoutObj = this.nextAutoArchiveTimeoutObj) != null) {
            this.cctx.time().removeTimeoutObject(timeoutObj);
        }
        FileWriteHandle currHnd = this.currentHandle();
        try {
            if (this.mode == WALMode.BACKGROUND && currHnd != null) {
                currHnd.flush(null, true);
            }
            if (currHnd != null) {
                currHnd.close(false);
            }
            if (this.archiver != null) {
                this.archiver.shutdown();
            }
            if (this.compressor != null) {
                this.compressor.shutdown();
            }
            if (this.decompressor != null) {
                this.decompressor.shutdown();
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to gracefully close WAL segment: " + this.currentHnd.fileIO, e);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activated file write ahead log manager [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.start0();
        if (!this.cctx.kernalContext().clientNode()) {
            assert (this.archiver != null);
            this.archiver.start();
            if (this.compressor != null) {
                this.compressor.start();
            }
            if (this.decompressor != null) {
                this.decompressor.start();
            }
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate file write ahead log [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
        this.currentHnd = null;
    }

    @Override
    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    @Override
    public boolean isFullSync() {
        return this.mode == WALMode.FSYNC;
    }

    @Override
    public void resumeLogging(WALPointer lastPtr) throws IgniteCheckedException {
        try {
            assert (this.currentHnd == null);
            assert (lastPtr == null || lastPtr instanceof FileWALPointer);
            FileWALPointer filePtr = (FileWALPointer)lastPtr;
            this.currentHnd = this.restoreWriteHandle(filePtr);
            if (this.currentHnd.serializer.version() != this.serializer.version()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Record serializer version change detected, will start logging with a new WAL record serializer to a new WAL segment [curFile=" + this.currentHnd + ", newVer=" + this.serializer.version() + ", oldVer=" + this.currentHnd.serializer.version() + ']');
                }
                this.rollOver(this.currentHnd);
            }
            if (this.mode == WALMode.BACKGROUND) {
                this.backgroundFlushSchedule = this.cctx.time().schedule(new Runnable(){

                    @Override
                    public void run() {
                        FsyncModeFileWriteAheadLogManager.this.doFlush();
                    }
                }, this.flushFreq, this.flushFreq);
            }
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.scheduleNextInactivityPeriodElapsedCheck();
            }
        }
        catch (StorageException e) {
            throw new IgniteCheckedException(e);
        }
    }

    private void scheduleNextInactivityPeriodElapsedCheck() {
        long lastRecMs = this.lastRecordLoggedMs.get();
        final long nextPossibleAutoArchive = (lastRecMs <= 0L ? U.currentTimeMillis() : lastRecMs) + this.walAutoArchiveAfterInactivity;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Schedule WAL rollover check at " + new Time(nextPossibleAutoArchive).toString());
        }
        this.nextAutoArchiveTimeoutObj = new GridTimeoutObject(){
            private final IgniteUuid id = IgniteUuid.randomUuid();

            @Override
            public IgniteUuid timeoutId() {
                return this.id;
            }

            @Override
            public long endTime() {
                return nextPossibleAutoArchive;
            }

            @Override
            public void onTimeout() {
                if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FsyncModeFileWriteAheadLogManager.this.log.debug("Checking if WAL rollover required (" + new Time(U.currentTimeMillis()).toString() + ")");
                }
                FsyncModeFileWriteAheadLogManager.this.checkWalRolloverRequiredDuringInactivityPeriod();
                FsyncModeFileWriteAheadLogManager.this.scheduleNextInactivityPeriodElapsedCheck();
            }
        };
        this.cctx.time().addTimeoutObject(this.nextAutoArchiveTimeoutObj);
    }

    public Collection<File> getAndReserveWalFiles(FileWALPointer low, FileWALPointer high) throws IgniteCheckedException {
        long awaitIdx = high.index() - 1L;
        while (this.archiver.lastArchivedAbsoluteIndex() < awaitIdx) {
            LockSupport.parkNanos(Thread.currentThread(), 1000000L);
        }
        if (!this.reserve(low)) {
            throw new IgniteCheckedException("WAL archive segment has been deleted [idx=" + low.index() + "]");
        }
        ArrayList<File> res = new ArrayList<File>();
        for (long i = low.index(); i < high.index(); ++i) {
            String segmentName = FileWriteAheadLogManager.FileDescriptor.fileName(i);
            File file = new File(this.walArchiveDir, segmentName);
            File fileZip = new File(this.walArchiveDir, segmentName + ".zip");
            if (file.exists()) {
                res.add(file);
                continue;
            }
            if (fileZip.exists()) {
                res.add(fileZip);
                continue;
            }
            if (!this.log.isInfoEnabled()) break;
            this.log.info("Segment not found: " + file.getName() + "/" + fileZip.getName());
            this.log.info("Stopped iteration on idx: " + i);
            break;
        }
        return res;
    }

    @Override
    public int serializerVersion() {
        return this.serializerVersion;
    }

    private void checkWalRolloverRequiredDuringInactivityPeriod() {
        if (this.walAutoArchiveAfterInactivity <= 0L) {
            return;
        }
        long lastRecMs = this.lastRecordLoggedMs.get();
        if (lastRecMs == 0L) {
            return;
        }
        long elapsedMs = U.currentTimeMillis() - lastRecMs;
        if (elapsedMs <= this.walAutoArchiveAfterInactivity) {
            return;
        }
        if (!this.lastRecordLoggedMs.compareAndSet(lastRecMs, 0L)) {
            return;
        }
        FileWriteHandle handle = this.currentHandle();
        try {
            this.rollOver(handle);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unable to perform segment rollover: " + e.getMessage(), e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    @Override
    public WALPointer log(WALRecord record) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        FileWriteHandle currWrHandle = this.currentHandle();
        if (currWrHandle == null) {
            return null;
        }
        record.size(this.serializer.size(record));
        do {
            WALPointer ptr;
            if (record.rollOver()) {
                assert (this.cctx.database().checkpointLockIsHeldByThread());
                currWrHandle = this.rollOver(currWrHandle);
            }
            if ((ptr = currWrHandle.addRecord(record)) != null) {
                this.metrics.onWalRecordLogged();
                this.lastWALPtr.set(ptr);
                if (this.walAutoArchiveAfterInactivity > 0L) {
                    this.lastRecordLoggedMs.set(U.currentTimeMillis());
                }
                return ptr;
            }
            currWrHandle = this.rollOver(currWrHandle);
            this.checkNode();
        } while (!this.isStopping());
        throw new IgniteCheckedException("Stopping.");
    }

    @Override
    public void flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return;
        }
        FileWriteHandle cur = this.currentHandle();
        if (cur == null) {
            return;
        }
        FileWALPointer filePtr = (FileWALPointer)(ptr == null ? this.lastWALPtr.get() : ptr);
        if (filePtr != null && !cur.needFsync(filePtr)) {
            return;
        }
        cur.fsync(filePtr, false);
    }

    @Override
    public WALIterator replay(WALPointer start) throws IgniteCheckedException, StorageException {
        assert (start == null || start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        FileWriteHandle hnd = this.currentHandle();
        FileWALPointer end = null;
        if (hnd != null) {
            end = hnd.position();
        }
        return new RecordsIterator(this.cctx, this.walWorkDir, this.walArchiveDir, (FileWALPointer)start, end, this.dsCfg, new RecordSerializerFactoryImpl(this.cctx), this.ioFactory, this.archiver, this.decompressor, this.log);
    }

    @Override
    public boolean reserve(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return false;
        }
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            throw new IgniteCheckedException("Could not reserve WAL segment: archiver == null");
        }
        archiver0.reserve(((FileWALPointer)start).index());
        if (!this.hasIndex(((FileWALPointer)start).index())) {
            archiver0.release(((FileWALPointer)start).index());
            return false;
        }
        return true;
    }

    @Override
    public void release(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return;
        }
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            throw new IgniteCheckedException("Could not release WAL segment: archiver == null");
        }
        archiver0.release(((FileWALPointer)start).index());
    }

    private boolean hasIndex(long absIdx) {
        boolean inArchive;
        String segmentName = FileDescriptor.fileName(absIdx);
        String zipSegmentName = FileDescriptor.fileName(absIdx) + ".zip";
        boolean bl = inArchive = new File(this.walArchiveDir, segmentName).exists() || new File(this.walArchiveDir, zipSegmentName).exists();
        if (inArchive) {
            return true;
        }
        if (absIdx <= this.lastArchivedIndex()) {
            return false;
        }
        FileWriteHandle cur = this.currentHnd;
        return cur != null && cur.idx >= absIdx;
    }

    @Override
    public int truncate(WALPointer low, WALPointer high) {
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        FileWALPointer lowPtr = (FileWALPointer)low;
        FileWALPointer highPtr = (FileWALPointer)high;
        FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.scan(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
        int deleted = 0;
        FileArchiver archiver0 = this.archiver;
        for (FileDescriptor desc : descs) {
            long lastArchived;
            if (lowPtr != null && desc.idx < lowPtr.index()) continue;
            if (archiver0 != null && archiver0.reserved(desc.idx)) {
                return deleted;
            }
            long l = lastArchived = archiver0 != null ? archiver0.lastArchivedAbsoluteIndex() : this.lastArchivedIndex();
            if (desc.idx >= highPtr.index() || desc.idx >= lastArchived) continue;
            if (!desc.file.delete()) {
                U.warn(this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath());
            } else {
                ++deleted;
            }
            if (this.lastTruncatedArchiveIdx >= desc.idx) continue;
            this.lastTruncatedArchiveIdx = desc.idx;
        }
        return deleted;
    }

    @Override
    public void allowCompressionUntil(WALPointer ptr) {
        if (this.compressor != null) {
            this.compressor.allowCompressionUntil(((FileWALPointer)ptr).index());
        }
    }

    @Override
    public int walArchiveSegments() {
        long lastTruncated = this.lastTruncatedArchiveIdx;
        long lastArchived = this.archiver.lastArchivedAbsoluteIndex();
        if (lastArchived == -1L) {
            return 0;
        }
        int res = (int)(lastArchived - lastTruncated);
        return res >= 0 ? res : 0;
    }

    @Override
    public boolean reserved(WALPointer ptr) {
        FileWALPointer fPtr = (FileWALPointer)ptr;
        FileArchiver archiver0 = this.archiver;
        return archiver0 != null && archiver0.reserved(fPtr.index());
    }

    @Override
    public boolean disabled(int grpId) {
        CacheGroupContext ctx = this.cctx.cache().cacheGroup(grpId);
        return ctx != null && !ctx.walEnabled();
    }

    private long lastArchivedIndex() {
        long lastIdx = -1L;
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                lastIdx = Math.max(lastIdx, idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return lastIdx;
    }

    private IgniteBiTuple<Long, Long> scanMinMaxArchiveIndices() {
        TreeSet<Long> archiveIndices = new TreeSet<Long>();
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                archiveIndices.add(idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        if (archiveIndices.isEmpty()) {
            return null;
        }
        Long min = (Long)archiveIndices.first();
        Long max = (Long)archiveIndices.last();
        if (max - min == (long)(archiveIndices.size() - 1)) {
            return F.t(min, max);
        }
        for (Long idx : archiveIndices.descendingSet()) {
            if (archiveIndices.contains(idx - 1L)) continue;
            return F.t(idx, max);
        }
        throw new IllegalStateException("Should never happen if TreeSet is valid.");
    }

    private File initDirectory(String cfg, String defDir, String consId, String msg) throws IgniteCheckedException {
        File workDir0;
        File dir = cfg != null ? ((workDir0 = new File(cfg)).isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), cfg, false), consId)) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), defDir, false), consId);
        U.ensureDirectory(dir, msg, this.log);
        return dir;
    }

    private FileWriteHandle currentHandle() {
        return this.currentHnd;
    }

    private FileWriteHandle rollOver(FileWriteHandle cur) throws StorageException, IgniteCheckedException {
        FileWriteHandle hnd = this.currentHandle();
        if (hnd != cur) {
            return hnd;
        }
        if (hnd.close(true)) {
            if (this.metrics.metricsEnabled()) {
                this.metrics.onWallRollOver();
            }
            FileWriteHandle next = this.initNextWriteHandle(cur.idx);
            boolean swapped = currentHndUpd.compareAndSet(this, hnd, next);
            assert (swapped) : "Concurrent updates on rollover are not allowed";
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.lastRecordLoggedMs.set(0L);
            }
            hnd.signalNextAvailable();
        } else {
            hnd.awaitNext();
        }
        return this.currentHandle();
    }

    private FileWriteHandle restoreWriteHandle(FileWALPointer lastReadPtr) throws IgniteCheckedException {
        long absIdx = lastReadPtr == null ? 0L : lastReadPtr.index();
        long segNo = absIdx % (long)this.dsCfg.getWalSegments();
        File curFile = new File(this.walWorkDir, FileDescriptor.fileName(segNo));
        int offset = lastReadPtr == null ? 0 : lastReadPtr.fileOffset();
        int len = lastReadPtr == null ? 0 : lastReadPtr.length();
        try {
            FileIO fileIO = this.ioFactory.create(curFile);
            try {
                int serVer = this.serializerVersion;
                if (lastReadPtr != null) {
                    try {
                        serVer = RecordV1Serializer.readSegmentHeader(fileIO, absIdx).getSerializerVersion();
                    }
                    catch (EOFException | SegmentEofException ignore) {
                        serVer = this.serializerVersion;
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(this.cctx).createSerializer(serVer);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Resuming logging to WAL segment [file=" + curFile.getAbsolutePath() + ", offset=" + offset + ", ver=" + serVer + ']');
                }
                FileWriteHandle hnd = new FileWriteHandle(fileIO, absIdx, offset + len, this.maxWalSegmentSize, ser);
                if (lastReadPtr == null) {
                    hnd.writeSerializerVersion();
                }
                this.archiver.currentWalIndex(absIdx);
                return hnd;
            }
            catch (IOException | IgniteCheckedException e) {
                fileIO.close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to restore WAL write handle: " + curFile.getAbsolutePath(), e);
        }
    }

    private FileWriteHandle initNextWriteHandle(long curIdx) throws StorageException, IgniteCheckedException {
        try {
            File nextFile = this.pollNextFile(curIdx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Switching to a new WAL segment: " + nextFile.getAbsolutePath());
            }
            FileIO fileIO = this.ioFactory.create(nextFile);
            FileWriteHandle hnd = new FileWriteHandle(fileIO, curIdx + 1L, 0L, this.maxWalSegmentSize, this.serializer);
            hnd.writeSerializerVersion();
            return hnd;
        }
        catch (IOException e) {
            StorageException se = new StorageException("Unable to initialize WAL segment", e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
            throw se;
        }
    }

    private void checkOrPrepareFiles() throws IgniteCheckedException {
        File[] allFiles;
        File[] tmpFiles = this.walWorkDir.listFiles(WAL_SEGMENT_TEMP_FILE_FILTER);
        if (!F.isEmpty(tmpFiles)) {
            for (File tmp : tmpFiles) {
                boolean deleted = tmp.delete();
                if (deleted) continue;
                throw new IgniteCheckedException("Failed to delete previously created temp file (make sure Ignite process has enough rights): " + tmp.getAbsolutePath());
            }
        }
        if ((allFiles = this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER)).length != 0 && allFiles.length > this.dsCfg.getWalSegments()) {
            throw new IgniteCheckedException("Failed to initialize wal (work directory contains incorrect number of segments) [cur=" + allFiles.length + ", expected=" + this.dsCfg.getWalSegments() + ']');
        }
        if (allFiles.length == 0) {
            File first = new File(this.walWorkDir, FileDescriptor.fileName(0L));
            this.createFile(first);
        } else {
            this.checkFiles(0, false, null, null);
        }
    }

    private void formatFile(File file) throws IgniteCheckedException {
        this.formatFile(file, this.dsCfg.getWalSegmentSize());
    }

    private void formatFile(File file, int bytesCntToFormat) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Formatting file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        try (FileIO fileIO = this.ioFactory.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            if (this.mode == WALMode.FSYNC) {
                int toWrite;
                for (int left = bytesCntToFormat; left > 0; left -= toWrite) {
                    toWrite = Math.min(FILL_BUF.length, left);
                    fileIO.write(FILL_BUF, 0, toWrite);
                }
                fileIO.force();
            } else {
                fileIO.clear();
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to format WAL segment file: " + file.getAbsolutePath(), e);
        }
    }

    private void createFile(File file) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        File tmp = new File(file.getParent(), file.getName() + ".tmp");
        this.formatFile(tmp);
        try {
            Files.move(tmp.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to move temp file to a regular WAL segment file: " + file.getAbsolutePath(), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WAL segment [file=" + file.getAbsolutePath() + ", size=" + file.length() + ']');
        }
    }

    private File pollNextFile(long curIdx) throws IgniteCheckedException {
        long absNextIdx = this.archiver.nextAbsoluteSegmentIndex(curIdx);
        long segmentIdx = absNextIdx % (long)this.dsCfg.getWalSegments();
        return new File(this.walWorkDir, FileDescriptor.fileName(segmentIdx));
    }

    public static FileDescriptor[] scan(File[] allFiles) {
        if (allFiles == null) {
            return EMPTY_DESCRIPTORS;
        }
        Object[] descs = new FileDescriptor[allFiles.length];
        for (int i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            descs[i] = new FileDescriptor(f);
        }
        Arrays.sort(descs);
        return descs;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    private void checkFiles(int startWith, boolean create, @Nullable IgnitePredicate<Integer> p, @Nullable IgniteInClosure<Integer> completionCallback) throws IgniteCheckedException {
        for (int i = startWith; i < this.dsCfg.getWalSegments() && (p == null || p != null && p.apply(i)); ++i) {
            File checkFile = new File(this.walWorkDir, FileDescriptor.fileName(i));
            if (checkFile.exists()) {
                if (checkFile.isDirectory()) {
                    throw new IgniteCheckedException("Failed to initialize WAL log segment (a directory with the same name already exists): " + checkFile.getAbsolutePath());
                }
                if (checkFile.length() != (long)this.dsCfg.getWalSegmentSize() && this.mode == WALMode.FSYNC) {
                    throw new IgniteCheckedException("Failed to initialize WAL log segment (WAL segment size change is not supported):" + checkFile.getAbsolutePath());
                }
            } else if (create) {
                this.createFile(checkFile);
            }
            if (completionCallback == null) continue;
            completionCallback.apply(i);
        }
    }

    public static long writeSerializerVersion(FileIO io, long idx, int version, WALMode mode) throws IOException {
        ByteBuffer buffer = FsyncModeFileWriteAheadLogManager.prepareSerializerVersionBuffer(idx, version, false);
        do {
            io.write(buffer);
        } while (buffer.hasRemaining());
        if (mode == WALMode.FSYNC) {
            io.force();
        }
        return io.position();
    }

    @NotNull
    private static ByteBuffer prepareSerializerVersionBuffer(long idx, int ver, boolean compacted) {
        ByteBuffer buf = ByteBuffer.allocate(29);
        buf.order(ByteOrder.nativeOrder());
        buf.put((byte)(WALRecord.RecordType.HEADER_RECORD.ordinal() + 1));
        RecordV1Serializer.putPosition(buf, new FileWALPointer(idx, 0, 0));
        buf.putLong(compacted ? 5622654036411574606L : -5705984118950656934L);
        buf.putInt(ver);
        if (!RecordV1Serializer.skipCrc) {
            int curPos = buf.position();
            buf.position(0);
            int crcVal = PureJavaCrc32.calcCrc32(buf, curPos);
            buf.putInt(crcVal);
        } else {
            buf.putInt(0);
        }
        buf.position(0);
        return buf;
    }

    private static int recordOffset(WALRecord rec) {
        FileWALPointer ptr = (FileWALPointer)rec.position();
        assert (ptr != null);
        return ptr.fileOffset();
    }

    private void doFlush() {
        FileWriteHandle hnd = this.currentHandle();
        try {
            hnd.flush((WALRecord)hnd.head.get(), false);
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to flush WAL record queue", e);
        }
    }

    private static FileDescriptor[] loadFileDescriptors(@NotNull File walFilesDir) throws IgniteCheckedException {
        File[] files = walFilesDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER);
        if (files == null) {
            throw new IgniteCheckedException("WAL files directory does not not denote a directory, or if an I/O error occurs: [" + walFilesDir.getAbsolutePath() + "]");
        }
        return FsyncModeFileWriteAheadLogManager.scan(files);
    }

    private class RecordsIterator
    extends AbstractWalRecordsIterator {
        private static final long serialVersionUID = 0L;
        private final File walWorkDir;
        private final File walArchiveDir;
        private final FileArchiver archiver;
        private final FileDecompressor decompressor;
        private final DataStorageConfiguration psCfg;
        @Nullable
        private FileWALPointer start;
        @Nullable
        private FileWALPointer end;

        private RecordsIterator(GridCacheSharedContext cctx, File walWorkDir, @Nullable File walArchiveDir, @Nullable FileWALPointer start, FileWALPointer end, @NotNull DataStorageConfiguration psCfg, RecordSerializerFactory serializerFactory, FileIOFactory ioFactory, FileArchiver archiver, FileDecompressor decompressor, IgniteLogger log) throws IgniteCheckedException {
            super(log, cctx, serializerFactory, ioFactory, psCfg.getWalRecordIteratorBufferSize());
            this.walWorkDir = walWorkDir;
            this.walArchiveDir = walArchiveDir;
            this.psCfg = psCfg;
            this.archiver = archiver;
            this.start = start;
            this.end = end;
            this.decompressor = decompressor;
            this.init();
            this.advance();
        }

        @Override
        protected ReadFileHandle initReadHandle(@NotNull AbstractWalRecordsIterator.AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
            if (this.decompressor != null && !desc.file().exists()) {
                FileDescriptor zipFile = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(desc.idx()) + ".zip"));
                if (!zipFile.file.exists()) {
                    throw new FileNotFoundException("Both compressed and raw segment files are missing in archive [segmentIdx=" + desc.idx() + "]");
                }
                this.decompressor.decompressFile(desc.idx()).get();
            }
            return (ReadFileHandle)super.initReadHandle(desc, start);
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            super.onClose();
            this.curRec = null;
            AbstractWalRecordsIterator.AbstractReadFileHandle handle = this.closeCurrentWalSegment();
            if (handle != null && handle.workDir()) {
                this.releaseWorkSegment(this.curWalSegmIdx);
            }
            this.curWalSegmIdx = Integer.MAX_VALUE;
        }

        private void init() throws IgniteCheckedException {
            FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.loadFileDescriptors(this.walArchiveDir);
            if (this.start != null) {
                if (!F.isEmpty(descs)) {
                    if (descs[0].idx() > this.start.index()) {
                        throw new IgniteCheckedException("WAL history is too short [descs=" + Arrays.asList(descs) + ", start=" + this.start + ']');
                    }
                    for (FileDescriptor desc : descs) {
                        if (desc.idx() != this.start.index()) continue;
                        this.curWalSegmIdx = this.start.index();
                        break;
                    }
                    if (this.curWalSegmIdx == -1L) {
                        long lastArchived = descs[descs.length - 1].idx();
                        if (lastArchived > this.start.index()) {
                            throw new IgniteCheckedException("WAL history is corrupted (segment is missing): " + this.start);
                        }
                        this.curWalSegmIdx = this.start.index();
                    }
                } else {
                    this.curWalSegmIdx = this.start.index();
                }
            } else {
                this.curWalSegmIdx = !F.isEmpty(descs) ? descs[0].idx() : 0L;
            }
            --this.curWalSegmIdx;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized WAL cursor [start=" + this.start + ", end=" + this.end + ", curWalSegmIdx=" + this.curWalSegmIdx + ']');
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
            ReadFileHandle nextHandle;
            FileDescriptor fd;
            if (curWalSegment != null) {
                curWalSegment.close();
                if (curWalSegment.workDir()) {
                    this.releaseWorkSegment(curWalSegment.idx());
                }
            }
            if (this.end != null && this.curWalSegmIdx + 1L > this.end.index()) {
                return null;
            }
            ++this.curWalSegmIdx;
            boolean readArchive = this.canReadArchiveOrReserveWork(this.curWalSegmIdx);
            if (readArchive) {
                fd = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(this.curWalSegmIdx)));
            } else {
                long workIdx = this.curWalSegmIdx % (long)this.psCfg.getWalSegments();
                fd = new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(workIdx)), this.curWalSegmIdx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file().getAbsolutePath() + ']');
            }
            try {
                nextHandle = this.initReadHandle(fd, this.start != null && this.curWalSegmIdx == this.start.index() ? this.start : null);
            }
            catch (FileNotFoundException e) {
                if (readArchive) {
                    throw new IgniteCheckedException("Missing WAL segment in the archive", e);
                }
                nextHandle = null;
            }
            if (nextHandle == null) {
                if (!readArchive) {
                    this.releaseWorkSegment(this.curWalSegmIdx);
                }
            } else {
                nextHandle.workDir = !readArchive;
            }
            this.curRec = null;
            return nextHandle;
        }

        private boolean canReadArchiveOrReserveWork(long absIdx) {
            return this.archiver != null && this.archiver.checkCanReadArchiveOrReserveWorkSegment(absIdx);
        }

        private void releaseWorkSegment(long absIdx) {
            if (this.archiver != null) {
                this.archiver.releaseWorkSegment(absIdx);
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(FileIO fileIO, long idx, RecordSerializer ser, FileInput in) {
            return new ReadFileHandle(fileIO, idx, ser, in);
        }
    }

    private static final class FakeRecord
    extends WALRecord {
        private final boolean stop;

        FakeRecord(FileWALPointer pos, boolean stop) {
            this.position(pos);
            this.stop = stop;
        }

        @Override
        public WALRecord.RecordType type() {
            return null;
        }

        @Override
        public FileWALPointer position() {
            return (FileWALPointer)super.position();
        }

        @Override
        public String toString() {
            return S.toString(FakeRecord.class, this, "super", super.toString());
        }
    }

    private class FileWriteHandle
    extends FileHandle {
        private final RecordSerializer serializer;
        private final long maxSegmentSize;
        private final AtomicReference<WALRecord> head;
        private volatile long written;
        private volatile long lastFsyncPos;
        private final AtomicBoolean stop;
        private final Lock lock;
        private final Condition writeComplete;
        private final Condition fsync;
        private final Condition nextSegment;

        private FileWriteHandle(FileIO fileIO, long idx, long pos, long maxSegmentSize, RecordSerializer serializer) throws IOException {
            super(fileIO, idx);
            this.head = new AtomicReference();
            this.stop = new AtomicBoolean(false);
            this.lock = new ReentrantLock();
            this.writeComplete = this.lock.newCondition();
            this.fsync = this.lock.newCondition();
            this.nextSegment = this.lock.newCondition();
            assert (serializer != null);
            fileIO.position(pos);
            this.maxSegmentSize = maxSegmentSize;
            this.serializer = serializer;
            this.head.set(new FakeRecord(new FileWALPointer(idx, (int)pos, 0), false));
            this.written = pos;
            this.lastFsyncPos = pos;
        }

        public void writeSerializerVersion() throws IgniteCheckedException {
            try {
                long updatedPosition;
                assert (this.fileIO.position() == 0L) : "Serializer version can be written only at the begin of file " + this.fileIO.position();
                this.written = updatedPosition = FsyncModeFileWriteAheadLogManager.writeSerializerVersion(this.fileIO, this.idx, this.serializer.version(), FsyncModeFileWriteAheadLogManager.this.mode);
                this.lastFsyncPos = updatedPosition;
                this.head.set(new FakeRecord(new FileWALPointer(this.idx, (int)updatedPosition, 0), false));
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Unable to write serializer version for segment " + this.idx, e);
            }
        }

        private boolean stopped() {
            return this.stopped(this.head.get());
        }

        private boolean stopped(WALRecord record) {
            return record instanceof FakeRecord && ((FakeRecord)record).stop;
        }

        @Nullable
        private WALPointer addRecord(WALRecord rec) throws StorageException, IgniteCheckedException {
            FileWALPointer ptr;
            assert (rec.size() > 0 || rec.getClass() == FakeRecord.class);
            boolean flushed = false;
            while (true) {
                WALRecord h;
                long nextPos;
                if ((nextPos = this.nextPosition(h = this.head.get())) + (long)rec.size() >= this.maxSegmentSize || this.stopped(h)) {
                    return null;
                }
                int newChainSize = h.chainSize() + rec.size();
                if (newChainSize > FsyncModeFileWriteAheadLogManager.this.tlbSize && !flushed) {
                    boolean res;
                    boolean bl = res = h.previous() == null || this.flush(h, false);
                    if (rec.size() <= FsyncModeFileWriteAheadLogManager.this.tlbSize) continue;
                    flushed = res;
                    continue;
                }
                rec.chainSize(newChainSize);
                rec.previous(h);
                ptr = new FileWALPointer(this.idx, (int)nextPos, rec.size());
                rec.position(ptr);
                if (this.head.compareAndSet(h, rec)) break;
            }
            return ptr;
        }

        private long nextPosition(WALRecord rec) {
            return FsyncModeFileWriteAheadLogManager.recordOffset(rec) + rec.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushOrWait(FileWALPointer ptr, boolean stop) throws IgniteCheckedException {
            long expWritten;
            if (ptr != null) {
                if (ptr.index() != this.idx) {
                    return;
                }
                expWritten = ptr.fileOffset();
            } else {
                expWritten = FsyncModeFileWriteAheadLogManager.recordOffset(this.head.get());
            }
            if (this.flush(ptr, stop)) {
                return;
            }
            if (stop) {
                FakeRecord fr = (FakeRecord)this.head.get();
                assert (fr.stop) : "Invalid fake record on top of the queue: " + fr;
                expWritten = FsyncModeFileWriteAheadLogManager.recordOffset(fr);
            }
            for (int i = 0; i < 64; ++i) {
                if (this.written < expWritten) continue;
                return;
            }
            this.lock.lock();
            try {
                while (this.written < expWritten && FsyncModeFileWriteAheadLogManager.this.envFailed == null) {
                    U.awaitQuiet(this.writeComplete);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean flush(FileWALPointer ptr, boolean stop) throws IgniteCheckedException, StorageException {
            WALRecord h;
            if (ptr == null) {
                WALRecord expHead;
                do {
                    FakeRecord frHead;
                    if ((expHead = this.head.get()).previous() != null || (frHead = (FakeRecord)expHead).stop != stop && !frHead.stop && !this.head.compareAndSet(expHead, new FakeRecord(frHead.position(), stop))) continue;
                    return false;
                } while (!this.flush(expHead, stop));
                return true;
            }
            assert (ptr.index() == this.idx);
            do {
                if (this.chainBeginPosition(h = this.head.get()) <= (long)ptr.fileOffset()) continue;
                return false;
            } while (!this.flush(h, stop));
            return true;
        }

        private long chainBeginPosition(WALRecord h) {
            return FsyncModeFileWriteAheadLogManager.recordOffset(h) + h.size() - h.chainSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flush(WALRecord expHead, boolean stop) throws StorageException, IgniteCheckedException {
            if (expHead.previous() == null) {
                FakeRecord frHead = (FakeRecord)expHead;
                if (!stop || frHead.stop) {
                    return false;
                }
            }
            FsyncModeFileWriteAheadLogManager.this.checkNode();
            if (!this.head.compareAndSet(expHead, new FakeRecord(new FileWALPointer(this.idx, (int)this.nextPosition(expHead), 0), stop))) {
                return false;
            }
            if (expHead.chainSize() == 0) {
                return false;
            }
            try {
                ByteBuffer buf;
                boolean tmpBuf = false;
                if (expHead.chainSize() > FsyncModeFileWriteAheadLogManager.this.tlbSize) {
                    buf = GridUnsafe.allocateBuffer(expHead.chainSize());
                    tmpBuf = true;
                } else {
                    buf = (ByteBuffer)FsyncModeFileWriteAheadLogManager.this.tlb.get();
                }
                try {
                    long pos = this.fillBuffer(buf, expHead);
                    this.writeBuffer(pos, buf);
                }
                finally {
                    if (tmpBuf) {
                        GridUnsafe.freeBuffer(buf);
                    }
                }
                return true;
            }
            catch (Throwable e) {
                StorageException se = new StorageException("Unable to write", new IOException(e));
                FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                this.signalNextAvailable();
                throw se;
            }
        }

        private long fillBuffer(ByteBuffer buf, WALRecord head) throws IgniteCheckedException {
            int limit = head.chainSize();
            assert (limit <= buf.capacity());
            buf.rewind();
            buf.limit(limit);
            do {
                buf.position(head.chainSize() - head.size());
                buf.limit(head.chainSize());
                try {
                    this.serializer.writeRecord(head, buf);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Failed to write record: " + head, e);
                }
                assert (!buf.hasRemaining()) : "Reported record size is greater than actual: " + head;
            } while ((head = head.previous()).previous() != null);
            assert (head instanceof FakeRecord) : head.getClass();
            buf.rewind();
            buf.limit(limit);
            return FsyncModeFileWriteAheadLogManager.recordOffset(head);
        }

        private boolean needFsync(FileWALPointer ptr) {
            return this.idx == ptr.index() && this.lastFsyncPos <= (long)ptr.fileOffset();
        }

        private FileWALPointer position() {
            this.lock.lock();
            try {
                FileWALPointer fileWALPointer = new FileWALPointer(this.idx, (int)this.written, 0);
                return fileWALPointer;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fsync(FileWALPointer ptr, boolean stop) throws StorageException, IgniteCheckedException {
            block16: {
                this.lock.lock();
                try {
                    long end;
                    if (ptr != null) {
                        if (!this.needFsync(ptr)) {
                            return;
                        }
                        if (FsyncModeFileWriteAheadLogManager.this.fsyncDelay > 0L && !this.stopped()) {
                            U.await(this.fsync, FsyncModeFileWriteAheadLogManager.this.fsyncDelay, TimeUnit.NANOSECONDS);
                            if (!this.needFsync(ptr)) {
                                return;
                            }
                        }
                    }
                    this.flushOrWait(ptr, stop);
                    if (this.stopped()) {
                        return;
                    }
                    if (this.lastFsyncPos == this.written) break block16;
                    assert (this.lastFsyncPos < this.written);
                    boolean metricsEnabled = FsyncModeFileWriteAheadLogManager.this.metrics.metricsEnabled();
                    long start = metricsEnabled ? System.nanoTime() : 0L;
                    try {
                        this.fileIO.force();
                    }
                    catch (IOException e) {
                        throw new StorageException(e);
                    }
                    this.lastFsyncPos = this.written;
                    if (FsyncModeFileWriteAheadLogManager.this.fsyncDelay > 0L) {
                        this.fsync.signalAll();
                    }
                    long l = end = metricsEnabled ? System.nanoTime() : 0L;
                    if (metricsEnabled) {
                        FsyncModeFileWriteAheadLogManager.this.metrics.onFsync(end - start);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean close(boolean rollOver) throws IgniteCheckedException, StorageException {
            if (this.stop.compareAndSet(false, true)) {
                this.lock.lock();
                try {
                    this.flushOrWait(null, true);
                    assert (this.stopped()) : "Segment is not closed after close flush: " + this.head.get();
                    try {
                        RecordSerializer backwardSerializer = new RecordSerializerFactoryImpl(FsyncModeFileWriteAheadLogManager.this.cctx).createSerializer(FsyncModeFileWriteAheadLogManager.this.serializerVersion);
                        SwitchSegmentRecord segmentRecord = new SwitchSegmentRecord();
                        int switchSegmentRecSize = backwardSerializer.size(segmentRecord);
                        if (rollOver && this.written < this.maxSegmentSize - (long)switchSegmentRecSize) {
                            int written0;
                            ByteBuffer buf = ByteBuffer.allocate(switchSegmentRecSize);
                            segmentRecord.position(new FileWALPointer(this.idx, (int)this.written, switchSegmentRecSize));
                            backwardSerializer.writeRecord(segmentRecord, buf);
                            buf.rewind();
                            for (int rem = buf.remaining(); rem > 0; rem -= written0) {
                                written0 = this.fileIO.write(buf, this.written);
                                this.written += (long)written0;
                            }
                        }
                        if (FsyncModeFileWriteAheadLogManager.this.mode == WALMode.FSYNC) {
                            this.fileIO.force();
                            this.lastFsyncPos = this.written;
                        }
                        this.fileIO.close();
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException(e);
                    }
                    if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FsyncModeFileWriteAheadLogManager.this.log.debug("Closed WAL write handle [idx=" + this.idx + "]");
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        }

        private void signalNextAvailable() {
            this.lock.lock();
            try {
                WALRecord rec = this.head.get();
                if (FsyncModeFileWriteAheadLogManager.this.envFailed == null) {
                    assert (rec instanceof FakeRecord) : "Expected head FakeRecord, actual head " + (rec != null ? rec.getClass().getSimpleName() : "null");
                    assert (this.written == this.lastFsyncPos || FsyncModeFileWriteAheadLogManager.this.mode != WALMode.FSYNC) : "fsync [written=" + this.written + ", lastFsync=" + this.lastFsyncPos + ']';
                }
                this.fileIO = null;
                this.nextSegment.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void awaitNext() throws IgniteCheckedException {
            this.lock.lock();
            try {
                while (this.fileIO != null) {
                    U.awaitQuiet(this.nextSegment);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBuffer(long pos, ByteBuffer buf) throws StorageException, IgniteCheckedException {
            boolean interrupted = false;
            this.lock.lock();
            try {
                assert (this.fileIO != null) : "Writing to a closed segment.";
                FsyncModeFileWriteAheadLogManager.this.checkNode();
                long lastLogged = U.currentTimeMillis();
                long logBackoff = 2000L;
                while (this.written != pos) {
                    assert (this.written < pos) : "written = " + this.written + ", pos = " + pos;
                    long now = U.currentTimeMillis();
                    if (now - lastLogged >= logBackoff) {
                        if (logBackoff < 3600000L) {
                            logBackoff *= 2L;
                        }
                        U.warn(FsyncModeFileWriteAheadLogManager.this.log, "Still waiting for a concurrent write to complete [written=" + this.written + ", pos=" + pos + ", lastFsyncPos=" + this.lastFsyncPos + ", stop=" + this.stop.get() + ", actualPos=" + this.safePosition() + ']');
                        lastLogged = now;
                    }
                    try {
                        this.writeComplete.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                    FsyncModeFileWriteAheadLogManager.this.checkNode();
                }
                int size = buf.remaining();
                assert (size > 0) : size;
                try {
                    assert (this.written == this.fileIO.position());
                    do {
                        this.fileIO.write(buf);
                    } while (buf.hasRemaining());
                    this.written += (long)size;
                    FsyncModeFileWriteAheadLogManager.this.metrics.onWalBytesWritten(size);
                    assert (this.written == this.fileIO.position());
                }
                catch (IOException e) {
                    StorageException se = new StorageException("Unable to write", e);
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                    throw se;
                }
            }
            finally {
                this.writeComplete.signalAll();
                this.lock.unlock();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private String safePosition() {
            FileIO io = this.fileIO;
            if (io == null) {
                return "null";
            }
            try {
                return String.valueOf(io.position());
            }
            catch (IOException e) {
                return "{Failed to read channel position: " + e.getMessage() + "}";
            }
        }
    }

    public static class ReadFileHandle
    extends FileHandle
    implements AbstractWalRecordsIterator.AbstractReadFileHandle {
        RecordSerializer ser;
        FileInput in;
        private boolean workDir;

        ReadFileHandle(FileIO fileIO, long idx, RecordSerializer ser, FileInput in) {
            super(fileIO, idx);
            this.ser = ser;
            this.in = in;
        }

        @Override
        public void close() throws IgniteCheckedException {
            try {
                this.fileIO.close();
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        @Override
        public long idx() {
            return this.idx;
        }

        @Override
        public FileInput in() {
            return this.in;
        }

        @Override
        public RecordSerializer ser() {
            return this.ser;
        }

        @Override
        public boolean workDir() {
            return this.workDir;
        }
    }

    private static abstract class FileHandle {
        protected FileIO fileIO;
        protected final long idx;

        private FileHandle(FileIO fileIO, long idx) {
            this.fileIO = fileIO;
            this.idx = idx;
        }
    }

    public static class FileDescriptor
    implements Comparable<FileDescriptor>,
    AbstractWalRecordsIterator.AbstractFileDescriptor {
        protected final File file;
        protected final long idx;

        public FileDescriptor(@NotNull File file) {
            this(file, null);
        }

        public FileDescriptor(@NotNull File file, @Nullable Long idx) {
            this.file = file;
            String fileName = file.getName();
            assert (fileName.contains(FsyncModeFileWriteAheadLogManager.WAL_SEGMENT_FILE_EXT));
            this.idx = idx == null ? Long.parseLong(fileName.substring(0, 16)) : idx;
        }

        public static String fileName(long segment) {
            SB b = new SB();
            String segmentStr = Long.toString(segment);
            for (int i = segmentStr.length(); i < 16; ++i) {
                b.a('0');
            }
            b.a(segmentStr).a(FsyncModeFileWriteAheadLogManager.WAL_SEGMENT_FILE_EXT);
            return b.toString();
        }

        private static String segmentNumber(long segment) {
            SB b = new SB();
            String segmentStr = Long.toString(segment);
            for (int i = segmentStr.length(); i < 16; ++i) {
                b.a('0');
            }
            b.a(segmentStr);
            return b.toString();
        }

        @Override
        public int compareTo(FileDescriptor o) {
            return Long.compare(this.idx, o.idx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor that = (FileDescriptor)o;
            return this.idx == that.idx;
        }

        public int hashCode() {
            return (int)(this.idx ^ this.idx >>> 32);
        }

        public long getIdx() {
            return this.idx;
        }

        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean isCompressed() {
            return this.file.getName().endsWith(".zip");
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public long idx() {
            return this.idx;
        }
    }

    private class FileDecompressor
    extends Thread {
        private volatile boolean stopped;
        private Map<Long, GridFutureAdapter<Void>> decompressionFutures;
        private PriorityBlockingQueue<Long> segmentsQueue;
        private byte[] arr;

        FileDecompressor() {
            super("wal-file-decompressor%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.decompressionFutures = new HashMap<Long, GridFutureAdapter<Void>>();
            this.segmentsQueue = new PriorityBlockingQueue();
            this.arr = new byte[FsyncModeFileWriteAheadLogManager.this.tlbSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                long segmentToDecompress = -1L;
                try {
                    block38: {
                        segmentToDecompress = this.segmentsQueue.take();
                        if (this.stopped) break;
                        File zip = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".zip");
                        File unzipTmp = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".tmp");
                        File unzip = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress));
                        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
                             FileIO io = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(unzipTmp);){
                            int bytesRead;
                            zis.getNextEntry();
                            while ((bytesRead = zis.read(this.arr)) > 0) {
                                io.write(this.arr, 0, bytesRead);
                            }
                        }
                        try {
                            Files.move(unzipTmp.toPath(), unzip.toPath(), new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            U.error(FsyncModeFileWriteAheadLogManager.this.log, "Can't rename temporary unzipped segment: raw segment is already present [tmp=" + unzipTmp + ", raw=" + unzip + ']', e);
                            if (unzipTmp.delete()) break block38;
                            U.error(FsyncModeFileWriteAheadLogManager.this.log, "Can't delete temporary unzipped segment [tmp=" + unzipTmp + ']');
                        }
                    }
                    FileDecompressor fileDecompressor = this;
                    synchronized (fileDecompressor) {
                        this.decompressionFutures.remove(segmentToDecompress).onDone();
                    }
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    if (this.stopped || segmentToDecompress == -1L) continue;
                    IgniteCheckedException e = new IgniteCheckedException("Error during WAL segment decompression [segmentIdx=" + segmentToDecompress + ']', t);
                    FileDecompressor fileDecompressor = this;
                    synchronized (fileDecompressor) {
                        this.decompressionFutures.remove(segmentToDecompress).onDone(e);
                    }
                }
            }
        }

        synchronized IgniteInternalFuture<Void> decompressFile(long idx) {
            if (this.decompressionFutures.containsKey(idx)) {
                return this.decompressionFutures.get(idx);
            }
            File f = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(idx));
            if (f.exists()) {
                return new GridFinishedFuture<Void>();
            }
            this.segmentsQueue.put(idx);
            GridFutureAdapter<Void> res = new GridFutureAdapter<Void>();
            this.decompressionFutures.put(idx, res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileDecompressor fileDecompressor = this;
            synchronized (fileDecompressor) {
                this.stopped = true;
                this.segmentsQueue.put(-1L);
            }
            U.join(this);
        }
    }

    private class FileCompressor
    extends Thread {
        private volatile boolean stopped;
        private volatile long lastCompressedIdx;
        private volatile long lastAllowedToCompressIdx;

        FileCompressor() {
            super("wal-file-compressor%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.lastCompressedIdx = -1L;
            this.lastAllowedToCompressIdx = -1L;
        }

        private void init() {
            File[] toDel;
            for (File f : toDel = FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER)) {
                if (this.stopped) {
                    return;
                }
                f.delete();
            }
            FileDescriptor[] alreadyCompressed = FsyncModeFileWriteAheadLogManager.scan(FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_FILE_COMPACTED_FILTER));
            if (alreadyCompressed.length > 0) {
                this.lastCompressedIdx = alreadyCompressed[alreadyCompressed.length - 1].getIdx();
            }
        }

        synchronized void allowCompressionUntil(long lastCpStartIdx) {
            this.lastAllowedToCompressIdx = lastCpStartIdx - 1L;
            this.notify();
        }

        synchronized void onNextSegmentArchived() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long tryReserveNextSegmentOrWait() throws InterruptedException, IgniteCheckedException {
            long segmentToCompress = this.lastCompressedIdx + 1L;
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                if (this.stopped) {
                    return -1L;
                }
                while (segmentToCompress > Math.min(this.lastAllowedToCompressIdx, FsyncModeFileWriteAheadLogManager.this.archiver.lastArchivedAbsoluteIndex())) {
                    this.wait();
                    if (!this.stopped) continue;
                    return -1L;
                }
            }
            segmentToCompress = Math.max(segmentToCompress, FsyncModeFileWriteAheadLogManager.this.lastTruncatedArchiveIdx + 1L);
            boolean reserved = FsyncModeFileWriteAheadLogManager.this.reserve(new FileWALPointer(segmentToCompress, 0, 0));
            return reserved ? segmentToCompress : -1L;
        }

        private void deleteObsoleteRawSegments() {
            FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.scan(FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
            HashSet<Long> indices = new HashSet<Long>();
            HashSet<Long> duplicateIndices = new HashSet<Long>();
            for (FileDescriptor desc : descs) {
                if (indices.add(desc.idx)) continue;
                duplicateIndices.add(desc.idx);
            }
            FileArchiver archiver0 = FsyncModeFileWriteAheadLogManager.this.archiver;
            for (FileDescriptor desc : descs) {
                if (desc.isCompressed()) continue;
                if (archiver0 != null && archiver0.reserved(desc.idx)) {
                    return;
                }
                if (desc.idx >= this.lastCompressedIdx || !duplicateIndices.contains(desc.idx) || desc.file.delete()) continue;
                U.warn(FsyncModeFileWriteAheadLogManager.this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath() + ", exists: " + desc.file.exists());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.init();
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                long currReservedSegment = -1L;
                try {
                    this.deleteObsoleteRawSegments();
                    currReservedSegment = this.tryReserveNextSegmentOrWait();
                    if (currReservedSegment == -1L) continue;
                    File tmpZip = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileWriteAheadLogManager.FileDescriptor.fileName(currReservedSegment) + ".zip" + ".tmp");
                    File zip = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileWriteAheadLogManager.FileDescriptor.fileName(currReservedSegment) + ".zip");
                    File raw = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileWriteAheadLogManager.FileDescriptor.fileName(currReservedSegment));
                    if (!Files.exists(raw.toPath(), new LinkOption[0])) {
                        throw new IgniteCheckedException("WAL archive segment is missing: " + raw);
                    }
                    this.compressSegmentToFile(currReservedSegment, raw, tmpZip);
                    Files.move(tmpZip.toPath(), zip.toPath(), new CopyOption[0]);
                    if (FsyncModeFileWriteAheadLogManager.this.mode != WALMode.NONE) {
                        try (FileIO f0 = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(zip, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                            f0.force();
                        }
                    }
                    this.lastCompressedIdx = currReservedSegment;
                }
                catch (IOException | IgniteCheckedException e) {
                    U.error(FsyncModeFileWriteAheadLogManager.this.log, "Compression of WAL segment [idx=" + currReservedSegment + "] was skipped due to unexpected error", e);
                    ++this.lastCompressedIdx;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    try {
                        if (currReservedSegment == -1L) continue;
                        FsyncModeFileWriteAheadLogManager.this.release(new FileWALPointer(currReservedSegment, 0, 0));
                    }
                    catch (IgniteCheckedException e) {
                        U.error(FsyncModeFileWriteAheadLogManager.this.log, "Can't release raw WAL segment [idx=" + currReservedSegment + "] after compression", e);
                    }
                }
            }
        }

        private void compressSegmentToFile(long nextSegment, File raw, File zip) throws IOException, IgniteCheckedException {
            int segmentSerializerVer;
            try (FileIO fileIO = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(raw);){
                segmentSerializerVer = RecordV1Serializer.readSegmentHeader(fileIO, nextSegment).getSerializerVersion();
            }
            var7_5 = null;
            try (final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));){
                zos.putNextEntry(new ZipEntry(""));
                zos.write(FsyncModeFileWriteAheadLogManager.prepareSerializerVersionBuffer(nextSegment, segmentSerializerVer, true).array());
                CIX1<WALRecord> appendToZipC = new CIX1<WALRecord>(){

                    @Override
                    public void applyx(WALRecord record) throws IgniteCheckedException {
                        MarshalledRecord marshRec = (MarshalledRecord)record;
                        try {
                            zos.write(marshRec.buffer().array(), 0, marshRec.buffer().remaining());
                        }
                        catch (IOException e) {
                            throw new IgniteCheckedException(e);
                        }
                    }
                };
                try (SingleSegmentLogicalRecordsIterator iter = new SingleSegmentLogicalRecordsIterator(FsyncModeFileWriteAheadLogManager.this.log, FsyncModeFileWriteAheadLogManager.this.cctx, FsyncModeFileWriteAheadLogManager.this.ioFactory, FsyncModeFileWriteAheadLogManager.this.tlbSize, nextSegment, FsyncModeFileWriteAheadLogManager.this.walArchiveDir, appendToZipC);){
                    while (iter.hasNextX()) {
                        iter.nextX();
                    }
                }
            }
            catch (Throwable throwable) {
                var7_5 = throwable;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                this.stopped = true;
                this.notifyAll();
            }
            U.join(this);
        }
    }

    private class FileArchiver
    extends Thread {
        private IgniteCheckedException cleanException;
        private long curAbsWalIdx;
        private volatile long lastAbsArchivedIdx;
        private volatile boolean stopped;
        private NavigableMap<Long, Integer> reserved;
        private Map<Long, Integer> locked;
        private int formatted;

        private FileArchiver(long lastAbsArchivedIdx) {
            super("wal-file-archiver%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.curAbsWalIdx = -1L;
            this.lastAbsArchivedIdx = -1L;
            this.reserved = new TreeMap<Long, Integer>();
            this.locked = new HashMap<Long, Integer>();
            this.lastAbsArchivedIdx = lastAbsArchivedIdx;
        }

        private long lastArchivedAbsoluteIndex() {
            return this.lastAbsArchivedIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.stopped = true;
                this.notifyAll();
            }
            U.join(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentWalIndex(long curAbsWalIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.curAbsWalIdx = curAbsWalIdx;
                this.notifyAll();
            }
        }

        private synchronized void reserve(long absIdx) {
            Integer cur = (Integer)this.reserved.get(absIdx);
            if (cur == null) {
                this.reserved.put(absIdx, 1);
            } else {
                this.reserved.put(absIdx, cur + 1);
            }
        }

        private synchronized boolean reserved(long absIdx) {
            return this.locked.containsKey(absIdx) || this.reserved.floorKey(absIdx) != null;
        }

        private synchronized void release(long absIdx) {
            Integer cur = (Integer)this.reserved.get(absIdx);
            assert (cur != null && cur >= 1) : cur;
            if (cur == 1) {
                this.reserved.remove(absIdx);
            } else {
                this.reserved.put(absIdx, cur - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.allocateRemainingFiles();
            }
            catch (IgniteCheckedException e) {
                FileArchiver fileArchiver = this;
                // MONITORENTER : fileArchiver
                this.cleanException = e;
                this.notifyAll();
                // MONITOREXIT : fileArchiver
                return;
            }
            Throwable err = null;
            try {
                FileArchiver fileArchiver = this;
                // MONITORENTER : fileArchiver
                while (this.curAbsWalIdx == -1L && !this.stopped) {
                    this.wait();
                }
                // MONITOREXIT : fileArchiver
                while (!Thread.currentThread().isInterrupted()) {
                    FileArchiver fileArchiver2;
                    if (this.stopped) return;
                    FileArchiver fileArchiver3 = this;
                    // MONITORENTER : fileArchiver3
                    assert (this.lastAbsArchivedIdx <= this.curAbsWalIdx) : "lastArchived=" + this.lastAbsArchivedIdx + ", current=" + this.curAbsWalIdx;
                    while (this.lastAbsArchivedIdx >= this.curAbsWalIdx - 1L && !this.stopped) {
                        this.wait();
                    }
                    long toArchive = this.lastAbsArchivedIdx + 1L;
                    // MONITOREXIT : fileArchiver3
                    if (this.stopped) {
                        return;
                    }
                    try {
                        SegmentArchiveResult res = this.archiveSegment(toArchive);
                        fileArchiver2 = this;
                        // MONITORENTER : fileArchiver2
                        while (this.locked.containsKey(toArchive) && !this.stopped) {
                            this.wait();
                        }
                        this.changeLastArchivedIndexAndWakeupCompressor(toArchive);
                        this.notifyAll();
                        // MONITOREXIT : fileArchiver2
                        if (!FsyncModeFileWriteAheadLogManager.this.evt.isRecordable(128)) continue;
                        FsyncModeFileWriteAheadLogManager.this.evt.record(new WalSegmentArchivedEvent(FsyncModeFileWriteAheadLogManager.this.cctx.discovery().localNode(), res.getAbsIdx(), res.getDstArchiveFile()));
                    }
                    catch (IgniteCheckedException e) {
                        fileArchiver2 = this;
                        // MONITORENTER : fileArchiver2
                        this.cleanException = e;
                        this.notifyAll();
                        // MONITOREXIT : fileArchiver2
                    }
                }
                return;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                err = t;
                return;
            }
            finally {
                if (err == null && !this.stopped) {
                    err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        private void changeLastArchivedIndexAndWakeupCompressor(long idx) {
            this.lastAbsArchivedIdx = idx;
            if (FsyncModeFileWriteAheadLogManager.this.compressor != null) {
                FsyncModeFileWriteAheadLogManager.this.compressor.onNextSegmentArchived();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextAbsoluteSegmentIndex(long curIdx) throws IgniteCheckedException {
            try {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    if (this.cleanException != null) {
                        throw this.cleanException;
                    }
                    assert (curIdx == this.curAbsWalIdx);
                    ++this.curAbsWalIdx;
                    this.notifyAll();
                    int segments = FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments();
                    while (this.curAbsWalIdx - this.lastAbsArchivedIdx > (long)segments && this.cleanException == null) {
                        this.wait();
                    }
                    while (this.curAbsWalIdx % (long)FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments() > (long)this.formatted) {
                        this.wait();
                    }
                    return this.curAbsWalIdx;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedCheckedException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkCanReadArchiveOrReserveWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                if (this.lastAbsArchivedIdx >= absIdx) {
                    if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FsyncModeFileWriteAheadLogManager.this.log.debug("Not needed to reserve WAL segment: absIdx=" + absIdx + ";" + " lastAbsArchivedIdx=" + this.lastAbsArchivedIdx);
                    }
                    return true;
                }
                Integer cur = this.locked.get(absIdx);
                cur = cur == null ? 1 : cur + 1;
                this.locked.put(absIdx, cur);
                if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FsyncModeFileWriteAheadLogManager.this.log.debug("Reserved work segment [absIdx=" + absIdx + ", pins=" + cur + ']');
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                Integer cur = this.locked.get(absIdx);
                assert (cur != null && cur > 0) : "WAL Segment with Index " + absIdx + " is not locked;" + " lastAbsArchivedIdx = " + this.lastAbsArchivedIdx;
                if (cur == 1) {
                    this.locked.remove(absIdx);
                    if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FsyncModeFileWriteAheadLogManager.this.log.debug("Fully released work segment (ready to archive) [absIdx=" + absIdx + ']');
                    }
                } else {
                    this.locked.put(absIdx, cur - 1);
                    if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FsyncModeFileWriteAheadLogManager.this.log.debug("Partially released work segment [absIdx=" + absIdx + ", pins=" + (cur - 1) + ']');
                    }
                }
                this.notifyAll();
            }
        }

        private SegmentArchiveResult archiveSegment(long absIdx) throws IgniteCheckedException {
            File dstFile;
            File origFile;
            block16: {
                long segIdx = absIdx % (long)FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments();
                origFile = new File(FsyncModeFileWriteAheadLogManager.this.walWorkDir, FileDescriptor.fileName(segIdx));
                String name = FileDescriptor.fileName(absIdx);
                File dstTmpFile = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, name + ".tmp");
                dstFile = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, name);
                if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FsyncModeFileWriteAheadLogManager.this.log.debug("Starting to copy WAL segment [absIdx=" + absIdx + ", segIdx=" + segIdx + ", origFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstFile.getAbsolutePath() + ']');
                }
                try {
                    Files.deleteIfExists(dstTmpFile.toPath());
                    Files.copy(origFile.toPath(), dstTmpFile.toPath(), new CopyOption[0]);
                    Files.move(dstTmpFile.toPath(), dstFile.toPath(), new CopyOption[0]);
                    if (FsyncModeFileWriteAheadLogManager.this.mode != WALMode.FSYNC) break block16;
                    try (FileIO f0 = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(dstFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                        f0.force();
                    }
                }
                catch (IOException e) {
                    throw new IgniteCheckedException("Failed to archive WAL segment [srcFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstTmpFile.getAbsolutePath() + ']', e);
                }
            }
            if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                FsyncModeFileWriteAheadLogManager.this.log.debug("Copied file [src=" + origFile.getAbsolutePath() + ", dst=" + dstFile.getAbsolutePath() + ']');
            }
            return new SegmentArchiveResult(absIdx, origFile, dstFile);
        }

        private boolean checkStop() {
            return this.stopped;
        }

        private void allocateRemainingFiles() throws IgniteCheckedException {
            final FileArchiver archiver = this;
            FsyncModeFileWriteAheadLogManager.this.checkFiles(1, true, new IgnitePredicate<Integer>(){

                @Override
                public boolean apply(Integer integer) {
                    return !FileArchiver.this.checkStop();
                }
            }, new CI1<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(Integer idx) {
                    FileArchiver fileArchiver = archiver;
                    synchronized (fileArchiver) {
                        FileArchiver.this.formatted = idx;
                        archiver.notifyAll();
                    }
                }
            });
        }
    }
}

