/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.UUID;
import javax.cache.configuration.CompleteConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheChangeRequest
implements Serializable {
    private static final long serialVersionUID = 0L;
    private UUID reqId;
    private IgniteUuid deploymentId;
    @GridToStringExclude
    private String cacheName;
    @GridToStringExclude
    private CacheConfiguration startCfg;
    private CacheType cacheType;
    private UUID initiatingNodeId;
    @GridToStringExclude
    private NearCacheConfiguration nearCacheCfg;
    private boolean clientStartOnly;
    private boolean stop;
    private boolean restart;
    private boolean disabledAfterStart;
    private boolean destroy;
    private boolean sql;
    private boolean failIfExists;
    private boolean template;
    private UUID rcvdFrom;
    private boolean resetLostPartitions;
    private QuerySchema schema;
    private transient boolean locallyConfigured;

    public DynamicCacheChangeRequest(UUID reqId, String cacheName, UUID initiatingNodeId) {
        assert (reqId != null);
        assert (cacheName != null);
        this.reqId = reqId;
        this.cacheName = cacheName;
        this.initiatingNodeId = initiatingNodeId;
    }

    static DynamicCacheChangeRequest resetLostPartitions(GridKernalContext ctx, String cacheName) {
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(UUID.randomUUID(), cacheName, ctx.localNodeId());
        req.markResetLostPartitions();
        return req;
    }

    static DynamicCacheChangeRequest addTemplateRequest(GridKernalContext ctx, CacheConfiguration<?, ?> cfg0) {
        CacheConfiguration cfg = new CacheConfiguration((CompleteConfiguration<?, ?>)cfg0);
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(UUID.randomUUID(), cfg.getName(), ctx.localNodeId());
        req.template(true);
        req.startCacheConfiguration(cfg);
        req.schema(new QuerySchema(cfg.getQueryEntities()));
        req.deploymentId(IgniteUuid.randomUuid());
        return req;
    }

    public static DynamicCacheChangeRequest stopRequest(GridKernalContext ctx, String cacheName, boolean sql, boolean destroy) {
        DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(UUID.randomUUID(), cacheName, ctx.localNodeId());
        req.sql(sql);
        req.stop(true);
        req.destroy(destroy);
        return req;
    }

    public UUID requestId() {
        return this.reqId;
    }

    public void template(boolean template) {
        this.template = template;
    }

    public boolean template() {
        return this.template;
    }

    public IgniteUuid deploymentId() {
        return this.deploymentId;
    }

    public void deploymentId(IgniteUuid deploymentId) {
        this.deploymentId = deploymentId;
    }

    public boolean start() {
        return !this.template && this.startCfg != null;
    }

    public void markResetLostPartitions() {
        this.resetLostPartitions = true;
    }

    public boolean resetLostPartitions() {
        return this.resetLostPartitions;
    }

    public boolean stop() {
        return this.stop;
    }

    public boolean destroy() {
        return this.destroy;
    }

    public void destroy(boolean destroy) {
        this.destroy = destroy;
    }

    public void stop(boolean stop) {
        this.stop = stop;
    }

    public boolean restart() {
        return this.restart;
    }

    public void restart(boolean restart) {
        this.restart = restart;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public UUID initiatingNodeId() {
        return this.initiatingNodeId;
    }

    public NearCacheConfiguration nearCacheConfiguration() {
        return this.nearCacheCfg;
    }

    public void nearCacheConfiguration(NearCacheConfiguration nearCacheCfg) {
        this.nearCacheCfg = nearCacheCfg;
    }

    public CacheConfiguration startCacheConfiguration() {
        return this.startCfg;
    }

    public void startCacheConfiguration(CacheConfiguration startCfg) {
        this.startCfg = startCfg;
    }

    public void cacheType(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public boolean clientStartOnly() {
        return this.clientStartOnly;
    }

    public void clientStartOnly(boolean clientStartOnly) {
        this.clientStartOnly = clientStartOnly;
    }

    public boolean failIfExists() {
        return this.failIfExists;
    }

    public void failIfExists(boolean failIfExists) {
        this.failIfExists = failIfExists;
    }

    public boolean sql() {
        return this.sql;
    }

    public void sql(boolean sql) {
        this.sql = sql;
    }

    public void receivedFrom(UUID nodeId) {
        this.rcvdFrom = nodeId;
    }

    @Nullable
    public UUID receivedFrom() {
        return this.rcvdFrom;
    }

    public QuerySchema schema() {
        return this.schema;
    }

    public void schema(QuerySchema schema) {
        this.schema = schema != null ? schema.copy() : null;
    }

    public boolean locallyConfigured() {
        return this.locallyConfigured;
    }

    public void locallyConfigured(boolean locallyConfigured) {
        this.locallyConfigured = locallyConfigured;
    }

    public boolean disabledAfterStart() {
        return this.disabledAfterStart;
    }

    public void disabledAfterStart(boolean disabledAfterStart) {
        this.disabledAfterStart = disabledAfterStart;
    }

    public String toString() {
        return "DynamicCacheChangeRequest [cacheName=" + this.cacheName() + ", hasCfg=" + (this.startCfg != null) + ", nodeId=" + this.initiatingNodeId + ", clientStartOnly=" + this.clientStartOnly + ", stop=" + this.stop + ", destroy=" + this.destroy + ", disabledAfterStart" + this.disabledAfterStart + ']';
    }
}

