/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class DataPageSetFreeListPageRecord
extends PageDeltaRecord {
    private long freeListPage;

    public DataPageSetFreeListPageRecord(int grpId, long pageId, long freeListPage) {
        super(grpId, pageId);
        this.freeListPage = freeListPage;
    }

    public long freeListPage() {
        return this.freeListPage;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        AbstractDataPageIO io = (AbstractDataPageIO)PageIO.getPageIO(pageAddr);
        io.setFreeListPageId(pageAddr, this.freeListPage);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.DATA_PAGE_SET_FREE_LIST_PAGE;
    }

    @Override
    public String toString() {
        return S.toString(DataPageSetFreeListPageRecord.class, this, "super", super.toString());
    }
}

