/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderEnum;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializationAware;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;

class BinaryBuilderSerializer {
    private final Map<BinaryObjectBuilderImpl, Integer> objToPos = new IdentityHashMap<BinaryObjectBuilderImpl, Integer>();
    private Map<BinaryObject, BinaryObjectBuilderImpl> binaryObjToWrapper;

    BinaryBuilderSerializer() {
    }

    public void registerObjectWriting(BinaryObjectBuilderImpl obj, int posInResArr) {
        this.objToPos.put(obj, posInResArr);
    }

    public void writeValue(BinaryWriterExImpl writer, Object val) {
        this.writeValue(writer, val, false, false);
    }

    public void writeValue(BinaryWriterExImpl writer, Object val, boolean forceCol, boolean forceMap) {
        assert (!forceCol || !forceMap);
        if (val == null) {
            writer.writeByte((byte)101);
            return;
        }
        if (val instanceof BinaryBuilderSerializationAware) {
            ((BinaryBuilderSerializationAware)val).writeTo(writer, this);
            return;
        }
        if (val instanceof BinaryObjectExImpl) {
            BinaryObjectBuilderImpl wrapper;
            if (this.binaryObjToWrapper == null) {
                this.binaryObjToWrapper = new IdentityHashMap<BinaryObject, BinaryObjectBuilderImpl>();
            }
            if ((wrapper = this.binaryObjToWrapper.get(val)) == null) {
                wrapper = BinaryObjectBuilderImpl.wrap((BinaryObject)val);
                this.binaryObjToWrapper.put((BinaryObject)val, wrapper);
            }
            val = wrapper;
        }
        if (val instanceof BinaryObjectBuilderImpl) {
            BinaryObjectBuilderImpl obj = (BinaryObjectBuilderImpl)val;
            Integer posInResArr = this.objToPos.get(obj);
            if (posInResArr == null) {
                this.objToPos.put(obj, writer.out().position());
                obj.serializeTo(writer.newWriter(obj.typeId()), this);
            } else {
                int handle = writer.out().position() - posInResArr;
                writer.writeByte((byte)102);
                writer.writeInt(handle);
            }
            return;
        }
        if (BinaryUtils.isEnum(val.getClass())) {
            String clsName = ((Enum)val).getDeclaringClass().getName();
            int typeId = writer.context().typeId(clsName);
            String typeName = writer.context().userTypeName(clsName);
            ?[] enumVals = val.getClass().getEnumConstants();
            LinkedHashMap<String, Integer> enumMap = new LinkedHashMap<String, Integer>(enumVals.length);
            for (Object enumVal : enumVals) {
                enumMap.put(((Enum)enumVal).name(), ((Enum)enumVal).ordinal());
            }
            BinaryMetadata meta = new BinaryMetadata(typeId, typeName, null, null, null, true, enumMap);
            writer.context().updateMetadata(typeId, meta);
            writer.context().descriptorForClass(((Enum)val).getDeclaringClass(), false);
            writer.writeByte((byte)28);
            writer.writeInt(typeId);
            writer.writeInt(((Enum)val).ordinal());
            return;
        }
        if (forceCol || BinaryUtils.isSpecialCollection(val.getClass())) {
            Collection c = (Collection)val;
            writer.writeByte((byte)24);
            writer.writeInt(c.size());
            byte colType = writer.context().collectionType(c.getClass());
            writer.writeByte(colType);
            for (Object obj : c) {
                this.writeValue(writer, obj);
            }
            return;
        }
        if (forceMap || BinaryUtils.isSpecialMap(val.getClass())) {
            Map map = (Map)val;
            writer.writeByte((byte)25);
            writer.writeInt(map.size());
            writer.writeByte(writer.context().mapType(map.getClass()));
            for (Map.Entry entry : map.entrySet()) {
                this.writeValue(writer, entry.getKey());
                this.writeValue(writer, entry.getValue());
            }
            return;
        }
        Byte flag = BinaryUtils.PLAIN_CLASS_TO_FLAG.get(val.getClass());
        if (flag != null) {
            BinaryUtils.writePlainObject(writer, val);
            return;
        }
        if (val instanceof Object[]) {
            int compTypeId = writer.context().typeId(((Object[])val).getClass().getComponentType().getName());
            if (val instanceof BinaryBuilderEnum[]) {
                this.writeArray(writer, (byte)29, (Object[])val, compTypeId);
                return;
            }
            if (((Object[])val).getClass().getComponentType().isEnum()) {
                Enum[] enumArr = (Enum[])val;
                writer.writeByte((byte)29);
                writer.writeInt(compTypeId);
                writer.writeInt(enumArr.length);
                for (Enum anEnum : enumArr) {
                    this.writeValue(writer, anEnum);
                }
                return;
            }
            this.writeArray(writer, (byte)23, (Object[])val, compTypeId);
            return;
        }
        writer.doWriteObject(val);
    }

    public void writeArray(BinaryWriterExImpl writer, byte elementType, Object[] arr, int compTypeId) {
        writer.writeByte(elementType);
        writer.writeInt(compTypeId);
        writer.writeInt(arr.length);
        for (Object obj : arr) {
            this.writeValue(writer, obj);
        }
    }

    public void writeArray(BinaryWriterExImpl writer, byte elementType, Object[] arr, String clsName) {
        writer.writeByte(elementType);
        writer.writeInt(0);
        writer.writeString(clsName);
        writer.writeInt(arr.length);
        for (Object obj : arr) {
            this.writeValue(writer, obj);
        }
    }
}

