/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridTaskSessionRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private IgniteUuid sesId;
    private IgniteUuid jobId;
    private byte[] attrsBytes;
    @GridDirectTransient
    private Map<?, ?> attrs;

    public GridTaskSessionRequest() {
    }

    public GridTaskSessionRequest(IgniteUuid sesId, IgniteUuid jobId, byte[] attrsBytes, Map<?, ?> attrs) {
        assert (sesId != null);
        assert (attrsBytes != null);
        assert (attrs != null);
        this.sesId = sesId;
        this.jobId = jobId;
        this.attrsBytes = attrsBytes;
        this.attrs = attrs;
    }

    public byte[] getAttributesBytes() {
        return this.attrsBytes;
    }

    public Map<?, ?> getAttributes() {
        return this.attrs;
    }

    public IgniteUuid getSessionId() {
        return this.sesId;
    }

    public IgniteUuid getJobId() {
        return this.jobId;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("attrsBytes", this.attrsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeIgniteUuid("sesId", this.sesId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.attrsBytes = reader.readByteArray("attrsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.jobId = reader.readIgniteUuid("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.sesId = reader.readIgniteUuid("sesId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridTaskSessionRequest.class);
    }

    @Override
    public short directType() {
        return 6;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return S.toString(GridTaskSessionRequest.class, this);
    }
}

