/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClassSet {
    private static final Map<String, Node> ALL = Collections.emptyMap();
    private Node root = new Node();

    public void add(String clsName) {
        String[] tokens = clsName.split("\\.");
        Node cur = this.root;
        for (int i = 0; i < tokens.length; ++i) {
            Node n;
            if (cur.children == ALL) {
                return;
            }
            if (tokens[i].equals("*")) {
                if (i != tokens.length - 1) {
                    throw new IllegalArgumentException("Incorrect class name format.");
                }
                cur.children = ClassSet.ALL;
                return;
            }
            if (cur.children == null) {
                cur.children = new HashMap();
            }
            if ((n = (Node)cur.children.get(tokens[i])) == null) {
                n = new Node();
                cur.children.put(tokens[i], n);
            }
            cur = n;
        }
    }

    public boolean contains(String clsName) {
        String[] tokens = clsName.split("\\.");
        Node cur = this.root;
        for (int i = 0; i < tokens.length; ++i) {
            if (cur.children == ALL) {
                return true;
            }
            if (cur.children == null) {
                return false;
            }
            Node n = (Node)cur.children.get(tokens[i]);
            if (n == null) {
                return false;
            }
            if (i == tokens.length - 1) {
                return true;
            }
            cur = n;
        }
        return false;
    }

    private static class Node {
        private Map<String, Node> children;

        private Node() {
        }
    }
}

