/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.mapreduce.records;

import java.nio.charset.Charset;
import org.apache.ignite.igfs.mapreduce.records.IgfsByteDelimiterRecordResolver;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsStringDelimiterRecordResolver
extends IgfsByteDelimiterRecordResolver {
    private static final long serialVersionUID = 0L;

    @Nullable
    private static byte[][] toBytes(Charset charset, String ... delims) {
        Object res = null;
        if (delims != null) {
            res = new byte[delims.length][];
            for (int i = 0; i < delims.length; ++i) {
                res[i] = delims[i].getBytes(charset);
            }
        }
        return res;
    }

    public IgfsStringDelimiterRecordResolver() {
    }

    public IgfsStringDelimiterRecordResolver(Charset charset, String ... delims) {
        super(IgfsStringDelimiterRecordResolver.toBytes(charset, delims));
    }

    public IgfsStringDelimiterRecordResolver(String ... delims) {
        super(IgfsStringDelimiterRecordResolver.toBytes(Charset.defaultCharset(), delims));
    }

    @Override
    public String toString() {
        return S.toString(IgfsStringDelimiterRecordResolver.class, this);
    }
}

