/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.io.GridFilenameUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public final class IgfsPath
implements Comparable<IgfsPath>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private static final char SLASH_CHAR = '/';
    public static final String SLASH = "/";
    private String path;
    public static final IgfsPath ROOT = new IgfsPath("/");

    public IgfsPath() {
        this.path = SLASH;
    }

    public IgfsPath(URI uri) {
        A.notNull(uri, "uri");
        this.path = IgfsPath.normalizePath(uri.getPath());
    }

    public IgfsPath(String path) {
        A.ensure(!F.isEmpty(path), "'path' is null or empty");
        this.path = IgfsPath.normalizePath(path);
    }

    public IgfsPath(IgfsPath parentPath, String childPath) {
        A.notNull(parentPath, "parentPath");
        String path = GridFilenameUtils.concat(parentPath.path, childPath);
        if (F.isEmpty(path)) {
            throw new IllegalArgumentException("Failed to parse path [parent=" + parentPath + ", childPath=" + childPath + ']');
        }
        this.path = IgfsPath.normalizePath(path);
    }

    private static String normalizePath(String path) {
        assert (path != null);
        String normalizedPath = GridFilenameUtils.normalizeNoEndSeparator(path, true);
        if (F.isEmpty(normalizedPath)) {
            throw new IllegalArgumentException("Failed to normalize path: " + path);
        }
        if (!SLASH.equals(GridFilenameUtils.getPrefix(normalizedPath))) {
            throw new IllegalArgumentException("Path should be absolute: " + path);
        }
        assert (!normalizedPath.isEmpty()) : "Expects normalized path is not empty.";
        assert (normalizedPath.length() == 1 || !normalizedPath.endsWith(SLASH)) : "Expects normalized path is root or don't ends with '/' symbol.";
        return normalizedPath;
    }

    public String name() {
        return GridFilenameUtils.getName(this.path);
    }

    public List<String> components() {
        String path = this.path;
        assert (path.length() >= 1) : "Path expected to be absolute: " + path;
        return path.length() == 1 ? Collections.emptyList() : Arrays.asList(path.substring(1).split(SLASH));
    }

    public String[] componentsArray() {
        return this.path.length() == 1 ? new String[]{} : this.path.substring(1).split(SLASH);
    }

    @Nullable
    public IgfsPath parent() {
        String path = this.path;
        if (path.length() == 1) {
            return null;
        }
        path = GridFilenameUtils.getFullPathNoEndSeparator(path);
        return new IgfsPath(path);
    }

    public IgfsPath suffix(String suffix) {
        A.ensure(!F.isEmpty(suffix), "'suffix' is null or empty.");
        A.ensure(!suffix.contains(SLASH), "'suffix' contains file's separator '/'");
        return new IgfsPath(this.path + suffix);
    }

    public int depth() {
        String path = this.path;
        int size = path.length();
        assert (size >= 1 && path.charAt(0) == '/') : "Expects absolute path: " + path;
        if (size == 1) {
            return 0;
        }
        int depth = 1;
        for (int i = 1; i < size; ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public boolean isSubDirectoryOf(IgfsPath path) {
        A.notNull(path, "path");
        return this.path.startsWith(path.path.endsWith(SLASH) ? path.path : path.path + SLASH);
    }

    @Override
    public int compareTo(IgfsPath o) {
        return this.path.compareTo(o.path);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.path = U.readString(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        this.writeRawBinary(writer.rawWriter());
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.readRawBinary(reader.rawReader());
    }

    public void writeRawBinary(BinaryRawWriter writer) throws BinaryObjectException {
        writer.writeString(this.path);
    }

    public void readRawBinary(BinaryRawReader reader) throws BinaryObjectException {
        this.path = reader.readString();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o != null && this.getClass() == o.getClass() && this.path.equals(((IgfsPath)o).path);
    }

    public String toString() {
        return this.path;
    }
}

