/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.cache.CacheException;
import org.apache.ignite.cache.QueryEntityPatch;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.annotations.QueryGroupIndex;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.internal.processors.cache.query.QueryEntityClassProperty;
import org.apache.ignite.internal.processors.cache.query.QueryEntityTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableAddColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexCreateOperation;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryEntity
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String keyType;
    private String valType;
    private String keyFieldName;
    private String valueFieldName;
    @GridToStringInclude
    private LinkedHashMap<String, String> fields = new LinkedHashMap();
    @GridToStringInclude
    private Set<String> keyFields;
    @GridToStringInclude
    private Map<String, String> aliases = new HashMap<String, String>();
    @GridToStringInclude
    private Collection<QueryIndex> idxs;
    private String tableName;
    private Set<String> _notNullFields;
    private Map<String, Object> defaultFieldValues = new HashMap<String, Object>();

    public QueryEntity() {
    }

    public QueryEntity(QueryEntity other) {
        this.keyType = other.keyType;
        this.valType = other.valType;
        this.keyFieldName = other.keyFieldName;
        this.valueFieldName = other.valueFieldName;
        this.fields = new LinkedHashMap<String, String>(other.fields);
        this.keyFields = other.keyFields != null ? new HashSet<String>(other.keyFields) : null;
        this.aliases = new HashMap<String, String>(other.aliases);
        this.idxs = other.idxs != null ? new ArrayList<QueryIndex>(other.idxs) : null;
        this.tableName = other.tableName;
        this._notNullFields = other._notNullFields != null ? new HashSet<String>(other._notNullFields) : null;
        this.defaultFieldValues = other.defaultFieldValues != null ? new HashMap<String, Object>(other.defaultFieldValues) : new HashMap();
    }

    public QueryEntity(String keyType, String valType) {
        this.keyType = keyType;
        this.valType = valType;
    }

    public QueryEntity(Class<?> keyCls, Class<?> valCls) {
        this(QueryEntity.convert(QueryEntity.processKeyAndValueClasses(keyCls, valCls)));
    }

    @NotNull
    public QueryEntityPatch makePatch(QueryEntity target) {
        if (target == null) {
            return QueryEntityPatch.empty();
        }
        StringBuilder conflicts = new StringBuilder();
        this.checkEquals(conflicts, "keyType", this.keyType, target.keyType);
        this.checkEquals(conflicts, "valType", this.valType, target.valType);
        this.checkEquals(conflicts, "keyFieldName", this.keyFieldName, target.keyFieldName);
        this.checkEquals(conflicts, "valueFieldName", this.valueFieldName, target.valueFieldName);
        this.checkEquals(conflicts, "tableName", this.tableName, target.tableName);
        List<QueryField> queryFieldsToAdd = this.checkFields(target, conflicts);
        Collection<QueryIndex> indexesToAdd = this.checkIndexes(target, conflicts);
        if (conflicts.length() != 0) {
            return QueryEntityPatch.conflict(this.tableName + " conflict: \n" + conflicts.toString());
        }
        ArrayList<SchemaAbstractOperation> patchOperations = new ArrayList<SchemaAbstractOperation>();
        if (!queryFieldsToAdd.isEmpty()) {
            patchOperations.add(new SchemaAlterTableAddColumnOperation(UUID.randomUUID(), null, null, this.tableName, queryFieldsToAdd, true, true));
        }
        if (!indexesToAdd.isEmpty()) {
            for (QueryIndex index : indexesToAdd) {
                patchOperations.add(new SchemaIndexCreateOperation(UUID.randomUUID(), null, null, this.tableName, index, true, 0));
            }
        }
        return QueryEntityPatch.patch(patchOperations);
    }

    @NotNull
    private Collection<QueryIndex> checkIndexes(QueryEntity target, StringBuilder conflicts) {
        HashSet<QueryIndex> indexesToAdd = new HashSet<QueryIndex>();
        HashMap<String, QueryIndex> currentIndexes = new HashMap<String, QueryIndex>();
        for (QueryIndex index : this.getIndexes()) {
            if (currentIndexes.put(index.getName(), index) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        for (QueryIndex queryIndex : target.getIndexes()) {
            if (currentIndexes.containsKey(queryIndex.getName())) {
                this.checkEquals(conflicts, "index " + queryIndex.getName(), currentIndexes.get(queryIndex.getName()), queryIndex);
                continue;
            }
            indexesToAdd.add(queryIndex);
        }
        return indexesToAdd;
    }

    private List<QueryField> checkFields(QueryEntity target, StringBuilder conflicts) {
        ArrayList<QueryField> queryFieldsToAdd = new ArrayList<QueryField>();
        for (Map.Entry<String, String> targetField : target.getFields().entrySet()) {
            String targetFieldName = targetField.getKey();
            String targetFieldType = targetField.getValue();
            if (this.getFields().containsKey(targetFieldName)) {
                this.checkEquals(conflicts, "fieldType of " + targetFieldName, this.getFields().get(targetFieldName), targetFieldType);
                this.checkEquals(conflicts, "nullable of " + targetFieldName, QueryEntity.contains(this.getNotNullFields(), targetFieldName), QueryEntity.contains(target.getNotNullFields(), targetFieldName));
                this.checkEquals(conflicts, "default value of " + targetFieldName, QueryEntity.getFromMap(this.getDefaultFieldValues(), targetFieldName), QueryEntity.getFromMap(target.getDefaultFieldValues(), targetFieldName));
                continue;
            }
            queryFieldsToAdd.add(new QueryField(targetFieldName, targetFieldType, !QueryEntity.contains(target.getNotNullFields(), targetFieldName), QueryEntity.getFromMap(target.getDefaultFieldValues(), targetFieldName)));
        }
        return queryFieldsToAdd;
    }

    private static boolean contains(Collection<String> collection, String elementToCheck) {
        return collection != null && collection.contains(elementToCheck);
    }

    private static Object getFromMap(Map<String, Object> sourceMap, String key) {
        return sourceMap == null ? null : sourceMap.get(key);
    }

    private void checkEquals(StringBuilder conflicts, String name, Object local, Object received) {
        if (!Objects.equals(local, received)) {
            conflicts.append(String.format("%s is different: local=%s, received=%s\n", name, local, received));
        }
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String findKeyType() {
        if (this.keyType != null) {
            return this.keyType;
        }
        if (this.fields != null && this.keyFieldName != null) {
            return this.fields.get(this.keyFieldName);
        }
        return null;
    }

    public QueryEntity setKeyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    public String getValueType() {
        return this.valType;
    }

    public String findValueType() {
        if (this.valType != null) {
            return this.valType;
        }
        if (this.fields != null && this.valueFieldName != null) {
            return this.fields.get(this.valueFieldName);
        }
        return null;
    }

    public QueryEntity setValueType(String valType) {
        this.valType = valType;
        return this;
    }

    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    public QueryEntity setFields(LinkedHashMap<String, String> fields) {
        this.fields = fields;
        return this;
    }

    public Set<String> getKeyFields() {
        return this.keyFields;
    }

    public QueryEntity setKeyFields(Set<String> keyFields) {
        this.keyFields = keyFields;
        return this;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }

    public QueryEntity setKeyFieldName(String keyFieldName) {
        this.keyFieldName = keyFieldName;
        return this;
    }

    public String getValueFieldName() {
        return this.valueFieldName;
    }

    public QueryEntity setValueFieldName(String valueFieldName) {
        this.valueFieldName = valueFieldName;
        return this;
    }

    @NotNull
    public Collection<QueryIndex> getIndexes() {
        return this.idxs == null ? Collections.emptyList() : this.idxs;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public QueryEntity setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public QueryEntity setIndexes(Collection<QueryIndex> idxs) {
        this.idxs = idxs;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public QueryEntity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Nullable
    public Set<String> getNotNullFields() {
        return this._notNullFields;
    }

    public QueryEntity setNotNullFields(@Nullable Set<String> notNullFields) {
        this._notNullFields = notNullFields;
        return this;
    }

    public Map<String, Object> getDefaultFieldValues() {
        return this.defaultFieldValues;
    }

    public QueryEntity setDefaultFieldValues(Map<String, Object> defaultFieldValues) {
        this.defaultFieldValues = defaultFieldValues;
        return this;
    }

    public QueryEntity addQueryField(String fullName, String type, String alias) {
        A.notNull(fullName, "fullName");
        A.notNull(type, "type");
        this.fields.put(fullName, type);
        if (alias != null) {
            this.aliases.put(fullName, alias);
        }
        return this;
    }

    private static QueryEntity convert(QueryEntityTypeDescriptor desc) {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(desc.keyClass().getName());
        entity.setValueType(desc.valueClass().getName());
        for (QueryEntityClassProperty prop : desc.properties().values()) {
            entity.addQueryField(prop.fullName(), U.box(prop.type()).getName(), prop.alias());
        }
        entity.setKeyFields(desc.keyProperties());
        QueryIndex txtIdx = null;
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        for (Map.Entry<String, GridQueryIndexDescriptor> idxEntry : desc.indexes().entrySet()) {
            GridQueryIndexDescriptor idx = idxEntry.getValue();
            if (idx.type() == QueryIndexType.FULLTEXT) {
                assert (txtIdx == null);
                txtIdx = new QueryIndex();
                txtIdx.setIndexType(QueryIndexType.FULLTEXT);
                txtIdx.setFieldNames(idx.fields(), true);
                txtIdx.setName(idxEntry.getKey());
                continue;
            }
            QueryIndex sortedIdx = new QueryIndex();
            sortedIdx.setIndexType(idx.type());
            LinkedHashMap<String, Boolean> fields = new LinkedHashMap<String, Boolean>();
            for (String f : idx.fields()) {
                fields.put(f, !idx.descending(f));
            }
            sortedIdx.setFields(fields);
            sortedIdx.setName(idxEntry.getKey());
            sortedIdx.setInlineSize(idx.inlineSize());
            idxs.add(sortedIdx);
        }
        if (desc.valueTextIndex()) {
            if (txtIdx == null) {
                txtIdx = new QueryIndex();
                txtIdx.setIndexType(QueryIndexType.FULLTEXT);
                txtIdx.setFieldNames(Arrays.asList("_VAL"), true);
            } else {
                txtIdx.getFields().put("_VAL", true);
            }
        }
        if (txtIdx != null) {
            idxs.add(txtIdx);
        }
        if (!F.isEmpty(idxs)) {
            entity.setIndexes(idxs);
        }
        if (!F.isEmpty(desc.notNullFields())) {
            entity.setNotNullFields(desc.notNullFields());
        }
        return entity;
    }

    private static QueryEntityTypeDescriptor processKeyAndValueClasses(Class<?> keyCls, Class<?> valCls) {
        QueryEntityTypeDescriptor d = new QueryEntityTypeDescriptor();
        d.keyClass(keyCls);
        d.valueClass(valCls);
        QueryEntity.processAnnotationsInClass(true, d.keyClass(), d, null);
        QueryEntity.processAnnotationsInClass(false, d.valueClass(), d, null);
        return d;
    }

    private static void processAnnotationsInClass(boolean key, Class<?> cls, QueryEntityTypeDescriptor type, @Nullable QueryEntityClassProperty parent) {
        if (U.isJdk(cls) || QueryUtils.isGeometryClass(cls)) {
            if (parent == null && !key && QueryUtils.isSqlType(cls)) {
                String idxName = cls.getSimpleName() + "_" + "_VAL" + "_idx";
                type.addIndex(idxName, QueryUtils.isGeometryClass(cls) ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED, -1);
                type.addFieldToIndex(idxName, "_VAL", 0, false);
            }
            return;
        }
        if (parent != null && parent.knowsClass(cls)) {
            throw new CacheException("Recursive reference found in type: " + cls.getName());
        }
        if (parent == null) {
            QueryGroupIndex.List grpIdxList;
            QueryGroupIndex grpIdx;
            QueryTextField txtAnnCls = cls.getAnnotation(QueryTextField.class);
            if (txtAnnCls != null) {
                type.valueTextIndex(true);
            }
            if ((grpIdx = cls.getAnnotation(QueryGroupIndex.class)) != null) {
                type.addIndex(grpIdx.name(), QueryIndexType.SORTED, grpIdx.inlineSize());
            }
            if ((grpIdxList = cls.getAnnotation(QueryGroupIndex.List.class)) != null && !F.isEmpty(grpIdxList.value())) {
                for (QueryGroupIndex idx : grpIdxList.value()) {
                    type.addIndex(idx.name(), QueryIndexType.SORTED, idx.inlineSize());
                }
            }
        }
        for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                QuerySqlField sqlAnn = field.getAnnotation(QuerySqlField.class);
                QueryTextField txtAnn = field.getAnnotation(QueryTextField.class);
                if (sqlAnn == null && txtAnn == null) continue;
                QueryEntityClassProperty prop = new QueryEntityClassProperty(field);
                prop.parent(parent);
                type.addProperty(prop, key, true);
                QueryEntity.processAnnotation(key, sqlAnn, txtAnn, cls, c, field.getType(), prop, type);
            }
        }
    }

    private static void processAnnotation(boolean key, QuerySqlField sqlAnn, QueryTextField txtAnn, Class<?> cls, Class<?> curCls, Class<?> fldCls, QueryEntityClassProperty prop, QueryEntityTypeDescriptor desc) {
        if (sqlAnn != null) {
            QueryEntity.processAnnotationsInClass(key, fldCls, desc, prop);
            if (!sqlAnn.name().isEmpty()) {
                prop.alias(sqlAnn.name());
            }
            if (sqlAnn.index()) {
                String idxName = curCls.getSimpleName() + "_" + prop.alias() + "_idx";
                if (cls != curCls) {
                    idxName = cls.getSimpleName() + "_" + idxName;
                }
                desc.addIndex(idxName, QueryUtils.isGeometryClass(prop.type()) ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED, sqlAnn.inlineSize());
                desc.addFieldToIndex(idxName, prop.fullName(), 0, sqlAnn.descending());
            }
            if (sqlAnn.notNull()) {
                desc.addNotNullField(prop.fullName());
            }
            if (!(F.isEmpty(sqlAnn.groups()) && F.isEmpty(sqlAnn.orderedGroups()) || sqlAnn.inlineSize() == -1)) {
                throw new CacheException("Inline size cannot be set on a field with group index [type=" + cls.getName() + ", property=" + prop.fullName() + ']');
            }
            if (!F.isEmpty(sqlAnn.groups())) {
                for (String group : sqlAnn.groups()) {
                    desc.addFieldToIndex(group, prop.fullName(), 0, false);
                }
            }
            if (!F.isEmpty(sqlAnn.orderedGroups())) {
                for (QuerySqlField.Group idx : sqlAnn.orderedGroups()) {
                    desc.addFieldToIndex(idx.name(), prop.fullName(), idx.order(), idx.descending());
                }
            }
        }
        if (txtAnn != null) {
            desc.addFieldToTextIndex(prop.fullName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntity entity = (QueryEntity)o;
        return F.eq(this.keyType, entity.keyType) && F.eq(this.valType, entity.valType) && F.eq(this.keyFieldName, entity.keyFieldName) && F.eq(this.valueFieldName, entity.valueFieldName) && F.eq(this.fields, entity.fields) && F.eq(this.keyFields, entity.keyFields) && F.eq(this.aliases, entity.aliases) && F.eqNotOrdered(this.idxs, entity.idxs) && F.eq(this.tableName, entity.tableName) && F.eq(this._notNullFields, entity._notNullFields) && F.eq(this.defaultFieldValues, entity.defaultFieldValues);
    }

    public int hashCode() {
        return Objects.hash(this.keyType, this.valType, this.keyFieldName, this.valueFieldName, this.fields, this.keyFields, this.aliases, this.idxs, this.tableName, this._notNullFields, this.defaultFieldValues);
    }

    public String toString() {
        return S.toString(QueryEntity.class, this);
    }
}

