/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.jdbc.thin.ConnectionPropertiesImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;

public class IgniteJdbcThinDriver
implements Driver {
    private static final int MAJOR_VER = IgniteVersionUtils.VER.major();
    private static final int MINOR_VER = IgniteVersionUtils.VER.minor();

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, props);
        return new JdbcThinConnection(connProps);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:ignite:thin://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.init(url, info);
        return connProps.getDriverPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return MAJOR_VER;
    }

    @Override
    public int getMinorVersion() {
        return MINOR_VER;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used.");
    }

    static {
        try {
            DriverManager.registerDriver(new IgniteJdbcThinDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to register Ignite JDBC driver.", e);
        }
    }
}

