/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.zillion.util.log.LogUtil;

public class stat_fjd_delay_index {
    public static void main(String[] args) throws Exception {
        Configuration configuration = new Configuration();
        configuration.addResource((InputStream)new FileInputStream(Constant.GetPath() + "/hbase-site.xml"));
        ZillionAgent agent = new ZillionAgent(configuration);
        agent.Start();
        String database_name = ConstantCE.database_name;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        long interval = 900000L;
        for (int index_cycle = 0; index_cycle < Integer.MAX_VALUE; ++index_cycle) {
            Thread.sleep(10000L);
            Date currentTime = new Date();
            Date next_time = new Date(currentTime.getTime() / interval * interval + interval);
            int valid_count = 0;
            double valid_avglag = 0.0;
            int building_valid_count = 0;
            double building_valid_avglag = 0.0;
            JSONObject Criteria = new JSONObject();
            JSONArray resultContent = QueryUtil.select((IZillionAgent)agent, database_name, "fjd_0_metercomputetime", Criteria);
            String tmp_building = null;
            int tmp_valid_count = 0;
            long tmp_valid_bestlag = 0L;
            for (int i = 0; i < resultContent.size(); ++i) {
                JSONObject item = (JSONObject)resultContent.get(i);
                String building = (String)item.get((Object)"building");
                String meter = (String)item.get((Object)"meter");
                Long funcid = (Long)item.get((Object)"funcid");
                Date next_data_time = sdf.parse((String)item.get((Object)"next_data_time"));
                if (i == 0) {
                    tmp_building = building;
                    tmp_valid_count = 0;
                    tmp_valid_bestlag = 0L;
                }
                if (tmp_building != null && !tmp_building.equals(building)) {
                    if (tmp_valid_count > 0) {
                        ++building_valid_count;
                        building_valid_avglag += (double)tmp_valid_bestlag;
                    }
                    tmp_building = building;
                    tmp_valid_count = 0;
                    tmp_valid_bestlag = 0L;
                }
                long item_lag = (next_time.getTime() - next_data_time.getTime()) / interval;
                if (funcid == 0L && item_lag <= 96L) {
                    ++valid_count;
                    valid_avglag += (double)item_lag;
                    if (++tmp_valid_count == 0 || tmp_valid_bestlag > item_lag) {
                        tmp_valid_bestlag = item_lag;
                    }
                }
                if (i != resultContent.size() - 1 || tmp_valid_count <= 0) continue;
                ++building_valid_count;
                building_valid_avglag += (double)tmp_valid_bestlag;
            }
            LogUtil.warn((String)(valid_count + "\t" + valid_avglag / (double)valid_count + "\tfinish"));
            LogUtil.warn((String)(building_valid_count + "\t" + building_valid_avglag / (double)building_valid_count + "\tfinish"));
        }
        agent.Stop();
        System.out.println();
    }
}

