/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.json;

import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class JSONUtil {
    private static JSONUtil instance = new JSONUtil();

    public static JSONUtil Instance() {
        return instance;
    }

    private JSONUtil() {
    }

    public void Set_JSON(Object entity, JSONObject json) throws Exception {
        Class<?> targetClass = entity.getClass();
        Method[] targetMethodArray = targetClass.getMethods();
        int i = 0;
        while (i < targetMethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = targetMethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("get") && (parameterTypes = method.getParameterTypes()).length == 0) {
                Object value;
                String fieldName = methodName.substring(3);
                if (json.containsKey((Object)(fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1)))) {
                    json.remove(fieldName);
                }
                if ((value = method.invoke(entity, new Object[0])) != null) {
                    String valueClassName = value.getClass().getName();
                    Object put_value = null;
                    if (valueClassName.equals("java.lang.String")) {
                        put_value = value;
                    } else if (valueClassName.equals("java.util.Date")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        put_value = sdf.format((Date)value);
                    } else {
                        put_value = valueClassName.equals("java.lang.Long") || valueClassName.equals("long") ? value : (valueClassName.equals("java.lang.Double") || valueClassName.equals("double") ? value : (valueClassName.equals("java.lang.Boolean") || valueClassName.equals("boolean") ? value : this.DeepCopyByObject(value)));
                    }
                    json.put((Object)fieldName, put_value);
                }
            }
            ++i;
        }
    }

    public void Set_JavaObject(JSONObject json, Object entity) throws Exception {
        Class<?> targetClass = entity.getClass();
        if (json == null) {
            return;
        }
        Method[] targetMethodArray = targetClass.getMethods();
        int i = 0;
        while (i < targetMethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = targetMethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("set") && (parameterTypes = method.getParameterTypes()).length == 1) {
                String fieldName = methodName.substring(3);
                fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                Class<?> paramClass = parameterTypes[0];
                if (json.containsKey((Object)fieldName)) {
                    Object sourceFieldValue = json.get((Object)fieldName);
                    Object targetFieldValue = this.To_JavaObject(sourceFieldValue, paramClass);
                    method.invoke(entity, targetFieldValue);
                }
            }
            ++i;
        }
    }

    public Object DeepCopyByObject(Object source) throws Exception {
        Class<?> sourceClass = source.getClass();
        if (sourceClass.isArray()) {
            JSONArray result = new JSONArray();
            int array_length = Array.getLength(source);
            int i = 0;
            while (i < array_length) {
                Object item = Array.get(source, i);
                result.add(this.DeepCopyByObject(item));
                ++i;
            }
            return result;
        }
        JSONObject result = new JSONObject();
        Method[] meethodArray = sourceClass.getMethods();
        int i = 0;
        while (i < meethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = meethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("get") && (parameterTypes = method.getParameterTypes()).length == 0) {
                Object put_value;
                String fieldName = methodName.substring(3);
                fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                Object value = method.invoke(source, new Object[0]);
                if (value == null) {
                    put_value = null;
                } else {
                    String valueClassName = value.getClass().getName();
                    if (valueClassName.equals("java.lang.String")) {
                        put_value = value;
                    } else if (valueClassName.equals("java.util.Date")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        put_value = sdf.format(value);
                    } else {
                        put_value = valueClassName.equals("java.lang.Long") || valueClassName.equals("long") ? value : (valueClassName.equals("java.lang.Double") || valueClassName.equals("double") ? value : (valueClassName.equals("java.lang.Boolean") || valueClassName.equals("boolean") ? value : this.DeepCopyByObject(value)));
                    }
                }
                result.put((Object)fieldName, put_value);
            }
            ++i;
        }
        return result;
    }

    public Object To_JavaObject(Object json, Class<?> entityClass) throws Exception {
        if (json == null) {
            return null;
        }
        String targetClassName = entityClass.getName();
        if (json instanceof JSONArray && entityClass.isArray()) {
            JSONArray sourceEntity = (JSONArray)json;
            int sourceLength = sourceEntity.size();
            Class<?> targetComponentType = entityClass.getComponentType();
            Object targetObjectArray = Array.newInstance(targetComponentType, sourceLength);
            int i = 0;
            while (i < sourceLength) {
                Object sourceObject = sourceEntity.get(i);
                Object targetObject = this.To_JavaObject(sourceObject, targetComponentType);
                Array.set(targetObjectArray, i, targetObject);
                ++i;
            }
            return targetObjectArray;
        }
        if (json instanceof JSONObject) {
            JSONObject sourceEntity = (JSONObject)json;
            Constructor<?> constructorMethod = entityClass.getConstructor(new Class[0]);
            Object targetObject = constructorMethod.newInstance(new Object[0]);
            Method[] methodArray = entityClass.getMethods();
            int i = 0;
            while (i < methodArray.length) {
                Class<?>[] parameterTypes;
                Method method = methodArray[i];
                int modifiers = method.getModifiers();
                String methodName = method.getName();
                if (modifiers == 1 && methodName.startsWith("set") && (parameterTypes = method.getParameterTypes()).length == 1) {
                    String fieldName = methodName.substring(3);
                    fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                    Class<?> paramClass = parameterTypes[0];
                    if (sourceEntity.containsKey((Object)fieldName)) {
                        Object sourceFieldValue = sourceEntity.get((Object)fieldName);
                        Object targetFieldValue = this.To_JavaObject(sourceFieldValue, paramClass);
                        method.invoke(targetObject, targetFieldValue);
                    }
                }
                ++i;
            }
            return targetObject;
        }
        if (json instanceof String && targetClassName.equals("java.lang.String")) {
            return (String)json;
        }
        if (json instanceof String && targetClassName.equals("java.util.Date")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            return sdf.parse((String)json);
        }
        if (targetClassName.equals("java.lang.Long") || targetClassName.equals("long")) {
            if (json instanceof String) {
                Long value = Long.parseLong((String)json);
                return value;
            }
            if (json instanceof Long) {
                Long value = (Long)json;
                return value;
            }
            return null;
        }
        if (targetClassName.equals("java.lang.Double") || targetClassName.equals("double")) {
            if (json instanceof String) {
                Double value = Double.parseDouble((String)json);
                return value;
            }
            if (json instanceof Long) {
                Double value = ((Long)json).doubleValue();
                return value;
            }
            if (json instanceof Double) {
                Double value = (Double)json;
                return value;
            }
            return null;
        }
        if (targetClassName.equals("java.lang.Boolean") || targetClassName.equals("boolean")) {
            if (json instanceof String) {
                Boolean value = ((String)json).equalsIgnoreCase("true");
                return value;
            }
            if (json instanceof Boolean) {
                Boolean value = (Boolean)json;
                return value;
            }
            return null;
        }
        return null;
    }

    public Object Clone_JSON(Object source) {
        if (source instanceof JSONObject) {
            JSONObject result = new JSONObject();
            JSONObject sourceJSON = (JSONObject)source;
            List keyList = sourceJSON.keySet();
            int i = 0;
            while (i < keyList.size()) {
                String key = (String)keyList.get(i);
                Object value = sourceJSON.get((Object)key);
                result.put((Object)key, this.Clone_JSON(value));
                ++i;
            }
            return result;
        }
        if (source instanceof JSONArray) {
            JSONArray result = new JSONArray();
            JSONArray sourceJSON = (JSONArray)source;
            int i = 0;
            while (i < sourceJSON.size()) {
                result.add(this.Clone_JSON(sourceJSON.get(i)));
                ++i;
            }
            return result;
        }
        if (source instanceof String) {
            return source;
        }
        if (source instanceof Double) {
            return source;
        }
        if (source instanceof Long) {
            return source;
        }
        if (source instanceof Boolean) {
            return source;
        }
        return null;
    }
}

